
/**
 * Модальный диалог, который пользователь не может закрыть,
 * показывает, что происходит длительная операция и позволяет избежать
 * случайных нажатий
 * @param jqueryObject объект JQuery, на котором строится диалог, например, $("#waitDialog")
 * @param title сообщение пользователю: если задано -- помещается в заголовок,
 * если нет -- диалог без заголовка
 */
function modalWait(jqueryObject, title) {
	var dialogClass, height;
	if (title == undefined) {
		dialogClass = "ui-untitledDialog";
		height = 47;
	} else {
		dialogClass = "ui-unclosingDialog";
		height = 75;
	}
	jqueryObject.html('<div class="progressbar"></div>')
	.dialog({
		title: title,
		dialogClass: dialogClass,
		minHeight: false,
		minWidth: false,
		height: height,
		width: 250,
		resizable: false,
		modal: true,
		closeOnEscape: false
	})
	.find(".progressbar").progressbar({ value:100});
	jqueryObject.find(".ui-progressbar .ui-progressbar-value").css(
		"background-image", "url($$$IMAGES_URL/document_editor/ajax-saver.gif)"
	);
}