var renderPrices = function(_params)
{
	var params;
	var def_params = {
			'onChange': function(){}
		};
	
	var createNewRow = function() {
		var clone;
		clone = params['tmpltEl'].clone();
		clone.insertAfter(findInsertAfterEl());
		clone.removeClass('tmpltRow')
			 .addClass('rowPrice')
			 .addClass('row');
			 
		clone.find('input.dateFrom').datepick({
			'showTrigger': '<span></span>',
			'dateFormat': 'dd.mm.yyyy',
			'onSelect': function(dates) {
				clone.find('span.dateFrom').html(
					$.datepick.formatDate('dd.mm.yyyy', dates[0])
				);
				//params['onChange']();
				triggerOnChange();
			}
		});
		
		clone.find('input.dateTo').datepick({
			'showTrigger': '<span></span>',
			'dateFormat': 'dd.mm.yyyy',
			'onSelect': function(dates) {
				clone.find('span.dateTo').html(
					$.datepick.formatDate('dd.mm.yyyy', dates[0])
				);
				//params['onChange']();
				triggerOnChange();
			}
		});
		
		return clone;
	}
	
	var clearList = function() {
		params['containerEl'].find('.rowPrice').remove();
	}
	
	var findInsertAfterEl = function() {
		return params['containerEl'].find('.row').last();
	}
	
	var fillRowData = function(el, data) {
		el.find('.first').val(data['FIRST_TERM_COST']);
		el.find('.second').val(data['SECOND_TERM_COST']);
		el.find('.third').val(data['THIRD_TERM_COST']);
		el.find('.fourth').val(data['FOURTH_TERM_COST']);
		el.find('.fifth').val(data['FIFTH_TERM_COST']);
		el.find('input.dateFrom')
		  .datepick('setDate', $.datepick.parseDate('dd.mm.yyyy',
  							    data['FROMDATE']));
		el.find('input.dateTo')
		  .datepick('setDate', $.datepick.parseDate('dd.mm.yyyy',
							    data['TODATE']));
	}
	
	var getRowData = function(rowIdx) {
		var row = params['containerEl'].find('.rowPrice:eq(' + rowIdx + ')');
		var data = {
			'FIRST_TERM_COST': row.find('.first').val(),
			'SECOND_TERM_COST': row.find('.second').val(),
			'THIRD_TERM_COST': row.find('.third').val(),
			'FOURTH_TERM_COST': row.find('.fourth').val(),
			'FIFTH_TERM_COST': row.find('.fifth').val(),
			'FROMDATE': row.find('input.dateFrom').val(),
			'TODATE': row.find('input.dateTo').val()
			};
			
		if ('' + data['FROMDATE'] === '' || '' + data['TODATE'] === '') {
			return {};
		} else {
			return data;
		}
	}
	
	var getRowsCount = function() {
		return params['containerEl'].find('.rowPrice').length;
	}
	
	var clbk_deleteRow = function() {
		// TODO
		$(this).parents('.rowPrice:first').remove();
		//params['onChange']();
		triggerOnChange();
	}
	
	var clbk_addRow = function() {
		newRow = createNewRow();
		//params['onChange']();
		triggerOnChange();
	}
	
	var setParam = function(paramName, paramValue) {
		params[paramName] = paramValue;
	}
	
	var triggerOnChange = function() {
		params['onChange']();
	}
	
	var init = function() {
		params = $.extend({}, def_params, _params);
		params['containerEl'].undelegate('.deletePriceRow', 'click', clbk_deleteRow);
		params['containerEl'].delegate('.deletePriceRow', 'click', clbk_deleteRow);
		params['containerEl'].undelegate('.addPriceRow', 'click', clbk_addRow);
		params['containerEl'].delegate('.addPriceRow', 'click', clbk_addRow);
		params['containerEl'].undelegate('input', 'change', triggerOnChange);
		params['containerEl'].delegate('input', 'change', triggerOnChange);
	}
	
	init();
	
	return {
		'clearList': clearList,
		'createNewRow': createNewRow,
		'fillRowData': fillRowData,
		'getRowsCount': getRowsCount,
		'getRowData': getRowData,
		'setParam': setParam
		};
}

var restateCostForm = function(params)
{
	var render;
	
	var getSavedPrices = function() {
		// TODO type checking
		return $.parseJSON(params['inputEl'].val());
	}
	
	var setSavedPrices = function(prices) {
		params['inputEl'].val($.toJSON(prices));
		//params['inputEl'].trigger('change');
	}
	
	var collectPrices = function() {
		var rowsCount = render.getRowsCount();
		var prices = [];
		var price;
		if (+rowsCount>0) {
			for (var i=0; i<rowsCount; i++) {
				price = render.getRowData(i);
				if (!$.isEmptyObject(price))
					prices.push(price);
			}
		}
		return prices;
	}
	
	var makePriceList = function() {
		var newRow;
		var prices = getSavedPrices();
		render.clearList();				
		for (var i=0, j=prices.length; i<j; i++) {
			newRow = render.createNewRow();
			render.fillRowData(newRow, prices[i]);
		}
	}
	
	var clbk_change = function() {
		var prices = collectPrices();
		setSavedPrices(prices);
	}
	
	var init = function() {
		render = renderPrices({
			'containerEl': params['containerEl'],
			'tmpltEl': params['tmpltEl']
		});
		
		makePriceList();
		
		render.setParam('onChange', clbk_change);
		params['containerEl'].find('.currencyLabel').html(params['currency']);;
	}
	
	init();
	
	return {};
}