/*
	������ ��� ������ �� ��������� ������.	

	Ver.: 1.0 (03 Nov 2010)

	(�) 2010 Kraynov Ilya ( mailto:ilya.kraynov@gmail.com ). 

	control_reflist_popup_wrapper

	control_reflist_popup

	control_reflist

	!!! required:
		jQuery (tested 1.4.2)
		jQuery UI (tested 1.8.5)
		jquery.json (tested 2.2) - http://code.google.com/p/jquery-json/

	TODO �������� �� input'��, ��� �� ��� �� �������� � �����.

	http://javascript.ru/tutorial/object/inheritance#factory
*/


/**
 *
 *
 * @param opts
 *   opts['inputEl']
 *   opts['propertyPath']
 *   opts['title']
 *   opts['resultEl']
 *   opts['multi']
 *   opts['documentId']
 *   opts['dependsOn']
 *
 */
function control_reflist_popup_wrapper (opts) {

    var dependsOnValue;
    var remoteList;
    var ctrl;

    var printResult = function() {
        try {
            $(opts['resultEl']).empty();
            $.each(ctrl.getSelectedValues(), function (i, el){
                $(opts['resultEl']).append('<li><span>' + el + '</span></li>');
            });
        } catch (e) {
            throw e;
        } finally {
        }
    }

    var isDependsOn = function () {
        return (opts['dependsOn']?true:false);
    }

    var getDependsOnValue = function () {
        try {
            if (isDependsOn()) {
                var retVal = $.parseJSON($(opts['dependsOn']).val());
                if ($.isArray(retVal))
                    retVal = retVal[0];
                return retVal;
            } else {
                return false;
            }
        } catch (e) {
            throw e;
        } finally {
        }
    }

    var getStoredValues = function () {
        try {
            var retVal = $.parseJSON($(opts['inputEl']).val());
            return retVal;
        } catch (e) {
            throw e;
        } finally {
        }
    }

    var setStoredValues = function (values) {
        try {
            $(opts['inputEl']).val($.toJSON(values));
            $(opts['inputEl']).trigger('change');
        } catch (e) {
            throw e;
        } finally {
        }
    }

    var show = function () {
        try {
            ctrl.setSelected(getStoredValues());
            if (isDependsOn()) {
                dependsOnValue = getDependsOnValue();
            }
            ctrl.show();
        } catch (e) {
		throw e;
		//console.log(e);
        } finally {
        }
    }

    var init = function() {
        var stringsTotalCount = 0;
        remoteList = stringSource({
            'srcType': 'callback',
            'src': function (clbk, f, c, inc, exc, moreParams) {
                if (!$.isArray(exc))
                    exc = [];
                if(!$.isArray(inc))
                    inc = [];
                c=90;
                de_x_request($.extend({},
				      de_getPluginCallParams(opts['targetObject'], opts['targetProperty'], 'get_ddd'),
				     {'exc': exc.join(','),
				      'inc': inc.join(','),
				      'f': f,
				      'c': c,
				      'dependsOnValue': dependsOnValue?dependsOnValue:''}),
			     function (data) {
		                    if (!$.isEmptyObject(data)) {
		                        stringsTotalCount = data['totalCount'];
		                        clbk(data['strings'], data['lastIdx']);
		                    }
		             });
            },
            'totalCount': function (){
                return stringsTotalCount;
            }
        });

        ctrl = control_reflist_popup ({
            stringsSrc:remoteList,
            title: opts['title'],
            multi: opts['multi']
        });

        ctrl.onchange(function () {
            try {
                setStoredValues(ctrl.getSelected());
                printResult();
            } catch (e) {
                throw e;
            } finally {
            }
        });

	if (opts['dependsOn']) {
		$(opts['dependsOn'])
		.change(function(){
			setStoredValues([]);
			$(opts['resultEl']).empty();
		});
	}

    }

    try {
        init();
    } catch (e) {
	throw e;
        //console.error('error catched', e);
    } finally {
    }

    return {
        show: show
    }

}



function control_reflist_popup(opts) 
{

    var list = opts['stringsSrc'];
    var title = opts['title'];
    var multi = opts['multi'];
    //var dependsOn = opts['dependsOn'];

    var onclose = [];
    var onshow = [];
    var onchange = [];
    var sel_state = [];
    var c_rl;

    var div;
    var list_div;
    var toolbar;
    var status;

    var set_onclose_callback = function (func_name) {
        onclose.push(func_name);
    }

    var set_onshow_callback = function (func_name) {
        onshow.push(func_name);
    }

    var set_onchange_callback = function (func_name) {
        onchange.push(func_name);
    }

    var show = function () {
        //sel_state = c_rl.getSelected();
        div.modal();
        // TODO: ����� ��������� ����������� � callback � � ����� ��������� ���������?
        c_rl.refresh();
        $.each(onshow, function (i, el) {el()});
    }

    var close = function () {
        div.dialog('close');
        // TODO: ����� ��������� ����������� � callback � � ����� ��������� ���������?
        $.each(onclose, function (i, el) {el()});
    }

    var accept = function () {
        close();
        sel_state = c_rl.getSelected();
        // TODO: if selection is changed{
        // TODO: ����� ��������� ����������� � callback � � ����� ��������� ���������?
        $.each(onchange, function (i, el) {el()});
        //}
    }

    var decline = function () {
        // TODO
        close();
        c_rl.setSelected(sel_state);
        // reset
    };

    var init = function () {
        div = $(opts.changeRefDialogID);
        body = div.find(".modal-body");
        footer = div.find(".modal-footer");
		div.find(".modal-footer .ok").click(function() {
			accept();
			div.modal("hide");
		});
		div.find(".modal-footer .cancel, .modal-header .cancel").click(function() {
			decline();
			div.modal("hide");
		});

        list_div = $('<div class="listcontainer"></div>')
            .appendTo(body);

        toolbar = $('<div style="float:left"></div>')
            .prependTo(footer);

        $('<span class="btn_span">Выделить всё</span>')
            .bind('click', function () { c_rl.selectAll(); })
            .appendTo(toolbar);
        $('<span>&nbsp;&nbsp;</span>')
            .appendTo(toolbar);
        $('<span class="btn_span">Снять выделение</span>')
            .bind('click', function () { c_rl.selectNone(); })
            .appendTo(toolbar);

        //$('<span class="link">Test</span>')
        //    .bind('click', function () { c_rl.setSelected('id_9'); })
        //    .appendTo(toolbar);


        status = $('<div></div>')
            .appendTo(body);

        c_rl = control_optionsList_wrapper({
            multi: multi,
            src: list,
            container: list_div
        });
        c_rl.onchange( function () {
            status.html('Выбрано ' + c_rl.getSelected().length + '. Из отображённых: '
                + c_rl.count() +'. Всего: '+list.totalCount() + '.' );
        });
    }

    init();


    return {
        show: show,
        close: close,
        onclose: set_onclose_callback,
        onshow: set_onshow_callback,
        onchange: set_onchange_callback,

        getSelected: c_rl.getSelected,
        getSelectedValues: c_rl.getSelectedValues,
        setSelected: c_rl.setSelected,
        selectAll: c_rl.selectAll,
        selectNone: c_rl.selectNone,
        onselect: c_rl.onchange

	//refreshList: c_rl.refresh
    }
} // control_reflist_popup



/**
 *
 * opts
 *   multi = (default)false
 *   pEl
 *   strSrc
 *
 *
*/
function control_optionsList_wrapper( in_opts ){

    var rand_id = Math.floor((1000-99)*Math.random()) + 100;
    var default_opts = {
        multi: false,
        container: null,
        src: null
    };

    var opts = $.extend({}, default_opts, in_opts);
    var cur_list;
    var lastFetchedIdx = -1;
    var selected = [];
    var onchange = [];
    var more;
    var waiter;
    var stringsCount = 0;

    var addItemsToListClbk = function (items, lastIdx) {
	stringsCount += items.length;

        if(stringsCount<opts['src'].totalCount()) {
            opts['container'].removeClass('noMoreStrings');
        } else if(stringsCount>=opts['src'].totalCount() || lastIdx<0 ) {
            opts['container'].addClass('noMoreStrings');
        }

        if (lastIdx>=0) {
            lastFetchedIdx = lastIdx;
        }
		addListItems(items);
    }
    // TODO: var select_all button
    // TODO: var select_none button

    var addListItems = function (items) {
        opts['container'].removeClass('stringsUpdating');
        $.each(items, function (idx, el) {
            cur_list.addListItem({
                id: el.id,
                str: el.str,
                selected: ($.inArray(parseInt(el.id), selected) >= 0 ? true : false)
            });
        });
    }

    var set_onchange_callback = function (func_name) {
        onchange.push(func_name);
    };

    var call_onchange_callback = function (eO) {
        $.each(onchange, function (i, el){ el(); });
    }

    var refreshList = function () {
        opts['container'].addClass('stringsUpdating');
        //opts['container'].addClass('noMore');
        stringsCount = 0;
        cur_list.clear();
        opts['src'].reset();
        opts['src'].getStrings({
            include: selected, // selected ids
            exclude: selected, // selected ids
            from: 0,
        });
    }

    var setSelected = function (selectedList) {
        selected = selectedList;
        cur_list.set_selected(selected);
    }

    var init = function () {
        cur_list = control_optionsList({'container':opts['container'], multi:opts['multi']});
        opts['src'].setCallbackNext(addItemsToListClbk);
        waiter = $('<div class="waiter"></div>').appendTo(opts['container']);
        more = $('<div class="rl_moreBtn">more</div><br>').appendTo(opts['container']);
        $(more).bind('click', function () {
		opts['container'].addClass('stringsUpdating');
            opts['src'].getStrings({
                exclude: selected,
                from: lastFetchedIdx+1,
            });
        });
        cur_list.onchange(function () {
            call_onchange_callback();
        });
    }

    init();

    return {
        refresh: refreshList,
        setSelected: setSelected,
        onchange: set_onchange_callback,

        getSelected: cur_list.get_selected,
        getSelectedValues: cur_list.get_selected_values,
        selectAll: cur_list.select_all,
        selectNone: cur_list.select_none,
        count: cur_list.count,
    };
}



// TRSH