/**
 * @param _params:
 *  inpEl - jQuery селектор инпута для хранения выбранных ссылок
 *  el - jQuery селектор контейнера контрола
 *  isCreate
 *  isLink
 *  isMulti
 *  refs - кэш-массив объектов  описывающие ссылки [{'id':'', 'name':''},...]
 *  documentId
 *  propertyId
 *  dependsOnEl - jQuery селектор инпута от значения которого зависит этот объект
 *  refTypes - []
 *  
 *  [addBtnCaption]
 *  [modBtnCaption]
 *  
*/
var refProperty = function(_params)
{
    var def_params = {
        'addBtnCaption': 'add',
        'modBtnCaption': 'modify',
        'emptyListCaption': 'There is no refs',
        'newRefCaption': 'New ref',
        'unlinkBtnCaption': '(x)',
        'refTypes': [],
        'popupTitle': 'Ref objects list'
    };
    var params = {}
    var that = {};
    
    var inpEl;
    var el;
    var cel;
    var refsListEl;
    var btnsPanelEl;
    var modBtnEl;
    var addBtnEl;
    var refListPopup;

    /**
     * События
     */
    var eventCallbacks = {};

    /**
     * Добавляет функцию для вызова в момент срабатывания события.
     *
     */
    var setEventCallback = function(eventType, callback)
    {
        if (typeof eventCallbacks[eventType] === 'undefined')
            eventCallbacks[eventType] = [];

        eventCallbacks[eventType].push(callback);
    }

    /**
     * Вызывает функции связанные с заданым событием.
     * @param string eventType - Обязательный параметр. Название события.
     * Все остальные параметры будут переданы в вызываемые функции.
     *
     */
    var triggerEvent = function(eventType)
    {
        var newArgs = [].slice.call(arguments);
        newArgs[0] = that;
        for (var i=0; i<eventCallbacks[eventType].length; i++) {
            eventCallbacks[eventType][i].apply(null, newArgs);
        }
    }

    /**
     * Возвращает ссылки из inpEl
     *
    */
    var getRefs = function()
    {
        return $.parseJSON(inpEl.val());
    }
    
    /**
     * Сохраняет ссылки в inpEl
     * @param {array} refs  массив ссылок
     *
    */
    var setRefs = function(refs)
    {
        inpEl.val($.toJSON(refs));
        triggerEvent('onRefsListChanged');
        inpEl.trigger('change');
    }
    
    /**
     * По refId возвращает объект из params['refs']
     *
    */
    var getRefInfo = function(refId)
    {
        for (var i=0, j=params['refs'].length; i<j; i++) {
            if (+params['refs'][i]['id']===+refId) {
                return params['refs'][i];
            }
        }
        return {};
    }

    var addRefInfo = function(ref)
    {
        for (var i=0, j=params['refs'].length; i<j; i++) {
            if (+params['refs'][i]['id']===+ref['id']) {
                return;
            }
        }
        params['refs'].push(ref);
    }

    /**
     * Возвращает зависим ли этот объект
     *
    */
    var isDependsOn = function()
    {
        return (params['dependsOnEl']?true:false);
    }

    /**
     * Возвращает занчение от которого зависит
     *
    */
    var getDependsOnValue = function()
    {
        try {
            if (isDependsOn()) {
                var retVal = $.parseJSON($(params['dependsOnEl']).val());
                if ($.isArray(retVal))
                    retVal = retVal[0];
                return retVal;
            } else {
                return false;
            }
        } catch (e) {
            throw e;
        } finally {
        }
    }


    /**
     * Отрисовывает "раму" контрола
     * 
    */    
    var renderControl = function()
    {
        cel = $('<div class="refs empty"></div>').appendTo(el);
        refsListEl = $('<div class="refsList"></div>').appendTo(cel);
        $('<div class="emptyRefsList">' + params['emptyListCaption'] + '</div>').appendTo(cel);
        
        btnsPanelEl = $('<div class="btnsPnl"></div>').appendTo(cel);
        if (params['isCreate']) {
            addBtnEl = $('<span class="link_plus"></span><span class="add_two">'
                         + params['addBtnCaption']
                         + '</span><br><br>').appendTo(btnsPanelEl); 
        }
        if (params['isLink']) {
            modBtnEl = $('<span class="link_change"></span><span class="slink">'
                         + params['modBtnCaption']
                         + '</span>').appendTo(btnsPanelEl);
        }
    }
    
    /**
     * Отрисовывает список ссылок
     *
    */
    var renderRefsList = function()
    {
        refsListEl.empty();
        var refs = getRefs();
        if (refs.length) {
            cel.toggleClass('empty', false);
            for (var i=0, j=refs.length; i<j; i++) {
                renderRefsListAddItem(getRefInfo(refs[i]));
            }
        } else {
            cel.toggleClass('empty', true);
        }
    }
    
    /**
     * Отрисовывает ссылку списка ссылок
     * @param {object} ref
     *
    */
    var renderRefsListAddItem = function(ref)
    {
	var doc_name = ref['name'];
	doc_name = doc_name.substring(0, 90);
	
        return $('<div id="' + ref['id'] + '" class="multi_garmonb"><div refId="'
          + ref['id'] + '" class="' +(params['isCreate']?'mg_caption':'')+ '"><span>' + doc_name
          + '</span><span class="newRefCaption">' + params['newRefCaption']
          + '</span><span class="unlinkBtn">' + params['unlinkBtnCaption'] 
          + '</span></div><div class="mg_content garmonb_hidden"></div></div>')
        .appendTo(refsListEl);
    }
    
    /**
     * калбэк для нажатия на элемент в списке ссылок
     *
    */
    var refsListItemClick = function()
    {
        //de_get_gormon(this, $(this).attr('refId'));
		
		// подразумеваем, что это так же разрешает редактирование документов
		// по ссылкам.
		if (!params['isCreate'])
			return;
		
        var target = $(this).siblings('.mg_content');
        if (target.html().length===0) {
            target.toggleClass('garmonb_hidden', false);
            $(this).toggleClass('selected', true);
            deRefGetDocument(params['documentId'], params['propertyId'],
							 $(this).attr('refId'), target,
							 function(){});
        } else {
			target.toggleClass('garmonb_hidden');
		    $(this).toggleClass('selected');
        }

	return false;
    };


    
    var removeRefsListItem = function(refId)
    {
        refsListEl.find('div[refId=' + refId + ']').parent().remove();
    }

    /**
     * калбэк для нажатия на "добавить"
     *
    */
    //var addBtnClbk = function()
    //{
    //    //console.log('adding');
    //    if (!params['isCreate'])
    //        return;
    //}

    /**
     * калбэк для нажатия на "изменить"
     *
    */
    var modBtnClbk = function()
    {
        refListPopup.setSelected(getRefs());
        refListPopup.show();
    }

    var strings;
    var stringsTotalCount = 0;
    var stringsSrcCallback = function(clbk, f, count, inc, exc, moreParams)
    {
        if (!$.isArray(exc))
            exc = [];
        if(!$.isArray(inc))
            inc = [];
        count=90;
        var dov = getDependsOnValue();
        if (dov===false)
            dov = '';
            
		de_x_request($.extend({},
			      de_getPluginCallParams(params['documentId'], params['propertyId'], 'get_ddd'),
			      {'exc': exc.join(','),
			       'inc': inc.join(','),
			       'f': f,
			       'c': count,
			       'dependsOnValue': dov}),
		     function (data) {
			if (!$.isEmptyObject(data)) {
				stringsTotalCount = data['totalCount'];
				clbk(data['strings'], data['lastIdx']);
			}
		     });
    }

    var popupOnchangeCallback = function()
    {
        var selectedRefsId = refListPopup.getSelected();
        var selectedRefsName = refListPopup.getSelectedValues();
        if (!$.isArray(selectedRefsId)) {
            console.log('NOT ARRAY!');
            throw 'NOT ARRAY!';
        }
        setRefs(selectedRefsId);
        
        for (var i=0, j=selectedRefsId.length; i<j; i++) {
            addRefInfo({'id':selectedRefsId[i], 'name':selectedRefsName[i]});
        }
        
        renderRefsList();
    }

    /**
     * Инициализирует попап
     *
    */
    var initPopup = function(){
        strings = stringSource({
            'srcType': 'callback',
            'src': stringsSrcCallback,
            'totalCount': function () {
                return stringsTotalCount;
            }
        });
		
		refListPopup = control_reflist_popup({
			'changeRefDialogID': _params.inpEl + '_changeRefDialog',
			'stringsSrc': strings,
			'title': params['popupTitle'],
			'multi': params['isMulti']
		});

        refListPopup.onchange(popupOnchangeCallback);
    };

    /**
     * Создаёт новый объект
     *
    */
    var createNewRef = function(refType)
    {
        if (!params['isMulti'] && getRefs().length>0)
            return;

        var listItemId = 'refListNewItem_' + Math.floor(Math.random() * (9999 - 1000 + 1)) + 1000;
        var refCont = renderRefsListAddItem({
            'id': listItemId,
            'name':''
        });
        refCont.addClass('new');
        var refCont_content = refCont.find('.mg_content');
        
        refCont_content.append('<div style="padding-bottom: 200px; padding-top: 7px; padding-left: 7px;">'
                               + '<img src="' + de_res_dir
                               + '/ajax-loader.gif"></div>')
        .toggleClass('garmonb_hidden', false);
        
        var refTypeName = '';
        for (var i=0, j=params['refTypes'].length; i<j; i++) {
            if (''+params['refTypes'][i]['namevar']===''+refType) {
                refTypeName = params['refTypes'][i]['name'];
                break;
            }
        }
        refCont.find('.mg_caption').toggleClass('selected', true).find('>span:first').html(refTypeName);
        cel.toggleClass('empty', false);
        de_createSubObject(
                           params['documentId'],
                           params['propertyId'],
                           refType,
                           {'listItemId': listItemId},
                           function(data) {
                                refCont_content.empty().html(data);
                           }
        );
    }

    /**
     * Функция вызывается после создания ссылки
     *
    */
    var createNewRefFinal = function(ref, listItemId)
    {
        addRefInfo(ref);
        var refs = getRefs();
        refs.push(ref['id']);
        setRefs(refs);
        $('#' + listItemId + ' .mg_caption').attr('refId', ref['id']);
        // todo set attr refId !!!
    }

    var unlinkRef = function(refId)
    {
        console.log(refId);
        var refs = getRefs();
        for (var i=0, j=refs.length; i<j; i++) {
            if (+refs[i]===+refId) {
                refs.splice(i,1);
                setRefs(refs);
		removeRefsListItem(refId);
                //renderRefsList();
                return;
            }
        }
        
    }
    
    var init = function()
    {
        params = $.extend({}, def_params, _params);
        inpEl = $(params['inpEl']);
        el = $(params['el']);
        
        renderControl();
        renderRefsList();
        
        refsListEl.delegate('.mg_caption', 'click', refsListItemClick);
        refsListEl.delegate('.unlinkBtn', 'click', function(){
            unlinkRef($(this).parent().attr('refId'));
            return false;
        });
        
        if (params['isCreate']) {

            var refTypesCount = params['refTypes'].length;
            if (refTypesCount===1) {
                addBtnEl.bind('click', function(){
                    createNewRef(params['refTypes'][0]['namevar']);
                });
            } else if(refTypesCount>1) {
                var contextItems = {};
                for (var i=0; i<refTypesCount; i++) {
                    contextItems[params['refTypes'][i]['name']] = function(namevar) {
                        return function(){createNewRef(namevar);}
                    }(params['refTypes'][i]['namevar']);
                }
                addBtnEl.contextmenu(contextItems, 'hold', 0);
            }

            if (!params['isMulti']) {
                if (getRefs().length) {
                    addBtnEl.hide();
                }

                setEventCallback('onRefsListChanged', function(){
                    if (params['isMulti'])
                        return;
                    if (getRefs().length>0) {
                        addBtnEl.hide();
                    } else {
                        addBtnEl.show();
                    }
                });
            }

        }
       
        if (params['isLink']) {
            modBtnEl.bind('click', modBtnClbk);
            initPopup();
            
            if (isDependsOn()) {
                $(params['dependsOnEl']).change(function(){
                    //console.log('implement onchange dependson');
                    setRefs([]);
                    renderRefsList();
		    //setStoredValues([]);
                    //$(opts['resultEl']).empty();
                });
            }
        }

        setEventCallback('onRefsListChanged', function(){
            console.log('refs List changed');
        });
    }
    
    that['addRef'] = createNewRefFinal;

    init();
    
    return that;    
}


