/**
 * Класс отображающий список опций.
 * Базовый класс для списка. Назначение: 
 *  1) отображение списка опций;
 *  2) очистка списка / поэлементная его постройка
 *  3) получение идентификаторов выделенных опций
 *  4) получение строковых значений выделенных опций
 *  5) работа с выделениями (установка для конкретного элемента,
 *     установка нескольких выделений, сброс)
 *
 * Конструктор
 *   @param opts
 *     opts[multi] (default:false)
 *     opts[container] - контейнер в котором будет рисоваться контрол
 *
 * Методы:
 * get_selected
 * get_selected_values
 * set_selected
 * select_none
 * select_all
 * set_onchange_callback
 * clear
 * count
 * addListItem
 *
 * События:
 * onchange
 *
 *
*/
function control_optionsList (opts) {

    var rand_id = Math.floor((1000-99)*Math.random()) + 100;
    var parent = $(opts['container']);
    var onchange = [];
    var selected = [];
    var ul_selected;
    var ul;
    var multi = (opts['multi']===true ? true : false);

    /**
     * Добавляет опцию в список
     *
     * @param opts
     *   id (required)
     *   str (default - идентификатор опции (id))
     *   selected (default - false)
     */
    var addListItem = function (opts) {
        var cur_li; var inp;
        if (typeof(opts['id']) == 'undefined') {
            throw 'undefined list item id';
        }
        if (!opts['str'])
            opts['str'] = opts['id'];
        cur_li = $('<li id="'+_id('li', count())+'"></li>').appendTo((opts['selected'] ? ul_selected : ul));
        $('<div id="'+_id('i', opts['id'])+'" class="ol_item"><span class="ol_checkbox"></span><span class="ol_caption">'+opts['str']+'</span></div>')
            .appendTo(cur_li)
            .toggleClass('selected', (opts['selected'] ?true:false))
            .data('list_id', opts['id']);
    };

    /**
     * Перестраивает список опций. Выбранные переносит в список для выбранных.
     * Невыбранные в список для не выбранных. Сортировка остаётся оригинальной.
     *
    */
    var redrawList = function () {
        // TODO :-)
    }

    /**
     * Генерирует идентификатор элемента. На вход подаются составные части идентификатора.
     *
    */
    var _id = function () {
        return $.merge( ['salt', rand_id], arguments ).join('_');
    }


    /**
     * Возвращает идентификаторы выбранного/выбранных элементов
     *
     *
    */
    var getSelected = function () {
        retVal = [];
        $('#'+_id('uls')+' .ol_item.selected, '+'#'+_id('ul')+' .ol_item.selected').each(function (i, el) {
            retVal.push($(el).data('list_id'));
        });
        return retVal;
    };

    /**
     * Возвращает строковые значения выбранного/выбранных элементов
     *
     *
     */
    var getSelectedStrings = function () {
        retVal = [];
        $('#'+_id('uls')+' .ol_item.selected .ol_caption, '+'#'+_id('ul')+' .ol_item.selected .ol_caption').each(function (i, el) {
            retVal.push($(el).html());
        });
        return retVal;
    };

    /**
     *
     *
     *
     */
    var _selectItem = function (el) {
        $(el).toggleClass('selected',true);
    }

    /**
     * Помечает опцию/опции как выбранные
     * @param toSelect
     *   [id1,idn]
     *   id1
     * Функция не снимает предыдущие выделения!
     */
    var set_selected = function (toSelect) {
        if ($.isArray(toSelect)) {
            $.each(toSelect, function(i, el){
                _selectItem('#'+_id('i', el));
            });
        } else {
            _selectItem('#'+_id('i', toSelect));
        }
        call_onchange_callback();
    };

    /**
     *
     *
     *
     */
    var select_none = function () {
        $('#'+_id('uls')+' .ol_item, '+'#'+_id('ul')+' .ol_item').toggleClass('selected', false);
        call_onchange_callback();
    };

    /**
     *
     *
     *
     */
    var select_all = function () {
        if (multi) {
            $('#'+_id('uls')+' .ol_item, '+'#'+_id('ul')+' .ol_item').toggleClass('selected', true);
            call_onchange_callback();
        }
    };

    /**
     * Удаляет все опции из списка
     *
     *
     */
    var clearItems = function () {
        $(ul).empty();
        $(ul_selected).empty();
    }

    /**
     * Возвращает количество опции
     *
     *
    */
    var count = function () {
        return $('#'+_id('uls')+' .ol_item, '+'#'+_id('ul')+' .ol_item').length;
    }

    /**
     * Добавляет хэндлер для события
     *
     *
     */
    var set_onchange_callback = function (func_name) {
        onchange.push(func_name);
    };

    /**
     * Вызывает хэндлеры для события
     *
     *
     */
    var call_onchange_callback = function (eO) {
        // TODO: какие параметры передававть в callback и в каком контексте выполнять?
        $.each(onchange, function (i, el){
		el();
	});
    }

    /**
     * Угадай что
     *
     *
     */
    var init = function () {
        ul_selected = $('<ul id="'+_id('uls')+'" class="optionsList"></ul>').appendTo(parent);
        ul = $('<ul id="'+_id('ul')+'" class="optionsList"></ul>').appendTo(parent);

	if ($.isArray(opts['selected']))
	        set_selected(opts['selected']);
	if (typeof(opts['onchange']) == 'function')
		onchange.push(opts['onchange']);

        $('#'+_id('uls')+' .ol_item, '+'#'+_id('ul')+' .ol_item').live('click', function (event) {
            if (multi) {
                $(event.currentTarget).toggleClass('selected');
            } else {
                var el = $(event.currentTarget);
                if (el.hasClass('selected')) {
                    el.toggleClass('selected', false);
                } else {
                    $('#'+_id('uls')+' .ol_item, '+'#'+_id('ul')+' .ol_item').toggleClass('selected', false);
                    el.toggleClass('selected', true);
                }
            }
            call_onchange_callback();
        });
    }

    init();

    return {
        get_selected: getSelected,
        get_selected_values: getSelectedStrings,
        set_selected: set_selected,
        select_all: select_all,
        select_none: select_none,
        onchange: set_onchange_callback,
        clear: clearItems,
        addListItem: addListItem,
        count: count
    };

} // control_reflist
