MediaField = function(_params)
{
    var defaultParams = {
        'documentId': '', // @todo required
        'propertyId': '', // @todo required
        'templateEl': '', // @todo required
        'containerEl': '', // @todo required
        'multi': false,
        'required': false,
        'propertyValues': '' // @todo required
    };
    var params = {};
    var templateEl, containerEl, mediaListEl, uploaderEl;
    var pvalues;



    var init = function()
    {
        params = $.extend({}, defaultParams, _params);
        //params['multi'] = true; // @test. удалить после тестов и настроек
        pvalues = params['propertyValues'];
        templateEl = $(params['templateEl']);
        containerEl = $(params['containerEl']);
        mediaListEl = containerEl.find('.mediaList');
        uploaderEl = containerEl.find('.uploaderContainer');
    }



    var show = function()
    {
        showMediaList();
        showUploader();
        showRestoreMedia();
    }



    var showMediaList = function()
    {
        mediaListEl.empty();
        containerEl.removeClass('hasDeleted');
        for (var i=0, j=pvalues.count(); i<j; i++) {
            createMediaListItem(i);
        }
    }



    var createMediaListItem = function(valIdx)
    {
//console.log('Cloning...');
        var clone, mediaValue;
        mediaValue = pvalues.getValue(valIdx);
        
        clone = templateEl.clone();
        clone.find('.medianame').html(mediaValue.getDisplay());
        clone.find('.mediaid').html(mediaValue.getV0());
        
        if (mediaValue.isToDelete()
            /*&& !mediaValue.isNew()*/
        ) {
            //console.log('deleted & not new');
            clone.addClass('deleted');
            containerEl.addClass('hasDeleted');
        }
        
        if (mediaValue.isNew()) {
            //console.log('new');
            clone.addClass('new');
        }
        
        if (mediaValue.isToUpdate()) {
            //console.log('to update');
            clone.addClass('toupdate');
        }
        
        
        clone.find('.deleteBtn').bind('click', function() {
            mediaValue.deleteValue();
            clone.addClass('deleted');
            containerEl.addClass('hasDeleted');
        });
        
        clone.find('.restoreBtn').bind('click', function() {
            mediaValue.undeleteValue();
            clone.removeClass('deleted');
            if (mediaListEl.find('.deleted').length > 0) {
                containerEl.toggleClass('hasDeleted', true);
            } else {
                containerEl.toggleClass('hasDeleted', false);
            }
        });
        
        var ct = contentTypeUtls.getContentTypeFromFilename(mediaValue.getDisplay());
        var cth = contentTypeUtls.getContentTypeHandler(ct);
        clone.find('.mediaContentType').html(cth['title']);
        clone.find('.previewBtn').bind('click', function() {
                cth['preview'](mediaValue.getV0(), mediaValue.getDisplay());
            }
        );
        clone.find('.downloadBtn').bind('click', function() {
                window.location = params['downloadUrl'] + mediaValue.getV0();
            }
        );
        
        clone.addClass(ct);
        
        clone.appendTo(mediaListEl);
        //console.log('...cloning!');
        return clone;
    }



    var showUploader = function()
    {
        uploaderEl.undelegate('input[type="file"]', 'change', uploadClbk);
        uploaderEl.delegate('input[type="file"]', 'change', uploadClbk);
        uploaderEl.find('input[type="file"]').each(function(idx, el){
            if ((''+$(el).attr('id')).length === 0) {
                $(el).attr('id', 'mediaFile_' + params['documentId'] + '_'
                        + params['propertyId'] + '_' + idx);
            }
        });
    }
    
    
    
    var showRestoreMedia = function()
    {
        var restoreClbk = function() {
            restoreAllMedia();
            showMediaList();
        }
        
        containerEl.find('.restoreAllBtn').unbind('click', restoreClbk).bind('click', restoreClbk);
    }



    var setUploadState = function(state, isAddRemove)
    {
        if (isAddRemove===true || isAddRemove===false) {
            
        } else {
            containerEl.removeClass('uploading');
            containerEl.removeClass('uploadError');
            containerEl.removeClass('uploadSucc');
            isAddRemove = true;
        }
        state = state + '';
        if ('uploading'===state) {
            containerEl.toggleClass('uploading', isAddRemove);
        } else if ('fail'===state) {
            containerEl.toggleClass('uploadError', isAddRemove);
        } else if ('succ'===state) {
            containerEl.toggleClass('uploadSucc', isAddRemove);
        } else {
            //
        }
    }



    var uploadClbk = function(eo){
        var target = $(eo.target);
        var clearNameOnExit=false;
        var name = target.attr('name');
        if (name == undefined || target.attr('name').length==0) {
            target.attr('name', 'file');
            clearNameOnExit=true;
        }
        
        uploadFile($(eo.target).attr('id'));
        
        if (clearNameOnExit) {
            target.attr('name', '');
        }
    }



    var uploadFile = function(inputFileId)
    {
        setUploadState('uploading');
        $.ajaxFileUpload({
            'url': de_getConnectorUrlString(true, true),
            'fileElementId': inputFileId,
            'dataType': 'json',
            'data': $.extend({},
                             de_getPluginCallParams(params['documentId'],
						    params['propertyId'],
						    'proccessFileUpload')),
            'success': function(data, status) {
                //console.log('succ', data);
                //data['status'] = false; // @test. удалить после тестов
                try {
                    if (data['status']) {
                        setUploadState('succ', true);
                        uploadSucc(data['answer']);
                    } else {
                        throw "Uploading fail";
                    }
                } catch (e) {
                    console.log(e);
                    setUploadState('fail', true);
                    //uploadFail();
                }
            },
            'error': function(data, status, e) {
                console.log(e);
                setUploadState('fail', true);
                //uploadError();
            },
            'complete': function(xml, status) {
                setUploadState('uploading', false);
            }
        });
    }



    var uploadSucc = function(uploadedMediaInfo)
    {
        var /*valIdx,*/ value;
        if (params['multi']) {
            //var valIdx = pvalues.createValue();
            //value = pvalues.getValue(valIdx);
            value = pvalues.createValue();
        } else {
            //valIdx = 0;
            value = pvalues.getValue(0);
            value.undeleteValue();
        }
        value.setV0(uploadedMediaInfo['id']);
        value.setDisplay(uploadedMediaInfo['name']);
        showMediaList();
    }



    var restoreAllMedia = function()
    {
        for (var i=0, j=pvalues.count(); i<j; i++) {
            pvalues.getValue(i).undeleteValue();
        }
    }



    init();



    return {
        'show': show,
        'showMediaList': showMediaList
    };
}



/**
 * Перенести в de.js
 *
*/
ValuesValue = function(propertyValues, valIdx)
{
    var allowedKeys = ['V0', 'V1', 'V2', 'DISPLAY'];
    var flags2 = ['isNew', 'isToDelete', 'isToUpdate'];
    var value;



    var init = function()
    {
        if (typeof propertyValues === 'undefined') {
            throw "Bad propertyValues";
        }
        
        if (isNaN(valIdx))
            valIdx = 0;
            
        getRowValueFromStorage();
    }



    var getValue = function(valName) // return value[valName]
    //overloading: function() // return value
    {
        if (typeof valName !== 'undefined') {
            valName = valName.toUpperCase();
            if (jQuery.inArray(valName, allowedKeys) < 0)
                throw "Not allowed key!";
        }
        
        try {
            getRowValueFromStorage();
            if (typeof valName === 'undefined') {
                return value;
            } else {
                return value[valName];
            }
        } catch (e) {
            return;
        }
    }



    var setValue = function(valName, valValue)
    //overloading: function({})
    {
        var newValue;
        if (arguments.length===2) { // function(valName, valValue)
            newValue = {};
            newValue[arguments[0]] = arguments[1];
        } else if (arguments.length===1
                   && $.isPlainObject(arguments[0]))
        { // function({})
            newValue = arguments[0];
        } else {
            throw "Bad arguments!";
        }
        
        $.each(newValue, function(k,v) {
            if (jQuery.inArray(k+'', allowedKeys) < 0)
                throw "Not allowed key!";
        });
        
        try {
            getRowValueFromStorage();
            value = $.extend({}, value, newValue);
            if (!!value['isNew']===false)
                value['isToUpdate'] = true;
            setRowValueToStorage();
        } catch (e) {
            console.dir(e); // debug only
            return;
        }
    }



    var flagState = function(flagName, is)
    {
        try {
            getRowValueFromStorage();
            if (flags2.indexOf(flagName) < 0) {
                throw "Wrong flag name";
            }
            if (typeof is !== 'undefined') {
                value[flagName] = !!is;
                setRowValueToStorage();
                return true;
            } else {
                return !!value[flagName];
            }
        }  catch (e) {
            console.dir(e);
            return; // ?
        }
    }



    var getRowValueFromStorage = function()
    {
        value = propertyValues.getRowValueFromStorage(valIdx);
    }



    var setRowValueToStorage = function()
    {
        propertyValues.setRowValueToStorage(valIdx, value);
    }



    init();



    return {
        'getV0': function(){ return getValue('V0'); },
        'getV1': function(){ return getValue('V1'); },
        'getV2': function(){ return getValue('V2'); },
        'getDisplay': function(){ return getValue('DISPLAY'); },
        'setV0': function(value){ return setValue('V0', value); },
        'setV1': function(value){ return setValue('V1', value); },
        'setV2': function(value){ return setValue('V2', value); },
        'setDisplay': function(value){ return setValue('DISPLAY', value); },
        'isNew': function(){ return flagState('isNew'); },
        'isToDelete': function(){ return flagState('isToDelete'); },
        'isToUpdate': function(){ return flagState('isToUpdate'); },
        'deleteValue': function(){ return flagState('isToDelete', true); },
        'undeleteValue': function(){ return flagState('isToDelete', false); },
        'getValIdx': function(){ return valIdx; }
    };
}



/**
 * Перенести в de.js
 *
*/
/**
 * see valuesToJSON comments
*/
PropertyValues = function(valuesStorage)
{
    var storage;
    var values = [];
    var _this = {};
    
    var init = function()
    {
        storage = $(valuesStorage);
    }



    var createValue = function()
    {
        var retVal;
        try {
            var values = getValuesFromStorage();
            retVal = values.push({'isNew':true});
            retVal--;
            setValuesToStorage(values);
        } catch (e) {
            console.dir(e); // debug only
        } finally {
            return getValue(retVal);
        }
    }



    var getValue = function(valIdx) // return values[valIdx]
    //overloading: function() // return values[0]
    {
        if (isNaN(valIdx)) {
            valIdx = 0;
        }
        if (typeof values[valIdx] === 'undefined') {
            values[valIdx] = ValuesValue(_this, valIdx);
        }
        return values[valIdx];
    }
    
    
    
	var count = function()
	{
		try {
			var values = getValuesFromStorage();
			//Для немножественных пустых полей показываем, что картинки нет
			if (values.length == 1) {
				if (values[0].PLURAL == null && values[0].V0 == null) {
					return 0;
				}
			}
			return values.length;
		} catch (e) {
			return 0;
		}
	}



    var getRowValueFromStorage = function(valIdx)
    //overloading: function()
    {
        if (isNaN(valIdx))
            valIdx = 0;
            
        var values = getValuesFromStorage();
        if (+valIdx!==0 && typeof values[valIdx] === 'undefined') {
            throw "Bad valIdx!";
        }
        
        return values[valIdx];
    }



    var setRowValueToStorage = function(valIdx, value)
    //overloading: function(value)
    {
        if (arguments.length===1) {
            value = arguments[0];
            valIdx = 0;
        }
        
        var values = getValuesFromStorage();
        if (+valIdx!==0 && typeof values[valIdx] === 'undefined') {
            throw "Bad valIdx!";
        }
        
        values[valIdx] = value;
        
        setValuesToStorage(values);
    }



    var getValuesFromStorage = function()
    {
        //console.log('reading values from storage');
        try {
            return $.parseJSON(storage.val());
        } catch (e) {
            return [];
        }
    }



    var setValuesToStorage = function(values)
    {
        //console.log('writing values from storage');
        try {
            storage.val($.toJSON(values));
            storage.trigger('change');
        } catch (e) {
        }
    }



    //var undeleteAllValues = function()
    //{
    //    
    //}



    //var addEvent = function(eventName, callback)
    //{
    //    
    //}



    //var retObj = {
    //    'getValue': getValue,
    //    'createValue': createValue,
    //    'count': count,
    //    'getRowValueFromStorage': getRowValueFromStorage,
    //    'setRowValueToStorage': setRowValueToStorage
    //};

    _this['getValue'] = getValue;
    _this['createValue'] = createValue;
    _this['count'] = count;
    _this['getRowValueFromStorage'] = getRowValueFromStorage;
    _this['setRowValueToStorage'] = setRowValueToStorage;
    //_this['undeleteAllValues'] = undeleteAllValues;
    //_this['addEvent'] = addEvent;



    init();



    return _this;
}



var contentTypeUtls = {
    'contentTypeHandlers': {
        'image': {
            'title': 'Картинкa',
            'preview': function(mediaId, filename) {
                    getCSS(js_url + '/j/fancybox/jquery.fancybox-1.3.4.css');
                    head.js(js_url + '/j/fancybox/jquery.easing-1.3.pack.js',
                            js_url + '/j/fancybox/jquery.fancybox-1.3.4.pack.js',
                            function(){
                                //alert('А тут должна быть превьюшка для картинки с именем "' + filename + ' "');
                                $.fancybox({
                                    'href':'$$$IMAGES_URL/idb2/image_preview.php?id=' + mediaId,
                                    'type': 'image'
                                });
                            }
                    );
            }
        },
        'msword': {
            'title': 'Документ Word',
            'preview': function() {
                alert('Документ Word');
            }
        },
        'msexcel': {
            'title': 'Книга Excel',
            'preview': function() {
                alert('Книга Excel');
            }
        },
        'pdf': {
            'title': 'Документ PDF',
            'preview': function() {
                alert('Документ PDF');
            }
        },
        'unknown': {
            'title': 'unknown',
            'preview': function() {
                alert('Просмотр недоступен (неизвестный тип файла)');
            }
        },

    },
   
    'extToContentType': {
        'jpeg': 'image',
        'jpg': 'image',
        'gif': 'image',
        'png': 'image',
        'doc':  'msword',
        'docx': 'msword',
        'pdf':  'pdf',
        'xls':  'msexcel',
        'xlsx': 'msexcel'

    },
    
    'defaultContentType': 'unknown',
    
    'getContentTypeFromFilename': function(filename) {
        var fileext = this.getFilenameExt(filename);
        var ct = this.extToContentType[fileext];
        if (!ct) {
            ct = this.defaultContentType;
        }
        return ct;
    },
    
    'getContentTypeHandler': function(contentType)
    {
        var contentTypeHandler = this.contentTypeHandlers[contentType];
        return contentTypeHandler;
    },
    
    'getFilenameExt': function(filename) {
        var re = /\S+\.(\w+)$/i;
        var res = re.exec(filename);
        if (res!==null) {
            return res[res.length-1].toLowerCase();
        } else {
            return '';
        }
    }
}



    //var getValue = function(valIdx, valName) // return values[valIdx][valName]
    ////overloading: function(string valName) // return values[0][valName]
    ////overloading: function(int valIdx) // return values[valIdx]
    ////overloading: function() // return values[0]
    //{
    //    if (+arguments.length===1) {
    //        if (isNaN(arguments[0])) { // function(string valName)
    //            valName = arguments[0];
    //            valIdx = 0;
    //        } else { // function(int valIdx)
    //            valName = undefined;
    //            valIdx = arguments[0];
    //        }
    //    } else if (+arguments.length===0) { // function()
    //        valName = undefined;
    //        valIdx = 0;
    //    }/* else { // function(valIdx, valName)
    //        
    //    }*/
    //    
    //    if (typeof valName !== 'undefined') {
    //        valName = valName.toUpperCase();
    //        if (jQuery.inArray(valName, allowedKeys) < 0)
    //            throw "Not allowed key!";
    //    }
    //    
    //    try {
    //        var values = getValuesFromStorage();
    //        if (typeof valName === 'undefined') {
    //            return values[valIdx];
    //        } else {
    //            return values[valIdx][valName];
    //        }
    //    } catch (e) {
    //        return;
    //    }
    //}
    //
    //
    //
    //var setValue = function(valIdx, valName, value)
    ////overloading: function(valIdx, {})
    ////overloading: function(valName, value)
    ////overloading: function({})
    //{
    //    var newValue;
    //    if (arguments.length===2) {
    //        if ($.isPlainObject(arguments[1])) { // function(valIdx, {})
    //            newValue = arguments[1];
    //        } else { // function(valName, value)
    //            //value = arguments[1];
    //            //valName = arguments[0];
    //            valIdx = 0;
    //            newValue = {};
    //            //newValue[valName] = value;
    //            newValue[arguments[0]] = arguments[1];
    //        }
    //    } else if (arguments.length===3) { // function(valIdx, valName, value)
    //        newValue = {};
    //        newValue[valName] = value;
    //    } else if (arguments.length===1) { // function({})
    //        newValue = arguments[0];
    //        valIdx = 0;
    //    } else {
    //        throw "Bad arguments!";
    //    }
    //    
    //    $.each(newValue, function(k,v){
    //        if (jQuery.inArray(k+'', allowedKeys) < 0)
    //            throw "Not allowed key!";
    //    });
    //    
    //    try {
    //        var values = getValuesFromStorage();
    //        if (+valIdx!==0 && !isTrueIdx(valIdx, values)) {
    //            throw "Bad valIdx!";
    //        }
    //        values[valIdx] = $.extend({}, values[valIdx], newValue);
    //        if (!!values[valIdx]['isNew']==false)
    //            values[valIdx]['isToUpdate'] = true;
    //        setValuesToStorage(values);
    //    } catch (e) {
    //        console.dir(e); // debug only
    //        return;
    //    }
    //}
    


    //var deleteValue = function(valIdx)
    //{
    //    flagState(valIdx, 'isToDelete', true);
    //}
    //
    //
    //
    //var undeleteValue = function(valIdx)
    //{
    //    flagState(valIdx, 'isToDelete', false);
    //}
    //
    //
    //
    //var isNew = function(valIdx)
    //{
    //    return flagState(valIdx, 'isNew');
    //}
    //
    //
    //
    //var isToUpdate = function(valIdx)
    //{
    //    return flagState(valIdx, 'isToUpdate');
    //}
    //
    //
    //
    //var isToDelete = function(valIdx)
    //{
    //    return flagState(valIdx, 'isToDelete');
    //}
    //var flagState = function(valIdx, flagName, is)
    //{
    //    var flags2 = ['isNew', 'isToDelete', 'isToUpdate'];
    //    if (isNaN(valIdx))
    //        valIdx = 0;
    //    try {
    //        var values = getValuesFromStorage();
    //        if (+valIdx!==0 && !isTrueIdx(valIdx, values)) {
    //            throw "Bad valIdx3!";
    //        }
    //        if (flags2.indexOf(flagName)<0) {
    //            throw "Wrong flag name";
    //        }
    //        if (typeof is !== 'undefined') {
    //            values[valIdx][flagName] = !!is;
    //            setValuesToStorage(values);
    //            return true;
    //        } else {
    //            return !!values[valIdx][flagName];
    //        }
    //    }  catch (e) {
    //        console.dir(e);
    //        return; // ?
    //    }
    //}
    //var isTrueIdx = function(idx, values)
    //{
    //    for(i in values) {
    //        if (!values.hasOwnProperty(i))
    //            continue;
    //        if (+i===+idx) {
    //            return true;
    //        }
    //    }
    //    return false;
    //}