if (!window.console) console = {};
console.log = console.log || function(){};
console.warn = console.warn || function(){};
console.error = console.error || function(){};
console.info = console.info || function(){};


/**
 * возвращает объект содержащий переменные запроса для доступа к плагину
 * документа или свойства.
 *
*/
de_getPluginCallParams = function(documentId, propertyId, callName)
{
	var params = {};
	documentId=+documentId;
	propertyId=+propertyId;
	if (documentId===0)
		documentId = NaN;
	if (propertyId===0)
		propertyId = NaN;

		
	if (isNaN(documentId) && isNaN(propertyId)) {
		throw "Wrong plugin target.";
	}
	
	if (typeof callName === 'undefined') {
		callName = '';
	}
	
	callName = '' + callName;
	
	if (callName==='')
		throw "Wrong plugin target.";
	
	if (!isNaN(documentId)) {
		params['icTO'] = documentId;
	}

	if (!isNaN(propertyId)) {
		params['icTP'] = propertyId;
	}
	
	params['call'] = callName;

	return params;	
}


de_getConnectorUrlString = function(isInternal, isAjax)
{
    return de_connector['url'] 
           + '?' + de_connector['get_prefix']
           + (isInternal ? '&' + de_connector['get_internal'] : '' )
           + (isAjax ? '&' + de_connector['ajax_marker'] : '' )
           + '&sTok=' + de_connector['sessionToken'] ;
}



/**
 * @param el jQuery-селектор на контейнер подобъектов.
 * @param tmpl_el jQuery-селектор на контейнер с шаблоном.
 * @param document_id
 * @param property_id
 *
*/
function de_createSubObject(document_id, property_id, subobject_type, params, callback)
{
    $.get(de_getConnectorUrlString(true, true),
		  $.extend({},
				   de_getPluginCallParams(document_id, property_id, 'createSubObject'),
				   params,
				   {'type': subobject_type}),
		  callback
		  );
}



function deRefGetDocument(docId, propId, targetId, contentHolder, callback)
{
    $(contentHolder).empty().append('<div style="padding-bottom: 200px; padding-top: 7px; padding-left: 7px;"><img src="'+de_res_dir+'/ajax-loader.gif"></div>');
    $.get(de_getConnectorUrlString(true, true),
		  $.extend({},
				   de_getPluginCallParams(docId, propId, 'getSubDocument'),
				   {'documentId': targetId}),
		  function(data) {
			//alert(data);
			//console.log(data);
			$(contentHolder).empty();
			$(contentHolder).html(data);
				if (typeof callback==='function')
				callback();
		  }
	);

}



function deLoadRefControl(docId, propId, container)
{
	//console.log('ss');
	if ($(container).data('loaded')===true) {
		return;
	}

	$(container).empty().addClass('loadingSpinner');
	var url = de_getConnectorUrlString(true, true);
	$.get(url,
		  $.extend({},
				   de_getPluginCallParams(docId, propId, 'getControl'))
	).success(function(data) {
		$(container).data('loaded', true);
		$(container).html(data);
	}).complete(function() {
		$(container).removeClass('loadingSpinner');
	});
	
}



/**
 * 
 *
 *
*/
function de_x_request($reqdata, callback_succ)
{
    $.getJSON(
	de_getConnectorUrlString(true, true),
	$reqdata,
	function(data){
	    callback_succ( data?data['answer']:{} );
	}
    );
}



var cLog = function()
{
	if (console) {
		var newArgs = ['DE REPORTS:'];
		for (var i=0; i<arguments.length; i++) {
			newArgs.push(arguments[i]);
		}
		console.log.apply(console, newArgs);
	}
}



var cWarn = function()
{
	if (console) {
		var newArgs = ['DE REPORTS:'];
		for (var i=0; i<arguments.length; i++) {
			newArgs.push(arguments[i]);
		}
		console.warn.apply(console, newArgs);
	}
}



var cErr = function()
{
	if (console) {
		var newArgs = ['DE REPORTS:'];
		for (var i=0; i<arguments.length; i++) {
			newArgs.push(arguments[i]);
		}
		console.error.apply(console, newArgs);
	}
}



var cInfo = function()
{
	if (console) {
		var newArgs = ['DE REPORTS:'];
		for (var i=0; i<arguments.length; i++) {
			newArgs.push(arguments[i]);
		}
		console.info.apply(console, newArgs);
	}
}



var formInSave = false;
var saveForm = function(historyBack, setStatus) {
	cInfo('Saving started!!!');

	if (formInSave) {
		cError('Saving aborted. Already in progres.');
		return '';
	}
	formInSave = true;
	$('.saverHelper.saverPB').css('display','inline-block');
	$('.saverHelper.saverOK').fadeOut("fast");
	$('.saverHelper.saverFail').fadeOut("fast");
	if (setStatus > 0) {
		$("#setMainDocumentStatus").val(setStatus);
	}

//console.log($('#frm_documentEditor').serialize());
//	var str = decodeURIComponent($('#frm_documentEditor').serialize());
var str = $('#frm_documentEditor').serialize();
//var str = encodeURIComponent($('#frm_documentEditor').serialize());
console.log(str);
//console.log(str);
//console.log(encodeURIComponent(str));

	//var url = '{$options["connector_url"]}?{$options["connector_prefix"]}&{$options["connector_internallcall_prefix"]}&'+de_connector['ajax_marker'];

//	var url = de_connector['url'] + '?'
//		+ de_connector['get_prefix'] + '&'
//		+ de_connector['get_internal'] + '&'
//		+ de_connector['ajax_marker'];
	cLog('Sending request');
	var url = de_getConnectorUrlString(true, true);
	//alert(url);
	$.ajax({
		url:url,
		data: str,
		type: 'POST',
		success: function(data) {
			cLog('Request answer', data);
			try {
				data = $.parseJSON(data);
				if (!data['status']){
					throw 'Error during saving!';
				}
				$('.saverHelper.saverOK').fadeIn("fast");
				formInSave=false; // comment after debugging
				if (historyBack > 0) {
					cookie_date = new Date();
					cookie_date.setTime ( cookie_date.getTime() + 30 * 24 * 60 * 60);
					document.cookie ="editor_history_back=1; path=/; expires=" + cookie_date.toGMTString();
					history.back();
				} else {
					cookie_date = new Date();
					cookie_date.setTime ( cookie_date.getTime() - 10);
					document.cookie = "editor_history_back=; path=/; expires=" + cookie_date.toGMTString();
					setTimeout(function() {
						if (window.disablePageReloadOnSave!==true)
							location.reload(true); // uncomment for production
					}, 200);
				}
			} catch (e) {
				cErr(e.message);
				//console.error('DE reports:' + e.message);
				$('.saverHelper.saverFail').show();
				formInSave=false;
			} finally {
				console.info('DE reports: Saving finished.');
				console.log(data);
			}
		},
		error: function() {
		    cErr('DE reports: error during request');
		    $('.saverHelper.saverFail').show();
		    formInSave=false;
		},
		complete: function() {
		    //console.log('aj3');
		    $('.saverHelper.saverPB').fadeOut("fast");
		}
		}
	);
}


/*
TODO: control dispatcher
var deStructure = {};

function register_document (documentId) {
    deStructure[documentId] = {};
}

function register_property (documentId, propertyId) {
    deStructure[documentId][propertyId] = {};
}

function register_control (documentId, propertyId, control) {
    deStructure[documentId][propertyId] = control;
}

function get_control (documentId, propertyId) {
    return deStructure[documentId][propertyId];
}
/**/
//var loadedScripts = [];
//var onLoadClbks = [];
//var loadingScripts =[];
//var loadJSFile = function (f, clbk) {
//var require_js = function (f, clbk) {
//alert('You are using deprecated function. de.js:require_js. Use headjs instead.');
//    var idx = $.inArray(f, loadedScripts);
//    if (idx!=-1) {
//	if (clbk) {
//	    clbk();
//	}
//	return;
//    }
//    idx = $.inArray(f, loadingScripts);
//    if (idx!=-1) {
//	if (clbk) {
//	    onLoadClbks[idx].push(clbk);
//	}
//	return;
//    }
//    idx = loadingScripts.length;
//    loadingScripts.push(f);
//    onLoadClbks.push([]);
//    if (clbk) {
//	onLoadClbks[idx].push(clbk);
//    }
//    $.ajax({
//	url: f,
//	dataType: 'script',
//	cache: true,
//	type: 'GET',
//	success: function (data, textStatus) {
//	    loadedScripts.push(f);
//	    loadingScripts.splice(idx,1);
//	    if (onLoadClbks[idx].length) {
//		var clbks = onLoadClbks[idx];
//		onLoadClbks[idx] = [];
//		for (var i=0; i<clbks.length; i++) {
//		    clbks[i]();
//		}
//	    }
//	}
//    });
//}

//var loadJSFiles = function (files, clbk) {
//var require_jss = function (files, clbk) {
//alert('You are using deprecated function. de.js:require_jss. Use headjs instead.');
    //console.log('try files: '+files);
//    var loaded = 0;
//    for (var i=0; i<files.length; i++) {
//	//loadJSFile(files[i], function(){
//	require_js(files[i], function(){
//	    //console.log('1 of many is loaded. Total loaded: '+(loaded+1)+' Total files to load: '+files.length);
//	    if (++loaded >= files.length) {
//		//console.log('everything done. call clbk.');
//		clbk();
//	    }
//	});
//    }
//}
/**
 *
*/
//function de_get_object_content(objectPath, contentHolder, callback)
//var de_get_object_content = function(objectPath, contentHolder, callback)
//{
//    $(contentHolder).empty().append('<div style="padding-bottom: 200px; padding-top: 7px; padding-left: 7px;"><img src="'+de_res_dir+'/ajax-loader.gif"></div>');
//    $.get(
//	de_connector['url'] + '?' + de_connector['get_prefix'] + '&' + de_connector['get_internal'] + '&' + de_connector['ajax_marker'],
//	{
//	    'icTO': objectPath,
//	    'do': 'getControl'
//	    //'do': 'get_subobject',
//	    //'subobject_path': objectPath
//	},
//	function(data) {
//	    //alert(data);
//	    //console.log(data);
//	    $(contentHolder).empty();
//	    $(contentHolder).html(data);
//	    callback();
//	}
//    );
//
//}
/*function de_get_gormon(src, objectPath)
//var de_get_gormon = function(src, objectPath)
{
    //console.log(objectPath);
    var target = $(src).siblings('.mg_content');
    if (target.html().length == 0) {
	target.toggleClass('garmonb_hidden', false);
	$(src).toggleClass('selected', true);
	de_get_object_content(
	    objectPath,
	    target,
	    function(){}
	);
    } else {
	    target.toggleClass('garmonb_hidden');
	    $(src).toggleClass('selected');
    }
}*/

function deRefGetControl(docId, propId, contentHolder, callback)
{
    $(contentHolder).empty().append('<div style="padding-bottom: 200px; padding-top: 7px; padding-left: 7px;"><img src="'+de_res_dir+'/ajax-loader.gif"></div>');
    $.get(
	de_connector['url'] + '?' + de_connector['get_prefix'] + '&' + de_connector['get_internal'] + '&' + de_connector['ajax_marker'],
	{
	    'icTO': docId,
            'icTP': propId,
	    'call': 'getControl',
	},
	function(data) {
	    $(contentHolder).empty();
	    $(contentHolder).html(data);
            if (typeof callback==='function')
		    callback();
	}
    );
}

