<?php
	class EnhancedCss {  
		public $values;  
		public $cssFile;  

		public function __construct($cssFile) {
			// check if the css file exists  
			if (!file_exists($cssFile)) {
				header('HTTP/1.0 404 Not Found');
				exit;
			}
			//define('SUB_URL', '/carabiadmin');
			include __DIR__ . '/../config/cfg.php';
			$this->values["IMAGES_URL"] = IMAGES_URL;
			$this->cssFile = $cssFile;
		}  

		private function parse() {
			// open the css file and throw every line to
			// findAndReplaceVars method
			$content = '';
			$lines = file($this->cssFile);  
			foreach($lines as $line) {  
				$content .= $this->findAndReplaceVars($line);  
			}  
			return $content;  
		}  

		private function findAndReplaceVars($line) {  
			// find the variable definitions, store the values,  
			// replace the variable by their defined values.  
			preg_match_all('/\s*\\$\\$\\$([A-Za-z1-9_\-]+)(\s*:\s*(.*?);)?\s*/', $line, $vars);
			$found     = $vars[0];
			$varNames  = $vars[1];
			$varValues = $vars[3];
			$count     = count($found);

			for($i = 0; $i < $count; $i++) {
				$varName  = trim($varNames[$i]);
				$varValue = trim($varValues[$i]);
				if ($varValue) {
					$this->values[$varName] = $this->findAndReplaceVars($varValue);
				} else if (isset($this->values[$varName])) {
					$line = preg_replace('/\\$\\$\\$'.$varName.'(\W|\z)/', $this->values[$varName].'\\1', $line);
				}
			}
			$line = str_replace($found, '', $line);
			return $line;
		}
		public function display() {  
			// display the new parsed content  
			header('Content-type: text/css');
			echo $this->parse();  
		}
	}

	if (isset($_GET['css'])) {  
		$css = new EnhancedCss($_GET['css']);
		$css->display();  
	}  
?>
