<?php

/**
 * Работа с новостями на сайте (для них используется документ "тема форума")
 *
 * @author sasha
 */

include_once CARABI_DIR . '/classes/wave_editor/class.WaveEditorUtils.php';

class pagehandler_forumCommon extends SimplePagehandler {
	var $rootChapters = array();//Корневые разделы форума

	var $size = 0;
	
	var $colModel = '[
	{ name: "NAME", label: "Заголовок", sortable: false/*, width: 600, fixed: true*/},
	{ name: "DATE_CREATE", label: "Дата создания", sortable: false, width: 150, fixed: true},
	{ name: "FTEMA_COUNT_MES", label: "Коммент.", sortable: false, width: 64, fixed: true},
	{ name: "FTEMA_NEW", label: "Новых к.", sortable: false, width: 64, fixed: true},
	{ name: "FTEMA_LINK", label: "ID", sortable: false, width: 65, fixed: true}
]';
	var $colModelSearch = '[
	{ name: "NAME", label: "Заголовок", sortable: false},
	{ name: "DATE_CREATE", label: "Дата создания", sortable: false, width: 150, fixed: true},
	{ name: "FTEMA_LINK", label: "ID", sortable: false, width: 64, fixed: true}
]';
	
	public function __construct(\SimpleUrl $simpleUrl, $selectAllRoots = true) {
		parent::__construct($simpleUrl);
		if ($selectAllRoots) {
			$sql = "select unique chapter.document_id as root_chapter
from doc_events chapter,
doc_references child_chapter
where chapter.dockind_id = get_kind_id('CHAPTER')
and chapter.history = 0
and chapter.doceventkind_id = get_doceventkind_id('CHAPTER_OPEN')
and child_chapter.docsource_id = chapter.document_id
and child_chapter.docpropsource_id = get_docpropid_byname('CHAPTER-REF-CHAPTER', 'CHAPTER')
";
			$root_chapters = ora_select($sql, "no-cache", "", "");
			$this->rootChapters = $root_chapters["ROOT_CHAPTER"];
		}
		
	}


	/**
	 * возвращает данные для jqGrid. Сперва разделы и подразделы, потом темы
	 */
	protected function getJqgridData() {
		$chapterID = get("nodeid");
		if (empty($chapterID)) {
			$chaptersData = $this->selectChapters();
			$chaptersData = \utls::treeToOrderedList(\utls::listToTree($chaptersData, "CHAPTER_ID", "PARENT_CHAPTER_ID"));
			foreach ($chaptersData as &$chapter) {
				//обнуляем isLeaf, чтобы при открытии подразделов грузить темы
				$chapter["isLeaf"] = "false";
			}
			$size = count($chaptersData);
			$rows = json_encode($chaptersData);
			echo '{"page": "1", "total": "1", "records": "'.$size.'",
				"rows":' . $rows . '
			}';
		} else {
			$newsData = \Forum::getChapterTopics($chapterID);
			$leftRight = get("n_left") + 1;
			foreach ($newsData as &$news) {
				$news["id"] = $news["FTEMA_ID"];unset($news["FTEMA_ID"]);
				$news["NAME"] = $news["FTEMA_NAME"]; unset($news["FTEMA_NAME"]);
				$news["DATE_CREATE"] = $news["DATE_CREATED_STR"];unset($news["DATE_CREATED_STR"]);
				$news["isLeaf"] = "true";
				$news["level"] = 2;
				$news["lft"] = $leftRight;
				$leftRight++;
				$news["rgt"] = $leftRight;
				$leftRight++;
				$news["parent"] = $chapterID;
				$news["FTEMA_LINK"] = "<a href='" . $this->baseUrl() . "/edit/{$news["id"]}' style='text-decoration:underline'>{$news["id"]}</a>";
			}
			$size = count($newsData);
			$rows = json_encode($newsData);
			echo '{"page": "1", "total": "1", "records": "'.$size.'",
				"rows":' . $rows . '
			}';
		}
	}
	
	/**
	 * action для обработки поискового запроса.
	 * Выводит страницу аналогичную Index и сохраняет результыт поиска в кеше
	 * для последующего показа через JqGrid
	 */
	protected function search() {
		$q = get("q");
		if (empty($q)) {
			return $this->index();
		}
		
		$tpl = $this->renderer()->createTemplate("content.forum.tpl");
		
		$sql = "APPL_CARABI_TABLE2.GET_CURSOR('CMS_FTEMA',
			APPL_WEB_PAGE.FIND_NEWS_BY_TEXT('$q')
		)";
		$newsData = ora_cursor($sql);
		$_SESSION["pagehandler_news"]["search"] = $newsData;
		$tpl->assign("colModel", $this->newsColModelSearch);
		$tpl->assign("size", count($newsData));
		$tpl->assign("search", true);
		$tpl->assign("pagehandler", $this);
		$tpl->display();
		
	}
	
	/**
	 * action для вывода найденных новостей в JqGrid.
	 */
	protected function getDataSearched() {
		$newsData = $_SESSION["pagehandler_news"]["search"];
		foreach ($newsData as &$news) {
			$news["id"] = $news["FTEMA_ID"];unset($news["FTEMA_ID"]);
			$news["NAME"] = $news["FTEMA_NAME"]; unset($news["FTEMA_NAME"]);
			$news["FTEMA_LINK"] = "<a href='" . $this->baseUrl() . "/edit/{$news["id"]}' style='text-decoration:underline'>{$news["id"]}</a>";
			$news["DATE_CREATE"] = format_string_date($news["FTEMA_DATE_CREATE"]);
			unset($news["FTEMA_DATE_CREATE"]);
		}
		$size = count($newsData);
		$rows = json_encode($newsData);
		echo '{"page": "1", "total": "1", "records": "'.$size.'",
			"rows":' . $rows . '
		}';
	}
	
	/**
	 * Выборка разделов и подразделов с новостями в виде массива, готового для построения дерева
	 * Из БД или кеша в сессии
	 * @return array
	 */
	protected function selectChapters($forceUpdate = false) {
		if ($forceUpdate || empty($_SESSION["pagehandler_news"]["chaptersList"])) {
			$subchapters = array();
			$rootChaptersList = implode(", ", $this->rootChapters);
			$rootChapters = ora_cursor("appl_carabi_table2.GET_CURSOR('CMS_NEWS_CHAPTER', T_NUMBER_LIST($rootChaptersList))", count($this->rootChapters));
			$leftRight = 1;
			foreach ($rootChapters as &$rootChapter) {
				//дерево будет одно для разделов и тем, поэтому столбцы Wave-таблицы
				//переименовываем под общий ColModel
				$rootChapter["DATE_CREATE"] = format_string_date($rootChapter["CHAPTER_DATE_CREATE"]);
				unset($rootChapter["CHAPTER_DATE_CREATE"]);
				$rootChapter["NAME"] = $rootChapter["CHAPTER_NAME"]; unset($rootChapter["CHAPTER_NAME"]);
				$rootChapter["expanded"] = "true";
				$rootChapter["lft"] = $leftRight;
				$leftRight++;
				$sql = "select * from table(appl_forum.GET_RAZDEL_CHAPTER_LIST({$rootChapter["CHAPTER_ID"]}))";
				$newsChapters = ora_redim(ora_select($sql, "no-cache", "", ""));
				foreach ($newsChapters as &$newsChapter) {
					$newsChapter["lft"] = $leftRight;
					$leftRight++;
					$leftRight += $newsChapter["R_COUNT"] * 2;
					$newsChapter["rgt"] = $leftRight;
					$leftRight++;
					$newsChapter["CHAPTER_ID"] = $newsChapter["R_ID"]; unset($newsChapter["R_ID"]);
					$newsChapter["PARENT_CHAPTER_ID"] = $rootChapter["CHAPTER_ID"];
					$newsChapter["NAME"] = $newsChapter["R_NAME"]; unset($newsChapter["R_NAME"]);
					$this->size += $newsChapter["R_COUNT"];
				}
				$rootChapter["rgt"] = $leftRight;
				$leftRight++;
				$subchapters = array_merge($subchapters, $newsChapters);
			}
			$chaptersList = array_merge($rootChapters, $subchapters);
			$_SESSION["pagehandler_news"]["chaptersList"] = $chaptersList;
			$_SESSION["pagehandler_news"]["size"] = $this->size;
		} else {
			$chaptersList = $_SESSION["pagehandler_news"]["chaptersList"];
			$this->size = $_SESSION["pagehandler_news"]["size"];
		}
		return $chaptersList;
	}

	/**
	 * action для редактирования новости -- открывает DocumentEditor
	 */
	protected function edit($parameters) {
		$newsID = $parameters["url"][1];
		if (empty($newsID)) {
			throw new NotFoundException("News id is empty");
		}
		$this->user()->actAsSelf();
		$currentClass = get_class($this);
		$newsName = \WaveEditorUtils::getSimpleField($newsID, "FTEMA", "NAME");
		if (substr($currentClass, 0, 13) == "carabi_office") {
			$tpl = \carabi_cms\DocumentEditor::editDocument($newsID, "carabi_office/_de.tpl");
			$tpl->assign("header", "$newsName <small>Редактирование темы</small>");
		} else if (substr($currentClass, 0, 10) == "carabi_cms"){
			$tpl = \carabi_cms\DocumentEditor::editDocument($newsID, "carabi_cms/editor.news.tpl");
			$tpl->assign("newsName", $newsName);
		} else {
			$tpl = \carabi_cms\DocumentEditor::editDocument($newsID);
		}
		
		$this->user()->actAsCommonUser();
		$tpl->assign("pagehandler", $this);
		$tpl->display();
	}

	/**
	 * action для создания страницы -- создаёт пустой документ и редиректит на редактор
	 */
	protected function create() {
		$chapterID = get("chapter");
		if (empty($chapterID)) {
			$chapters = $this->selectChapters(true);
			$chapterID = $chapters[1]["CHAPTER_ID"];//По умолчанию -- первый подраздел первого корня
		}
		$this->user()->actAsSelf();
		$newsID = \Forum::createTopic($chapterID, "", "");
		
		$this->user()->actAsCommonUser();
		header("Location: " . $this->baseUrl() . "/edit/$newsID");
	}
	
	/**
	 * action для удаления новости
	 */
	protected function delete() {
		$news = get("news");
		if (empty($news)) {
			throw new Exception("news for delete is not set");
		}
		$this->user()->actAsSelf();
		\WaveEditorUtils::changeDocumentStatus($news, "FTEMA_CLOSE");
		$this->user()->actAsCommonUser();
		header("Location: " . $this->baseUrl());
	}
}
?>
