{extends 'carabi_office/_standard.tpl'}
{block 'content'}
	{setParam name="css_links" value="/js/jqGrid/css/ui.jqgrid.css"}
	{setParam name="js_links" value="/js/jqGrid/js/i18n/grid.locale-ru.js"}
	{setParam name='js_links' value='/js/jqGrid/js/jquery.jqGrid.src.js'}
	{setParam name='js_links' value='/js/modalWait.js'}
	
	<div class="row">
		<div class="span10">
			<script type="text/javascript" language="javascript">
				{*использование скрипта вместо input type="submit" -- для замены input на button с улучшением дизайна*}
				var startSearch = function() {
					$("#searchForm").submit();
				}
				var clearSearch = function() {
					window.location = "{$pagehandler->baseUrl()}";
				}
			</script>
			<h4>
				<i class="icon-list-alt"style="margin-top:4px;"></i>
				Навигатор по {if $docsType == "incidents"} инцидентам {elseif $docsType == "additions"} доработкам{/if} <span class="badge badge-info">{$size}</span>
			</h4>
		</div>
	</div>
	<div class="row">
		<div class="span10">
			<table id="incidentsTable"></table>
		</div>
	</div>
	<div id="waitDialog" style="display:none;"></div>
	<script type="text/javascript" language="javascript">
		var incidentsTable = $("#incidentsTable");
		
		var rootNodesOpened = false;
		openRootNodes = function() {
			if (rootNodesOpened) return;
			//Открываем корневые узлы дерева (встроенными средствами jqGrid не удалось)
			incidentsTable.find(".treeclick:visible").click();
			rootNodesOpened = true;
		};
		
		incidentsTable.jqGrid({
			colModel: {$colModel},
			datatype: "json",
			rowNum: {$size},
			{if $search}
				url: "?action=getDataSearched",
			{else}
				url: "?action=getJqgridData",
			{/if}
			autowidth: true,
			height: "100%",

			jsonReader: {
				repeatitems: false
			},
			
			{if !$search}
				treeGrid: true,
				ExpandColumn: "CHAPTER_NAME",
			{/if}
				
			gridComplete: openRootNodes
		});
	</script>
{/block}
