{extends 'carabi_office/_standard.tpl'}

{*Корпоративный форум. Скопировано с новостей в CMS*}
{block 'content'}
	{setParam name="css_links" value="/js/jqGrid/css/ui.jqgrid.css"}
	{setParam name="js_links" value="/js/jqGrid/js/i18n/grid.locale-ru.js"}
	{setParam name='js_links' value='/js/jqGrid/js/jquery.jqGrid.src.js'}
	{setParam name='js_links' value='/js/modalWait.js'}
	
	<div class="row">
		<div class="span10">
			<form class="form-horizontal" action="{$pagehandler->baseUrl()}/search" id="searchForm">
				{*Разный дизайн формы для начала и результата поиска*}
				{if empty($smarty.get.q)}
					<div class="input-append">
						<input type="text" placeholder="Поиск темы..." name="q"><button class="btn" onclick="startSearch();">Найти</button>
					</div>
				{else}
					<div class="input-append">
						<input type="text" placeholder="Поиск темы..." name="q" value="{$smarty.get.q}"><button class="btn" onclick="startSearch()">
							Уточнить</button><button class="btn" onclick="clearSearch();return false;">Очистить
						</button>
					</div>
				{/if}
				&nbsp;
				<button class="btn btn-success" onclick="createNews();return false;">Создать тему</button>
			</form>
			<script type="text/javascript" language="javascript">
				{*использование скрипта вместо input type="submit" -- для замены input на button с улучшением дизайна*}
				var startSearch = function() {
					$("#searchForm").submit();
				}
				var clearSearch = function() {
					window.location = "{$pagehandler->baseUrl()}";
				}
			</script>
			<h4>
				<i class="icon-list-alt"style="margin-top:4px;"></i>
				Навигатор по корпоративному форуму <span class="badge badge-info">{$size}</span>
			</h4>
		</div>
	</div>
	<div class="row">
		<div class="span10">
			<table id="newsTable"></table>
			<div id="nonselectNewsWarning" style="display:none">Вы не выбрали ни одну тему!</div>
			<div id="selectParentHelp" style="display:none">
				Укажите подраздел для темы.
				<button class="btn" id="selectParentCancel">Отмена</button>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="span10">
			<div class="btn-toolbar">
				<button class="btn btn-success" onclick="createNews()">Создать тему</button>
				<button class="btn" onclick="deleteNews()">Удалить тему</button>
			</div>
		</div>
	</div>
	<div style="display:none" id="deleteDialog">
		Удалить выбранную тему?
	</div>
	<div id="waitDialog" style="display:none;"></div>
	<script type="text/javascript" language="javascript">
		var newsTable    = $("#newsTable"),
			deleteDialog = $("#deleteDialog");
		
		var rootNodesOpened = false;
		openRootNodes = function() {
			if (rootNodesOpened) return;
			//Открываем корневые узлы дерева (встроенными средствами jqGrid не удалось)
			newsTable.find(".treeclick:visible").click();
			rootNodesOpened = true;
		};
		//функция должна срабатывать при создании новой новости и выборе подраздела
		//для неё. При этом отображается справка, а выбранный узел -- подраздел
		selectAsParent=function(nodeID) {
			if ($("#selectParentHelp").css("display") != "none") {
				nodeData = newsTable.jqGrid("getRowData", nodeID);
				//новость должна быть в подразделе -- уровень 1 в дереве (0 -- раздел, 2 -- новость)
				if (nodeData.level == 1) {
					modalWait($("#waitDialog"));
					window.location = "{$pagehandler->baseUrl()}?action=create&chapter=" + nodeID;
				}
			}
		};
		
		newsTable.jqGrid({
			colModel: {$colModel},
			datatype: "json",
			rowNum: {$size},
			{if $search}
				url: "?action=getDataSearched",
			{else}
				url: "?action=getJqgridData",
			{/if}
			autowidth: true,
			height: "100%",

			jsonReader: {
				repeatitems: false
			},
			
			{if !$search}
				treeGrid: true,
				ExpandColumn: "CHAPTER_NAME",
			{/if}
				
			gridComplete: openRootNodes,
			onSelectRow: selectAsParent
		});
		
		//создание темы. В отличие от новости, выбор подраздела необходим.
		function createNews() {
			nodeID = newsTable.jqGrid("getGridParam", "selrow");
			alert
			nodeData = newsTable.jqGrid("getRowData", nodeID);
			//новость должна быть в подразделе -- уровень 1 в дереве (0 -- раздел, 2 -- новость)
			paramChapter = "";
			if (nodeData.level == 1) {
				paramChapter = "&chapter=" + nodeID
				modalWait($("#waitDialog"));
				window.location = "{$pagehandler->baseUrl()}?action=create" + paramChapter;
			} else {
				$("#selectParentHelp").show();
			}
		}
		function deleteNews() {
			nodeID = newsTable.jqGrid("getGridParam", "selrow");
			if (nodeID == null) {
				$("#nonselectNewsWarning").show();
				return;
			}
			nodeData = newsTable.jqGrid("getRowData", nodeID);
			if (nodeData.level != 2) { //разделы удалять нельзя
				$("#nonselectNewsWarning").show();
				return;
			}
			$("#nonselectNewsWarning").hide();
			deleteDialog.dialog({
				resizable: false,
				height: 140,
				modal: true,
				buttons: {
					OK: function() {
						deleteDialog.dialog("close");
						modalWait($("#waitDialog"));
						window.location = "{$pagehandler->baseUrl()}/delete?news=" + nodeID;
					},
					Отмена: function() {
						deleteDialog.dialog("close");
					}
				}
			});
		}
		$("#selectParentCancel").click(function() {
			$("#selectParentHelp").hide();
		});
	</script>
{/block}
