<?php
namespace carabi_office;
/**
 * Description of class
 *
 * @author sasha
 */
class pagehandler_supportDocs extends \SimplePagehandler {
	var $size;
	var $doctypeName, $mainField, $categoryField, $categoryVocab, $unsupportedStatus;
	var $sqlGetIncidentsList = "
select status.doceventkind_id as status_id,
       status_name.value as status_name,
       category_id.doc_prop_value as category_id,
       category_name.value as category_name,
       status.document_id,
       description.doc_prop_value as description
       
  from doc_events status, vocabs status_name, doc_properties description,
       doc_properties category_id, vocabs category_name
 where status.dockind_id = get_kind_id('%s')
   and status.history = 0
   and status.document_id = description.document_id
   and description.docprop_id = get_docpropid_byname('%s', '%s')
   and status.document_id = category_id.document_id
   and category_id.docprop_id = get_docpropid_byname('%s', '%s')
   and category_name.vocab_id = get_vocab_id('%s')
   and category_name.code = category_id.doc_prop_value
   and status_name.vocab_id = get_vocab_id('Doc_EventKind')
   and status_name.value_id = status.doceventkind_id
   
	and status.doceventkind_id != %d
 order by document_id desc";

	var $colModel = '[
	{ name: "name", label: "Заголовок", sortable: false/*, width: 600, fixed: true*/},
//	{ name: "DATE_CREATE", label: "Дата создания", sortable: false, width: 150, fixed: true},
	{ name: "label", label: "ID/кол-во", sortable: false, width: 80, fixed: true},
	{ name: "id", hidden: true}
]';
	
	protected function getJqgridData() {
		$incidentsList = $this->readDocsList();
		$size = count($incidentsList);
		$rows = json_encode($incidentsList);
		echo '{"page": "1", "total": "1", "records": "'.$size.'",
			"rows":' . $rows . '
		}';
	}
	
	protected function readDocsList($forceUpdate = false) {
		$incidentsList = null;
		if (empty($_SESSION["pagehandler_incidents"]["incidents_list"]) || $forceUpdate) {
			$sql = sprintf($this->sqlGetIncidentsList,
					$this->doctypeName,
					$this->mainField,
					$this->doctypeName,
					$this->categoryField,
					$this->doctypeName,
					$this->categoryVocab,
					$this->unsupportedStatus
			);
			$incidentsList = ora_redim(ora_select($sql, "no-cache", '', ''));
			$this ->size = count($incidentsList);
			//инциденты имеют статус и категорию. Построим трёхуровневое дерево.
			$tree = array();
			foreach ($incidentsList as $incident) {
				$statusID = $incident["STATUS_ID"];
				if (empty($tree[$statusID])) {
					$tree[$statusID] = array(
						"id" => $statusID,
						"parent" => "",
						"name" => $incident["STATUS_NAME"],
						"label" => 0,
						"children" => array()
					);
				}
				$caregoryID = $incident["CATEGORY_ID"];
				if (empty($tree[$statusID]["children"][$caregoryID])) {
					$tree[$statusID]["children"][$caregoryID] = array(
						"id" => $caregoryID ."_" . $statusID,
						"parent" => $statusID,
						"name" => $incident["CATEGORY_NAME"],
						"label" => 0,
						"children" => array()
					);
				}
				$tree[$statusID]["children"][$caregoryID]["children"][] = array(
					"id" => $incident["DOCUMENT_ID"],
					"parent" => $caregoryID ."_" . $statusID,
					"name" => \utls::strHead($incident["DESCRIPTION"]),
					"description" => $incident["DESCRIPTION"],
					"label" => "<a href=\"" . $this->baseUrl() ."/edit/{$incident["DOCUMENT_ID"]}\" style=\"text-decoration:underline\">{$incident["DOCUMENT_ID"]}</a>",
					"children" => array()
				);
				$tree[$statusID]["children"][$caregoryID]["label"]++;
				$tree[$statusID]["label"]++;
			}
			$incidentsList = \utls::treeToOrderedList($tree);
			$_SESSION["pagehandler_incidents"]["incidents_list"] = $incidentsList;
		} else {
			$incidentsList = $_SESSION["pagehandler_incidents"]["incidents_list"];
			$this ->size = count($incidentsList);
		}
		return $incidentsList;
	}
	
	protected function edit($parameters) {
		$documentId = $parameters["url"][1];
		if (empty($documentId)) {
			throw new \NotFoundException("Document id is empty");
		}
		$this->user()->actAsSelf();
		$tpl = \carabi_cms\DocumentEditor::editDocument($documentId, "carabi_office/_de.tpl");
		$currentClass = get_class($this);
		if ($currentClass == 'carabi_office\pagehandler_incidents') {
			$tpl->assign("header", "Редактирование инцидента");
		} else if ($currentClass == 'carabi_office\pagehandler_additions') {
			$tpl->assign("header", "Редактирование доработки");
		}
		
		$this->user()->actAsCommonUser();
		$tpl->assign("pageName", $pageName);
		$tpl->assign("pagehandler", $this);
		$tpl->display();
	}
}
?>
