<?php
namespace carabi_office;

/**
 * Авторизация в Carabi Office с возможностью выбора схемы данных.
 *
 * @author sasha
 */
class pagehandler_login extends \SimplePagehandler {
	public function process() {
		$this->executeAction();
	}

	protected function index() {
		$tpl = $this->createDefaultTemplate();
		$schemasList = \lib_office::getSchemasList();
		$tpl->assign("schemasList", $schemasList);
		$tpl->assign("currentSchema", \Auth::getCurrentSchema());
		$tpl->assign("pagehandler", $this);
		$tpl->display();
	}

	/**
	 * Авторизация по логину и паролю
	 * @global type $DATABASE_SCHEMAS
	 * @global type $DB_USER
	 * @global type $DB_PASSWORD
	 * @global type $DB_NAME
	 * @global type $conn
	 */
	protected function authorize() {
		global $DATABASE_SCHEMAS, $DB_USER, $DB_PASSWORD, $DB_NAME, $conn;
		$schema = get("schema");
		if (!empty($schema) && $schema != \Auth::getCurrentSchema()) {
			\Auth::setCurrentSchema($schema);
			$DB_NAME = $DATABASE_SCHEMAS[$schema]["tns_name"];
			$DB_USER = $DATABASE_SCHEMAS[$schema]["n"];
			$DB_PASSWORD = $DATABASE_SCHEMAS[$schema]["s"];
			oci_close($conn);
			$conn = ora_connect();
		}
		try {
			$userId = $this->user()->authorize(get("login"), get("password"), get("setToken"));
			if (get("setToken")) {
				$_SESSION["SAVED_AUTHORIZE"][$schema] = $this->user()->getToken();
			}
			if ($userId > 0) {
				$url = $_SESSION["REDIRECT_TO_AFTER_LOGIN"];
				if (empty($url)) $url = LOGIN_TO;
				header("Location: $url");
				return;
			}
		} catch (\Exception $e) {
		}
		$tpl = $this->createTemplate("content.login.tpl");
		$tpl->assign("schemasList", \lib_office::getSchemasList());
		$tpl->assign("pagehandler", $this);
		$tpl->display();
	}

	/**
	 * Выход из системы
	 */
	protected function signout() {
		try {
			$this->user()->unauthorize();
			header("Location: /");
		} catch (Exception $e) {
		}
		$tpl = $this->createTemplate("content.login.tpl");
		$tpl->display();
	}

	/**
	 * Вход в другую схему БД (если пользователь вводил пароль для этой схемы --
	 * второй раз не придётся)
	 */
	protected function changeSchema() {
		$schema = get("schema");
		\Auth::setCurrentSchema($schema);
		if (!empty($_SESSION["SAVED_AUTHORIZE"][$schema])) {
			$expired = time()+60*60*24*30;
			setcookie('at', $_SESSION["SAVED_AUTHORIZE"][$schema], $expired, '/');
			$this->user()->tokenAuthorize($_SESSION["SAVED_AUTHORIZE"][$schema]);
			if (!empty($_SERVER["HTTP_REFERER"])) {
				$url = $_SERVER["HTTP_REFERER"];
			} else {
				$url = LOGIN_TO;
			}
			header("Location: $url");
		} else {
			$_SESSION["REDIRECT_TO_AFTER_LOGIN"] = $_SERVER["HTTP_REFERER"];
			$this->user()->unauthorize(false);
			header("Location: " . $this->baseUrl());
		}
	}

	/**
	 * Вход под другим именем
	 */
	protected function relogin() {
		$this->user()->unauthorize(false);
		$tpl = $this->createTemplate("content.login.tpl");
		$tpl->assign("schemasList", \lib_office::getSchemasList());
		$tpl->assign("pagehandler", $this);
		$tpl->display();
	}

}
?>
