<?php

include_once CARABI_DIR . '/classes/wave_editor/class.WaveEditorUtils.php';

/**
 * Функции и настройки для CMS
 *
 * @author sasha
 */
class lib_office {
	
	const PERMISSION_ANY = 7;
	const PERMISSION_INCIDENTS = 8;
	const PERMISSION_ADDITIONS = 9;
	const PERMISSION_FORUM = 10;

	public static function OFFICE_ROOT() {
		return SUB_URL;
	}
	/**
	 * Получение главного меню офиса
	 * @param boolean $withOthers Показывать рядом меню других модулей
	 * @global WebUserAuth $currentUser 
	 */
	public static function getMainMenu($withOthers = true) {
		global $currentUser;
		if ($currentUser->userId() > 0) {
			$menu = array();
			$menu[] = array("url" => self::OFFICE_ROOT() . "/desktop", "caption" => "Главная");
			if (self::hasPermission($currentUser, self::PERMISSION_INCIDENTS)) {
				$menu[] = array("url" => self::OFFICE_ROOT() . "/incidents", "caption" => "Инциденты");
			}
			if (self::hasPermission($currentUser, self::PERMISSION_ADDITIONS)) {
				$menu[] = array("url" => self::OFFICE_ROOT() . "/additions", "caption" => "Доработки");
			};
			if (self::hasPermission($currentUser, self::PERMISSION_FORUM)) {
				$menu[] = array("url" => self::OFFICE_ROOT() . "/forum", "caption" => "Форум");
			};
		} else {
			$menu = array();
		}
		foreach ($menu as &$item) {
			$urlLength = strlen($item["url"]);
			if (substr($_SERVER["REDIRECT_URL"], 0, $urlLength) === $item["url"]) {
				$item["current"] = true;
			}
		}
		if ($withOthers) {
			if (class_exists("lib_cms") && lib_cms::hasPermission($currentUser, lib_cms::PERMISSION_ANY)) {
				$menu[] = array(
					"caption" => "CMS",
					"children" => lib_cms::getMainMenu(false)
				);
			}
		}
		return $menu;
	}
	
	public static function getTopMenu() {
		$menu = array(
			array("url" => self::OFFICE_ROOT() . "/login/relogin", "caption" => "Войти под другим именем", "dividerAfter" => true)
		);
		$schemasList = self::getSchemasList();
		foreach($schemasList as $schema) {
			$menu[] = array("url" => self::OFFICE_ROOT() . "/login/changeSchema?schema=$schema", "caption" => $schema);
		}
		$menu[] = array("url" => self::OFFICE_ROOT() . "/login/signout", "caption" => "Выход", "dividerBefore" => true);
		self::markCurrentSchema($menu);
		return $menu;
	}
	private static function markCurrentSchema(&$menu) {
		$currentSchema = Auth::getCurrentSchema();
		foreach ($menu as &$item) {
			if ($item["caption"] == $currentSchema) {
				$item["current"] = true;
				$item["url"] = "#";
				break;
			}
		}
	}

	/**
	 * Получение списка БД, с которыми мы работаем
	 * @global array $DATABASE_SCHEMAS
	 * @return array
	 */
	public static function getSchemasList() {
		global $DATABASE_SCHEMAS;
		return array_keys($DATABASE_SCHEMAS);
	}
	
	/**
	 * Проверка, имеет ли пользователь право на доступ к Carabi Office и определённым его модулям
	 * @param WebUserAuth $user
	 */
	public static function hasPermission(WebUserAuth $user, $permissionRequired) {
		$permissionsHas = $user->getUserPermissions();
		if (array_search($permissionRequired, $permissionsHas) !== false) {
			return true;
		} else {
			return false;
		}
	}
}
?>
