{extends 'carabi_cms/_standard.tpl'}
{block 'content'}
	{setParam name="css_links" value="/js/jqGrid/css/ui.jqgrid.css"}
	{setParam name="js_links" value="/js/jqGrid/js/i18n/grid.locale-ru.js"}
	{setParam name='js_links' value='/js/jqGrid/js/jquery.jqGrid.src.js'}
	{setParam name='js_links' value='/js/modalWait.js'}
	
	<div class="row">
		<div class="span10">
			<form class="form-horizontal" action="{$pagehandler->baseUrl()}/search" id="searchForm">
				{*Разный дизайн формы для начала и результата поиска*}
				{if empty($smarty.get.q)}
					<div class="input-append">
						<input type="text" placeholder="Поиск страницы..." name="q"><button class="btn" onclick="startSearch();">Найти</button>
					</div>
				{else}
					<div class="input-append">
						<input type="text" placeholder="Поиск страницы..." name="q" value="{$smarty.get.q}"><button class="btn" onclick="startSearch()">
							Уточнить</button><button class="btn" onclick="clearSearch();return false;">Очистить
						</button>
					</div>
				{/if}
				&nbsp;
				<button class="btn btn-success" onclick="createPage();return false;">Добавить страницу</button>
			</form>
			<script type="text/javascript" language="javascript">
				{*использование скрипта вместо input type="submit" -- для замены input на button с улучшением дизайна*}
				var startSearch = function() {
					$("#searchForm").submit();
				}
				var clearSearch = function() {
					window.location = "{$pagehandler->baseUrl()}";
				}
			</script>
			<h4>
				<i class="icon-list-alt" style="margin-top:4px;"></i>
				Страницы сайта <span class="badge badge-info">{$size}</span>
			</h4>
		</div>
	</div>
	<div class="row">
		<div class="span10">
			<table id="pagesTable"></table>
			<div id="nonselectWarning" style="display:none">Вы не выбрали ни одну страницу!</div>
			<div id="selectParentHelp" style="display:none">
				Укажите новую родительскую страницу для редактируемой.
				<button class="btn" id="selectParentCancel">Отмена</button>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="span10">
			<div class="btn-toolbar">
				<button class="btn btn-success" onclick="createPage()">Добавить страницу</button>
				<button class="btn" onclick="deletePage()">Удалить страницу</button>
				<div class="btn-group">
					<button class="btn dropdown-toggle" data-toggle="dropdown">Переместить в дереве<span class="caret"></span></button>
					<ul class="dropdown-menu pull-right">
						<li><a href="javascript:void(0)" id="selectParent">Выбрать родителя</a></li>
						<li><a href="javascript:void(0)" id="unbindParent">На самый верх</a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<div style="display:none" id="deleteDialog">
		Удалить выбранную страницу?
	</div>
	<div id="waitDialog" style="display:none;"></div>
	<script type="text/javascript" language="javascript">
		var pagesTable   = $("#pagesTable"),
			deleteDialog = $("#deleteDialog");
		var rootNodesOpened = false;
		openRootNodes = function() {
			if (rootNodesOpened) return;
			//Открываем корневые узлы дерева (встроенными средствами jqGrid не удалось)
			pagesTable.find(".treeclick:visible").click();
			rootNodesOpened = true;
		};
		
		$("#unbindParent").click(function() {
			pageID = pagesTable.jqGrid("getGridParam", "selrow");
			if (pageID == null) {
				$("#nonselectWarning").show();
				return;
			}
			$("#nonselectWarning").hide();
			modalWait($("#waitDialog"));
			window.location = "{$pagehandler->baseUrl()}/reparent?reparentPage="+ pageID;
		});
		//Для установки нового родителя при нажатии кнопки в диалоге сохраняем
		//текущую страницу в дополнительном атрибуте, при отмене очищаем его.
		//При щелчке по дереву проверяем наличие.
		$("#selectParent").click(function() {
			pageID = pagesTable.jqGrid("getGridParam", "selrow");
			if (pageID == null) {
				$("#nonselectWarning").show();
				return;
			}
			$("#nonselectWarning").hide();
			$("#selectParent").attr("pageForReparent", pageID);
			$("#selectParentHelp").show();
		});
		$("#selectParentCancel").click(function() {
			$("#selectParentHelp").hide();
		});
		selectAsParent = function(pageID) {
			pageForReparent = $("#selectParent").attr("pageForReparent");
			if (pageForReparent != null && pageForReparent != undefined) {
				modalWait($("#waitDialog"));
				window.location = "{$pagehandler->baseUrl()}/reparent?reparentPage="+ pageForReparent + "&newParent=" + pageID;
			}
		};
		
		pagesTable.jqGrid({
			colModel: {$colModel},
			datatype: "json",
			rowNum: {$size},
			url: "?action=getPagesList",
			autowidth: true,
			height: "100%",
			pager : "#pagesPanel",

			jsonReader: {
				repeatitems: false
			},
			
			{if !$search}
				treeGrid: true,
				ExpandColumn: "WEB_PAGE_TITLE",
			{/if}
			
			gridComplete: openRootNodes,
			onSelectRow: selectAsParent
		});
		createPage = function() {
			pageID = pagesTable.jqGrid("getGridParam", "selrow");
			parentParam = "";
			if (pageID != null) {
				parentParam = "?parent=" + pageID;
			}
			
			modalWait($("#waitDialog"));
			window.location = "{$pagehandler->baseUrl()}/create" + parentParam;
		};

		deletePage = function() {
			pageID = pagesTable.jqGrid("getGridParam", "selrow");
			if (pageID == null) {
				$("#nonselectWarning").show();
				return;
			}
			$("#nonselectWarning").hide();
			deleteDialog.dialog({
				resizable: false,
				height: 140,
				modal: true,
				buttons: {
					OK: function() {
						deleteDialog.dialog("close");
						modalWait($("#waitDialog"));
						window.location = "{$pagehandler->baseUrl()}/delete?page=" + pageID;
					},
					Отмена: function() {
						deleteDialog.dialog("close");
					}
				}
			});
		}
	</script>
{/block}
