{extends 'carabi_cms/_standard.tpl'}
{block 'content'}
	{setParam name="css_links" value="/js/jqGrid/css/ui.jqgrid.css"}
	{setParam name="js_links" value="/js/jqGrid/js/i18n/grid.locale-ru.js"}
	{setParam name='js_links' value='/js/jqGrid/js/jquery.jqGrid.src.js'}
	{setParam name='js_links' value='/js/modalWait.js'}
	
	<div class="row">
		<div class="span10">
			<h4> <!--style='margin-top:-46px;'--><i class="icon-list-alt"	style="margin-top:4px;"></i>&nbsp;Навигационные меню на сайте <span class="badge badge-info">{$size}</span></h4>
		</div>
	</div>
	<div class="row">
		<div class="span10">
			<table id="menuTable"></table>
			<div id="nonselectLinkWarning" style="display:none">Вы не выбрали ни одну ссылку!</div>
			<div id="selectParentHelpCreation" class="selectParentHelp" style="display:none">
				Укажите меню или родительскую ссылку для новой
				<button class="btn selectParentCancel">Отмена</button><br/>
			</div>
			<div id="selectParentHelpMove" class="selectParentHelp" style="display:none">
				Укажите новую родительскую ссылку или меню
				<button class="btn selectParentCancel">Отмена</button><br/>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="span10">
			<div class="btn-toolbar">
				<button class="btn btn-success" onclick="createLink()">Создать ссылку</button>
				<button class="btn" onclick="deleteLink()">Удалить ссылку</button>
				<button class="btn" onclick="selectParent()">Переместить ссылку</button>
			</div>
		</div>
	</div>
	<div style="display:none" id="deleteDialog">
		Удалить выбранную ссылку?
	</div>
	<div id="waitDialog" style="display:none;"></div>
	<script type="text/javascript" language="javascript">
		var menuTable    = $("#menuTable"),
			deleteDialog = $("#deleteDialog");
		
		var rootNodesOpened = false;
		openRootNodes = function() {
			if (rootNodesOpened) return;
			//Открываем корневые узлы дерева (встроенными средствами jqGrid не удалось)
			menuTable.find(".treeclick:visible").click();
			rootNodesOpened = true;
		};
		//функция должна срабатывать при создании новой ссылки и выборе родителя
		//для старой. При этом отображается справка.
		selectAsParent=function(nodeID) {
			if ($("#selectParentHelpCreation").css("display") != "none") {
				modalWait($("#waitDialog"));
				window.location = "{$pagehandler->baseUrl()}?action=createLink&parent=" + nodeID;
			}
			if ($("#selectParentHelpMove").css("display") != "none") {
				linkForReparent = $("#selectParentHelpMove").attr("linkForReparent");
				modalWait($("#waitDialog"));
				window.location = "{$pagehandler->baseUrl()}?action=reparentLink&reparentLink="
					+ linkForReparent + "&newParent=" + nodeID;
			}
		};
		
		menuTable.jqGrid({
			colModel: {$colModel},
			datatype: "json",
			rowNum: {$size},
			url: "?action=getJqgridData",
			autowidth: true,
			height: "100%",

			jsonReader: {
				repeatitems: false
			},
			
			treeGrid: true,
			ExpandColumn: "CHAPTER_NAME",
			
			gridComplete: openRootNodes,
			onSelectRow: selectAsParent
		});
		
		//создание ссылки. Если выбрано меню или родительская ссылка -- создаётся там,
		//если нет -- предлагается выбрать
		function createLink() {
			nodeID = menuTable.jqGrid("getGridParam", "selrow");
			nodeData = menuTable.jqGrid("getRowData", nodeID);
			if (nodeData.level != undefined) {
				modalWait($("#waitDialog"));
				window.location = "{$pagehandler->baseUrl()}?action=createLink&parent=" + nodeID;
			} else {
				$("#selectParentHelpCreation").show();
			}
		}
		//выбор нового родителя (перемещение в дереве)
		function selectParent() {
			nodeID = menuTable.jqGrid("getGridParam", "selrow");
			if (nodeID == null) {
				$("#nonselectLinkWarning").show();
				return;
			}
			nodeData = menuTable.jqGrid("getRowData", nodeID);
			if (nodeData.level == 0) { //меню перемещать нельзя
				$("#nonselectLinkWarning").show();
				return;
			}
			$("#nonselectLinkWarning").hide();
			$("#selectParentHelpMove").attr("linkForReparent", nodeID);
			$("#selectParentHelpMove").show();
		}
		function deleteLink() {
			nodeID = menuTable.jqGrid("getGridParam", "selrow");
			if (nodeID == null) {
				$("#nonselectLinkWarning").show();
				return;
			}
			nodeData = menuTable.jqGrid("getRowData", nodeID);
			if (nodeData.level == 0) { //меню удалять нельзя
				$("#nonselectLinkWarning").show();
				return;
			}
			$("#nonselectLinkWarning").hide();
			deleteDialog.dialog({
				resizable: false,
				height: 140,
				modal: true,
				buttons: {
					OK: function() {
						deleteDialog.dialog("close");
						modalWait($("#waitDialog"));
						window.location = "{$pagehandler->baseUrl()}/delete?link=" + nodeID;
					},
					Отмена: function() {
						deleteDialog.dialog("close");
					}
				}
			});
		}
		$(".selectParentCancel").click(function() {
			$(".selectParentHelp").hide();
			$("#selectParent").attr("linkForReparent", "");
		});
	</script>
{/block}
