<?php
namespace carabi_cms;

/**
 * Description of class
 *
 * @author sasha
 */
class pagehandler_login extends \SimplePagehandler {
	public function process() {
		$this->executeAction();
	}
	
	protected function authorize($params) {
		try {
			$userId = $this->user()->authorize(get("login"), get("password"), get("setToken"));
			if ($userId > 0) {
				$url = $_SESSION["REDIRECT_TO_AFTER_LOGIN"];
				if (empty($url)) $url = LOGIN_TO;
				header("Location: $url");
				return;
			}
		} catch (\Exception $e) {
		}
		$tpl = $this->renderer()->createTemplate("carabi_cms/content.login.tpl");
		$tpl->assign("pagehandler", $this);
		$tpl->display();
	}
	
	protected function signout() {
		try {
			$this->user()->unauthorize();
			header("Location: " . \lib_cms::CMS_ROOT() . "/");
		} catch (Exception $e) {
		}
		$tpl = $this->renderer()->createTemplate("carabi_cms/content.login.tpl");
		$tpl->display();
	}
}
?>
