<?php
namespace carabi_cms;

/**
 * Description of class
 *
 * @author sasha
 */
class pagehandler_banners extends SimplePagehandler {
	var $pagesColModel = '[
	{ name: "CLASS_RESTATE_ID", label: "Класс объекта недвижимости, ID", sortable: false},
	{ name: "ID_CLASS_RESTATE_DESCR", label: "Наименование", sortable: false},
	{ name: "ORDER_ADVERT_ID", label: "ID", sortable: false},
	{ name: "ID_ORDER_ADVERT_DESCR", label: "Идентификатор", sortable: false},
	{ name: "CLASS_RESTATE_NAME_CLASS", label: "Класс объекта недвижимости, Название", sortable: false},
	{ name: "CLASS_RESTATE_NUM", label: "Класс объекта недвижимости, Код", sortable: false},
	{ name: "ORDER_ADVERT_NAME", label: "Название", sortable: false},
	{ name: "ORDER_ADVERT_URL", label: "Ссылка", sortable: false},
	{ name: "ORDER_ADVERT_DIRECTURL", label: "Прямая ссылка", sortable: false},
	{ name: "ORDER_ADVERT_VALIDFROM", label: "Срок действия. С", sortable: false},
	{ name: "ORDER_ADVERT_VALIDTO", label: "Срок действия. По", sortable: false},
	{ name: "ORDER_ADVERT_TYPE", label: "Тип рекламы", sortable: false},
	{ name: "ORDER_ADVERT_TEXT", label: "Текст рекламы", sortable: false},
	{ name: "ORDER_ADVERT_SYSTEMCOMMENTS", label: "Системные комментарии", sortable: false},
	{ name: "ORDER_ADVERT_IMAGE", label: "Изображение", sortable: false},
]';

	public function process() {
		$this->executeAction();
	}
	protected function index() {
		$tpl = $this->renderer()->createTemplate("carabi_cms/content.banners.tpl");
		$bannersList = ora_cursor("APPL_WEB_TABLE.GET_ORDER_ADVERT_TABLE");
		$_SESSION["pagehandler_banners"]["bannersList"] = $bannersList;
		$tpl->assign('colModel', $this->pagesColModel);
		$tpl->assign('size', count($bannersList));
		$tpl->assign("pagehandler", $this);
		$tpl->display();
	}
	
	protected function getBannersList($parameters) {
		$bannersList = $_SESSION["pagehandler_banners"]["bannersList"];
		if (empty($bannersList)) {
			$bannersList = ora_cursor("APPL_WEB_TABLE.GET_ORDER_ADVERT_TABLE");
		}
		$size = count($bannersList);
		$rows = json_encode($bannersList);
		echo '{"page": "1", "total": "1", "records": "'.$size.'",
			"rows":' . $rows . '
		}';
	}
	
	protected function edit($parameters) {
		$this->user()->actAsSelf();
		$documentEditor = new DocumentEditor();
		$tpl = $documentEditor->editDocument($parameters["url"][1]);
		$this->user()->actAsCommonUser();
		$tpl->assign("pagehandler", $this);
		$tpl->display();
	}
	
	protected function create() {
		$this->user()->actAsSelf();
		$bannerID = DocumentEditor::createNewDocument("ORDER_ADVERT");
		$this->user()->actAsCommonUser();
		header("Location: /banners/edit/$bannerID");
	}

	protected function delete() {
		$banner = get("banner");
		if (empty($banner)) {
			throw new Exception("banner for delete is not set");
		}
		DocumentEditor::deleteDocument($banner);
		header("Location: /banners");
	}
}
?>
