<?php

include_once CARABI_DIR . '/classes/wave_editor/class.WaveEditorUtils.php';

/**
 * Функции и настройки для CMS
 *
 * @author sasha
 */
class lib_cms {
	const WEBSITE_ID = 1;//ID редактируемого сайта, к которому привязаны страницы и меню
	const WEBSITE_URL = "http://veneta.ru";//URL редактируемого сайта, если CMS располагается отдельно
	
	const PERMISSION_ANY = 3;
	const PERMISSION_PAGES = 4;
	const PERMISSION_NEWS = 5;
	const PERMISSION_NAVIGATION = 6;
	
	/**
	 * Корень CMS -- корень проекта (отдельно лежащая CMS) или глубже
	 */
	public static function CMS_ROOT() {
		return SUB_URL . "/cms";
	}
	
	/**
	 * URL страницы авторизации -- carabi_cms/pagehandler_login или
	 * carabi_office/pagehandler_login, если cms в составе office
	 */
	public static function loginPage() {
		if (class_exists("lib_office")) {
			return lib_office::OFFICE_ROOT() . "/login";
		} else {
			return lib_cms::CMS_ROOT() . "/login";
		}
	}

	/**
	 * Получение главного меню CMS
	 * @param boolean $withOthers Показывать рядом меню других модулей
	 * @global WebUserAuth $currentUser 
	 */
	public static function getMainMenu($withOthers = true) {
		global $currentUser;
		if ($currentUser->userId() > 0) {
			$menu = array();
			$menu[] = array("url" => self::CMS_ROOT() . "/desktop", "caption" => "Главная");
			if (self::hasPermission($currentUser, self::PERMISSION_PAGES)) {
				$menu[] = array("url" => self::CMS_ROOT() . "/pages", "caption" => "Страницы");
			}
			if (self::hasPermission($currentUser, self::PERMISSION_NEWS)) {
				$menu[] = array("url" => self::CMS_ROOT() . "/news", "caption" => "Новости");
			}
			if (self::hasPermission($currentUser, self::PERMISSION_NAVIGATION)) {
				$menu[] = array("url" => self::CMS_ROOT() . "/navigate", "caption" => "Навигация");
			}
				/*array("url" => self::CMS_ROOT() . "/banners", "caption" => "Баннеры")*/
		} else {
			$menu = array();
		}
		foreach ($menu as &$item) {
			$urlLength = strlen($item["url"]);
			if (substr($_SERVER["REDIRECT_URL"], 0, $urlLength) === $item["url"]) {
				$item["current"] = true;
			}
		}
		if ($withOthers) {
			if (class_exists("lib_office") && lib_office::hasPermission($currentUser, lib_office::PERMISSION_ANY)) {
				$menu[] = array(
					"caption" => "Office",
					"children" => lib_office::getMainMenu(false)
				);
			}
		}
		return $menu;
	}
	
	public static function getTopMenu() {
		if (class_exists("lib_office")) {
			return lib_office::getTopMenu();
		} else {
			$menu = array(
				array("url" => self::CMS_ROOT() . "/login/signout", "caption" => "Выход")
			);
			return $menu;
		}
	}

	/**
	 * Проверка, имеет ли пользователь право на доступ к Carabi CMS и определённым его модулям
	 * @param WebUserAuth $user
	 */
	public static function hasPermission(WebUserAuth $user, $permissionRequired) {
		$permissionsHas = $user->getUserPermissions();
		if (array_search($permissionRequired, $permissionsHas) !== false) {
			return true;
		} else {
			return false;
		}
	}
}
?>
