<?php

define(SITE_ID, 1);
define(SECRET, "viCEWer7DkcIPTF5cYywgSjMbjICmDZ1");
define(API_URL, "192.168.0.116");
define(API_PORT, 4041);

function send_request($xml) {
	$request["operation_xml"] = base64_encode($xml);
	$request["signature"] = base64_encode(sha1(SECRET . $xml . SECRET, 1));
	$request = json_encode($request);
	
	$fp = fsockopen(API_URL, API_PORT, $errno, $errstr);
	if (!$fp) {
		die("ERROR: $errno - $errstr<br />\n");
	} else {
		fputs($fp, "$request.");
		$result = '';
		while(($tmp = fgets($fp, 1024)) != "\r\n") {
			$result .= $tmp;
		}
		fclose($fp);
	}
	
	//print_r($request);
	//exit;
	
	$result = json_decode($result, true);
	
	if ($result["message"] == "Access denied") {
		print_r($request);
		exit;
	}
	
	$utf_arr = $result["result"];
	
	
	if (is_array($utf_arr)) {
		foreach($utf_arr as $k1 => $v1) {
			if (is_array($v1)) {
				foreach($v1 as $k2 => $v2) {
					$result["result"][$k1][$k2] = iconv("utf-8", "windows-1251", $v2);
				}
			} else {
				$result["result"][$k1] = iconv("utf-8", "windows-1251", $v1);
			}
		}
	}
	//print_r($result);
	return $result;
}

function carabi_term() {
	$xml = "
		<request>
			<site_id>" . SITE_ID . "</site_id>
			<action>term</action>
		</request>
	";
	return send_request($xml);
}

function carabi_connect($project) {
	$xml = "
		<request>
			<site_id>" . SITE_ID . "</site_id>
			<action>connect</action>
			<project>$project</project>
		</request>
	";
	return send_request($xml);
}

function carabi_register($uid) {
	$xml = "
		<request>
			<site_id>" . SITE_ID . "</site_id>
			<action>register</action>
			<uid>$uid</uid>
		</request>
	";
	return send_request($xml);
}

function carabi_get_user_id() {
	$xml = "
		<request>
			<site_id>" . SITE_ID . "</site_id>
			<action>get_user_id</action>
		</request>
	";
	return send_request($xml);
}

function carabi_select($sql) {
	$xml = "
		<request>
			<site_id>" . SITE_ID . "</site_id>
			<action>select</action>
			<sql>$sql</sql>
		</request>
	";
	return send_request($xml);
}

function carabi_select_clob($sql) {
	$xml = "
		<request>
			<site_id>" . SITE_ID . "</site_id>
			<action>select_clob</action>
			<sql>$sql</sql>
		</request>
	";
	return send_request($xml);
}

function carabi_proc($sql, $commit = 1) {
	$xml = "
		<request>
			<site_id>" . SITE_ID . "</site_id>
			<action>procedure</action>
			<sql>$sql</sql>
			<commit>$commit</commit>
		</request>
	";
	return send_request($xml);
}

function carabi_function($sql, $commit = 1, $bindings) {
	$xml = "
		<request>
			<site_id>" . SITE_ID . "</site_id>
			<action>function</action>
			<sql>$sql</sql>
			<commit>$commit</commit>
			<bindings>" . json_encode($bindings) . "</bindings>
		</request>
	";
	return send_request($xml);
}

function carabi_function_dual($sql, $commit = 1) {
	$xml = "
		<request>
			<site_id>" . SITE_ID . "</site_id>
			<action>function_dual</action>
			<sql>$sql</sql>
			<commit>$commit</commit>
		</request>
	";
	return send_request($xml);
}

function carabi_function_2($sql, $commit = 1) {
	$xml = "
		<request>
			<site_id>" . SITE_ID . "</site_id>
			<action>function_2</action>
			<sql>$sql</sql>
			<commit>$commit</commit>
		</request>
	";
	return send_request($xml);
}

function carabi_cursor($sql, $max_count) {
	$xml = "
		<request>
			<site_id>" . SITE_ID . "</site_id>
			<action>cursor</action>
			<sql>$sql</sql>
			<max_count>$max_count</max_count>
		</request>
	";
	return send_request($xml);
}

?>