<?

function ShowGeoIp($key){
/*
Возвращает GEO-данные по IP-адресу

NOTE: Обязательно должны быть включены сессии!!!
session_start();

ShowGeoIp('region') - регион
ShowGeoIp('city') - город
ShowGeoIp('district') - округ
ShowGeoIp('lat') - широта
ShowGeoIp('lng') - долгота
*/

	$url = 'http://194.85.91.253:8090/geo/geo.html'; // url на XML сервер <<IpGeobase>>
	if (!isset($_SESSION['location'])) // проверяем наличие сессии
	{ // если сессии нет, то начинаем выполнять поиск
	if (!empty($_SERVER['HTTP_CLIENT_IP'])) // пытаемся определить IP в обход прокси-сервера
	{
	$ip = $_SERVER['HTTP_CLIENT_IP'];
	} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
	$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else { //  если не удалось, то выводим простой IP
	$ip = $_SERVER['REMOTE_ADDR'];
	}
	$cl = curl_init(); // Устанавливаем cURL
	$query = '<ipquery><fields><all/></fields><ip-list><ip>'.$ip.'</ip></ip-list></ipquery>'; //  формируем запрос
	curl_setopt($cl, CURLOPT_URL, $url); //  выполняем запрос на сервер по адресу $url
	curl_setopt($cl, CURLOPT_RETURNTRANSFER,1); // указываем что ответ сервера нужно записать в переменную
	curl_setopt($cl, CURLOPT_TIMEOUT, 2); // таймаут соединения - 2 секунды
	curl_setopt($cl, CURLOPT_POST, 1); // указываем метод выполнения скрипта - POST
	curl_setopt($cl, CURLOPT_POSTFIELDS, $query); //  выпосляем запрос
	$result = curl_exec($cl); // записываем в переменную
	curl_close($cl); //  закрываем соединение
	preg_match_all("|<region>(.*?)</region>|", $result, $region); //  узнаём регион
	preg_match_all("|<city>(.*?)</city>|", $result, $city); //  узнаём город
	preg_match_all("|<district>(.*?)</district>|", $result, $district); //  узнаём округ
	preg_match_all("|<lat>(.*?)</lat>|", $result, $lat); //  узнаём широта
	preg_match_all("|<lng>(.*?)</lng>|", $result, $lng); //  узнаём долгота
	$_SESSION['location'] = array(); //  определяем сессию 'location' массивом
	$_SESSION['location']['region'] = $region[1][0]; //  записываем в массив сессии регион
	$_SESSION['location']['city'] = $city[1][0];  //  записываем в массив сессии город
	$_SESSION['location']['district'] = $district[1][0]; //  записываем в массив сессии округ
	$_SESSION['location']['lat'] = $lat[1][0]; //  записываем в массив сессии широту
	$_SESSION['location']['lng'] = $lng[1][0]; //  записываем в массив сессии долготу
	$location = $_SESSION['location'][$key];  //  выводим результат функции согласно ключу
	} else { //  если сессия найдена, что выводим данные от туда
	$location = $_SESSION['location'][$key];  //  выводим результат функции согласно ключу
	}
	return $location;  //  возвращаем результат
}

?>