<?php

// ПОЛЕЗНЫЕ УТИЛИТЫ
// Настоятельно рекомендую сюда добавлять часто встречающиеся задачи и реализовывать их функциями с расширенными параметрами
// (c) Business Solutions, Inc, 2004    :)
// (c) mikhail@molochnikov.com
// Версия 2.0 от 11-08-2010
// только основные функции. специализированные функции размещаем в /includes или utilities.[special name].inc
//include "../includes/socket_api.php";

/* 	Безопасное получение переменных запроса.
  Если переменная не существует, то возвращается значение по умолчанию.
  Иначе значение переменной декодируется и возвращается */
function get($name, $defaultvalue = false) {
	return (isset($_REQUEST[$name])) ? htmlspecialchars(urldecode($_REQUEST[$name])) : $defaultvalue;
}

function to_number($number) {
	$result = number_format(round($number, 2), 2, '.', '');
	return $result;
}

function str_to_view($str) {
	$result = nl2br(str_replace("  ", "&nbsp; ", $str));
	return $result;
}

function str_to_edit($str) {
	$result = htmlspecialchars($str);
	return $result;
}

function str_to_area($str) {
	$result = html_entity_decode($str);
	return $result;
}

function str_to_save($str) {
	$result = str_replace("'", "\"", $str);
	$result = stripslashes($result);
	return $result;
}

function toupper($content) {
	$content = strtr($content, "абвгдеёжзийклмнорпстуфхцчшщъьыэюя", "АБВГДЕЁЖЗИЙКЛМНОРПСТУФХЦЧШЩЪЬЫЭЮЯ");
	return strtoupper($content);
}

function tolower($content) {
	$content = strtr($content, "АБВГДЕЁЖЗИЙКЛМНОРПСТУФХЦЧШЩЪЬЫЭЮЯ", "абвгдеёжзийклмнорпстуфхцчшщъьыэюя");
	return strtolower($content);
}

/**
 * Преобразует строку с датой из вида '24-AUG-11' в '24 августа 2011 г.' или 24.08.2011
 * @param string $date дата в исходном виде '24-AUG-11'
 * @param boolean $numeric писать месяц числом
 * @return string
 */
function format_string_date($date, $numeric = false) {
	if (empty($date)) return "";
	if (!preg_match("/^\d\d-\w\w\w-\d\d/", $date)) {
		throw new Exception ("Unformatible date: $date");
	}
	$mounth = null;
	if ($numeric) {
		switch (substr($date, 3, 3)) {
			case "JAN": $mounth = "01";
				break;
			case "FEB": $mounth = "02";
				break;
			case "MAR": $mounth = "03";
				break;
			case "APR": $mounth = "04";
				break;
			case "MAY": $mounth = "05";
				break;
			case "JUN": $mounth = "06";
				break;
			case "JUL": $mounth = "07";
				break;
			case "AUG": $mounth = "08";
				break;
			case "SEP": $mounth = "09";
				break;
			case "OCT": $mounth = "10";
				break;
			case "NOV": $mounth = "11";
				break;
			case "DEC": $mounth = "12";
				break;
		}
		return substr($date, 0, 2) . "." . $mounth . ".20" . substr($date, 7, 2);
	} else {
		switch (substr($date, 3, 3)) {
			case "JAN": $mounth = "января";
				break;
			case "FEB": $mounth = "февраля";
				break;
			case "MAR": $mounth = "марта";
				break;
			case "APR": $mounth = "апреля";
				break;
			case "MAY": $mounth = "мая";
				break;
			case "JUN": $mounth = "июня";
				break;
			case "JUL": $mounth = "июля";
				break;
			case "AUG": $mounth = "августа";
				break;
			case "SEP": $mounth = "сентября";
				break;
			case "OCT": $mounth = "октября";
				break;
			case "NOV": $mounth = "ноября";
				break;
			case "DEC": $mounth = "декабря";
				break;
		}
		return substr($date, 0, 2) . " " . $mounth . " 20" . substr($date, 7, 2) . " г.";
	}
}

/**
 * преобразует строку в ENCODED-URL строку
 * @param type $content
 * @return string
 */
function tourl($content) {
	//$str0 = 'абвгдеёжзийклмнорпстуфхцчшщъьыэюяАБВГДЕЁЖЗИЙКЛМНОРПСТУФХЦЧШЩЪЬЫЭЮЯ';
	//$str1 = '%E0%E1%E2%E3%E4%E5%B8%E6%E7%E8%E9%EA%EB%EC%ED%EE%F0%EF%F1%F2%F3%F4%F5%F6%F7%F8%F9%FA%FC%FB%FD%FE%FF%C0%C1%C2%C3%C4%C5%A8%C6%C7%C8%C9%CA%CB%CC%CD%CE%D0%CF%D1%D2%D3%D4%D5%D6%D7%D8%D9%DA%DC%DB%DD%DE%DF';
	$res = '';
	for ($i = 0; $i < strlen($content); $i++) {
		$str = substr($content, $i, 1);
		$res .= '%' . ord($str);
	}
	return $res;
}

function replace($tag, $value, $str) {
	// синоним str_replace + заменяет пусто на &nbsp
	// что - на что - где
	// если зхначение пустое, возвращает &nbsp;
	$res = str_replace($tag, str_to_view($value), $str);
	return $res;
}

function strcopy($str, $pos1, $len) {
	// синоним substr - возвращает подстроку длиной len
	$res = substr($str, $pos1, $len);
	return $res;
}

function str_copy($str, $pos1, $len) {
	// синоним substr - возвращает подстроку длиной len
	$res = substr($str, $pos1, $len);
	return $res;
}

function array_remove($arr, $first, $cnt = 1) {
	// удаляет из массива cnt элементов начиная с first
	$res = $arr;
	array_splice($res, $first, $cnt);
	return $res;
}

function array_copy($arr, $first, $cnt = 1) {
	// возвращает часть массива начиная с элемента first - cnt элементов
	$res = array_splice($arr, $first, $cnt);
	return $res;
}

// Возвращает строку из массива $err, объявленного в init_all_var.php

function get_msg($code, $extended = true) {
// $code   - код ошибки (отрицательный)
// $extended - расширенное сообщение
	global $err;
	$res = "";
	//print_r($err);
	if ($code < 0) {
		if ($extended) {
			$res = "[OMM" . $code . "]: " . $err[$code] . "!";
		} else {
			$res = $err[$code][msg] . "!";
		}
	}
	return $res;
}

/**
 * выполняет перекодировку всех элементов массива в кодировку UTF-8
 * @param array $arr
 * @return array
 */
function array_to_utf($arr) {
	array_walk_recursive($arr, function(&$value, $index) {
				$value = mb_convert_encoding($value, 'utf-8', 'windows-1251');
			});
	//$arr = array();
	//$arr[0][id] = 'id';
	//$arr[0][value] = 'value';
	//$arr[0][label] = 'label';

	return $arr;
}

/**
 * функция возвращает результат SQL-запроса - массив
 * @global type $conn
 * @param type $sql
 * @return type
 */
function get_table($sql) {
	global $conn;

	$stmt = ociparse($conn, $sql);
	ociexecute($stmt, OCI_NO_AUTO_COMMIT);
	ocifetchstatement($stmt, $result);
	ocifreestatement($stmt);

	return $result;
}

; // end get_table
// запуск строки с обработчиком
function exec_str($str, $commit = true) {
// $str - строка
// $commit   - если true, то с commit
	global $conn;
	//$sql = $str;
	$aa = 2;
	$sql = "BEGIN $str; EXCEPTION  WHEN OTHERS THEN NULL; END;";
	///echo $sql;

	$stmt = ociparse($conn, $sql);
	$mode = $commit ? OCI_COMMIT_ON_SUCCESS : OCI_NO_AUTO_COMMIT;
	ociexecute($stmt, $mode);
	echo $aa . "<br>";
	$except_array = ocierror($stmt);
	echo "ОШИБКИ<br>";
	print_r($except_array);

//  if  ($commit) ocicommit($conn);
	ocifreestatement($stmt);
}

;

// возвращает цвет фона из массива цветов фона
function get_bk_color($index = 1, $random = false) {
	global $bk_colors;

	if ($index > count($bk_colors)) {
		$index = 1;
	}
	if ($random) {
		$index = rand(0, count($bk_colors) - 1);
	}
	//print_r ($bk_colors);
	return $bk_colors[$index];
}

;

// ЗАПОЛНЕНИЕ ВЫПАДАЮЩЕГО СПИСКА СИСТЕМНЫХ ЮЗЕРОВ ОПРЕДЕЛЕННЫХ РОЛЕЙ (строка через запятую: '1,3' )
// Возвращает ПУТЬ в СЛОВАРЕ для листа
function get_row_id_by_vocab_code($vocab_name, $vocab_code) {
	global $conn;
	$sql = " SELECT V.ID  FROM VOCABS V WHERE LEVEL > 1 AND V.CODE = '$vocab_code'
          START WITH V.NAME = '$vocab_name' CONNECT BY PRIOR V.ID = V.PARENT";

	$stmt = ociparse($conn, $sql);
	ociexecute($stmt);
	ocifetch($stmt);
	$result = ociresult($stmt, "ID");

	return $result;
}

// Возвращает ПУТЬ в СЛОВАРЕ для листа
function get_vocab_path_by_vocab_code($vocab_name, $vocab_code) {
	global $conn;
	$sql = "SELECT VC.DESCRIPTION
          FROM VOCABS VC
          WHERE LEVEL > 0 AND VC.NAME IS NULL
          START WITH VC.ID = (SELECT VC.ID
                                    FROM VOCABS VC
                                    WHERE VC.CODE = '$vocab_code'
                                    START WITH VC.NAME = '$vocab_name'
                                    CONNECT BY PRIOR VC.ID = VC.PARENT)
         CONNECT BY PRIOR VC.PARENT = VC.ID";

	$stmt = ociparse($conn, $sql);
	ociexecute($stmt);
	while (ocifetch($stmt)) {
		if (!empty($result))
			$result = "/" . $result;
		$result = ociresult($stmt, "DESCRIPTION") . $result;
	}
	return $result;
}

// ЗАПОЛНЕНИЕ ВЫПАДАЮЩЕГО СПИСКА ИЗ ЗНАЧЕНИЙ(листьев) СЛОВАРЯ
function fill_vocab_listbox($vocab_name, $selected, $addempty = true, $max_level = 100, $orderby_code = false) {
// vocab_name$  - наименование словаря
// selected     - код выбранного значения (12)
// addempty     - если true, то добавлять пустую строку
// orderby_code - если true, то сортировка списка идет по коду, иначе -- по значению
	global $conn;

	// cортировка
	if ($orderby_code) {
		$sort_order = 1;
	} else {
		$sort_order = 2;
	}

	$sql = "SELECT VC.CODE, VC.DESCRIPTION AS NODE, VC.PARENT, VN.DESCRIPTION AS PARENT_NAME, VN.CODE AS PARENT_CODE  FROM VOCABS VC, VOCABS VN
          WHERE LEVEL BETWEEN 2 AND '$max_level' AND NOT EXISTS
          (SELECT NULL FROM VOCABS V1 WHERE V1.PARENT = VC.ID) AND
          VN.ID(+) = VC.PARENT START WITH VC.NAME = '$vocab_name' CONNECT BY PRIOR VC.ID = VC.PARENT
          ORDER BY 3, $sort_order";
	echo $sql;
	$stmt = ociparse($conn, $sql);
	ociexecute($stmt);
	// Печатаем пустое поле
	if ($addempty) {
		echo "<option></option>";
	}
	while (ocifetch($stmt)) {
		echo "<option value=\"" . ociresult($stmt, "CODE") . "\"";
		if ($selected == ociresult($stmt, "CODE"))
			echo " selected ";
		echo ">" . get_vocab_path_by_vocab_code($vocab_name, ociresult($stmt, "CODE"));
		echo "</option>";
	}
	return true;
}

;

// ЗАПОЛНЕНИЕ ВЫПАДАЮЩЕГО СПИСКА ИЗ ЗНАЧЕНИЙ(листьев) СЛОВАРЯ
function fill_vocab_listbox_without($vocab_name, $selected, $without, $addempty = true, $max_level = 100) {
// vocab_name$ - наименование словаря
// selected    - код выбранного значения (12)
// addempty    - если true, то добавлять пустую строку
	global $conn;

	if (!empty($without))
		$sql = "SELECT VC.CODE, VC.DESCRIPTION AS NODE, VC.PARENT, VN.DESCRIPTION AS PARENT_NAME, VN.CODE AS PARENT_CODE  FROM VOCABS VC, VOCABS VN
          WHERE LEVEL BETWEEN 2 AND '$max_level' AND VC.CODE NOT IN ($without) AND NOT EXISTS
          (SELECT NULL FROM VOCABS V1 WHERE V1.PARENT = VC.ID) AND
          VN.ID(+) = VC.PARENT
          START WITH VC.NAME = '$vocab_name' CONNECT BY PRIOR VC.ID = VC.PARENT
          ORDER BY 3, 2";
	else
		$sql = "SELECT VC.CODE, VC.DESCRIPTION AS NODE, VC.PARENT, VN.DESCRIPTION AS PARENT_NAME, VN.CODE AS PARENT_CODE  FROM VOCABS VC, VOCABS VN
          WHERE LEVEL BETWEEN 2 AND '$max_level' AND NOT EXISTS
          (SELECT NULL FROM VOCABS V1 WHERE V1.PARENT = VC.ID) AND
          VN.ID(+) = VC.PARENT START WITH VC.NAME = '$vocab_name' CONNECT BY PRIOR VC.ID = VC.PARENT
          ORDER BY 3, 2";

	$stmt = ociparse($conn, $sql);
	ociexecute($stmt);
	// Печатаем пустое поле
	if ($addempty) {
		echo "<option></option>";
	}
	while (ocifetch($stmt)) {
		echo "<option value=\"" . ociresult($stmt, "CODE") . "\"";
		if ($selected == ociresult($stmt, "CODE"))
			echo " selected ";
		echo ">" . get_vocab_path_by_vocab_code($vocab_name, ociresult($stmt, "CODE"));
		echo "</option>";
	}
	return true;
}

;

// ЗАПОЛНЕНИЕ ВЫПАДАЮЩЕГО СПИСКА ИЗ ЗНАЧЕНИЙ(УЗЛОВ) СЛОВАРЯ
function fill_vocab_node_listbox($vocab_name, $selected, $addempty = true, $max_level = 100) {
// vocab_name$ - наименование словаря
// selected    - код выбранного значения (12)
// addempty    - если true, то добавлять пустую строку
	global $conn;

	$sql = "SELECT *  FROM VOCABS VC WHERE LEVEL BETWEEN 2 AND '$max_level' AND  EXISTS
       (SELECT NULL FROM VOCABS V1 WHERE V1.PARENT = VC.ID)
       START WITH VC.NAME = '$vocab_name'
       CONNECT BY PRIOR VC.ID = VC.PARENT  ORDER BY  2";

	$stmt = ociparse($conn, $sql);
	ociexecute($stmt);
	// Печатаем пустое поле
	if ($addempty) {
		echo "<option></option>";
	}
	while (ocifetch($stmt)) {
		echo "<option value=\"" . ociresult($stmt, "CODE") . "\"";
		if ($selected == ociresult($stmt, "CODE"))
			echo " selected ";
		echo ">" . get_vocab_path_by_vocab_code($vocab_name, ociresult($stmt, "CODE"));
		echo "</option>";
	}
	return true;
}

;

// ЗАПОЛНЕНИЕ ВЫПАДАЮЩЕГО СПИСКА ИЗ ЗНАЧЕНИЙ СЛОВАРЯ для родителя
function fill_vocab_listbox_by_parent($vocab_name, $selected, $parent_code, $addempty = true, $max_level = 100) {
// vocab_name$ - наименование словаря
// selected    - код выбранного значения (12)
// addempty    - если true, то добавлять пустую строку
// parent_code
	global $conn;

	/* $sql = "SELECT *  FROM VOCABS VC,(SELECT V.ID, V.CODE, V.DESCRIPTION
	  FROM VOCABS V WHERE LEVEL > 1 AND V.CODE = '$parent_code'
	  START WITH V.NAME = '$vocab_name' CONNECT BY PRIOR V.ID = V.PARENT
	  ) V
	  WHERE  LEVEL BETWEEN 2 AND '$max_level' START WITH VC.ID = V.ID  CONNECT BY PRIOR VC.ID = VC.PARENT    ORDER BY 5";
	 */
	$parent_id = get_row_id_by_vocab_code($vocab_name, $parent_code);

	$sql = "SELECT VC.CODE, VC.DESCRIPTION AS NODE, VC.PARENT,  VN.DESCRIPTION AS PARENT_NAME, VN.CODE AS PARENT_CODE
         FROM VOCABS VC, VOCABS VN
         WHERE LEVEL BETWEEN 2 AND '$max_level' AND NOT EXISTS        (SELECT NULL FROM VOCABS V1 WHERE V1.PARENT = VC.ID) AND
        VN.ID(+) = VC.PARENT START WITH VC.ID = '$parent_id' CONNECT BY PRIOR VC.ID = VC.PARENT ORDER BY 3, 2";


	$stmt = ociparse($conn, $sql);
	ociexecute($stmt);
	// Печатаем пустое поле
	if ($addempty) {
		echo "<option></option>";
	}
	while (ocifetch($stmt)) {
		echo "<option value=\"" . ociresult($stmt, "CODE") . "\"";
		if ($selected == ociresult($stmt, "CODE"))
			echo " selected ";
		echo ">" . ociresult($stmt, "PARENT_NAME") . "/" . ociresult($stmt, "NODE");

		echo "</option>";
	}
	return true;
}

;

// ЗАПОЛНЕНИЕ ВЫПАДАЮЩЕГО СПИСКА ИЗ ЗНАЧЕНИЙ СЛОВАРЯ для родителя
function fill_doc_templ_listbox($selected, $doc_type, $addempty = true, $max_level = 100) {
// vocab_name$ - наименование словаря
// selected    - код выбранного значения (12)
// addempty    - если true, то добавлять пустую строку
// parent_code
	global $conn;
	$obj = get_doc_type_list();
	/* $sql = "SELECT *  FROM VOCABS VC,(SELECT V.ID, V.CODE, V.DESCRIPTION
	  FROM VOCABS V WHERE LEVEL > 1 AND V.CODE = '$parent_code'
	  START WITH V.NAME = 'DOC_TYPE' CONNECT BY PRIOR V.ID = V.PARENT
	  ) V
	  WHERE  LEVEL BETWEEN 2 AND '$max_level' START WITH VC.ID = V.ID  CONNECT BY PRIOR VC.ID = VC.PARENT    ORDER BY 5";



	  $nrows = count($obj[TYPE]);
	  $stmt = ociparse($conn, $sql);
	  ociexecute ($stmt); */

	// Печатаем пустое поле
	if ($addempty)
		echo "<option></option>";

	//$count_option=0;
	/* while (ocifetch($stmt))
	  {
	  $add  = 0;
	  for ($i = 0; $i < $nrows; $i++)
	  {
	  if ( $obj[TYPE][$i] ==  ociresult($stmt, "CODE") )

	  {
	  $add = 1;
	  }
	  }
	  if ( $add == 1)
	  {
	  $count_option = $count_option +1;
	  echo "<option value=\"".ociresult($stmt, "CODE")."\"";
	  if ($selected == ociresult($stmt, "CODE")) echo " selected ";
	  echo ">".ociresult($stmt, "DESCRIPTION");

	  echo "</option>";
	  }
	  } */
	$count_option = 0;
	$nrows = count($obj[ID]);
	for ($i = 0; $i < $nrows; $i++) {
		if ($obj[TYPE][$i] == $doc_type) {
			$count_option = $count_option + 1;
			echo "<option value=\"" . $obj[ID][$i] . "\"";
			if ($selected == $obj[ID][$i])
				echo " selected ";
			echo ">" . $obj[TITLE][$i];
			echo "</option>";
		}
	}

	if ($count_option == 0)
		echo "<option>Пусто</option>";
	return true;
}

;

// Возвращает СПИСОК ЗНАЧЕНИЙ СЛОВАРЯ
function get_vocab_list($vocab_name) {
// vocab_name$ - наименование словаря
	global $conn;
	$sql = "SELECT VC.CODE, VC.DESCRIPTION FROM VOCABS VC WHERE LEVEL > 1
          START WITH VC.NAME = '$vocab_name' CONNECT BY PRIOR VC.ID = VC.PARENT";
	echo $sql;
	$stmt = ociparse($conn, $sql);
	ociexecute($stmt);
	$i = 0;
	while (ocifetch($stmt)) {
		$result[$i] = array("code" => ociresult($stmt, "CODE"), "description" => ociresult($stmt, "DESCRIPTION"));
		$i = $i + 1;
	}
	return $result;
}

;

/**
 * Возвращает СПИСОК ЗНАЧЕНИЙ СЛОВАРЯ - НОВАЯ 2011
 * @global type $conn
 * @param string $vocab_name наименование словаря
 * @param string $filter_sql
 * @param string $orderBy Поле сортировки: 'value' -- по значению (по умолчанию), 'code' -- по ключу
 * @return array
 */
function get_vocab_list2($vocab_name, $filter_sql = '', $orderBy = "value") {
	global $conn;
	if (!empty($filter_sql)) {
		$dop_filter = ' and ' . $filter_sql;
	}
	if (!isset($orderBy) || $orderBy == "") {
		$orderBy = "value";
	}
	$sql = "SELECT VC.CODE, VC.VALUE AS DESCRIPTION
  FROM VOCABS VC
WHERE VC.VOCAB_ID = get_vocab_id('$vocab_name') " . $dop_filter . "
ORDER BY $orderBy";
	//echo $sql;
	$stmt = ociparse($conn, $sql);
	ociexecute($stmt);
	$result = array();
	$i = 0;
	while (ocifetch($stmt)) {
		$result[$i] = array("code" => ociresult($stmt, "CODE"), "description" => ociresult($stmt, "DESCRIPTION"));
		$i = $i + 1;
	}
	return $result;
}

;

/**
 * Переводит словарь из списка записей "ключ-значение" в ассоциативный массив ключ => значение
 * Может добавить строку для невыбранного варианта
 * @param array $vocab_list словарный список в формате {{code, descr}, {code, descr}, {code, descr}}
 * @param string unselectedRow строка с индексом 0 для невыбранного варианта
 * @return array
 */
function assotiate_vocab_list($vocab_list, $unselectedRow = null) {
	$vocab = array();
	if (isset($unselectedRow)) {
		$vocab[0] = $unselectedRow;
	}
	foreach ($vocab_list as $record) {
		$vocab[$record["code"]] = $record["description"];
	}
	return $vocab;
}

/**
 * Возвращает ЗНАЧЕНИЕ из СЛОВАРЯ по его КОДУ
 * @param string $vocab_name наименование словаря
 * @param type $vocab_code код значения словаря
 * @return type
 */
function get_vocab_description_by_code($vocab_name, $vocab_code) {
	/*  global $conn;
	  $sql = "SELECT VC.CODE, VC.DESCRIPTION FROM VOCABS VC WHERE LEVEL > 1 AND VC.CODE = '$vocab_code'
	  START WITH VC.NAME = '$vocab_name' CONNECT BY PRIOR VC.ID = VC.PARENT  ";

	  $stmt = ociparse($conn, $sql);
	  ociexecute ($stmt);
	  ocifetch($stmt);
	  $result =ociresult($stmt, "DESCRIPTION");

	  return $result; */

	$info = file_get_contents('db_vocabs.dat');
	//echo $info;
	$info = explode('>', $info);
	//echo($info);
	foreach ($info as $str) {

		$voc = explode('*', trim($str));
		//print_r($user);
		//echo $voc[0];
		//echo $voc[1];
		//echo $voc[2];
		//echo "<br>";
		if (($voc[0] == $vocab_name) and (trim($voc[1]) == trim($vocab_code))) {
			$result = $voc[2];
			return $result;
		}
	}
}

;

function get_vocab_value($vocab_name, $vocab_code) {
	return get_vocab_description_by_code($vocab_name, $vocab_code);
}

// Возвращает фамилию и инициалы физ лица по его ID
function get_name_by_fiz_lico($fiz_lico_id, $fullname = null) {
// $fiz_lico_id - идентификатор физ лица из FIZ_LICO.ID
// $fullname == null, то  Возвращает фамилию и инициалы
// $fullname != null, то  Возвращает фамилию имя и отчество
	/* global $conn;
	  $sql = "SELECT PERSON.GET_FULL_NAME_FIZ_LICO_BY_ID('$fiz_lico_id','$fullname') AS FULL_NAME FROM DUAL";
	  $stmt = ociparse($conn, $sql);
	  ociexecute ($stmt);
	  ocifetch($stmt);
	  $result = ociresult($stmt, "FULL_NAME");

	  if (get_visible_by_fiz_lico($fiz_lico_id) == 0)  $result = "<font color=#FF0000>".$result."</font>";

	  return $result; */

	// читаем массив из файла...

	$info = file_get_contents('db_login.dat');
	//echo $info;
	$info = explode('>', $info);
	//echo($info);
	foreach ($info as $str) {
		$user = explode('*', trim($str));
		//print_r($user);
		if (trim($user[0]) == trim($fiz_lico_id)) {
			$result = $user[3] . " " . $user[4] . " " . $user[5];
		}
	}
	return $result;
}

function file_append($filename, $str) {
// добавляет в конец файла строку $str
// Вначале давайте убедимся, что файл существует и доступен для записи.
	if (is_writable($filename)) {

		// В нашем примере мы открываем $filename в режиме "дописать в конец".
		// Таким образом, смещение установлено в конец файла и
		// наш $somecontent допишется в конец при использовании fwrite().
		if (!$handle = fopen($filename, 'a')) {
			return -1;
			exit;
		}

		// Записываем $somecontent в наш открытый файл.
		if (fwrite($handle, $str) === FALSE) {
			return -2;
			exit;
		}
		fclose($handle);
	} else {
		// read-only file
		return -3;
	}
	return 0;
}

// ПРОВЕРКА корректности ввода времени
// ТРЕБУЕТСЯ ЗАПОЛНЯТЬ ВСЕ ПОЛЯ
function istime($hh, $mm) {
// возвращает true или false
	$res = false;
	if ((!empty($hh)) and (!empty($mm))) {
		if (is_numeric($hh) and is_numeric($mm))
			if ($hh >= 0 and $hh <= 24 and $mm >= 0 and $mm <= 59) {
				$res = true;
			};
	};
	return $res;
}

;

// ПРОВЕРКА корректности ввода даты.
// ТРЕБУЕТСЯ ЗАПОЛНЯТЬ ВСЕ ПОЛЯ
function isdate($dd, $mm, $yyyy) {
// возвращает true или false
	$res = false;
	if ((!empty($dd)) and (!empty($mm)) and (!empty($yyyy))) {
		if (is_numeric($dd) and is_numeric($mm) and is_numeric($yyyy) and ($yyyy > 1800))
			if (checkdate($mm, $dd, $yyyy)) {
				$res = true;
			};
	};
	return $res;
}

;

// ПРОВЕРКА корректности ввода даты.
// ТРЕБУЕТСЯ ЗАПОЛНЯТЬ ВСЕ ПОЛЯ
function isdatestr($dd, $mm, $yyyy) {
// возвращает true или false
	$res = false;
	if ((!empty($dd)) and (!empty($mm)) and (!empty($yyyy))) {
		if (is_numeric($dd) and is_numeric($mm) and is_numeric($yyyy) and ($yyyy > 1800))
			if (checkdate($mm, $dd, $yyyy)) {
				$res = true;
			};
	};
	return $res;
}

;

// ПРОВЕРКА корректности ввода даты.
// Проверяет, введена ли дата
function isdateempty($dd, $mm, $yyyy) {
// возвращает true, если дата не заполнена
	$res = false;
	if ((empty($dd)) and (empty($mm)) and (empty($yyyy))) {
		$res = true;
	};
	return $res;
}

;

// ПРОВЕРКА корректности ввода процента.
function isprocent($number) {
// возвращает $number, если корректно иначе 0
	$res = 0;
	$number = abs((float) $number);
	if ($number >= 0 and $number <= 100) {
		$res = $number;
	};
	return $res;
}

;

function isemail($email) {
	if (eregi("^[a-z0-9]+([-_\.]?[a-z0-9])+@[a-z0-9]+([-_\.]?[a-z0-9])+\.[a-z]{2,4}", $email))
		return TRUE;
	else
		return FALSE;
}

function islogin($login) {
	if (eregi("^[a-z0-9][a-z0-9]+([a-z0-9])", $login))
		return TRUE;
	else
		return FALSE;
}

function ispassword($password) {
	if (eregi("^[a-z0-9][a-z0-9]+([a-z0-9])", $password))
		return TRUE;
	else
		return FALSE;
}

// чистит  входную строку от мусора и режет на слова
function str_explode($content) {
	$content = stripslashes($content); //строка контекста на входе
	// $word_end="а,ам,ами,ах,ая,е,его,ее,ей,ем,ему,ею,и,ие,ием,еем,еям,еях,ией,ии,ий,им,ими,их,ию,ия,иях,й,о,ого,ое,ой,ом,ому,ою,у,ую,ы,ые,ый,ым,ыми,ых,ь,ью,ья,ю,юю,я,ям,ями,ях,s,es,ies,e,y,i";
	// $word_end_array=explode(",",trim($word_end));//массив окончаний
	$lex = 0; //конечная длина строки контекста
	$lst = 1; //стартовая длина строки контекста
	while ($lex != $lst) {
		$lst = strlen($content);
		$content = str_replace("\r\n", " ", $content);
		$content = str_replace("\t", " ", $content);
		$content = str_replace(".", " ", $content);
		$content = str_replace(",", " ", $content);
		$content = str_replace(":", " ", $content);
		$content = str_replace(";", " ", $content);
		$content = str_replace('"', " ", $content);
		$content = str_replace('/', " ", $content);
		$content = str_replace('!', " ", $content);
		$content = str_replace('@', " ", $content);
		$content = str_replace('#', " ", $content);
		$content = str_replace('$', " ", $content);
		$content = str_replace('%', " ", $content);
		$content = str_replace('^', " ", $content);
		$content = str_replace('&', " ", $content);
		$content = str_replace('*', " ", $content);
		$content = str_replace('?', " ", $content);
		$content = str_replace('=', " ", $content);
		$content = str_replace('[', " ", $content);
		$content = str_replace(']', " ", $content);
		$content = str_replace('<', " ", $content);
		$content = str_replace('>', " ", $content);
		$content = str_replace("'", " ", $content);
		//$content=str_replace("-", " ", $content);
		$content = str_replace("+", " ", $content);
		$content = str_replace("(", " ", $content);
		$content = str_replace(")", " ", $content);
		$content = str_replace("|", " ", $content);
		$content = str_replace("_", " ", $content);
		$content = str_replace('\\', " ", $content);
		$content = str_replace("°", " ", $content);
		$content = str_replace("№", " ", $content);
		$content = str_replace("©", " ", $content);
		$content = str_replace("«", " ", $content);
		$content = str_replace("»", " ", $content);
		$content = str_replace("·", " ", $content);
		//$content=str_replace("–", " ", $content);
		$content = str_replace("“", " ", $content);
		$content = str_replace("”", " ", $content);
		//$content=str_replace("—", " ", $content);
		$content = str_replace("~", " ", $content);
		$content = str_replace("  ", " ", $content);
		$lex = strlen($content);
	}
	$content_arrai = explode(" ", trim($content)); //массив контекста

	return $content_arrai;
}

/**
 * ЗАПОЛНЕНИЕ ВЫПАДАЮЩЕГО СПИСКА ИЗ ЗНАЧЕНИЙ
 * @param type $array_values
 * @param type $selected код выбранного значения (12)
 * @param type $addempty если true, то добавлять пустую строку
 * @return type
 */
function fill_listbox($array_values, $selected, $addempty = true) {

	// Печатаем пустое поле
	if ($addempty) {
		echo "<option></option>";
	}
	//if (count($array_values) >0)
	foreach ($array_values as $value => $descr) {
		echo "<option value=\"" . $value . "\"";
		if ($selected == $value)
			echo " selected ";
		echo ">" . $descr;
		echo "</option>";
	}
	return true;
}

;

// Отправляет сообщение из PHP
function simple_mail($from_email, $to_email, $subject, $message) {
	// multiple recipients
	//$to  = rus_encode($to_name).'<'.$to_email.'>';
	//$from  = rus_encode($from_name).'<'.$from_email.'>';
	$to = $to_email;
	$from = $from_email;

	// subject
	//$subject = rus_encode($subject);
	// To send HTML mail, the Content-type header must be set
	$headers = 'MIME-Version: 1.0' . "\r\n";
	$headers .= 'Content-type: text/html; charset=windows-1251' . "\r\n";

	// Additional headers
	//$headers .= 'To: '.$to."\r\n";
	$headers .= 'From: ' . $from . "\r\n";
	//$headers .= 'Cc: mikhail@molochnikov.com' . "\r\n";
	//$headers .= 'Bcc: mikhail@molochnikov.com' . "\r\n";
	// Mail it
	$res = mail($to, $subject, $message, $headers);
	return $res;
}

function get_field_value($doc_id, $doc_prop_name, $doc_kind_name) {
	if (!empty($doc_id) and !empty($doc_prop_name) and !empty($doc_kind_name)) {
		$result = ora_func_dual("(SELECT DOCUMENTS.DOCF_GET_DISPLAY_VALUE($doc_id, GET_DOCPROPID_BYNAME('$doc_prop_name', '$doc_kind_name')) FROM DUAL)");
	} else {
		$result = NULL;
	}
	return $result;
}

function var_empty($variable) {
// возвращает значение переменной, а если она пустая - то &nbsp;
	if (empty($variable)) {
		return '&nbsp;';
	} else {
		return $variable;
	}
}

/**
 * возвращает имя класса, входящее в имя файла вида /path/class.ClassName.php
 * @param string $fileName имя файла
 * @return string имя класса
 */
function getClassName($fileName) {
	$fileClassPattern = "/(.*)class\.(.*)\.php$/";
	return preg_replace($fileClassPattern, '$2', $fileName);
}

////////////////////////////////////////////////////////////////////////////////
// Раздел Функции Oracle
////////////////////////////////////////////////////////////////////////////////

function ora_connect() {
// выполняет подключение к серверу.
// Если не получилось, то остановились - критическая ошибка.
	global $DB_USER, $DB_PASSWORD, $DB_NAME, $ENCODING;

//echo "[", $DB_USER, "-", $DB_PASSWORD,"-", $DB_NAME, "-",$ENCODING, "]";
//die("1");
	$conn = OCILogon($DB_USER, $DB_PASSWORD, $DB_NAME, $ENCODING);
//echo $DB_USER . ":" . $DB_PASSWORD . ":" . $DB_NAME;
//die("2");
	//echo $conn;
	//exit;
	if (empty($conn)) {
		echo "<font color=\"#FF0000\">Сервер временно недоступен. Пожалуйста, повторите попытку через несколько минут.</font>";
		exit;
	}
	return $conn;
}

function ora_select($sql, $buffer1, $buffer2, $buffer3) {
// выполняет переданный селект, сохраняет выполнение в $bufferX
// возвращает результат в виде массива
// если $buffer уже сохранен, селект не вызывается
// если $buffer1 == 'no-cache' - данные не кэшируем
//      echo '<li>'.$sql;
	//if (md5($sql) == '46640c881e1f5d0fa0637c2744f22c9d') {
//	die($sql);
	//    }
	if (class_exists('utls')) {
		utls::logStr('ORA', '-- [ORA_SELECT] sql for ' . $buffer1 . ' ' . $buffer2 . ' ' . $buffer3);
		utls::logStr('ORA', $sql . ';');
	}
	if (class_exists('utls'))
		utls::timer('старт', 'ora_Select', true);

	global $conn;
	global $debug;
	if (empty($conn)) {
		throw new Exception('Сервер временно недоступен. Пожалуйста, повторите попытку через несколько минут.');
		//echo "<font color=\"#FF0000\">Сервер временно недоступен. Пожалуйста, повторите попытку через несколько минут.</font>";
		//return;
	}

	$cache_on = 1; // 0 - кэш отключен, используется для дебага


	if ($buffer1 == 'no-cache') {
		$cache_on = 0; // 0 - кэш отключен, используется для дебага
	}
	//////////////////////////////////////////////////////////////////////////
	// кэширование результатов запросов
	//////////////////////////////////////////////////////////////////////////
	// 1. проверка на изменение (только при включенном кэше)
	if ($cache_on == 1) {
		$changed = 0; // TODO: exec_func("get_web_page_change('".(int)$page_login."')");
		$fn = CACHE_DIR . '/data_' . $buffer1 . '_' . $buffer2 . '_' . $buffer3;
		if ($changed == 0) {
			// 2. не изменена - читать кэш
			if (file_exists($fn)) {
				$cache = file_get_contents($fn);
				$res = unserialize($cache);
				$cache_loaded = 1;
			} else {
				$cache_loaded = 0;
			}
		}
	}

	if (($changed > 0) or ($cache_loaded == 0) or ($cache_on == 0)) {
		// 3. изменена (или кэш не загрузился, или кэш отключен принудительно) - читать базу
		//$sql = "SELECT * FROM TABLE(CAST(APPL_PRICE_CLIENT.GET_CARTRAGE_PRINTER_LIST(".$filial_id.",-1, '') AS T_PRICE_CARTRIGE_FILIAL_LIST ))";
		//-------------------------------------------------------------------------------------

		$stmt = ociparse($conn, $sql);
		try {
			ociexecute($stmt, OCI_NO_AUTO_COMMIT);
		} catch (Exception $e) {
			/* if ($debug) */ {
				$e1 = oci_error($stmt);  // For oci_execute errors pass the statement handle
				$errMsg = '';
				$errMsg .= '<b><br />========== ORA_SELECT ========<br /></b>';
				$errMsg .= $e1['message'];
				$errMsg .= "\n<pre>\n";
				$errMsg .= $e1['sqltext'];
				$errMsg .= sprintf("\n%" . ($e1['offset'] + 1) . "s", "^");
				$errMsg .= "\n</pre>";
				$errMsg .= '<b><br />==============================<br /></b>';
				throw new Exception($errMsg);
				//echo $errMsg;
				//die();
			}
		}

		try {
			OCIFetchstatement($stmt, $res);
		} catch (Exception $e) {
			/* if ($debug) */ {
				$e1 = oci_error($stmt);  // For oci_execute errors pass the statement handle
				$errMsg = '';
				$errMsg .= '<b><br />========== ORA_SELECT:FETCH ========<br /></b>';
				$errMsg .= $e1['message'];
				$errMsg .= "\n<pre>\n";
				$errMsg .= $e1['sqltext'];
				$errMsg .= sprintf("\n%" . ($e1['offset'] + 1) . "s", "^");
				$errMsg .= "\n</pre>";
				$errMsg .= '<b><br />==================================<br /></b>';
				throw new Exception($errMsg);
				//echo $errMsg;
				//die();
			}
		}
		//-------------------------------------------------------------------------------------
		//carabi_connect("rentru");
		//$res = carabi_select($sql);
		//$res = $res['result'];
		// сохранить в кэше
		if ($cache_on == 1) {
			serialize($res);
			$cache = serialize($res);
			file_put_contents($fn, $cache);
		}
	}

	if (class_exists('utls'))
		utls::timer('стоп', 'ora_Select');

	return $res;
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
}

/**
 * запускает функцию, которая имеет возвращаемое значение - курсор
 * @global type $conn
 * @param string $cursor
 * @param int $max_count
 * @return array
 */
function ora_cursor($cursor, $max_count = 200) {
//echo "[{$cursor}]";
//echo '<textarea cols=80 rows=10>',$cursor,'</textarea>';

	global $conn;
	if (empty($conn)) {
		echo "<font color=\"#FF0000\">Сервер временно недоступен. Пожалуйста, повторите попытку через несколько минут.</font>";
		return;
	}

	$curs = OCINewCursor($conn);
	$stmt = OCIParse($conn, "begin :data := $cursor; end;");

	if (class_exists('utls')) {
		utls::logStr('ORA', '-- [ORA_CURSOR] cursor: ');
		utls::logStr('ORA', '/*');
		utls::logStr('ORA', $cursor . ';');
		utls::logStr('ORA', '*/');
	}

	ocibindbyname($stmt, "data", $curs, -1, OCI_B_CURSOR);
	try {
		ociexecute($stmt);
	} catch (Exception $e) {
		/* if ($debug) */ {
			$e1 = oci_error($stmt);  // For oci_execute errors pass the statement handle
			$errMsg = '<b><br />========== ORA_CURSOR($stmt) ===========<br /></b>';
			$errMsg .= $e1['message'];
			$errMsg .= "\n<pre>\n";
			$errMsg .= $e1['sqltext'];
			$errMsg .= sprintf("\n%" . ($e1['offset'] + 1) . "s", "^");
			$errMsg .= "\n</pre>";
			$errMsg .= '<b><br />=========================================<br /></b>';
			throw new Exception($errMsg);
			//die();
		}
	}
	try {
		ociexecute($curs);
	} catch (Exception $e) {
		/* if ($debug) */ {
			$e1 = oci_error($curs);  // For oci_execute errors pass the statement handle
			$errMsg = '<b><br />========== ORA_CURSOR($curs) ===========<br /></b>';
			$errMsg .= $e1['message'];
			$errMsg .= "\n<pre>\n";
			$errMsg .= $e1['sqltext'];
			$errMsg .= sprintf("\n%" . ($e1['offset'] + 1) . "s", "^");
			$errMsg .= "\n</pre>";
			$errMsg .= '<b><br />========================================<br /></b>';
			throw new Exception($errMsg);
			//die();
		}
	}

	$i = 0;

	$result = array();
	while ($data = oci_fetch_array($curs, OCI_ASSOC + OCI_RETURN_NULLS)) {
		if ($max_count && $i++ > $max_count) {
			break;
		}
		$result[] = $data;
	}

	OCIFreeStatement($stmt);
	OCIFreeCursor($curs);

	//$sql = "BEGIN :data := $cursor; END;";
	//$result = carabi_cursor($sql, $max_count = 200);
	//return $result["result"];

	return $result;
}

function ora_cursor_fetch($cursor, $max_count = 200, $page_no = 1) {
// запускает функцию, которая имеет возвращаемое значение - курсор
// $page_no - номер страницы начиная с 1!!!
//echo "[{$cursor}]";
	global $conn;

	if (empty($conn)) {
		echo "<font color=\"#FF0000\">Сервер временно недоступен. Пожалуйста, повторите попытку через несколько минут.</font>";
		return;
	}

	$curs = OCINewCursor($conn);
	$stmt = OCIParse($conn, "begin :data := $cursor; end;");

	//echo $cursor;

	ocibindbyname($stmt, "data", $curs, -1, OCI_B_CURSOR);
	try {
		ociexecute($stmt);
	} catch (Exception $e) {
		/* if ($debug) */ {
			$e1 = oci_error($stmt);  // For oci_execute errors pass the statement handle
			print '<b><br />========== ORA_CURSOR_FETCH($stmt) ===========<br /></b>';
			print $e1['message'];
			print "\n<pre>\n";
			print $e1['sqltext'];
			printf("\n%" . ($e1['offset'] + 1) . "s", "^");
			print "\n</pre>";
			print '<b><br />==============================================<br /></b>';
			die();
		}
	}
	try {
		ociexecute($curs);
	} catch (Exception $e) {
		/* if ($debug) */ {
			$e1 = oci_error($curs);  // For oci_execute errors pass the statement handle
			print '<b><br />========== ORA_CURSOR_FETCH($curs) ===========<br /></b>';
			print $e1['message'];
			print "\n<pre>\n";
			print $e1['sqltext'];
			printf("\n%" . ($e1['offset'] + 1) . "s", "^");
			print "\n</pre>";
			print '<b><br />==============================================<br /></b>';
			die();
		}
	}

	$i = 0;
	if ($page_no < 1) {
		$page_no = 1;
	}
	while (OCIFetchInto($curs, $data, OCI_ASSOC)) {
		if ($i < $max_count * ($page_no - 1) + $max_count) {
			if ($i >= $max_count * ($page_no - 1)) {
				// echo '<li>'.$i;
				$result[] = $data;
			}
		} else {
			break;
		}
		$i++;
	}

	OCIFreeStatement($stmt);
	OCIFreeCursor($curs);

	return ($result);
}

function ora_cursor_sql($sql) {
// запускает SQL выражение (любое) и возвращает курсор в виде массива
	global $conn;
	if (empty($conn)) {
		echo "<font color=\"#FF0000\">Сервер временно недоступен. Пожалуйста, повторите попытку через несколько минут.</font>";
		return;
	}

	$curs = OCINewCursor($conn);
	$stmt = OCIParse($conn, "begin open :data for $sql; end;");

	//echo $cursor;

	ocibindbyname($stmt, "data", $curs, -1, OCI_B_CURSOR);
	try {
		ociexecute($stmt);
	} catch (Exception $e) {
		/* if ($debug) */ {
			$e1 = oci_error($stmt);  // For oci_execute errors pass the statement handle
			print '<b><br />========== ORA_CURSOR_SQL($stmt) ===========<br /></b>';
			print $e1['message'];
			print "\n<pre>\n";
			print $e1['sqltext'];
			printf("\n%" . ($e1['offset'] + 1) . "s", "^");
			print "\n</pre>";
			print '<b><br />============================================<br /></b>';
			die();
		}
	}
	try {
		ociexecute($curs);
	} catch (Exception $e) {
		/* if ($debug) */ {
			$e1 = oci_error($curs);  // For oci_execute errors pass the statement handle
			print '<b><br />========== ORA_CURSOR_SQL($curs) ===========<br /></b>';
			print $e1['message'];
			print "\n<pre>\n";
			print $e1['sqltext'];
			printf("\n%" . ($e1['offset'] + 1) . "s", "^");
			print "\n</pre>";
			print '<b><br />===========================================<br /></b>';
			die();
		}
	}

	while (OCIFetchInto($curs, $data, OCI_ASSOC)) {
		$result[] = $data;
	}

	OCIFreeStatement($stmt);
	OCIFreeCursor($curs);

	return ($result);
}

// запуск оракловой процедуры
function ora_proc($proc_str, $commit = true) {
// $proc_str - строка название процедуры с параметрами
// $commit   - если true, то с commit
	//utls::logStr('ORA', '[ORA_PROC] proc_str: ' . $proc_str);
	$sql = "BEGIN " . $proc_str . "; END;";

	if (class_exists('utls')) {
		utls::logStr('ORA', '-- [ORA_PROC] procedure: ');
		utls::logStr('ORA', 'call ' . $proc_str . ';');
	}

	global $conn;

	if (empty($conn)) {
		echo "<font color=\"#FF0000\">Сервер временно недоступен. Пожалуйста, повторите попытку через несколько минут.</font>";
		return;
	}


	$stmt = ociparse($conn, $sql);

	try {
		$mode = $commit ? OCI_COMMIT_ON_SUCCESS : OCI_NO_AUTO_COMMIT;
		ociexecute($stmt, $mode);
	} catch (Exception $e) {
		/* if ($debug) */ {
			$e1 = oci_error($stmt);  // For oci_execute errors pass the statement handle
			$errMsg = '<b><br />========== ORA_PROC ===========<br /></b>';
			$errMsg .= $e1['message'];
			$errMsg .= "\n<pre>\n";
			$errMsg .= $e1['sqltext'];
			$errMsg .= sprintf("\n%" . ($e1['offset'] + 1) . "s", "^");
			$errMsg .= "\n</pre>";
			$errMsg .= '<b><br />==============================<br /></b>';
			throw new Exception($errMsg);
		}
	}

	ocifreestatement($stmt);

	//carabi_proc($sql, $commit?1:0);
}

;

// запуск оракловой функции
function ora_func_dual($func_str, $commit = true) {
// $func_str - строка название функции с параметрами
// $commit   - если true, то с commit
	utls::logStr('ORA', '[ORA_FUNC_DUAL] func_str: ' . $func_str);
	global $conn;
	if (empty($conn)) {
		echo "<font color=\"#FF0000\">Сервер временно недоступен. Пожалуйста, повторите попытку через несколько минут.</font>";
		return;
	}

	$sql = "SELECT " . $func_str . " AS RESULT FROM DUAL";

	//echo $sql;
	$stmt = ociparse($conn, $sql);
	try {
		$mode = $commit ? OCI_COMMIT_ON_SUCCESS : OCI_NO_AUTO_COMMIT;
		ociexecute($stmt, $mode);
	} catch (Exception $e) {
		/* if ($debug) */ {
			$e1 = oci_error($stmt);  // For oci_execute errors pass the statement handle
			print '<b><br />========== ORA_PROC_DUAL ======<br /></b>';
			print $e1['message'];
			print "\n<pre>\n";
			print $e1['sqltext'];
			printf("\n%" . ($e1['offset'] + 1) . "s", "^");
			print "\n</pre>";
			print '<b><br />==============================<br /></b>';
			die();
		}
	}

	ocifetch($stmt);
	$result = ociresult($stmt, "RESULT");
	ocifreestatement($stmt);

	return $result;
}

;

/**
 * Запуск оракловой функции с параметрами.
 * Пример использования:
  $sql = "inc_create_document_empty ('$documentType', :TYPE_ID, :DOCUMENT_ID)";
  $binding = array("TYPE_ID" => &$typeID, "DOCUMENT_ID" => &$docID);
  $error = ora_func($sql, $commit, $binding);
  if ($error != 0) {
  throw new Exception("Could not create new $documentType");
  }
  return $docID;
 *
 * @global $conn
 * @param string $func_str Название функции с параметрами. Можно использовать выходные параметры с префиксом :
 * @param boolean $commit если true, то с commit
 * @param array $bindings массив выходных параметров {имя параметра в Oracle => переменная в PHP}
 * @return string
 */
function ora_func($func_str, $commit = true, &$bindings = array()) {

	$sql = "BEGIN :res := " . $func_str . ";  END;";

	if (class_exists('utls')) {
		utls::logStr('ORA', '-- [ORA_FUNC] function (select from dual added here): ' . $func_str);
		utls::logStr('ORA', 'SELECT ' . $func_str . ' FROM DUAL;');
	}

	global $conn;
	if (empty($conn)) {
		$errMsg = "<font color=\"#FF0000\">Сервер временно недоступен. Пожалуйста, повторите попытку через несколько минут.</font>";
		//echo $errMsg;
		//return;
		throw new Exception($errMsg);
	}


	// echo $sql."<br>";

	$stmt = ociparse($conn, $sql);
	oci_bind_by_name($stmt, ":res", $result, 640);
	foreach ($bindings as $oracleVarName => &$phpVar) {
		oci_bind_by_name($stmt, ":$oracleVarName", $phpVar, 10240);
	}
	try {
		$mode = $commit ? OCI_COMMIT_ON_SUCCESS : OCI_NO_AUTO_COMMIT;
		ociexecute($stmt, $mode);
	} catch (Exception $e) {
		//if ($debug) {
		$e1 = oci_error($stmt);  // For oci_execute errors pass the statement handle
		$errMsg = '<b><br />========== ORA_FUNC ===========<br /></b>';
		//$errMsg .= $e1['message'];
		$errMsg .= $e1['message'];
		$errMsg .= "\n<pre>\n";
		//$errMsg .= $e1['sqltext'];
		$errMsg .= $e1['sqltext'];
		$errMsg .= sprintf("\n%" . ($e1['offset'] + 1) . "s", "^");
		$errMsg .= "\n</pre>";
		$errMsg .= '<b><br />==============================<br /></b>';
		//die();
		throw new Exception($errMsg);
		//}
	}

	ocifreestatement($stmt);
	return $result;
}

;

// запуск оракловой функции (возвращает NUMBER + ERRMESS - возвращаемое значение)
function ora_func2($func_str, $commit = true) {
// $func_str - строка название процедуры с параметрами
// $commit   - если true, то с commit
	utls::logStr('ORA', '[ORA_FUNC2] func_str: ' . $func_str);
	global $conn;
	if (empty($conn)) {
		echo "<font color=\"#FF0000\">Сервер временно недоступен. Пожалуйста, повторите попытку через несколько минут.</font>";
		return;
	}

	$sql = "BEGIN :res := " . $func_str . ";  END;";

	//echo $sql."<br>";

	$stmt = ociparse($conn, $sql);
	OCIBindByName($stmt, ":res", $result, -1, SQLT_INT);
	//OCIBindByName($stmt, ":res", $result, 64);
	OCIBindByName($stmt, ":errmess", $err, 256, SQLT_CHR);

	try {
		$mode = $commit ? OCI_COMMIT_ON_SUCCESS : OCI_NO_AUTO_COMMIT;
		ociexecute($stmt, $mode);

		utls::logStr('ORA', 'res ' . $result);
		utls::logStr('ORA', 'err ' . $err);
//utls::logStr();
//var_dump($result);
	} catch (Exception $e) {
		/* if ($debug) */ {
			$e1 = oci_error($stmt);  // For oci_execute errors pass the statement handle
			print '<b><br />========== ORA_FUNC2 ==========<br /></b>';
			print $e1['message'];
			print "\n<pre>\n";
			print $e1['sqltext'];
			printf("\n%" . ($e1['offset'] + 1) . "s", "^");
			print "\n</pre>";
			print '<b><br />==============================<br /></b>';
			die();
		}
	}

	ocifreestatement($stmt);
	return $result;
}

;

/**
 * Запуск произвольного кода PL/SQL. Никакие ключевые слова не подставляются,
 * код должен содержать begin и кончаться на end;, может содержать declare и
 * любые переменные, включая выходные, отмеченные префиксом :
 * @global $conn
 * @param string $code_str Произвольный код, который можно написать в test-окне SQL Developer
 * @param array $bindings массив выходных переменных {имя переменной в Oracle => переменная в PHP}
 * @param boolean $commit если true, то с commit
 */
function ora_code($code_str, &$bindings = array(), $commit = true) {
	utls::logStr('ORA', '[ORA_CODE] code_str: ' . $code_str);
	utls::logStr('ORA', '/*' . $code_str . '*/');
	global $conn;
	if (empty($conn)) {
		$errMsg = "<font color=\"#FF0000\">Сервер временно недоступен. Пожалуйста, повторите попытку через несколько минут.</font>";
		//echo $errMsg;
		//return;
		throw new Exception($errMsg);
	}
	$stmt = ociparse($conn, $code_str);
	foreach ($bindings as $oracleVarName => &$phpVar) {
		oci_bind_by_name($stmt, ":$oracleVarName", $phpVar, 10240);
	}

	try {
		$mode = $commit ? OCI_COMMIT_ON_SUCCESS : OCI_NO_AUTO_COMMIT;
		ociexecute($stmt, $mode);
	} catch (Exception $e) {
		//if ($debug) {
		$e1 = oci_error($stmt);  // For oci_execute errors pass the statement handle
		$errMsg = '<b><br />========== ORA_FUNC ===========<br /></b>';
		//$errMsg .= $e1['message'];
		$errMsg .= $e1['message'];
		$errMsg .= "\n<pre>\n";
		//$errMsg .= $e1['sqltext'];
		$errMsg .= $e1['sqltext'];
		$errMsg .= sprintf("\n%" . ($e1['offset'] + 1) . "s", "^");
		$errMsg .= "\n</pre>";
		$errMsg .= '<b><br />==============================<br /></b>';
		//die();
		throw new Exception($errMsg);
		//}
	}

	ocifreestatement($stmt);
}

// читает clob из поля
// аналог oci_result, только для clob
// пример: $content = oci_result_clob($stmt, "CONTENT");

function ora_result_clob($statement, $fieldname) {
	//echo $fieldname;
	$lob = oci_result($statement, $fieldname);
	if (!empty($lob)) {
		$result = $lob->load();
	} else {
		$result = $lob;
	}
	return $result;
}

function ora_save_clob($connection, $statement, $fieldname, $value)
// сохраняет значение в clob-поле и коммитит сессию
// напрямую сохранять нельзя, т.к. будет сообщение ORA-01704: string literal too long
// ВАЖНО: в $statement должен быть select for update!!!
/*
  $sql = "SELECT
  mylob
  FROM
  mylobs
  WHERE
  id = 3
  FOR UPDATE // locks the row

  $stmt = oci_parse($conn, $sql);

  // Execute the statement using OCI_DEFAULT (begin a transaction)
  oci_execute($stmt, OCI_DEFAULT)    // OCI_DEFAULT is required!!!
  or die ("Unable to execute query\n");

 */ {
	// Fetch the SELECTed row
	if (FALSE === ($row = oci_fetch_assoc($statement) )) {
		oci_rollback($connection);
		die("Unable to fetch row\n");
	}
	// Discard the existing LOB contents
	if (!$row[$fieldname]->truncate()) {
		oci_rollback($connection);
		die("Failed to truncate LOB\n");
	}
	// Now save a value to the LOB
	if (!$row[$fieldname]->save($value)) {
		// On error, rollback the transaction
		oci_rollback($connection);
	} else {
		// On success, commit the transaction
		oci_commit($connection);
	}
	// Free resources
	oci_free_statement($statement);
	$row[$fieldname]->free();
}

function ora_save_blob($connection, $statement, $fieldname, $value) {
// сохраняет значение в blob-поле и коммитит сессию
	// функция не реализована, поскольку имеется своя
	die('Не поддерживается!');
	// Работающий пример использования: сохраняем картинку в медиа - поле

	/*
	  $filename = 'image.jpg';
	  $doc_id = 1418100;

	  $picData = fread(fopen($filename, "rb"), filesize($filename));

	  $sql = "INSERT INTO DOCUMENTS_TREE (PARENT, DOC_NAME, DOC_DESCR, DOC_CONTENT, DOC_CONTENT_TYPE)
	  VALUES (".$doc_id.", '".$filename."', '".$filename."', EMPTY_BLOB(), pkg_values.GET_MEDIA_TYPE('".$filename."')) returning DOCUMENT_ID, DOC_CONTENT into :media_id, :lob_locator";

	  $stmt = oci_parse($conn, $sql);
	  $lob = oci_new_descriptor($conn, OCI_D_LOB);
	  oci_bind_by_name($stmt, ':lob_locator', &$lob, -1, OCI_B_BLOB);
	  oci_bind_by_name($stmt, ":media_id", $media_id, 64);
	  echo '<li> sql='.$sql;
	  if(OCIExecute($stmt, OCI_DEFAULT)==false) {
	  echo "
	  Не удалось вставить медиа-файл в систему
	  ";
	  } else {
	  $lob->save($picData);
	  echo '<li> media_id='.$media_id;
	  $sql = "pkg_values.COMPRESS_MEDIA_DOC(".$media_id.")";
	  echo '<li> compress_sql='.$sql;
	  ora_func($sql);
	  }
	  oci_commit($conn);
	 */
}

// Функция для пробразования массива ora_select в стандартный массив.
function ora_redim(&$ora_res, $idx = null) {

	$keys = array_keys($ora_res);
	$retVal = array();

	/*        if( !empty($idx) && in_array( $idx, $keys ) )
	  {

	  }
	  else
	  {
	  $idx = null;
	  }
	 */
	for ($i = 0, $j = count($ora_res[$keys[0]]); $i < $j; $i++) {
		/*            if( $idx )
		  {
		  $arr =& $retVal[$ora_res[$idx][$i]] = array();
		  }
		  else
		  { */
		$retVal[] = array();
//            }

		foreach ($keys as $v) {
			$retVal[$i][$v] = $ora_res[$v][$i];
			//$arr[$v] = $ora_res[$v][$i];
		}
	}

	return $retVal;
}

function ora_sid() {
	// Возвращает SID текущей сессии
	$res = ora_select('select sid from dual', 'sid', md5(uniqid()), '');
	//print_r($res);
	return $res[SID][0];
}

////////////////////////////////////////////////////////////////////////////////
// Раздел Функции Oracle - конец
////////////////////////////////////////////////////////////////////////////////
?>