<?php

//echo "SUPER";
// Версия 2.0 от 28-oct-2010
//**********************************************************************
// Данный файл содержит полный и достаточный набор функций для работы
// с имиджами на уровне СУБД
// Вс всех функциях при работе с файлами стоят заточки под Винду
// там где написано rb, wb надо менять на br, bw тогда будет работать под
// UNIX
//**********************************************************************

include "utilities.inc";

$IMAGE_TYPE_GIF = 3848;
$IMAGE_TYPE_JPEG = 4201;
$IMAGE_TYPE_PNG = 31545;

$image_types =
		array(
			$IMAGE_TYPE_GIF => "gif",
			$IMAGE_TYPE_JPEG => "jpeg",
			$IMAGE_TYPE_PNG => "png"
);

/*
  Функция возвращает по идентификатору имиджа его тип и размеры
  работает только с таблтицей IMAGES
 */

function get_image_inf($image_id) {
	global $conn;
	$stmt = OCIParse($conn, "SELECT IMAGE_INF FROM IMAGES WHERE ID = $image_id");
	OCIExecute($stmt);
	OCIFetch($stmt);
	$image_inf = OCIResult($stmt, "IMAGE_INF");
	OCIFreestatement($stmt);
	$image_inf_list = explode(" ", $image_inf);
	return $image_inf_list;
}

//------------------------------------------------
//  load_image_from_file - загружает файл по его
//  пути в стринг
//
function load_image_from_file($file_name) {
	$ret = NULL;
	if (!empty($file_name)) {
		//echo $file_name;
		@$fp = fopen($file_name, "rb");
		if ($fp) {
			$ret = fread($fp, filesize($file_name));
			fclose($fp);
		}
		unlink($file_name);
	}
	return $ret;
}

//
//------------------------------------------------
//------------------------------------------------
//  save_image_to_db - загружает файл из стринга
//  в СУБД, файло ложит в поляну FIELD, а описалово
//  в поляну FIELD_INF
//
function save_image_to_db($content, $table, $field, $id_field, $id, $width, $height, $type) {
	global $conn;
	$ret = 0;
	if (!empty($content) && !empty($table) && !empty($field) && !empty($id_field) && !empty($id) && !empty($width) && !empty($height) && !empty($type)) {
		//echo $content;
		$stmt = OCIParse($conn, "update $table set " . $field . "_INF='" . $width . " " . $height . " " . $type . "', $field=empty_blob() where $id_field=$id
		    returning $field into :image_blob");
		$lob = OCINewDescriptor($conn, OCI_D_LOB);
		//OCIBindByName($stmt, ":image_blob", &$lob, -1, OCI_B_BLOB);
		OCIBindByName($stmt, ":image_blob", $lob, -1, OCI_B_BLOB);
		OCIExecute($stmt, OCI_DEFAULT);
		if ($lob->save($content)) {
			OCICommit($conn);
			$ret = 1;
		}
		OCIFreeStatement($stmt);
		OCIFreeDesc($stmt);
	}
	return $ret;
}

//
//------------------------------------------------
//------------------------------------------------
//  save_image_to_db - загружает файл из стринга
//  в СУБД, файло ложит в поляну FIELD, а описалово
//  в поляну FIELD_INF
//
function save_unvisible_image_to_db($content, $table, $field, $id_field, $id, $width, $height, $type) {
	global $conn;
	$ret = 0;
	if (!empty($content) && !empty($table) && !empty($field) && !empty($id_field) && !empty($id) && !empty($width) && !empty($height) && !empty($type)) {
		$stmt = OCIParse($conn, "update $table set " . $field . "_INF='" . $width . " " . $height . " " . $type . "',
		    $field=empty_blob() where $id_field=$id and VISIBLE=-1
		    returning $field into :image_blob");
		$lob = OCINewDescriptor($conn, OCI_D_LOB);
		//OCIBindByName($stmt, ":image_blob", &$lob, -1, OCI_B_BLOB);
		OCIBindByName($stmt, ":image_blob", $lob, -1, OCI_B_BLOB);
		OCIExecute($stmt, OCI_DEFAULT);
		if ($lob->save($content)) {
			OCICommit($conn);
			$ret = 1;
		}
		OCIFreeStatement($stmt);
		OCIFreeDesc($stmt);
	}
	return $ret;
}

//
//------------------------------------------------
//------------------------------------------------
//  load_image_from_db - выгружает имидж из СУБД
//  таблица TABLE поляна FIELD, поляна с ключом
//  ID_FIELD, ключ ID
//
function load_image_from_db($table, $field, $id_field, $id) {
	global $conn;
	$ret = null;
	if (!empty($table) && !empty($field) && !empty($id_field) && !empty($id)) {
		$stmt = OCIParse($conn, "select $field from $table where $id_field=$id");
		OCIExecute($stmt);
		if (OCIFetch($stmt)) {
			$image = OCIResult($stmt, $field);
			$ret = $image->load();
		}
		OCIFreeStatement($stmt);
	}
	return $ret;
}

//
//------------------------------------------------
//------------------------------------------------
//  display_image - отображает имидж из СУБД по ID документа, реквизита и типа документа
//  таблица TABLE поляна FIELD, поляна с ключом
//  ID_FIELD, ключ ID. Также данная функция
//  ресайзит имидж в соответствии с OUTWIDTH и
//  OUTHEIGHT
//  $rgb=0xFFFFFF - цвет фона, по умолчанию белый
//
function display_image($doc_id, $docpropname, $dockindname, $outwidth = 0, $outheight = 0, $rgb = 0xFFFFFF) {
	// TODO: добавить буферизацию
	global $conn;
	global $image_types;

	if (!empty($doc_id) && !empty($docpropname) && !empty($dockindname)) {
		$sql = "SELECT COMPRESSOR.BLOB_DECOMPRESS(T.DOC_CONTENT) AS CONTENT, T.DOC_CONTENT_TYPE AS CONTENT_TYPE FROM DOCUMENTS_TREE T, DOC_PROPERTIES DP WHERE T.DOCUMENT_ID = DP.DOC_PROP_VALUE   AND DP.DOCPROP_ID = GET_DOCPROPID_BYNAME('$docpropname', '$dockindname') AND DP.DOCUMENT_ID = '$doc_id'";
		//echo $sql;
		$stmt = OCIParse($conn, $sql);
		OCIExecute($stmt);
		if (OCIFetch($stmt)) {
			$image = OCIResult($stmt, 'CONTENT');
			//$imageinf=OCIResult($stmt, 'CONTENT_TYPE');
			$type = OCIResult($stmt, 'CONTENT_TYPE');
			//echo $type;
			$content = $image->load();

			// получим размер картинки
			$res_image = imagecreatefromstring($content);
			$width = imagesx($res_image);
			$height = imagesy($res_image);

			//list($width, $height, $type)=explode(" ", $imageinf);
			$outwidth = intval($outwidth);
			$outheight = intval($outheight);

			if ($outwidth != $width and $outheight != $height) {
				$content = resize_image_center($content, $type, $outwidth, $outheight, $rgb);
			}
		}
		OCIFreeStatement($stmt);
		if (!empty($content) && !empty($type)) {
			header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");	// Date in the past
			header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // always modified
			header("Cache-Control: no-store, no-cache, must-revalidate");  // HTTP/1.1
			header("Cache-Control: post-check=0, pre-check=0", false);
			header("Pragma: no-cache");	 // HTTP/1.0
			header("Content-type: image/" . $image_types[$type]);
			print $content;
		}
	}
	return;
}

//
//------------------------------------------------
//------------------------------------------------
//  display_image_media - отображает имидж из СУБД ПО ID MEDIA-файла
//  таблица TABLE поляна FIELD, поляна с ключом
//  ID_FIELD, ключ ID. Также данная функция
//  ресайзит имидж в соответствии с OUTWIDTH и
//  OUTHEIGHT
//  $rgb=0xFFFFFF - цвет фона, по умолчанию белый
//
// старая реализация функции
function display_image_media_old($doc_id, $outwidth = 0, $outheight = 0, $rgb = 0xFFFFFF) {
	global $conn;
	global $image_types;

	if (!empty($doc_id)) {
		$sql = "SELECT COMPRESSOR.BLOB_DECOMPRESS(T.DOC_CONTENT) AS CONTENT, T.DOC_CONTENT_TYPE AS CONTENT_TYPE FROM DOCUMENTS_TREE T WHERE T.DOCUMENT_ID = '{$doc_id}'";
		//echo $sql;
		$stmt = OCIParse($conn, $sql);
		OCIExecute($stmt);
		if (OCIFetch($stmt)) {
			$image = OCIResult($stmt, 'CONTENT');
			//$imageinf=OCIResult($stmt, 'CONTENT_TYPE');
			$type = OCIResult($stmt, 'CONTENT_TYPE');
			//echo $type;
			$content = $image->load();

			/*
			  // for test purposes only
			  $content = 'iVBORw0KGgoAAAANSUhEUgAAABwAAAASCAMAAAB/2U7WAAAABl'
			  . 'BMVEUAAAD///+l2Z/dAAAASUlEQVR4XqWQUQoAIAxC2/0vXZDr'
			  . 'EX4IJTRkb7lobNUStXsB0jIXIAMSsQnWlsV+wULF4Avk9fLq2r'
			  . '8a5HSE35Q3eO2XP1A1wQkZSgETvDtKdQAAAABJRU5ErkJggg==';
			  $content = base64_decode($content);
			  $type = 31545;
			  //echo $image_types[$type];
			  // end test purposes
			 */


			// получим размер картинки
			$res_image = imagecreatefromstring($content);
			$width = imagesx($res_image);
			$height = imagesy($res_image);

			//list($width, $height, $type)=explode(" ", $imageinf);
			$outwidth = intval($outwidth);
			$outheight = intval($outheight);

			if ($outwidth != $width and $outheight != $height) {
				//$content=resize_image3($content, $type, $outwidth, $outheight, $rgb);
			}
		}
		OCIFreeStatement($stmt);
		if (!empty($content) && !empty($type)) {
			header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");	// Date in the past
			header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // always modified
			header("Cache-Control: no-store, no-cache, must-revalidate");  // HTTP/1.1
			header("Cache-Control: post-check=0, pre-check=0", false);
			header("Pragma: no-cache");	 // HTTP/1.0
			header("Content-type: image/" . $image_types[$type]);
//			header("Content-type: text/html");
			//echo 123;
			print $content;
		}
	}
	return;
}

function display_image_media($doc_id, $outwidth = 0, $outheight = 0, $rgb = 0xFFFFFF, $type = "") {
	if (!empty($doc_id)) {
		$sql = "SELECT COMPRESSOR.BLOB_DECOMPRESS(T.DOC_CONTENT) AS CONTENT, T.DOC_NAME AS FILENAME, T.DOC_CONTENT_TYPE AS CONTENT_TYPE FROM DOCUMENTS_TREE T WHERE T.DOCUMENT_ID = '$doc_id'";

		$result = ora_select_clob($sql);

		if (count($result) > 0) {
			$content = base64_decode($result[0]["CONTENT"]);
			$type = $result[0]["CONTENT_TYPE"];
			$filename = $result[0]["FILENAME"];

			if (strpos(strtolower($filename), '.gif') > 0)
				$filetype = 'gif';
			if (strpos(strtolower($filename), '.jpg') > 0)
				$filetype = 'jpeg';
			if (strpos(strtolower($filename), '.jpeg') > 0)
				$filetype = 'jpeg';
			if (strpos(strtolower($filename), '.png') > 0)
				$filetype = 'png';
		}

		if (!empty($content) && !empty($type)) {
			header("Expires: Mon, 26 Jul 2009 05:00:00 GMT");	// Date in the past
			header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // always modified
			header("Cache-Control: no-store, no-cache, must-revalidate");  // HTTP/1.1
			header("Cache-Control: post-check=0, pre-check=0", false);
			header("Pragma: no-cache");	 // HTTP/1.0
			header("Content-type: image/" . $filetype);

			print $content;
		}

		/*
		  $stmt=OCIParse($conn,$sql);
		  OCIExecute($stmt);
		  if(OCIFetch($stmt)) {
		  $image=OCIResult($stmt, 'CONTENT');
		  $type = OCIResult($stmt, 'CONTENT_TYPE');
		  $filename = OCIResult($stmt, 'FILENAME');
		  if (strpos(strtolower($filename), '.gif') > 0) $filetype = 'gif';
		  if (strpos(strtolower($filename), '.jpg') > 0) $filetype = 'jpeg';
		  if (strpos(strtolower($filename), '.jpeg') > 0) $filetype = 'jpeg';
		  if (strpos(strtolower($filename), '.png') > 0) $filetype = 'png';
		  print_r($image);
		  exit;
		  $content=$image->load();
		  // получим размер картинки

		  $res_image = imagecreatefromstring($content);
		  $width = imagesx($res_image);
		  $height = imagesy($res_image);
		  //list($width, $height, $type)=explode(" ", $imageinf);
		  $outwidth=intval($outwidth);
		  $outheight=intval($outheight);

		  if($outwidth!=$width and $outheight!=$height) {
		  //$content=resize_image3($content, $type, $outwidth, $outheight, $rgb);
		  }
		  }

		  OCIFreeStatement($stmt);
		  if(!empty($content) && !empty($type)) {
		  header("Expires: Mon, 26 Jul 2009 05:00:00 GMT");    // Date in the past
		  header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // always modified
		  header("Cache-Control: no-store, no-cache, must-revalidate");  // HTTP/1.1
		  header("Cache-Control: post-check=0, pre-check=0", false);
		  header("Pragma: no-cache");			  // HTTP/1.0
		  header("Content-type: image/".$filetype);
		  print $content;
		  }
		 */
	} else {
		$filetype = "png";
		switch ($type) {
			case "rent":
				$image_name = "no_photo3.png";
				break;
			case "contact":
				$image_name = "no_photo_user.png";
				break;
			default:
				$image_name = "no_photo2.png";
		}

		$content = file_get_contents($_SERVER["DOCUMENT_ROOT"] . "/images/" . $image_name);

		header("Expires: Mon, 26 Jul 2009 05:00:00 GMT");	// Date in the past
		header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // always modified
		header("Cache-Control: no-store, no-cache, must-revalidate");  // HTTP/1.1
		header("Cache-Control: post-check=0, pre-check=0", false);
		header("Pragma: no-cache");	 // HTTP/1.0
		header("Content-type: image/" . $filetype);

		print $content;
	}
}

//
//------------------------------------------------
//------------------------------------------------
//  display_visible_image - отображает имидж из СУБД
//  таблица TABLE поляна FIELD, поляна с ключом
//  ID_FIELD, ключ ID. Также данная функция
//  ресайзит имидж в соответствии с OUTWIDTH и
//  OUTHEIGHT
//
function display_visible_image($table, $field, $id_field, $id, $visible, $outwidth = 0, $outheight = 0) {
	global $conn;
	global $image_types;
	if (!empty($table) && !empty($field) && !empty($id_field) && !empty($id)) {
		$stmt = OCIParse($conn, "select * from $table where $id_field=$id and VISIBLE=$visible");
		OCIExecute($stmt);
		if (OCIFetch($stmt)) {
			$image = OCIResult($stmt, $field);
			$imageinf = OCIResult($stmt, $field . "_INF");
			$content = $image->load();
			list($width, $height, $type) = explode(" ", $imageinf);
			$outwidth = intval($outwidth);
			$outheight = intval($outheight);
			if ($outwidth > 0 && $outheight > 0 && ($outwidth != $width || $outheight != $height)) {
				$content = resize_image($content, $outwidth, $outheight);
			}
		}
		OCIFreeStatement($stmt);
		if (!empty($content) && ($type == 1 || $type == 2)) {
			header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");	// Date in the past
			header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // always modified
			header("Cache-Control: no-store, no-cache, must-revalidate");  // HTTP/1.1
			header("Cache-Control: post-check=0, pre-check=0", false);
			header("Pragma: no-cache");	 // HTTP/1.0
			Header("Content-type: image/" . $image_types[$type]);
			print $content;
		}
	}
	return;
}

//
//------------------------------------------------
//------------------------------------------------
//  resize_image - ресайзит имидж в соответствии с
//  OUTWIDTH и OUTHEIGHT
//
function resize_image($content, $width, $height) {
	$width = intval($width);
	$height = intval($height);
	if (!empty($content) && $width > 0 && $height > 0) {
		$file_name = tempnam("../temp", "TMPIMAGE-");
		//$file_name = "a1.jpg";
		if (save_image_to_file($content, $file_name)) {
			$sim = ImageCreateFromJPEG($file_name);
			if ($sim) {
				$sw = imagesx($sim);
				$sh = imagesy($sim);
				$dw = $width;
				$dh = $height;
				$dim = ImageCreate($dw, $dh);
				$bgcolor = ImageColorAllocate($dim, 255, 255, 255);
				ImageFilledRectangle($dim, 0, 0, $dw, $dh, $bgcolor);
				ImageCopyResized($dim, $sim, 0, 0, 0, 0, $dw, $dh, $sw, $sh);
				ImageJPEG($dim, $file_name);
				$content = load_image_from_file($file_name);
				ImageDestroy($dim);
			}
			//unlink($file_name);
		}
	}
	return $content;
}

//
//------------------------------------------------

/* * *********************************************************************************
  Функция resize_image_files(): масштабирование изображения, на вход 2 файла и параметры
  РАБОТАЕТ С СОХРАНЕНИЕМ ПРОПОРЦИЙ, В ОТЛИЧИЕ ОТ resize_image()
  Параметры:
  $src	     - имя исходного файла
  $dest	    - имя генерируемого файла
  $width, $height  - ширина и высота генерируемого изображения, в пикселях
  Необязательные параметры:
  $rgb	     - цвет фона, по умолчанию - белый
  $quality	 - качество генерируемого JPEG, по умолчанию - максимальное (100)
 * ********************************************************************************* */
function resize_image_files($src, $dest, $width, $height, $rgb = 0xFFFFFF, $quality = 100) {
	if (!file_exists($src))
		return false;

	$size = getimagesize($src);

	if ($size === false)
		return false;

	// Определяем исходный формат по MIME-информации, предоставленной
	// функцией getimagesize, и выбираем соответствующую формату
	// imagecreatefrom-функцию.
	$format = strtolower(substr($size['mime'], strpos($size['mime'], '/') + 1));
	$icfunc = "imagecreatefrom" . $format;
	if (!function_exists($icfunc))
		return false;

	$x_ratio = $width / $size[0];
	$y_ratio = $height / $size[1];

	$ratio = min($x_ratio, $y_ratio);
	$use_x_ratio = ($x_ratio == $ratio);

	$new_width = $use_x_ratio ? $width : floor($size[0] * $ratio);
	$new_height = !$use_x_ratio ? $height : floor($size[1] * $ratio);
	$new_left = $use_x_ratio ? 0 : floor(($width - $new_width) / 2);
	$new_top = !$use_x_ratio ? 0 : floor(($height - $new_height) / 2);

	$isrc = $icfunc($src);
	$idest = imagecreatetruecolor($width, $height);

	imagefill($idest, 0, 0, $rgb);
	imagecopyresampled($idest, $isrc, $new_left, $new_top, 0, 0, $new_width, $new_height, $size[0], $size[1]);

	imagejpeg($idest, $dest, $quality);

	imagedestroy($isrc);
	imagedestroy($idest);

	return true;
}

//------------------------------------------------
//  resize_image - ресайзит имидж в соответствии с
//  OUTWIDTH и OUTHEIGHT
//  РАБОТАЕТ С СОХРАНЕНИЕМ ПРОПОРЦИЙ, В ОТЛИЧИЕ ОТ resize_image()
//  $rgb	     - цвет фона, по умолчанию - белый

function resize_image2($content, $width, $height, $rgb = 0xFFFFFF) {
	echo $width . " " . $height;
	$width = intval($width);
	$height = intval($height);
	if (!empty($content) && $width > 0 && $height > 0) {
		//$file_name = tempnam("../temp", "TMPIMAGE-");
		$file_name = tempnam("../temp", "TMPIMAGE-");
		//echo "<br>".$file_name."<br>";
		//$file_name = "a1.jpg";
		if (save_image_to_file($content, $file_name)) {
			resize_image_files($file_name, $file_name, $width, $height, $rgb);
			$content = load_image_from_file($file_name);

			//unlink($file_name);
		}
	}
	return $content;
}

//	$image_type    1 = gif,    2 = jpeg
function resize_image3($content, $image_type, $width, $height, $rgb = 0xFFFFFF) {
	global $IMAGE_TYPE_GIF;

	$width = intval($width);
	$height = intval($height);
	if (!empty($content) && $width > 0 && $height > 0) {
		$file_name = tempnam("../temp", "TMPIMAGE-");
		//$file_name = "a1.jpg";
		if (save_image_to_file($content, $file_name)) {
			if ($image_type == $IMAGE_TYPE_GIF) {
				$sim = ImageCreateFromGIF($file_name);
			} else {
				$sim = ImageCreateFromJPEG($file_name);
			};

			if ($sim) {
				// размер реального изображения
				$sw = imagesx($sim);
				$sh = imagesy($sim);

				// ВНИМАНИЕ!!! Здесь идет отключение масштабирования на увеличение,
				// если реальное изображение по высоте меньше, чем требуемое.
				// НАДО ОТКЛЮЧТИЬ ЭТУ КНОСТРУКЦИЮ, ЕСЛИ ТРЕБУЕТСЯ ПРОИЗВОДИТЬ ПРОСТОЕ МАСШТАБИРОВАНИЕ.
				if ($sh < $height) {
					$height = $sh;
				};

				$x_ratio = $width / $sw;
				$y_ratio = $height / $sh;

				$ratio = min($x_ratio, $y_ratio);
				$use_x_ratio = ($x_ratio == $ratio);

				$new_width = $use_x_ratio ? $width : floor($sw * $ratio);
				$new_height = !$use_x_ratio ? $height : floor($sh * $ratio);
				$new_left = $use_x_ratio ? 0 : floor(($width - $new_width) / 2);
				$new_top = !$use_x_ratio ? 0 : floor(($height - $new_height) / 2);

				// ВНИМАНИЕ!!! Здесь идет отключение увеличения высоты изображения.
				// если после масштабирования оказалось, что высота меньше, чем требуемая.
				// НАДО ОТКЛЮЧТИЬ ЭТУ КНОСТРУКЦИЮ, ЕСЛИ ТРЕБУЕТСЯ ПРОИЗВОДИТЬ ПРОСТОЕ МАСШТАБИРОВАНИЕ.
				if ($use_x_ratio) {
					if ($new_height < $height) {
						$new_top = 0;
						$height = $new_height;
					}
				};


				$dw = $width;
				$dh = $height;

				$dim = ImageCreatetruecolor($dw, $dh);

				imagefill($dim, 0, 0, $rgb);
				ImageCopyResized($dim, $sim, $new_left, $new_top, 0, 0, $new_width, $new_height, $sw, $sh);
				ImageJPEG($dim, $file_name);
				$content = load_image_from_file($file_name);
				ImageDestroy($dim);
			}
		}
	}
	return $content;
}

//	$image_type    1 = gif,    2 = jpeg
function resize_image_center($content, $image_type, $width, $height, $rgb = 0xFFFFFF) {
	global $IMAGE_TYPE_GIF;

	$width = intval($width);
	$height = intval($height);
	if (!empty($content) && $width > 0 && $height > 0) {
		$file_name = tempnam("../temp", "TMPIMAGE-");
		//$file_name = "a1.jpg";
		if (save_image_to_file($content, $file_name)) {
			//echo  $file_name;
			if ($image_type == $IMAGE_TYPE_GIF) {
				$sim = ImageCreateFromGIF($file_name);
			} else {
				//phpinfo();
				$sim = ImageCreateFromJPEG($file_name);
			}

			if ($sim) {
				// размер реального изображения
				$sw = imagesx($sim);
				$sh = imagesy($sim);

				$x_ratio = $width / $sw;
				$y_ratio = $height / $sh;

				$ratio = $y_ratio;  //min($x_ratio, $y_ratio);

				$sneww = round($width / $ratio);
				$sneww = $sneww > $sw ? $sw : $sneww;

				$snewleft = round(($sw - $sneww) / 2);
				$snewleft = $snewleft < 0 ? 0 : $snewleft;

				$dim = imagecreatetruecolor($width, $height);

				imagefill($dim, 0, 0, $rgb);
				//ImageCopyResized($dim, $sim, $new_left, $new_top, 0, 0, $new_width, $new_height, $sw, $sh);
				imagecopyresampled($dim, $sim, 0, 0, $snewleft, 0, $width, $height, $sneww, $sh);
				ImageJPEG($dim, $file_name);
				$content = load_image_from_file($file_name);
				ImageDestroy($dim);
				ImageDestroy($sim);
			} else {
				/* See if it failed */
				$sim = imagecreate($width, $height); /* Create a blank image */
				$bgc = imagecolorallocate($sim, 255, 255, 255);
				$tc = imagecolorallocate($sim, 0, 0, 0);
				imagefilledrectangle($sim, 0, 0, 150, 30, $bgc);
				/* Output an errmsg */
				imagestring($sim, 1, 2, $height / 2, "Error loading image", $tc);
				ImageJPEG($sim, $file_name);
				$content = load_image_from_file($file_name);
				ImageDestroy($sim);
			}
		}
	}
	return $content;
}

function img_resize($src, $dest, $width, $height, $rgb = 0xFFFFFF, $quality = 100) {
	if (!file_exists($src))
		return false;

	$size = getimagesize($src);

	if ($size === false)
		return false;

	// Определяем исходный формат по MIME-информации, предоставленной
	// функцией getimagesize, и выбираем соответствующую формату
	// imagecreatefrom-функцию.
	//rem $format = strtolower(substr($size['mime'], strpos($size['mime'], '/')+1));
	$icfunc = "imagecreatefromjpeg" . $format;
	//if (!function_exists($icfunc)) return false;

	$x_ratio = $width / $size[0];
	$y_ratio = $height / $size[1];

	$ratio = min($x_ratio, $y_ratio);
	$use_x_ratio = ($x_ratio == $ratio);

	$new_width = $use_x_ratio ? $width : floor($size[0] * $ratio);
	$new_height = !$use_x_ratio ? $height : floor($size[1] * $ratio);
	$new_left = $use_x_ratio ? 0 : floor(($width - $new_width) / 2);
	$new_top = !$use_x_ratio ? 0 : floor(($height - $new_height) / 2);

	$isrc = $icfunc($src);
	$idest = imagecreatetruecolor($width, $height);

	imagefill($idest, 0, 0, $rgb);
	imagecopyresampled($idest, $isrc, $new_left, $new_top, 0, 0, $new_width, $new_height, $size[0], $size[1]);

	imagejpeg($idest, $dest, $quality);

	imagedestroy($isrc);
	imagedestroy($idest);

	return true;
}

//
//------------------------------------------------
//------------------------------------------------
//  filetype2imagetype - устанавливает тип имиджа
//  в соответствии с расширением файла
//
function filetype2imagetype($filetype) {
	global $image_types;
	$ret = 0;
	reset($image_types);
	while (list($key, $val) = each($image_types)) {
		if (strstr($filetype, $val)) {
			$ret = $key;
			break;
		}
	}
	return $ret;
}

//
//------------------------------------------------
//------------------------------------------------
//  save_image_to_file - сохраняет имидж из строки
//  в файл
//
function save_image_to_file($content, $file_name) {
	$ret = 0;
	if (!empty($file_name)) {
		@$fd = fopen($file_name, "wb");
		if ($fd) {
			$ret = fwrite($fd, $content, strlen($content));
			fclose($fd);
		}
	}
	return $ret;
}

//
//------------------------------------------------

/*
  //------------------------------------------------
  //  delete_image_from_db - убивает имидж из СУБД
  //  Это какая-то бредовая функция - короче срань не работающая
  function delete_image_from_db($table, $field, $id_field, $id)
  {
  global $conn;
  $ret=0;
  if(!empty($table) && !empty($field) && !empty($id_field) && !empty($id))
  {
  $lob=OCINewDescriptor($conn, OCI_D_LOB);
  $stmt=OCIParse($conn, "select $field from $table where $id_field=$id");
  OCIDefineByName($stmt, $field, &$lob);
  OCIExecute($stmt, OCI_DEFAULT);
  if(OCIFetch($stmt))
  {
  $update=OCIParse($conn, "update $table set ".$field."_INF='' where ID=$id");
  OCIExecute($update, OCI_DEFAULT);
  if($lob->free())
  {
  OCICommit($conn);
  $ret=1;
  }
  OCIFreeStatement($update);
  }
  OCIFreeDesc($lob);
  OCIFreeStatement($stmt);
  }
  return $ret;
  }
  //
  //------------------------------------------------
 */

function delete_image_from_db($table, $field, $id_field, $id) {
	global $conn;
	$ret = 0;
	if (!empty($table) && !empty($field) && !empty($id_field) && !empty($id)) {
		$stmt = OCIParse($conn, "update $table set $field = empty_blob()," . $field . "_INF='' where $id_field=$id");
		OCIExecute($stmt, OCI_DEFAULT);
		OCICommit($conn);
		$ret = 1;
	}
	return $ret;
}

?>