<?php

/*
	SimpleProperty
	Класс позволяющий работать с реквизитами класса simpleDocument
	(c) 2010, Kraynov Ilya, ilya.kraynov@gmail.com
	Версия 1 (13 ноября 2010 года)


	Объект класса создаётся автоматически из объекта simpleDocument.
	В конструктор передаётся сам объект simpleDocument, id реквизита, а так же ссылки на массивы props, vals и refs
	Конструктором для вызова извне является статическая функция getInstance(). Она обесечивает уникальность объекта
	для объекта simpleDocument (реализован патерн одиночка).

	Публичные методы:
		get_value()
		get_values()
		get_ref()
		get_refs()

		isRef()
		isMulti()

		document(), get_parent()
		get_dump()
		get_instance_id()
		get_values_count()

		get_*() - методы позваляющие обратиться к свойствам реквизита по их имени. Например:
			str = $someSimpleDocument->get_property('someProperty')->get_dOcPrOP_KiNd()


	Публичные методы (сокращения):
		get_display()
		get_v()
		get_vmulti()

*/

/**
 * @todo Сделать для каждого типа отдельный файл плагин с набор спецефичных функций.
 *
*/
define('SIMPLEPROPERTY_DEBUG', 0);

class SimpleProperty
{
    protected $doc; //текущий SimpleDocument
    protected $prop_name; //системное имя св-ва
    protected $prop_id; //системный ID св-ва
    protected $props; //характеристики всех свойств SimpleDocument
    protected $vals; //значения текущего св-ва
    protected $refs; //ссылочные значения текущего св-ва
    protected $prop_idx = NULL; //номер св-ва в массиве $props
    protected $vals_idx=array();
    protected $refs_idx=array();
    protected $prop_type=null;
    private static $m_pInstances=array();
    private $instance_id = null;

    private function __construct($simple_doc, $prop_id, &$props, &$vals, &$refs)
    {
        $this->prop_id = $prop_id;
        $this->prop_idx = $simple_doc->getPropIdxById($prop_id);
        $this->doc = $simple_doc;
        $this->props = &$props;
        $this->vals = &$vals;
        $this->refs = &$refs;
        $this->instance_id = crc32("{$this->doc->document_id}-{$prop_name}");
	if (preg_match('/^[\w\_]+\-REF\-[\w\_]+/', $this->get_DOCPROP_DESCR())){
            $this->prop_type = 'refs';
            $this->refs_idx = $this->get_refs_idx();
	} else {
            $this->prop_type = 'vals';
            $this->vals_idx = $this->get_values_idx();
            if ($this->isMulti()) {
                $this->_makemultifromdisplay(); // - заглушка
            }

	}
    }



/*
* Функция которую необходимо вызывать вместо конструктора. Обеспечивает паттерн одиночка.
* Для определённого свойства определенного объекта караби - один пхп объект.
*
*
*
*/
    public static function getInstance($simple_doc,
				       $prop_id,
				       &$props,
				       &$vals,
				       &$refs)
    {
        if (!$simple_doc instanceof simpleDocument) {
            throw new ErrorException('simpleDocument is not defined');
        }
		if (SIMPLEPROPERTY_DEBUG) {
			if (!(is_numeric($prop_id) && is_int((int)$prop_id)) || empty($prop_id)) {
				throw new ErrorException('Wrong property Id');
			}
		}
        $sign = crc32("{$simple_doc->document_id}-{$prop_id}");
	if (!array_key_exists($sign, self::$m_pInstances)
	    || !self::$m_pInstances[$sign]
	) {
            self::$m_pInstances[$sign] = new SimpleProperty($simple_doc,
							    $prop_id,
							    $props,
							    $vals,
							    $refs);
        }

        return self::$m_pInstances[$sign];
    }

    /**
     * Функция выдаёт массив индексов значений для этого свойства. Либо пустой
     * массив, если свойств нет.
     *
    */
    protected function get_values_idx()
    {
        $prop_id = $this->props['DOCPROP_ID'][$this->prop_idx];
        $retVal = array();
        for ($i=0, $j=count($this->vals['DOCPROP_ID']); $i<$j; $i++) {
            if ($this->vals['DOCPROP_ID'][$i] == $prop_id) {
				
                if (empty($this->vals['V0'][$i])
                    && empty($this->vals['V1'][$i])
                    && empty($this->vals['V2'][$i])
                ) {
                    continue;
                }
                $retVal[] = $i;
            }
        }
        return $retVal;
    }

    /**
     * Функция выдаёт массив индексов значений для этого свойства. Либо пустой
     * массив, если свойств нет.
     *
    */
    protected function get_refs_idx()
    {
        $prop_id = $this->props['DOCPROP_ID'][$this->prop_idx];
        $retVal = array();
        for ($i=0, $j=count($this->refs['DOCPROPSOURCE_ID']); $i<$j; $i++) {
            if ($this->refs['DOCPROPSOURCE_ID'][$i] == $this->prop_id) {
                $retVal[] = $i;
            }
        }
        return $retVal;
    }

    /**
     * Функция возвращает количество значений для данного свойства
     *
    */
    public function get_values_count()
    {
        switch ($this->prop_type) {
            case 'vals':
                return count($this->vals_idx);
            break;

            case 'refs':
                return count($this->refs_idx);
            break;
        }
    }

    /**
     * Функция возвращает количество значений для данного свойства
     *
    */
    public function get_refs_count()
    {
	return $this->get_values_count();
    }

    /**
     * Функция возвращает значение для данного свойства.
     * $val_type = V0 | V1 | V2 | DISPLAY | V_CLOB
     * $val_num = номер значения
     * TODO выбрать тип реализации для значения: Либо возвращать конкретное
     * значение, либо объект класса cSimpleValue
     *
    */
    public function get_value($val_type='V0', $val_num = 0)
    {
        return $this->vals[$val_type][$this->vals_idx[$val_num]];
    }

    /**
     * Функция возвращает значениЯ для данного свойства.
     * $val_type = V0 | V1 | V2 | DISPLAY
     *
     * TODO выбрать тип реализации для значения: Либо возвращать конкретное
     * значение, либо объект класса cSimpleValue
     *
    */
    public function get_values($val_type='V0')
    {
        $retVal = array();
        foreach ($this->vals_idx as $val_idx) {
            //if ($this->vals[$val_type][$val_idx])
                $retVal []= $this->vals[$val_type][$val_idx];
        }
        return $retVal;
    }


// SHORTs

	public function get_display()
	{
		if (!$this->isRef()) {// для всех полей кроме ссылок
			if ($this->get_docprop_object() == 4 && $this->get_docprop_kind() == 1) {
				// Текстовые поля. Раньше проверяли заполненность поля V_CLOB.
				// Теперь этого делать нельзя, так как оно заполнено во всех случаях...
				// Flint: added 01-06-2012
				// снова проверяем по заполненности V_CLOB
				$clob = $this->get_value('V_CLOB');
				if (empty($clob)) {
					return $this->get_value('V0');
				} else {
					return $clob;
				}
			}
			return $this->get_value('DISPLAY');
		} else {
			// для ссылок
			return $this->get_ref_display();
		}
	}

    public function get_v($v=0)
    {
        return $this->get_value("V{$v}");
    }

    public function get_vmulti()
    {
        return $this->get_values();
    }



/*
* Функция возвращает значение для данной ссылки.
* $val_num = номер ссылки
*
* TODO коструктор заменить на getInstance
*
*/
    public function get_ref($ref_num = 0)
    {
	$ref = explode('-',
		       $this->props['DOCPROP_DESCR'][$this->prop_idx],
		       3);
	$newSDoc = new SimpleDocument(
	    $this->refs['DOCTARGET_ID'][$this->refs_idx[$ref_num]],
	    $ref[2]
	);
	$newSDoc->set_parentDocument($this->document());
	$newSDoc->set_parentProperty($this, $ref_num);
	return $newSDoc;
    }

    public function get_ref_display($ref_num = 0)
    {
        return $this->refs['DOC_NAME'][$this->refs_idx[$ref_num]];
    }

    public function get_ref_target_id($ref_num = 0)
    {
	return (int)$this->refs['DOCTARGET_ID'][$this->refs_idx[$ref_num]];
    }


    public function get_refs()
    {
        // TODO может возвращать doctargetid ?
        $retVal = array();
        $ref_keys = array_keys($this->refs);
        foreach ($this->refs_idx as $ref_idx) {
            $arr = array();
            foreach ($ref_keys as $key) {
                $arr[$key] = $this->refs[$key][$ref_idx];
            }
            $retVal []= $arr;
        }
        return $retVal;
    }

    public function __call($n1, $v)
    {
        $n = explode('_', $n1, 2);
        if (count($n) < 2) {
            throw new Exception('No such method: '+$n1);
            return false;
        }
        switch ($n[0]) {
            case "get":
				if (isset($this->props)) {
					if (array_key_exists(strtoupper($n[1]), $this->props)) {
						return $this->props[strtoupper($n[1])][$this->prop_idx];
					} else {
						throw new ErrorException(__CLASS__."->{$n1}() - method not exists.");
					}
				} else {
					throw new Exception('Properties is null');
				}
				break;
            default:
                //return false;
				throw new Exception('No such method: '+$n1);
		}
    }

    public function get_parent()
    {
        return $this->doc;
    }
    public function document()
    {
        return $this->doc;
    }

    public function get_instance_id()
    {
        return $this->instance_id;
    }

    public function get_proptype()
    {
        return $this->prop_type;
    }

    public function isRef()
    {
        return ($this->prop_type=='refs' ? true : false);
    }

    public function isMulti()
    {
        return $this->props['DOCPROP_MULTI'][$this->prop_idx];
    }
	
	/**
	 * @return boolean текущий пользователь имеет права на запись в это поле
	 */
	public function isWriteable() {
		return (boolean) $this->props['IS_WRITEBLE'][$this->prop_idx];
	}

    /**
     * [Для ссылочного поля] Определяет можно ли создовать объекты
     *
    */
    public function isRefCreate(){
	// is ref check
	return ($this->get_docprop_sql()==1 || $this->get_docprop_sql()==11);
    }

    /**
     * [Для ссылочного поля] Определяет можно ли создовать ссылки на объекты
     *
    */
    public function isRefLink(){
	// is ref check
	return ($this->get_docprop_sql()==10 || $this->get_docprop_sql()==11);
    }



    public function get_dump()
    {
        $keys = array_keys($this->props);
        $retVal = array();
        foreach ($keys as $key) {
            $retVal[$key] = $this->props[$key][$this->prop_idx];
	}
        $retVal['values'] = array();
        $val_keys = array_keys($this->vals);
        foreach ($this->vals_idx as $val_idx) {
            $arr = array();
            foreach ($val_keys as $key) {
                $arr[$key] = $this->vals[$key][$val_idx];
            }
            $retVal['values'] []= $arr;
        }
        $retVal['refs'] = array();
        $ref_keys = array_keys($this->refs);
        foreach ($this->refs_idx as $ref_idx) {
            $arr = array();
            foreach ($ref_keys as $key) {
                $arr[$key] = $this->refs[$key][$ref_idx];
            }
            $retVal['refs'] []= $arr;
        }
	$retVal['prop_type'] = $this->prop_type;
        return $retVal;
    }



/*
	Функция заглушка, в текущей версии из базы прилетает для мульти значений
	в каждом DISPLAY будет записано
	    muli1; multi2; multi3
	Эта функция рабивает эту строку на состовляющие и для каждого DISPALY
	назначает соответствующее значение.
Пример:
    До:
	values = array(
	    [0] => array(
		'V0' => 'value fot V0',
		'V1' => 'value fot V1',
		'V2' => 'value fot V2',
		'DISPLAY' => 'display value 0; display value 1; display value 2',
	    ),
	    [1] => array(
		'V0' => 'value fot V0',
		'V1' => 'value fot V1',
		'V2' => 'value fot V2',
		'DISPLAY' => 'display value 0; display value 1; display value 2',
	    ),
	    [2] => array(
		'V0' => 'value fot V0',
		'V1' => 'value fot V1',
		'V2' => 'value fot V2',
		'DISPLAY' => 'display value 0; display value 1; display value 2',
	    ),
	);

    После:
	values = array(
	    [0] => array(
		'V0' => 'value fot V0',
		'V1' => 'value fot V1',
		'V2' => 'value fot V2',
		'DISPLAY' => 'display value 0',
	    ),
	    [1] => array(
		'V0' => 'value fot V0',
		'V1' => 'value fot V1',
		'V2' => 'value fot V2',
		'DISPLAY' => 'display value 1',
	    ),
	    [2] => array(
		'V0' => 'value fot V0',
		'V1' => 'value fot V1',
		'V2' => 'value fot V2',
		'DISPLAY' => 'display value 2',
	    ),
	);

*/
    protected function _makemultifromdisplay()
    {
        $vals = explode(';', $this->vals['DISPLAY'][$this->vals_idx[0]]);
        for ($i=0, $j=count($this->vals_idx); $i<$j; $i++) {
            $this->vals['DISPLAY'][$this->vals_idx[$i]] = trim($vals[$i]);
        }
    }

// Примеры:
//    [refs] => Array(
//	[0] => Array(
//	    [DOCSOURCE_ID] => 1340790
//	    [DOCPROPSOURCE_ID] => 14332
//	    [DOCTARGET_ID] => 1041133
//	    [DOC_NAME] => Бизнес/ Квартиры и комнаты
//	    [DOC_KIND_ID] => 30298
//	)
//    )
//    
//    [values] => Array(
//	[0] => Array(
//	    [DOCPROP_ID] => 15349
//	    [PLURAL] => 0
//	    [V0] => 1
//	    [V1] =>
//	    [V2] =>
//	    [DISPLAY] => RENT.RU
//	    [V_CLOB] =>
//	)
//    )
// Физический массив values:
// Array(
//    [DOCPROP_ID] => Array
//        (
//            [0] => 14360
//            [n] => 15348
//        )
//
//    [PLURAL] => Array
//        (
//            [0] => 0
//            [n] => 0
//        )
//
//    [V0] => Array
//        (
//            [0] => 1
//            [n] => 1
//        )
//
//    [V1] => Array
//        (
//            [0] => 
//            [n] => 
//        )
//
//    [V2] => Array
//        (
//            [0] => 
//            [n] => 
//        )
//
//    [DISPLAY] => Array
//        (
//            [0] => Аренда
//            [n] => Каталог
//        )
//
//    [V_CLOB] => Array
//        (
//            [0] => 
//            [n] => 
//        )
// )
// Физический массив refs:
//Array(
//    [DOCSOURCE_ID] => Array
//        (
//            [6] => 1340790
//            [7] => 1340790
//            [8] => 1340790
//        )
//
//    [DOCPROPSOURCE_ID] => Array
//        (
//            [6] => 14381
//            [7] => 14568
//            [8] => 14568
//        )
//
//    [DOCTARGET_ID] => Array
//        (
//            [6] => 1340731
//            [7] => 1340736
//            [8] => 1340740
//        )
//
//    [DOC_NAME] => Array
//        (
//            [6] => Компания "СТН"/ Прямой владелец
//            [7] => 1/ Спальня
//            [8] => 2/ Кухня
//        )
//
//    [DOC_KIND_ID] => Array
//        (
//            [6] => 30328
//            [7] => 30591
//            [8] => 30591
//        )
//)

    /**
     * 
     *
    */
    public function addRef($docTargetId)
    {
	if (!$this->isRef())
	    return false;
	
	$this->refs['DOCSOURCE_ID'] []= $this->document()->document_id;
	$this->refs['DOCPROPSOURCE_ID'] []= $this->get_docprop_id();
	$this->refs['DOCTARGET_ID'] []= $docTargetId;
	$this->refs['DOC_NAME'] []= '';
	$this->refs['DOC_KIND_ID'] []= '';
	$this->refs['FLAGS'][(count($this->refs['DOCTARGET_ID'])-1)] = 'NEW';
	$this->refs_idx = $this->get_refs_idx();
    }
    
    public function deleteRef($ref_idx=0)
    {
	if (!$this->isRef())
	    return false;
	
	$this->refs['FLAGS'][$this->refs_idx[$ref_idx]] = "TODELETE";
	
    }
    
    /**
     * Добавляет или изменяет значение свойства.
     *
     *
    */    
    public function setValue(array $values, $val_idx=null)
    {
		if ($this->isRef())
			return false;
		
		if (($val_idx===false || is_null($val_idx)) && !$this->isMulti()) {
			$val_idx = 0;
		} else {
			$val_idx = (int)$val_idx;
			if ($val_idx>0 && !$this->isMulti()) {
			$val_idx = 0;
			// или return false; ?
			}
		}
		
		if (!array_key_exists($val_idx, $this->vals_idx)) {
			$this->addValue($values);
		}
		
		$values = array_change_key_case($values, CASE_UPPER);
		if ($val_idx) { // multi
			// TODO
		} else {
			//echo '<li>', '1';
			if (!$this->compare($values)) {
				//echo '2';
				$a = array('V0', 'V1', 'V2', 'V_CLOB');
				foreach ($a as $k) {
					//echo '', '.';
					if (array_key_exists($k, $values)) {
					//echo '', '!';
					$this->vals[$k][$this->vals_idx[$val_idx]] = $values[$k];
					}
				}
				//echo '<li>', '5';
				$this->vals['FLAGS'][$this->vals_idx[$val_idx]] = "TOUPDATE";
				//echo '<li>idx:',$val_idx;
				//print_a($this->vals_idx);
				//print_a($this->vals);
			}
			//echo '6';
		}
	}

	public function deleteValue($val_idx=0) {
	if ($this->isRef())
		return false;
	
		//if (!$this->isMulti())
		//    return false;
	
		if ($val_idx >= count($this->vals_idx))
			return false;
	
		$this->vals['FLAGS'][$this->vals_idx[$val_idx]] = "TODELETE";
	}

	public function addValue(array $values) {
		if ($this->isRef())
			return false;

		//if (!$this->isMulti())
		//    return false;

		if ($this->isMulti() || !$this->get_values_count()) {
		} else {
			return false;
		}

		//print_r($values);

		$values = array_change_key_case($values, CASE_UPPER);
		$max_plural = -1;
		for ($i=0, $j=count($this->vals_idx); $i<$j; $i++) {
			$max_plural = max(
				$max_plural,
				$this->vals['PLURAL'][$this->vals_idx[$i]]
			);
		}
		$this->vals['DOCPROP_ID'][] = $this->get_docprop_id();
		$this->vals['PLURAL'][] = ++$max_plural;
		$this->vals['V0'][] = $values['V0'];
		$this->vals['V1'][] = $values['V1'];
		$this->vals['V2'][] = $values['V2'];
		$this->vals['V_CLOB'][] = $values['V_CLOB'];
		//$this->vals['DISPLAY'][] = $values['DISPLAY']; // ?
		$this->vals['FLAGS'][(count($this->vals['DOCPROP_ID'])-1)] = "NEW";
	}


    /**
     * Сравнивает значения в зависимости от типа свойства. Тру если равны.
     * 
    */    
    public function compare($values, $val_idx=0)
    {
	$kind = $this->get_docprop_kind();
	if (1==$kind) {
	    // простые
	    $object = $this->get_docprop_object();
	    if ($object>=11 && $object<=15) {
		// цифры
		//echo '<li>',$this->get_docprop_id(),' ',$object;
		$a = array('V0', 'V1', 'V2');
		foreach ($a as $k) {
		    if (array_key_exists($k, $values)) {
			if (!$this->compareNumeric(
			    $this->vals[$k][$this->vals_idx[$val_idx]],
			    $values[$k]
			)) {
			    //echo '-';
			    return false;
			}
		    }
		}
		//echo '+';
		return true;
	    } elseif ($object==2) {
		// деньги
		return $this->compareNumeric(
		    $this->vals['V0'][$this->vals_idx[$val_idx]],
		    $values['V0']
		);
	    } else if ($object == 31 || $object == 32
		       || $object == 33 || $object == 37
		       || $object == 38)
	    {
		//31 - 'full', 32 - 'standard',
		//33 - 'time', 37 - 'shorttime',
		//38 - 'hour'
		$oracleDateTime = "d.m.Y^H:i:s";
		$formats = array(
		    31 => 'd.m.Y^H:i:s',
		    32 => 'd.m.Y^00:00:00',
		    33 => '01.01.0004^H:i:s',
		    37 => '01.01.0004^H:i:00',
		    38 => '01.01.0004^H:00:00',
		);
		if (!empty($values['V0'])
		    && !empty($this->vals['V0'][$this->vals_idx[$val_idx]]))
		{
		    try {
			if ($v = DateTime::createFromFormat(
			    $oracleDateTime,
			    $values['V0']
			)) {
			   $v = $v->format($formats[$object]);
			}
			
			if ($v1 = DateTime::createFromFormat(
			    $oracleDateTime,
			    $this->vals['V0'][$this->vals_idx[$val_idx]]
			)) {
			    $v1 = $v1->format($formats[$object]);
			}
		    } catch (Exception $e) {
			return false;
		    }
		    
		    return $v==$v1;
		    
		} elseif (empty($values['V0'])
		    && empty($this->vals['V0'][$this->vals_idx[$val_idx]]))
		{
		    return true;
		} else {
		    return false;
		}
	    } elseif ($object>=31 && $object<=43) {
		// даты
		//$a = array('V0', 'V1', 'V2');
		//foreach ($a as $k) {
		//    if (array_key_exists($k, $values)) {
		//	if ($values[$k] !=
		//	    $this->vals[$k][$this->vals_idx[$val_idx]]) {
		//	    return false;
		//	}
		//    }
		//}
		return true;
	    } elseif ($object==4) {
		// текст
		$a = array('V0', 'V1', 'V2', 'V_CLOB');
		foreach ($a as $k) {
		    if (array_key_exists($k, $values)) {
			//if ($values[$k] !=
			//    $this->vals[$k][$this->vals_idx[$val_idx]]) {
			//    return false;
			//}
			
			if (0 != strnatcmp(
				$values[$k],
				$this->vals[$k][$this->vals_idx[$val_idx]]
				)
			) {
			    return false;
			}
		    }
		}
		return true;
	    } elseif ($object==5) {
		// бул
		return $this->compareNumeric(
		    $this->vals['V0'][$this->vals_idx[$val_idx]],
		    $values['V0']
		);
	    } else {
		// not supported
	    }
	} elseif (10==$kind) {
	    // словарный
	    return $this->compareNumeric(
		$this->vals['V0'][$this->vals_idx[$val_idx]],
		$values['V0']
	    );
	} elseif (11==$kind) {
	    // табличный
	    return $this->compareNumeric(
		$this->vals['V0'][$this->vals_idx[$val_idx]],
		$values['V0']
	    );
	} elseif (16==$kind) {
	    return $this->compareNumeric(
		$this->vals['V0'][$this->vals_idx[$val_idx]],
		$values['V0']
	    );
	}
	return true;
    }

    /**
     * Приводит переменную к вещественному типу данных, либо к null если не
     * возможно. Нативные функция приводят неверное значение к нулю.
     *
    */
    protected function toNumeric($testNum)
    {
	if (is_numeric($testNum)) {
	    return (float)$testNum;
	} else {
	    return null;
	}
    }

    /**
     * Сравнивает числа. В отличии от нативных функций обрабатывает null
     * значения, а не интерпретирует их нулём.
     * null != <число>
     * null != 0
     * null == null
     * "<число>" == <число>
     * "<число>" == "<число>"
     *
    */    
    protected function compareNumeric($num1, $num2)
    {
	$num1 = $this->toNumeric($num1);
	$num2 = $this->toNumeric($num2);
	return $num1 === $num2;
    }
    

    /**
     * Функция определяет от кого поля зависит текущее
     *
     * @param boolean $asId если тру возвращает Ид полей от которых зависит,
     * иначе их названия.
    */
    public function dependsOn($asId=false)
    {
	// is ref check
	$xml_str = $this->get_ref_xml();
//utls::logStr($xml_str);
	$xml_doc = new DOMDocument();
	$xml_doc->loadXML($xml_str);
	$xpath = new DOMXPath($xml_doc);
	$query = '//query/formal/reference/property[@valuevar][@doc_prop_value]';
	$entries = $xpath->query($query);
	$dependsOn = array();
	foreach ($entries as $entry) {
		$item = $entry->attributes->getNamedItem('valuevar');
		$iV = $item->value;
		if (!empty($iV))
		$dependsOn []= $iV;
		//$item = $entry->attributes->getNamedItem('doc_prop_value');
		//$item->value=$dependsOnValue;
	}

//	utls::logStr('depends: ' . print_r($dependsOn, true));
	
	if ($asId) {
	    for ($i=0, $j=count($dependsOn); $i<$j; $i++) {
		$dependsOn[$i] = $this->document()->getPropIdByName($dependsOn[$i]);
	    }
//	utls::logStr('depends id: ' . print_r($dependsOn, true));
	}
	
	return $dependsOn;
	//$xml = '';
	//foreach($xml_doc->childNodes as $node)
	//    $xml .= $xml_doc->saveXML($node)."\n";
	//echo '<textarea cols=100 rows=10>'.$xml.'</textarea>';
    }


    protected $refObjTypes=null;
    /**
     * [для ссылочного поля]
     * Возвращает допустимые типы объектов для создания.
     *
    */    
    public function getRefObjectTypes()
    {
	if (!$this->isRef())
	    return false;
	if (is_null($this->refObjTypes)) {
	    $sql = 'select * from table(GET_REFKIND_LIST('
		. $this->get_docprop_id()
		. '))';
	    $retVal = ora_select($sql, md5($sql), '', '');
	    $this->refObjTypes = array();
	    for ($i=0, $j=count($retVal['STRING_VALUE1']); $i<$j; $i++) {
		$this->refObjTypes []= array(
					     'dockind_id' => $retVal['STRING_VALUE1'][$i],
					     'dockind_name'  => $retVal['STRING_VALUE2'][$i],
					     'dockind_namevar'  => $retVal['STRING_VALUE3'][$i],
					     'xml'  => $retVal['STRING_VALUE4'][$i],
					     );
	    }
	}
	return $this->refObjTypes;
    }


    /**
     * Проверяет являются ли значения для текущщего свойства валидными.
     * todo
    */
//    protected function verifyValue(array $value)
//    {
//	$kind = $this->get_docprop_kind();
//	if (1==$kind) {
//	    // простые
//	    $object = $this->get_docprop_object();
//	    if ($object>=11 && $object<=15) {
//		// цифры
//		$a = array('V0', 'V1', 'V2');
//		foreach ($a as $k) {
//		    if (array_key_exists($k, $values)) {
//			if (!$this->compareNumeric(
//			    $this->vals[$k][$this->vals_idx[$val_idx]],
//			    $values[$k]
//			)) {
//			    return false;
//			}
//		    }
//		}
//		return true;
//	    } elseif ($object==2) {
//		// деньги
//		return $this->compareNumeric(
//		    $this->vals['V0'][$this->vals_idx[$val_idx]],
//		    $values['V0']
//		);
//	    } elseif ($object>=31 && $object<=43) {
//		// даты
//		$a = array('V0', 'V1', 'V2');
//		foreach ($a as $k) {
//		    if (array_key_exists($k, $values)) {
//			if ($values[$k] !=
//			    $this->vals[$k][$this->vals_idx[$val_idx]]) {
//			    return false;
//			}
//		    }
//		}
//		return true;
//	    } elseif ($object==4) {
//		// текст
//		$a = array('V0', 'V1', 'V2');
//		foreach ($a as $k) {
//		    if (array_key_exists($k, $values)) {
//			if ($values[$k] !=
//			    $this->vals[$k][$this->vals_idx[$val_idx]]) {
//			    return false;
//			}
//		    }
//		}
//		return true;
//	    } elseif ($object==5) {
//		// бул
//		return $this->compareNumeric(
//		    $this->vals['V0'][$this->vals_idx[$val_idx]],
//		    $values['V0']
//		);
//	    } else {
//		// not supported
//	    }
//	} elseif (10==$kind) {
//	    // словарный
//	    return $this->compareNumeric(
//		$this->vals['V0'][$this->vals_idx[$val_idx]],
//		$values['V0']
//	    );
//	} elseif (11==$kind) {
//	    // табличный
//	    return $this->compareNumeric(
//		$this->vals['V0'][$this->vals_idx[$val_idx]],
//		$values['V0']
//	    );
//	}
//	return true;
//    }
}


//class sp_property1
//{
//
//    /**
//     * Проверяет на допустимые значения.
//     * 
//    */    
//    static public function verifyValue()
//    {
//        
//    }
//    
//    /**
//     * Объединяет значение_1 и значени_2
//     *
//    */
//    static public combineValues()
//    {
//	
//    }
//    
//}




    //public static function __set_state()
    //{ 
    //    return $this->getDump();
    //}

/*
class cSimpleValue{
    private static $m_pInstances=array();
    protected $instance_id = null;
    protected $prop;
    protected $val_num;
    protected $props;
    protected $prop_idx;
    protected $vals;
    protected $vals_idx;

    private function __construct( $simple_property, $val_num, &$props, $prop_idx, &$vals, $vals_idx )
    {
        $this->prop = $simple_property;
        $this->val_num = $val_num;
        $this->props = &$props;
        $this->prop_idx = $prop_idx;
        $this->vals= &$vals;
        $this->vals_idx = $vals_idx;
        $this->instance_id= crc32( "{$simple_property->get_instance_id()}-{$val_num}" );
    }



//
// Функция которую необходимо вызывать вместо конструктора. Обеспечивает паттерн одиночка.
// Для определённого значения определённого свойства определенного объекта караби - один пхп объект.
//
//
//
//
    public static function getInstance( $simple_property, $val_num, &$props, $prop_idx, &$vals, $vals_idx )
    {
        $sign = crc32( "{$simple_property->get_instance_id()}-{$val_num}" );
	if( !array_key_exists( $sign, self::$m_pInstances ) || !self::$m_pInstances[$sign] )
        {
            self::$m_pInstances[$sign] = new cSimpleValue( $simple_property, $val_num, &$props, $prop_idx, &$vals, $vals_idx );
        }
        else
        {
        }
        return self::$m_pInstances[$sign];
    }



    public function get_parent(){
        return $this->prop;
    }



    public function get_instance_id(){
        return $this->instance_id;
    }



    public function value( $val_type = 'V0' )
    {
        return $this->vals[$val_type][$this->vals_idx[$this->val_num]];
    }



    public function _set_value( $val, $val_type = 'V0' )
    {
        $this->vals[$val_type][$this->vals_idx[$this->val_num]] = $val;
    }

}
/**/
/*
    [DOCPROP_ID] => 15108
    [DOCKIND_ID] => 30433
    [DOC_MU_NAME] =>
    [DOC_FORMAT] => 0
    [DOCPROP_DESCR] => OUTSKIRTS
    [DOCPROP_NAME] => Окрестности
    [DOCPROP_KIND] => 10
    [DOCPROP_VISIBLE] => 1
    [DOCPROP_NOTNULL] => 0
    [DOCPROP_UNIQUE] => 0
    [DOCPROP_OBJECT] => CottageOutskirts
    [DOCPROP_REPEAT] => 0
    [DOCPROP_MULTI] => 1
    [DOCPROP_SQL] =>
    [SHOW_ORDER] => 9
    [DOCPROP_DISPLAY_ORDER] => -1
    [DOCPROP_DISPLAY_COMMENT] => 
    [REF_XML] =>
    [REF_SQL] =>
    [REF_COLUMN] =>
    [REF_COMBO] =>
    [DOCPROP_VLEVEL] => 0
/**/

        /*$this->vals_idx = $this->get_values_idx();
        $this->refs_idx = $this->get_refs_idx();

        if( !empty($this->vals_idx) )
        {
            $this->prop_type = 'vals';
            if( $this->isMulti() ){
                $this->_makemultifromdisplay(); // - заглушка
            }
        }
        else if( !empty($this->refs_idx) )
        {

            $this->prop_type = 'refs';
        }
        else
        {
            //prop has no vals or refs
        }*/

?>