<?php

// КЛАСС ДЛЯ РАБОТЫ С ФОРМАЛИЗОВАННЫМ ДОКУМЕНТООБОРОТОМ ЧЕРЕЗ WEB
// Версия 1.0
// © Molochnikov Mikhail, mikhail@molochnikov.com
// дата начала разработки PHP-версии: 25.02.2003
// Версия 1.1
// дата реанимации и возвращения в разработку: 17.03.2008
// Версия 1.2
// 15.10.2009
// реализованы основные механизмы, включая чтение документов и сохранение, переработано на поддержку ajax
// Версия 1.3
// Добавлена работа с реквизитами документа через объекты класса simpleProperty.
// Добавлено обращение к объекту, как к функции (PHP >5.3). На вход функции подаются название реквизита,
//     на выходе simpleProperty

define('SIMPLEDOCUMENT_DEBUG', 1);

$FORMZ_PATH = '../';

//require('db/logon.inc');
require_once('docobjects.inc');
require_once('popup.inc');


class simpledocument
{
	// Свойства класса
	// Документ
	var $document_id;      // ИД документа
	var $document_name;    // Наименование документа
	var $document_locked;  // Состояние блокировки документа
	// Тип документа
	var $dockind_id;      // ИД типа документа
	var $dockind_name;    // Наименование типа документа
	var $dockind_namevar; // системное наименование типа документа
	// Статусы
	var $status_id;       // ID статуса
	var $status_name;     // наименование статуса
	var $status_namevar;  // системное наименование статуса
	var $status_list;     // список всех статусов
	var $status_current_list;// список статусов, на которые можно перевести документ сейчас
	// Реквизиты
	var $properties;      // массив реквизитов документа
	// Значения
	var $values;          // массив значений документа
	var $refs;            // массив ссылок на документы

	// constructor
	function simpledocument($adocument_id, $adockind_namevar = '') {

		utls::logTimeStr('SD_'.$adocument_id, 'new SimpleDocument');
		//utls::logTimeStr('SD_'.$this->document_id, 'new SimpleDocument');
		utls::timer('start', 'simpledoc', true);

		if ($adocument_id > 0) {
			$this->document_id = $adocument_id;
			$this->dockind_namevar = '';
		} else {
			$this->document_id = -1;
			$this->dockind_namevar = $adockind_namevar;
		}

		$this->set_document_info();

		utls::timer('point 1', 'simpledoc' );
		// echo "doc_id=$this->document_id doc_name=$this->document_name dockind_id=$this->dockind_id dockind_name=$this->dockind_name dockind_namevar=$this->dockind_namevar";

		//$this->dockind_id = getdockindid($adocument_id);
		//$this->dockind_name = get_dockind_name($this->dockind_id);
		//$this->dockind_namevar = get_dockind_namevar($this->dockind_id);
		if (($adocument_id > 0) and empty($this->dockind_id)) {
			if (SIMPLEDOCUMENT_DEBUG) {
				die('<b>SimpleDocument.New: Документ ID='.$adocument_id.' (тип документа '.$adockind_namevar.') недоступен или не существует!</b>');
			}
			return;
		}
		if (empty($this->dockind_id)) {
			if (SIMPLEDOCUMENT_DEBUG) {
				die('<b>SimpleDocument.New: В документе ID='.$adocument_id.' (тип документа '.$adockind_namevar.') не задан ID типа документа!</b>');
			}
			return;
		}
		$this->properties = get_properties_list($this->dockind_id, $this->status_id);

		utls::timer('point after get_properties_list', 'simpledoc' );
		//echo $this->Properties['DOCPROP_NAME'][0];
		// формируем список идентификаторов реквизитов...

		$dockind_id_list = implode(",", $this->properties["DOCPROP_ID"]);
		// получаем значения документа...
		utls::timer('point 3', 'simpledoc' );
			$this->values = get_values_list($this->document_id, $dockind_id_list);
		utls::timer('point after get_values_list', 'simpledoc' );
			// получаем ссылочные значения документа...
			$this->refs = get_refs_list($this->document_id, $dockind_id_list);
		utls::timer('point after get_refs_list', 'simpledoc' );
			//echo $this->Values['DOC_PROP_VALUE'][0];
		utls::timer('stop', 'simpledoc' );
	}

  // Take $num articles of $artnr out of the cart

	function set_document_info() {
		global $STATUS_CREATED;
		$this->document_name = '';  // Наименование документа
		$this->dockind_name = '';  //
		//$this->dockind_namevar = '';
		$this->document_locked = 0;
		$this->document_eventid = -1;
		$this->document_eventdate = 0;
		$this->status_id = -1;
		$this->status_namevar = '';
		if ($this->document_id > 0) {
			// Задан ИД документа
			$res = ora_cursor("PKG_WEB.DOCF_GET_DOCUMENT_INFO({$this->document_id})");
			//print_a($res);
			//exit;
			$this->document_name = $res[0][DOC_DESCR];
			$this->dockind_name = $res[0][DOCKIND_NAME];
			$this->dockind_namevar = $res[0][DOCKIND_NAMEVAR];
			$this->dockind_id = $res[0][DOCKIND_ID];

			// print_r($res);
			// Текущий статус
			$this->status_id = $res[0][STATUS_ID];
			$this->status_name = $res[0][STATUS_NAME];
			$this->status_namevar = $res[0][STATUS_NAMEVAR];
			// список статусов
			$this->status_list = get_status_list_all($this->dockind_id);
			$this->status_current_list = get_status_list($this->document_id, $this->dockind_id, $this->status_id);
			// DocFGetStatus(document_id, current_status);
			// Информация о поcледний модификации документа
			// DocFGetLastStatusEvent(document_id, tmpint, document_eventid, document_eventdate);
		} else {
			// Задан ИД типа документа, и не задан ИД документа (-1)
			// получение name and namevar типа документа
			$namevar = $this->dockind_namevar;
			$res = ora_cursor("PKG_WEB.DOCF_GET_KIND_INFO_BY_NAMEVAR('$namevar')");
			$this->dockind_name = $res[0][DOCKIND_NAME];
			$this->dockind_namevar = $res[0][DOCKIND_NAMEVAR];
			$this->dockind_id = $res[0][DOCKIND_ID];
			$this->current_status = $STATUS_CREATED; //по умолчанию статус создан
			// print_r($res);
			//echo $STATUS_CREATED;
		}
		// Список статусов
		/*res := DocFGetStatusList(document_id, dockind_id, current_status, st_list);
		case res of
		integer(SQL_EOF): Status_List := NULL;
		0: Status_List := st_list;
		else
		begin
		result := - 100;
		exit;
		end;
		end;
		result := 0;  */
	}

	/**
	 * Создаёт документ и записывает его в свойства объекта
	 * @return ID документа
	 */
	function create_document() {
		if ($this->document_id == -1) {
			$doc_id = create_document($this->dockind_namevar);
			if ($doc_id > 0) {
				// устанавливаем значение ID документа
				$this->document_id = $doc_id;
				// Обновляем значения - они проинициализированы значениями по-умолчанию
				// формируем список идентификаторов реквизитов...
				$dockind_id_list = implode(",", $this->properties[DOCPROP_ID]);
				// получаем значения документа...
				$this->values = get_values_list($this->document_id, $dockind_id_list);
				// получаем ссылочные значения документа...
				$this->refs = get_refs_list($this->document_id, $dockind_id_list);
			}
		}
	}

	function delete_document() {
		if ($this->document_id <> -1) {
			//$doc_id = create_document($this->dockind_namevar);
			//if ($doc_id > 0) {
			// удаление из базы
			exec_proc("documents.DOCF_DELETE_2('".$this->document_id."', true)");
			// устанавливаем значение ID документа
			$this->document_id = -1;
			// Обновляем значения - они проинициализированы значениями по-умолчанию
			// формируем список идентификаторов реквизитов...
			unset($dockind_id_list);
			// получаем значения документа...
			unset($this->values);
			// получаем ссылочные значения документа...
			unset($this->refs);
		}
	}


	/**
	 * возвращает hidden-поле для ссылок на этот документ. Поле из другого документа $docsource_id по ссылке $ref!
	 * @param type $docsource_id
	 * @param type $ref
	 * @param type $num номер ссылки
	 * @return string 
	 */
	function getrefid($docsource_id, $ref, $num) {
		$html = '<input name="P_'.$docsource_id.'_'.$ref.'_'.$num.'" type="hidden" value="'.$this->document_id.'">';
		return $html;
	}

	/**
	 * возвращает индекс в массиве реквизитов
	 * 
	 * @param type $docprop_namevar системное наименование реквизита
	 * @return int 
	 */
	function get_prop_index($docprop_namevar) {
		for ($i = 0; $i < count($this->properties[DOCPROP_ID]); $i++) {
			$prop_namevar = $this->properties[DOCPROP_DESCR][$i];
			if ($docprop_namevar == $prop_namevar) {
				return $i;
			}
		}
	}


	/**
	 * возвращает массив идентификаторов и наименований документов, полученных по указанной ссылке
	 * @param type $docprop_namevar
	 * @return type 
	 */
	function get_refs($docprop_namevar) {
		$prop_index = $this->get_prop_index($docprop_namevar);
		$prop_id = $this->properties[DOCPROP_ID][$prop_index];
		$res = get_ref_value($this, $prop_id);
		return $res;
	}


	// Прочие функции
	/**
	 * Возвращает значение для просмотра (display)
	 * @param type $prop_id
	 * @return type 
	 */
	function get_display_value($prop_id) {
		for ($i = 0; $i < count($this->values[DOCPROP_ID]); $i++) {
			if ($prop_id == $this->values[DOCPROP_ID][$i]) {
				return $this->values[DISPLAY][$i];
				break;
			}
		}
	}
	
	/**
	 * Возвращает первое значение реквизита
	 * Для ссылочных полей возвращает первое Id ссылочного документа
	 * @global type $debug
	 * @param type $aprop_namevar
	 * @return string 
	 */
	function getv($aprop_namevar) {
		global $debug;
		$prop_id = -1;

		// Получение ID реквизита по его системному наименованию
		for ($i = 0; $i < count($this->properties[DOCPROP_ID]); $i++) {
			//$prop_namevar = $this->properties[DOCPROP_DESCR][$i];
			if ($this->properties[DOCPROP_DESCR][$i] === $aprop_namevar) {
				// нашли!
				$prop_id = $this->properties[DOCPROP_ID][$i];
				break;
			}
		}

		//echo 'prop_id='.$prop_id;
		if ($prop_id > 0) {
			$value = get_value($this, $prop_id);
			if( !empty($value) ){
				$value = $value[V0][0];	
			}else{
				$value = get_ref_value($this, $prop_id);
				$value = $value['DOCTARGET_ID'][0];
			}
		} else {
			$value = "";
			//if ($debug) {
			//  echo '<br>В документе ID='.$this->document_id.' реквизит '.$aprop_namevar.' не найден.<br>';
			//}
			if (SIMPLEDOCUMENT_DEBUG) {

				//throw new Exception('В документе ' . $this->dockind_namevar .' ID='.$this->document_id.' реквизит '.$aprop_namevar.' не найден.');
				// теперь пишем в лог
				$logstr = 'В документе ' . $this->dockind_namevar .' ID='.$this->document_id.' реквизит '.$aprop_namevar.' не найден.';
				utls::logTimeStr('SD_GETV_Errors', 'ERROR: '.$logstr);
			}
		}

		return $value;
	}
	
	/**
	 * Возвращает отображение значения реквизита по его наименованию
	 * Для ссылочных полей возвращает первое Id ссылочного документа
	 * @global type $debug
	 * @param type $aprop_namevar
	 * @return type 
	 */
	function get_display($aprop_namevar) {
		global $debug;
		$prop_id = -1;

		// Получение ID реквизита по его системному наименованию
		for ($i = 0; $i < count($this->properties[DOCPROP_ID]); $i++) {
			//$prop_id = $this->properties[DOCPROP_ID][$i];
			//$prop_namevar = $this->properties[DOCPROP_DESCR][$i];
			if ($this->properties[DOCPROP_DESCR][$i] === $aprop_namevar) {
				// нашли!
				$prop_id = $this->properties[DOCPROP_ID][$i];
				break;
			}
		}
		//echo 'prop_id='.$prop_id;
		if ($prop_id > 0) {
			$value = get_value($this, $prop_id);

			if( !empty($value) ){
				$value = $value['DISPLAY'][0];
			}else{
				$value = get_ref_value($this, $prop_id);
				$value = $value['DOC_NAME'][0];
			}
		} else {
			//if ($debug) {
				//echo '<br>В документе ID='.$this->document_id.' реквизит '.$aprop_namevar.' не найден.<br>';
			//}
			if (SIMPLEDOCUMENT_DEBUG) {
				// throw new Exception('В документе ' . $this->dockind_namevar .' ID='.$this->document_id.' реквизит '.$aprop_namevar.' не найден.');
				// теперь пишем в лог
				$logstr = 'В документе ' . $this->dockind_namevar .' ID='.$this->document_id.' реквизит '.$aprop_namevar.' не найден.';
				utls::logTimeStr('SD_GETV_Errors', 'ERROR: '.$logstr);
			}
		}

		/// TODO: получать и ссылочные поля
		//$ref_value = get_ref_value($doc, $prop_id);
		//$res = $ref_value[DOCTARGET_ID][0];

		return $value;
	}
	
	/**
	 * Возвращает список значений реквизита по его наименованию
	 * ДЛЯ МНОЖЕСТВЕНЫХ ЗНАЧЕНИЙ
	 * в виде array(значение 1, значение 2, ...)
	 * Для ссылочных полей возвращает первое Id ссылочного документа
	 * @global type $debug
	 * @param type $aprop_namevar
	 * @return type 
	 */
	function get_multi($aprop_namevar) {
		global $debug;
		$prop_id = -1;

		// Получение ID реквизита по его системному наименованию
		for ($i = 0; $i < count($this->properties[DOCPROP_ID]); $i++) {
			$prop_id = $this->properties[DOCPROP_ID][$i];
			$prop_namevar = $this->properties[DOCPROP_DESCR][$i];
			if ($prop_namevar == $aprop_namevar) {
				// нашли!
				break;
			}
		}
		//echo 'prop_id='.$prop_id;
		if ($prop_id > 0) {
			$value = get_value($this, $prop_id);
			if( !empty($value) ){
				$value = $value[DISPLAY][0];
				$value = replace('...', '', $value);
				$arr = array();
				$arr = explode('; ', $value);
			}else{
				//$value = get_ref_value($this, $prop_id);
				//$value = $value['DOCTARGET_ID'][0];
			}

		} else {
			//if ($debug) {
			//  echo '<br>В документе ID='.$this->document_id.' реквизит '.$aprop_namevar.' не найден.<br>';
			//}
			if (SIMPLEDOCUMENT_DEBUG) {
				// throw new Exception('В документе ' . $this->dockind_namevar .' ID='.$this->document_id.' реквизит '.$aprop_namevar.' не найден.');
				// теперь пишем в лог
				$logstr = 'Get_Multi. В документе ' . $this->dockind_namevar .' ID='.$this->document_id.' реквизит '.$aprop_namevar.' не найден.';
				utls::logTimeStr('SD_GETV_Errors', 'ERROR: '.$logstr);
			}
		}

		/// TODO: получать и ссылочные поля
		//$ref_value = get_ref_value($doc, $prop_id);
		//$res = $ref_value[DOCTARGET_ID][0];

		return $arr;
	}


	/*
		Added by Ilya Kraynov @ 2010.10.13 11:38
	*/
	function __get($v){
		return $this->getv( strtoupper($v) );
	}


	public function get_property( $prop ) {
		$prop_id = null;
		if( is_numeric($prop) && is_int( (int)$prop ) )
		{
			$prop_id = (int)$prop;
		}
		else
		{
			if( !$prop_id = $this->getPropIdByName($prop) )
			{
				//die( "Document: В документе ID=<b>{$this->document_id}</b> - <b>'{$this->dockind_namevar}'</b> нет реквизита <b>'{$prop}'</b>." );
				//return false;
				if (SIMPLEDOCUMENT_DEBUG) {
					// throw new Exception('В документе ' . $this->dockind_namevar .' ID='.$this->document_id.' реквизит '.$aprop_namevar.' не найден.');
					// теперь пишем в лог
					$logstr = 'get_property. В документе ' . $this->dockind_namevar .' ID='.$this->document_id.' реквизит '.$aprop_namevar.' не найден.';
					utls::logTimeStr('SD_GETV_Errors', 'ERROR: '.$logstr);
				}
			}
		}

		require_once dirname(__FILE__).'/simpleproperty.php';

		return SimpleProperty::getInstance( $this, $prop_id, $this->properties, $this->values, $this->refs );
	}

    public function __invoke( $prop )
    {
        return $this->get_property( $prop );
    }


    protected $propIds = array();
    protected function findPropById( $property_id )
    {
		if (!is_numeric($property_id)) return;
        //$property_name = strtoupper( $property_name );
        if( !array_key_exists( $property_id, $this->propIds ) )
        {
            for( $i=0, $j=count($this->properties['DOCPROP_ID']); $i<$j; $i++ )
            {
                if( $this->properties['DOCPROP_ID'][$i] == $property_id )
                {
                    $property_name = $this->properties['DOCPROP_DESCR'][$i];
                    $this->propNames[$property_name]['id'] = (int)$this->properties['DOCPROP_ID'][$i];
                    $this->propNames[$property_name]['idx'] = $i;
                    $this->propIds[$this->properties['DOCPROP_ID'][$i]]['name'] = $property_name;
                    $this->propIds[$this->properties['DOCPROP_ID'][$i]]['idx'] = $i;

                    return true;
                    //return $this->propNames[$property_name];
                }
            }
            return false;
        }
        return true; //$this->propNames[$property_name];
    }

    protected $propNames = array();
    protected function findPropByName( $property_name )
    {
        //$property_name = strtoupper( $property_name );
        if( !array_key_exists( $property_name, $this->propNames ) )
        {

            for( $i=0, $j=count($this->properties['DOCPROP_ID']); $i<$j; $i++ )
            {
                if( $this->properties['DOCPROP_DESCR'][$i] == $property_name )
                {
                    $this->propNames[$property_name]['id'] = (int)$this->properties['DOCPROP_ID'][$i];
                    $this->propNames[$property_name]['idx'] = $i;
                    $this->propIds[$this->properties['DOCPROP_ID'][$i]]['name'] = $property_name;
                    $this->propIds[$this->properties['DOCPROP_ID'][$i]]['idx'] = $i;

                    return true;
                    //return $this->propNames[$property_name];
                }
            }
            return false;
        }
        return true; //$this->propNames[$property_name];
    }

    public function getPropIdxByName( $property_name )
    {
        $property_name = strtoupper( $property_name );
        if( $this->findPropByName( $property_name ) )
            return $this->propNames[$property_name]['idx'];
        else
            return false;
    }

    public function getPropIdByName( $property_name )
    {
        $property_name = strtoupper( $property_name );
        if( $this->findPropByName( $property_name ) ){
            return $this->propNames[$property_name]['id'];
        }else
            return false;
    }

    public function getPropIdxById( $id )
    {
        if( $this->findPropById( $id ) ){
            return $this->propIds[$id]['idx'];
        }else
            return false;
    }


        protected $pSD = null;
        protected $pSP = null;
        protected $pSPIdx = null;


	public function set_parentDocument( $parent_simpleDocument ){
		$this->pSD = $parent_simpleDocument;
	}

	public function set_parentProperty( $parent_simpleProperty, $ref_idx=0 ){
		$this->pSP = $parent_simpleProperty;
		$this->pSPIdx = $ref_idx;
	}

	public function get_parentDocument(){
		return $this->pSD;
	}

	public function get_parentProperty(){
		if( !empty($this->pSP) ){
			return array( $this->pSP, $this->pSPIdx );
		}else{
			return null;
		}
	}


	public function get_dump(){
		$retVal = array();
		$retVal['document_id'] = $this->document_id;
		$retVal['document_name'] = $this->document_name;
		$retVal['dockind_name'] = $this->dockind_name;
		$retVal['dockind_namevar'] = $this->dockind_namevar;
		$retVal['dockind_id'] = $this->dockind_id;
		$retVal['current_status'] = $this->current_status;
		$retVal['status_list'] = $this->status_list;
		$retVal['compiled_props'] = ora_redim($this->properties);
		$retVal['values'] = ora_redim($this->values);
		$retVal['refs'] = ora_redim($this->refs);
		//$retVal['compiled'] = array();

		for($i=0, $j=count($retVal['compiled_props']); $i<$j; $i++){

			$retVal['compiled_props'][$i]['refs'] = array();
			for( $i2=0, $j2=count($retVal['refs']); $i2<$j2; $i2++ ){
				if($retVal['compiled_props'][$i]['DOCPROP_ID']==$retVal['refs'][$i2]['DOCPROP_ID']){
					$retVal['compiled_props'][$i]['refs'] []= $retVal['refs'][$i2];
				}
			}

			$retVal['compiled_props'][$i]['values'] = array();
			for( $i2=0, $j2=count($retVal['values']); $i2<$j2; $i2++ ){
				if($retVal['compiled_props'][$i]['DOCPROP_ID']==$retVal['values'][$i2]['DOCPROP_ID']){
					$retVal['compiled_props'][$i]['values'] []= $retVal['values'][$i2];
				}
			}

		}
		unset($retVal['values']);
		unset($retVal['refs']);
		return $retVal;

	}

  //////////////////////////////////////////////////////////////////////////////
  // СОХРАНЕНИЕ....
  function save_document(&$err)
  // Сохраняет документ, возвращает 0, если все OK, или число.
  // В err записывается сообщение с сервера.

  // Пройти по документу, по наименованиям реквизитов получить значения переменных
  // (надо знать тип!), а по нему получить значения переменных V, V1, V2
  {
    
   
    global $conn;
    global $PROPKIND_REF;
    global $PROPKIND_BREF;
	//global $USER_ID;        // ID пользователя
	global $USER_LOGIN_REGIME;

  $sql  = "DECLARE \n";
  $sql .= "  CHECK_PERMISSIONS BOOLEAN := SYS.DIUTIL.INT_TO_BOOL(1); \n";
  $sql .= "  IDENTIFY          BOOLEAN := SYS.DIUTIL.INT_TO_BOOL(0); \n";
  $sql .= "  DOCF_VALUES$      T_DOCF_PROP_VALUES := T_DOCF_PROP_VALUES(); \n";
  $sql .= "  DOCF_REFS$        T_DOCF_REF_VALUE_LIST := T_DOCF_REF_VALUE_LIST(); \n";
  $sql .= "  DLIST             T_NUMBER_LIST; \n";
  $sql .= "  ERR_MSG$          VARCHAR2(1000); \n";
  $sql .= "  RESULT$           NUMBER; \n";
  $sql .= "BEGIN \n";
  //$sql .= "  DOCUMENTS.REGISTER_USER(".$USER_ID.",2); \n";
  $sql .= "  DOCUMENTS.REGISTER_USER(".$this->getUserId().",2); \n";

  $endsql = "  RESULT$ := PKG_VALUES.INS_VAL(DOCF_VALUES => DOCF_VALUES$, DOCF_REFS => DOCF_REFS$, DLIST => DLIST, ERR_MSG => ERR_MSG$, REPEAT$ => 0, CHECK_PERMISSIONS => CHECK_PERMISSIONS, IDENTIFY => IDENTIFY); \nSET_STATUS(".$this->document_id.", GET_DOCEVENTKIND_ID('SAVED'), TRUE);\nEND;";
    // Передаем точное время: в Москве 16-43, в Петропавловске-Камчатском - за полночь (01-43)
    // (это было лирическое отступление)

    // Передаем переменные среды, в которых находятся значения, в объект.
    //print_r($_POST);


    for ($i = 0; $i < count($this->properties[DOCPROP_ID]); $i++)
    {

      $prop_id = $this->properties[DOCPROP_ID][$i];
      $prop_name = $this->properties[DOCPROP_NAME][$i];
      $prop_namevar = $this->properties[DOCPROP_DESCR][$i];
      $prop_type =   $this->properties[DOCPROP_KIND][$i];

      $visible = $this->properties[DOCPROP_VISIBLE][$i];
      $notnull = $this->properties[DOCPROP_NOTNULL][$i];
      $multi = $this->properties[DOCPROP_MULTI][$i];
      $prop_object = $this->properties[DOCPROP_OBJECT][$i];

      // получаем значение. (заполняем переменные v, v0, v1)
      $exists = get_posted_values2($this->document_id, $prop_id, $prop_namevar, $prop_type, $prop_object, $multi, $v0, $v1, $v2);
      //$display = $this->get_display_value($prop_id);
      if (($prop_type <> $PROPKIND_REF) /*and ($prop_type <> $PROPKIND_BREF)*/) {
         // ОБЫЧНЫЕ ТИПЫ ДАННЫХ
	     if ($exists) {
	       // Сохраняем только существующие значения!!!
	       $sql .= "  DOCF_VALUES$.EXTEND; DOCF_VALUES$(DOCF_VALUES$.LAST) := T_DOCF_PROP_VALUE(".$this->document_id.",". $prop_id.",".'0'.",'".$v0."','".$v1."','".$v2."'); \n";
	       //echo "v=".$v0." v1=".$v1." v2=".$v2."<br>";
	     }
	  } else {
	    // ССЫЛОЧНЫЕ ТИПЫ ДАННЫХ
	    //echo "<br>REF ".$prop_namevar." multi=".$multi.'<br>';
	    if ($multi == 0) {
	      // не мульти
	      if ($exists) {
  	        $sql .= "    DOCF_REFS$.EXTEND;  DOCF_REFS$(DOCF_REFS$.LAST) := T_DOCF_REF_VALUE('',".$this->document_id.",". $prop_id.",'".$v0."', 1); \n";
	        //echo "REF v=".$v0." v1=".$v1." v2=".$v2."<br>";
	      }
	    } else {
	      // мульти
          //echo "!!! cnt_refs=".count($v0).'<br>';
          for ($j = 0; $j < count($v0); $j++) {
            $sql .= "    DOCF_REFS$.EXTEND;  DOCF_REFS$(DOCF_REFS$.LAST) := T_DOCF_REF_VALUE('',".$this->document_id.",". $prop_id.",'".$v0[$j]."', 1); \n";
            //echo "REF v[".$j."]=".$v0[$j]." v1=".$v1." v2=".$v2."<br>";
          }
	    } // else if
	  } // else if ссылочный
    } // for
    // конец sql выражения
    $sql .= $endsql;



    //echo "<pre>".$sql."</pre>";


    // запускаем...
    $stmt = ociparse($conn, $sql);
    ociexecute ($stmt, OCI_DEFAULT);
    ocicommit($conn);
    ocifreestatement($stmt);

    $res = 0;
    $err = "";
    //$err = "Документ сохранен!";

    return $res;
  }


    static $sqls = array();


    public function save_prepare_values($vals) {
        $vals_prop = array();
        // набивка массива
        for ($i = 0; $i < count($vals); $i++)
	{
            //
            // в multi - полях -- не добавляем в массив пустышки
            if (
                //($this->properties['DOCPROP_MULTI'][$this->getPropIdxById($vals[$i]['DOCPROP_ID'])] == 1)
                //and
                (empty($vals[$i]['DISPLAY']) and empty($vals[$i]['V0']) and empty($vals[$i]['V1']) and empty($vals[$i]['V2']))
               ) continue;
            //
            
            // это надо для того, чтобы в мульти-полях 
            if (!is_array($vals_prop[$vals[$i]['DOCPROP_ID']])) {
                $vals_prop[$vals[$i]['DOCPROP_ID']] = array('data' => array(), 'status' => 0);
            }
            //
            
            // удалено
            if ($vals[$i]['FLAGS'] == 'TODELETE') {
                $vals_prop[$vals[$i]['DOCPROP_ID']]['status'] += 1;
            } else {
		$vals_prop[$vals[$i]['DOCPROP_ID']]['data'][] = $vals[$i];
	    }
	    
            // изменения есть
            if ($vals[$i]['FLAGS'] == 'TOUPDATE') {
                //$vals_prop[$vals[$i][DOCPROP_ID]][data][] = $vals[$i];
                $vals_prop[$vals[$i]['DOCPROP_ID']]['status'] += 1;
            }
	    
            // добавили новое значение
            if ($vals[$i]['FLAGS'] == 'NEW') {
                //$vals_prop[$vals[$i][DOCPROP_ID]][data][] = $vals[$i];
                $vals_prop[$vals[$i]['DOCPROP_ID']]['status'] += 1;
            }
            
        }
        
        
        // добавление записи, если все удалено
        for ($i = 0; $i < count($vals_prop); $i++) {
            //if ($this->properties[DOCPROP_MULTI][$vals[$i][DOCPROP_ID]] == 1) {
                // проходим только по мульти
                if (!count($vals_prop[$vals[$i][DOCPROP_ID]][data])) {
                    $vals_prop[$vals[$i][DOCPROP_ID]][data] = array(array(DOCPROP_ID => $vals[$i][DOCPROP_ID], V0 => '', V1 => '', V2 => '', PLURAL => 0, V_CLOB => '', DISPLAY => ''));
                }
            //}    
        }
        //utls::logStr('SD_'.$this->document_id, 'vals_prop: ' . print_r($vals_prop, true));
        return $vals_prop;
    }



	public function save_prepare()
	{
		utls::logTimeStr('SD_'.$this->document_id, 'START save prepare');
		$endsql = "\n  -- Сохранение значений...\n  RESULT$ := PKG_VALUES.INS_VAL(DOCF_VALUES => DOCF_VALUES$, DOCF_REFS => DOCF_REFS$, DOCF_CLOB => DOCF_CLOB$, DLIST => DLIST, ERR_MSG => ERR_MSG$, REPEAT$ => 0, CHECK_PERMISSIONS => CHECK_PERMISSIONS, IDENTIFY => IDENTIFY);\n";

		// Передаем точное время: в Москве 16-43, в Петропавловске-Камчатском - за полночь (01-43)
		// (это было лирическое отступление из предыдущей версии систмы сохранения:)
		// Передаем переменные среды, в которых находятся значения, в объект.
		// print_r($_POST);
		$values = ora_redim($this->values);
		utls::logStr('SD_'.$this->document_id, 'values before: ' . print_r($values, true));
		$vals = $this->save_prepare_values($values); // готовим массив
		//print_a($vals);
		$refs = ora_redim($this->refs);
		//print_a($refs);
		utls::logStr('SD_'.$this->document_id, 'values: ' . print_r($vals, true));
		utls::logStr('SD_'.$this->document_id, 'refs: ' . print_r($refs, true));
		
		
		$sql = '';
		$sql .= "\n\n  -- ДОКУМЕНТ: ID = "
		        .$this->document_id
				." (KIND = "
				.$this->dockind_namevar
				.")\n\n";
		$sql .= "  DOCF_VALUES$ := T_DOCF_PROP_VALUES();\n";
		$sql .= "  DOCF_REFS$   := T_DOCF_REF_VALUE_LIST();\n";
		$sql .= "  DOCF_CLOB$   := T_DOCF_PROP_CLOBS();\n";
		
		if (count($vals) > 0) {
			$rawSql = "DOCF_VALUES$.EXTEND; DOCF_VALUES$(DOCF_VALUES$.LAST) := T_DOCF_PROP_VALUE(%d, %d, %d, '%s','%s','%s');";
			//$rawSqlLarge = "UPDATE_PROPERTY_AS_CLOB(%d, %d, '%s');";
			$rawSqlLarge = "DOCF_CLOB$.EXTEND; DOCF_CLOB$(DOCF_CLOB$.LAST) := T_DOCF_PROP_CLOB(%d, %d, %d, '%s');";
			$sql .= "\n  -- ЗНАЧЕНИЯ ДОКУМЕНТА\n";
			foreach ($vals as $key => $v) {
				if ($v[status] == 0)
					continue; // пропускаем не измененные значения
				for ($i=0, $j=count($v[data]); $i < $j; $i++) {
					// 1. Сохраняем существующие значения, которые были изменены
					//$sql .= "  DOCF_VALUES$.EXTEND; DOCF_VALUES$(DOCF_VALUES$.LAST) := T_DOCF_PROP_VALUE(".$this->document_id.",".$v[data][$i][DOCPROP_ID].",".$v[data][$i][PLURAL].",'".$v[data][$i][V0]."','".$v[data][$i][V1]."','".$v[data][$i][V2]."'); \n";
					
					if (is_string($v['data'][$i]['V0'])) {
						$v['data'][$i]['V0'] = str_replace("'", "''", $v['data'][$i]['V0']);
					}
					
					if (is_string($v['data'][$i]['V1'])) {
						$v['data'][$i]['V1'] = str_replace("'", "''", $v['data'][$i]['V1']);
					}
					
					if (is_string($v['data'][$i]['V2'])) {
						$v['data'][$i]['V2'] = str_replace("'", "''", $v['data'][$i]['V2']);
					}

					//Надо писать в CLOB, если длина строки в байтах больше 3000
					if (strlen($v['data'][$i]['V0']) > 3000) {
						$new_V0 = wordwrap($v['data'][$i]['V0'], 32000, "' " . PHP_EOL . "|| '");
						$sql .= "  " . sprintf($rawSqlLarge,
											   $this->document_id,
											   $v['data'][$i]['DOCPROP_ID'],
											   $v['data'][$i]['PLURAL'],
											   $new_V0) . " \n";
						//в v0 пишем начало, отрезаем в mb_substr, чтобы не разрезать русскую букву
						$cut_V0 = mb_substr($v['data'][$i]['V0'], 0, 1500);
						$sql .= "  " . sprintf($rawSql,
											   $this->document_id,
											   $v['data'][$i]['DOCPROP_ID'],
											   $v['data'][$i]['PLURAL'],
											   $cut_V0,
											   "",
											   "") . " \n";
					} else {
						$sql .= "  " . sprintf($rawSql,
											   $this->document_id,
											   $v['data'][$i]['DOCPROP_ID'],
											   $v['data'][$i]['PLURAL'],
											   $v['data'][$i]['V0'],
											   $v['data'][$i]['V1'],
											   $v['data'][$i]['V2']) . " \n";
					}
				}
			}
			$sql .= "\n  -- ЗНАЧЕНИЯ ДОКУМЕНТА -- конец\n";
		}
		
		if (count($refs) > 0) {
			$sql .= "\n  -- ССЫЛОЧНЫЕ ПОЛЯ ДОКУМЕНТА\n";
			for ($i = 0; $i < count($refs); $i++) {
				// Сохраняем только существующие значения!!!
				switch ($refs[$i][FLAGS]) {
					case 'NEW': // добавление значения (1)
						$sql .= "  DOCF_REFS$.EXTEND;  DOCF_REFS$(DOCF_REFS$.LAST) := T_DOCF_REF_VALUE('',".$this->document_id.",".$refs[$i][DOCPROPSOURCE_ID].",'".$refs[$i][DOCTARGET_ID]."', 1); \n";
						//echo "REF v[".$j."]=".$v0[$j]." v1=".$v1." v2=".$v2."<br>";
					break;
					case 'TODELETE': // удаление значения (-1)
						$sql .= "  DOCF_REFS$.EXTEND;  DOCF_REFS$(DOCF_REFS$.LAST) := T_DOCF_REF_VALUE('',".$this->document_id.",".$refs[$i][DOCPROPSOURCE_ID].",'".$refs[$i][DOCTARGET_ID]."', -1); \n";
						//echo "REF v[".$j."]=".$v0[$j]." v1=".$v1." v2=".$v2."<br>";
					break;
				}
			}
			$sql .= "\n  -- ССЫЛОЧНЫЕ ПОЛЯ ДОКУМЕНТА -- конец\n";
		}
		
		// конец sql выражения
		$sql .= $endsql;
		//echo '<pre>'.$sql.'</pre>';
		// запускаем...
		//$stmt = ociparse($conn, $sql);
		//ociexecute ($stmt, OCI_DEFAULT);
		//ocicommit($conn);
		//ocifreestatement($stmt);
		self::$sqls []= $sql;
		$res = 0;
		$err = "";
		//$err = "Документ сохранен!";
		utls::logStr('SD_'.$this->document_id, 'SQL: ' . "\n".str_repeat('=',50)."\n" . $sql . "\n".str_repeat('=',50)."\n");
		utls::logStr('SD_'.$this->document_id, 'STOP save prepare. Result=' . $res);
		return $res;
	}

    public function save_commit()
    {
		utls::logTimeStr('SD_'.$this->document_id, 'START save commit');
		utls::logStr('SD_'.$this->document_id, 'SQLS: ' . "\n".str_repeat('=',50)."\n" . print_r(self::$sqls, true) . "\n".str_repeat('=',50)."\n");
		
		global $conn;
		global $PROPKIND_REF;
		global $PROPKIND_BREF;
		//global $USER_ID;        // ID пользователя
		global $USER_LOGIN_REGIME;
		$sql  = "DECLARE \n";
			$sql .= "  CHECK_PERMISSIONS BOOLEAN := SYS.DIUTIL.INT_TO_BOOL(1); \n";
			$sql .= "  IDENTIFY          BOOLEAN := SYS.DIUTIL.INT_TO_BOOL(0); \n";
			$sql .= "  DOCF_VALUES$      T_DOCF_PROP_VALUES := T_DOCF_PROP_VALUES(); \n";
			$sql .= "  DOCF_REFS$        T_DOCF_REF_VALUE_LIST := T_DOCF_REF_VALUE_LIST(); \n";
			$sql .= "  DOCF_CLOB$        T_DOCF_PROP_CLOBS; \n";
			$sql .= "  DLIST             T_NUMBER_LIST; \n";
			$sql .= "  ERR_MSG$          VARCHAR2(1000); \n";
			$sql .= "  RESULT$           NUMBER; \n";
			$sql .= "BEGIN \n";
			//$sql .= "  DOCUMENTS.REGISTER_USER(".$USER_ID.",2); \n";
			$sql .= "  DOCUMENTS.REGISTER_USER(".$this->getUserId().",2); \n";
			
			$endsql = "  -- Установка статуса saved...\n  SET_STATUS(".$this->document_id.", GET_DOCEVENTKIND_ID('SAVED'), TRUE);\nEND;";
			// собираем значения...
		$sql .= join("\n", self::$sqls);
			$sql .= $endsql;
			//echo '<pre>'.$sql.'</pre>';
	
		utls::logStr('SD_'.$this->document_id, 'TRANSACTION: ' . "\n".str_repeat('=',50)."\n" . $sql."\n".str_repeat('=',50)."\n");
		
		try {
			// запускаем...
			$stmt = ociparse($conn, $sql);
			ociexecute ($stmt, OCI_DEFAULT);
			ocicommit($conn);
			ocifreestatement($stmt);
		} catch(Exception $e) {
			utls::logStr('SD_'.$this->document_id, 'STOP save commit. Error: ' . $e->getMessage());
			throw $e;
		}
		$res = 0;
		$err = "";
		////$err = "Документ сохранен!";
	
		utls::logStr('SD_'.$this->document_id, 'STOP save commit. Succ!');
		return $res;
    }


	protected function getUserId()
	{
		global $currentUser;
		//return $currentUser->userId();
		return $currentUser->getSystemUserId();
	}

  } // SimpleDocument


?>