<?php
// POPUP-КОНТРОЛЫ ДЛЯ ФОРМАЛИЗОВАННЫХ ДОКУМЕНТОВ
// редактирование формализованного документа для WEB-формы интерфейса
// Версия 1.0
// © Molochnikov Mikhail, mikhail@molochnikov.com
// дата начала разработки PHP-версии: 25.02.2003


// Возвращает html для попапа
// $doc - объект классы simpledocument
// $index - номер в списке реквизитов
function get_popup($doc, $index, $options, $width = 200)
{
  global $EXTPATH;

  $html = '';
  $doc_id = $doc->document_id;
  // получаем свойства реквизита..
  $prop_id = $doc->properties[DOCPROP_ID][$index];
  $prop_name = $doc->properties[DOCPROP_NAME][$index];
  $prop_namevar = $doc->properties[DOCPROP_DESCR][$index];
  $prop_type =   $doc->properties[DOCPROP_KIND][$index];
  $prop_object = $doc->properties[DOCPROP_OBJECT][$index];

  $visible = $doc->properties[DOCPROP_VISIBLE][$index];
  $notnull = $doc->properties[DOCPROP_NOTNULL][$index];
  $multi = $doc->properties[DOCPROP_MULTI][$index];
  // XML для ссылочных полей
  $ref_xml = $doc->properties[REF_XML][$index];
  $ref_column = $doc->properties[REF_COLUMN][$index];
  // SQL для ссылочных полей
  $ref_sql = $doc->properties[REF_SQL][$index];

  // Значение
  $display = $doc->get_display_value($prop_id);
  $value = get_value($doc, $prop_id);
  $ref_value = get_ref_value($doc, $prop_id);
  // значение (для простого реквизита
  $v0 = $value[V0][0];
  $v1 = $value[V1][0];
  $v2 = $value[V2][0];
  // одиночная ссылка
  $ref0 = $ref_value[DOCTARGET_ID][0];
  // echo '<br>ref0='.$ref0;

  // класс
  // input, если не обязательное, required если обязательно
  if ($notnull == 1) {
  	$fclass = 'required';
  	$ftitle = ' title="Обязательное поле" ';
  } else {
  	$fclass = 'input';
  	$ftitle = '';
  }
  // Наименование контрола
  // P_DOCID_PROPNAMEVAR
  $control_name = "P_".$doc_id."_".$prop_namevar;
  switch ($prop_type) {
    case 1: {// =============== ПРОСТЫЕ ТИПЫ ДАННЫХ ===============
      //echo $prop_object;
      switch ($prop_object) {
        // ЧИСЛОВЫЕ
        case 11: // стандартная запись числа
          // class='input' style='width:200px; padding-top:0px;'
          $html .= "<input type='text' id='".$prop_namevar."' name='".$control_name."' value='".$v0."' ".$options." class='".$fclass."' $ftitle style='width:".$width."px; padding-top:0px;' onKeypress='checknum();'>";
          break;
        case 12: // число с допуском (xxxx +/- yyyy)
          $html .= "<input type='text' id='".$prop_namevar."' name='".$control_name."' value='".$v0."' class='".$fclass."' $ftitle style='width:88px; padding-top:0px;' onKeypress='checknum();'> <b>+</b> <input type='text' name='".$control_name."_1' value='".$v1."' class='".$fclass."' style='width:40px; padding-top:0px;' onKeypress='checknum();'> <b>-</b> <input type='text' name='".$control_name."_2' value='".$v2."' class='".$fclass."' style='width:40px; padding-top:0px;' onKeypress='checknum();'>";
          break;
        case 13: // интервал (от ... до ...)
          $html .="от <input type='text' id='".$prop_namevar."' name='".$control_name."' value='".$v0."' class='".$fclass."' $ftitle style='width:80px; padding-top:0px;' onKeypress='checknum();'> до <input type='text' name='".$control_name."_1' value='".$v1."' class='".$fclass."' style='width:80px; padding-top:0px;' onKeypress='checknum();'>";
          break;
        case 14: // размер (x ... y ... z ...)
          $html .= "Х=<input type='text' id='".$prop_namevar."' name='".$control_name."' value='".$v0."' class='".$fclass."' $ftitle style='width:61px; padding-top:0px;' onKeypress='checknum();'>&nbsp;Y=<input type='text' id='".$prop_namevar."' name='".$control_name."_1' value='".$v1."' class='".$fclass."' style='width:40px; padding-top:0px;' onKeypress='checknum();'>&nbsp;Z=<input type='text' id='".$prop_namevar."' name='".$control_name."_2' value='".$v2."' class='".$fclass."' style='width:40px; padding-top:0px;' onKeypress='checknum();'>";
          break;
        case 15: // цвет
          $html .= $display;
          break;
        // ДЕНЕЖНЫЙ
        case 2: // денежный
          $html .= "<input type='text' id='".$prop_namevar."' name='".$control_name."' value='".$v0."' class='".$fclass."' $ftitle style='width:".$width."px; padding-top:0px;' onKeypress='checknum();'>";
          break;
        // ДАТА И ВРЕМЯ
        case 31: // полный (дата + время)
          $html .= "<input type='text' style='width:75px; padding-top:0px;' class='".$fclass."' id='".$prop_namevar."' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='".$EXTPATH."formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''></a>";
          $html .= "&nbsp;&nbsp;<input type='text' name='".$control_name."_HH' value='".get_str_hour($v0)."' class='".$fclass."' style='width:30px; padding-top:0px;' onKeypress='checknum();'>&nbsp;";
          $html .= ":&nbsp;<input type='text' id='".$prop_namevar."' name='".$control_name."_MM' value='".get_str_min($v0) ."' class='".$fclass."' style='width:30px; padding-top:0px;' onKeypress='checknum();'>&nbsp;";
          $html .= ":&nbsp;<input type='text' id='".$prop_namevar."' name='".$control_name."_SS' value='".get_str_sec($v0) ."' class='".$fclass."' style='width:30px; padding-top:0px;' onKeypress='checknum();'>&nbsp;";
          break;
        case 32: // полный (дата + время)
          $html .= "<input type='text' style='width:75px; padding-top:0px;' class='".$fclass."' $ftitle id='".$prop_namevar."' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='".$EXTPATH."formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''></a>";
          break;
        case 33: // время
          $html .= "<input type='text' style='width:75px; padding-top:0px;' class='".$fclass."' $ftitle id='".$prop_namevar."' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='".$EXTPATH."formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''></a>";
          break;
        case 34: // дата (год и месяц)
          $year = substr($v0, 6, 4);
          $html .= "<select id='".$prop_namevar."' name='".$control_name."_MM' class='".$fclass."' $ftitle>";
          $html .= "  <option value=''></option>";
          for ($i = 1; $i <= 12; $i++) {
            if ($i == 1)
              // Специально для Романа из Брига - месяц по умолчанию - январь.
              $html .= "  <option value=".(int)$i." selected>".get_month_name($i, 1)."</option>";
            else
              $html .= "  <option value=".(int)$i.">".get_month_name($i, 1)."</option>";
          }
          $html .= "</select>";
          $html .= "<select id='".$prop_namevar."' name='".$control_name."_YYYY' class='".$fclass."' $ftitle>";
          $html .= "  <option value=''></option>";
          for ($i = 2010; $i >= 1980; $i--) {
            if ($i == $year) $sel = ' selected '; else $sel = '';
            $html .= "  <option value=\"".(int)$i."\" ".$sel.">".$i."</option>";
          }
          $html .= "</select>";
          break;
        case 35: // дата (год)
          $year = substr($v0, 6, 4);
          $html .= "<select id='".$prop_namevar."' name='".$control_name."_YYYY' class='".$fclass."' $ftitle>";
          $html .= "  <option value=''></option>";
          for ($i = 2010; $i >= 1980; $i--) {
            if ($i == $year) $sel = ' selected '; else $sel = '';
            $html .= "  <option value=\"".(int)$i."\" ".$sel.">".$i."</option>";
          }
          $html .= "</select>";
          break;
        // ТЕКСТОВЫЙ
        case 4: // текстовый
          if (strlen($v0) < 50) {
            $html .= "<input id='".$prop_namevar."' type='text' name='".$control_name."' value='".$v0."' class='".$fclass."' $ftitle $options style='width:".$width."px; padding-top:0px;'>";
          } else {
            $html .= "<textarea id='".$prop_namevar."' name='".$control_name."' WRAP='physical' $options COLS=55 ROWS=4>".$v0."</textarea>";
          };
          break;
        // ЛОГИЧЕСКИЙ
        case 5: // логический
          // определение, что должно быть отмечено
          // Вариант 1: радио (работающий)
          // определение, что должно быть отмечено
          // if ($v0 == "0") {$v_no_checked = "checked";} else {if ($v0 == "1") {$v_yes_checked = "checked";}};
          // $html .= "<input type='radio' name='".$control_name."' value='1' ".$v_yes_checked.">Да&nbsp;&nbsp;&nbsp;<input type='radio' name='".$control_name."' value='0' ".$v_no_checked.">Нет";

          // Вариант 2: галочка
          // определение, что должно быть отмечено
          if ($v0 == "0") {$v_checked = "";} else {if ($v0 == "1") {$v_checked = "checked=\"checked\"";}};
          // class='".$fclass."' - не ставим, поскольку некорректно обрабатывается обязательными полями
          $html .= "<input type='checkbox' id='".$prop_namevar."' name='".$control_name."' value='1' ".$v_checked." ".$options.">";

          break;
      }
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      break;
    }
    case 9: {// ===============ССЫЛОЧНЫЙ ТИП ДАННЫХ ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= get_ref_popup($doc, $index, $ref_xml, $ref_column, $ref_sql, $ref_value, $multi, $notnull, $prop_namevar, $control_name, $options);

      break;
    }
    case 10: {// =============== СЛОВАРНЫЙ ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= get_vocab_popup($prop_object, $v0, $multi, $notnull, $prop_namevar, $control_name, $options, $width, $height);
      break;
    }
    case 11: {// =============== ВЫБОРКА ИЗ ТАБЛИЦЫ ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 12: {// =============== ОБРАТНАЯ ССЫЛКА ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 16: {// =============== МЕДИА ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 17: {// =============== СЧЕТЧИК ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 18: {// =============== ОТОБРАЖЕНИЕ ПОЛЯ ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 19: {// =============== СИСТЕМНАЯ ФУНКЦИЯ ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 20: {// =============== СПРАВОЧНИК - КЛАССИФИКАТОР ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 21: {// =============== СПРАВОЧНИК - ПАРАМЕТРЫ ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }

  }
  //echo htmlspecialchars($html)."<br>";
  return $html;

}


// Возвращает html для попапа
// $doc - объект классы simpledocument
// $index - номер в списке реквизитов
function get_popup_ex($doc_id, $doc_prop_name, $doc_kind_name, $width, $height)
{
  global $conn;
  global $EXTPATH;

  $html = '';

  // получим prop_id
  $sql = "SELECT GET_DOCPROPID_BYNAME('$doc_prop_name', '$doc_kind_name') AS DOCPROPID FROM DUAL" ;
  $stmt = ociparse($conn, $sql);
          ociexecute ($stmt);
          ocifetch($stmt);
  $prop_id = ociresult($stmt, "DOCPROPID");
  ocifreestatement($stmt);

  // получим остальные свойства реквизита...
  $sql = "SELECT DOCPROP_NAME,
       DOCPROP_DESCR AS DOCPROP_NAMEVAR,
       DOCPROP_KIND,
       DOCPROP_OBJECT,
       DOCPROP_VISIBLE,
       DOCPROP_NOTNULL,
       DOCPROP_MULTI
  FROM DOC_KIND_PROPERTIES
 WHERE DOCPROP_ID = $prop_id";
  //echo $sql;
  $stmt = ociparse($conn, $sql);
          ociexecute ($stmt);
          ocifetch($stmt);

  $prop_name =    ociresult($stmt, "DOCPROP_NAME");
  $prop_namevar = ociresult($stmt, "DOCPROP_DESCR");
  $prop_type =    ociresult($stmt, "DOCPROP_KIND");
  $prop_object =  ociresult($stmt, "DOCPROP_OBJECT");
  $visible =      ociresult($stmt, "DOCPROP_VISIBLE");
  $notnull =      ociresult($stmt, "DOCPROP_NOTNULL");
  $multi =        ociresult($stmt, "DOCPROP_MULTI");

  // Значение
  $values = get_values_list($doc_id, $prop_id);
  //print_r($values);

  $display = $values[DISPLAY][0];
  $v0 = $values[V0][0];
  $v1 = $values[V1][0];
  $v2 = $values[V2][0];

  // Наименование контрола
  // P_DOCID_PROPNAMEVAR
  $control_name = "P_".$doc_id."_".$prop_namevar;
  switch ($prop_type) {
    case 1: {// =============== ПРОСТЫЕ ТИПЫ ДАННЫХ ===============
      switch ($prop_object) {
        // ЧИСЛОВЫЕ
        case 11: // стандартная запись числа
          $html .= "<input type='text' name='".$control_name."' value='".$v0."' class='input' style='width:".$width."px; padding-top:0px;' onKeypress='checknum();'>";
          break;
        case 12: // число с допуском (xxxx +/- yyyy)
          $html .= "<input type='text' name='".$control_name."' value='".$v0."' class='input' style='width:88px; padding-top:0px;' onKeypress='checknum();'> <b>+</b> <input type='text' name='".$control_name."_1' value='".$v1."' class='input' style='width:40px; padding-top:0px;' onKeypress='checknum();'> <b>-</b> <input type='text' name='".$control_name."_2' value='".$v2."' class='input' style='width:40px; padding-top:0px;' onKeypress='checknum();'>";
          break;
        case 13: // интервал (от ... до ...)
          $html .="от <input type='text' name='".$control_name."' value='".$v0."' class='input' style='width:80px; padding-top:0px;' onKeypress='checknum();'> до <input type='text' name='".$control_name."_1' value='".$v1."' class='input' style='width:80px; padding-top:0px;' onKeypress='checknum();'>";
          break;
        case 14: // размер (x ... y ... z ...)
          $html .= "Х=<input type='text' name='".$control_name."' value='".$v0."' class='input' style='width:61px; padding-top:0px;' onKeypress='checknum();'>&nbsp;Y=<input type='text' name='".$control_name."_1' value='".$v1."' class='input' style='width:40px; padding-top:0px;' onKeypress='checknum();'>&nbsp;Z=<input type='text' name='".$control_name."_2' value='".$v2."' class='input' style='width:40px; padding-top:0px;' onKeypress='checknum();'>";
          break;
        case 15: // цвет
          $html .= $display;
          break;
        // ДЕНЕЖНЫЙ
        case 2: // денежный
          $html .= "<input type='text' name='".$control_name."' value='".$v0."' class='input' style='width:".$width."px; padding-top:0px;' onKeypress='checknum();'>";
          break;
        // ДАТА И ВРЕМЯ
        case 31: // полный (дата + время)
          $html .= "<input type='text' style='width:75px; padding-top:0px;' class='input' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='".$EXTPATH."formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''></a>";
          $html .= "&nbsp;&nbsp;<input type='text' name='".$control_name."_HH' value='".get_str_hour($v0)."' class='input' style='width:30px; padding-top:0px;' onKeypress='checknum();'>&nbsp;";
          $html .= ":&nbsp;<input type='text' name='".$control_name."_MM' value='".get_str_min($v0) ."' class='input' style='width:30px; padding-top:0px;' onKeypress='checknum();'>&nbsp;";
          $html .= ":&nbsp;<input type='text' name='".$control_name."_SS' value='".get_str_sec($v0) ."' class='input' style='width:30px; padding-top:0px;' onKeypress='checknum();'>&nbsp;";
          break;
        case 32: // полный (дата + время)
          $html .= "<input type='text' style='width:75px; padding-top:0px;' class='input' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='".$EXTPATH."formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''></a>";
          break;
        case 33: // время
          $html .= "<input type='text' style='width:75px; padding-top:0px;' class='input' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='".$EXTPATH."formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''></a>";
          break;
        case 34: // дата (год и месяц)
          //$html .= "<input type='text' style='width:75px; padding-top:0px;' class='input' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='".$EXTPATH."formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''></a>";
          //$html .= "<input type='text' style='width:75px; padding-top:0px;' class='input' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='".$EXTPATH."formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''></a>";
          break;
        // ТЕКСТОВЫЙ
        case 4: // текстовый
          if ($height > 0) {
            $html .= "<input type='text' name='".$control_name."' value='".$v0."' class='input' style='width:".$width."px;height:".$height."px; padding-top:0px;'>";
          } else {
            $html .= "<textarea name='".$control_name."' WRAP='physical' COLS=55 ROWS=4>".$v0."</textarea>";
          };
          break;
        // ЛОГИЧЕСКИЙ
        case 5: // логический
          // Вариант 1: радио (работающий)
          // определение, что должно быть отмечено
          // if ($v0 == "0") {$v_no_checked = "checked";} else {if ($v0 == "1") {$v_yes_checked = "checked";}};
          // $html .= "<input type='radio' name='".$control_name."' value='1' ".$v_yes_checked.">Да&nbsp;&nbsp;&nbsp;<input type='radio' name='".$control_name."' value='0' ".$v_no_checked.">Нет";

          // Вариант 2: галочка
          // определение, что должно быть отмечено
          if ($v0 == "0") {$v_checked = "";} else {if ($v0 == "1") {$v_checked = "checked=\"checked\"";}};
          $html .= "<input type='checkbox' name='".$control_name."' value='1' ".$v_checked.">";

          break;
      }
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      break;
    }
    case 9: {// ===============ССЫЛОЧНЫЙ ТИП ДАННЫХ ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      //$html .= get_ref_popup($doc, $index);
      break;
    }
    case 10: {// =============== СЛОВАРНЫЙ ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= get_vocab_popup($prop_object, $v0, $multi, $notnull, $prop_namevar, $control_name, $width, $height);
      break;
    }
    case 11: {// =============== ВЫБОРКА ИЗ ТАБЛИЦЫ ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 12: {// =============== ОБРАТНАЯ ССЫЛКА ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 16: {// =============== МЕДИА ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 17: {// =============== СЧЕТЧИК ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 18: {// =============== ОТОБРАЖЕНИЕ ПОЛЯ ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 19: {// =============== СИСТЕМНАЯ ФУНКЦИЯ ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 20: {// =============== СПРАВОЧНИК - КЛАССИФИКАТОР ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }
    case 21: {// =============== СПРАВОЧНИК - ПАРАМЕТРЫ ===============
      //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
      $html .= $display;
      break;
    }

  }
  //echo htmlspecialchars($html)."<br>";
  return $html;

}



function get_vocab_popup($vocab_name, $value_code, $multi, $notnull, $prop_namevar, $control_name, $options, $width = 200, $height = 0) {
  // возвращает html для popup-контрола

  $html = '';
  // input, если не обязательное, required если обязательно
  if ($notnull == 1) {
  	$fclass = 'required';
  	$ftitle = ' title="Обязательное поле" ';
  } else {
  	$fclass = 'input';
  	$ftitle = '';
  }
  $voc = get_vocab_values_list($vocab_name);
  //print_r($voc);
  $html .= "<select id='".$prop_namevar."' name=".$control_name." ".$options." class='".$fclass."' $ftitle style='width:".$width."px'>";
  $html .= "<option value=''></option>";

  for ($i = 0; $i < count($voc); $i++) {
    $code = $voc[$i][CODE];
    $value = $voc[$i][VALUE];
    $value_id = $voc[$i][VALUE_ID];
    $parent = $voc[$i][PARENT];

    if ($code == $value_code) {$selected = "selected";} else {$selected = "";};
    $html .= "<option value='$code' $selected>$value</option>";
  }
  $html .= "</select>";
  return $html;
}

function get_ref_popup($doc, $index, $xml, $column_view, $sql, $ref_value, $multi, $notnull, $prop_namevar, $control_name, $options, $width = 200, $height = 0) {
  // возвращает html для popup-контрола - ссылочного типа
  // column_view - наименование колонки (UPPERCASE!!!) для выдачи в выпадающем списке
  //echo '<br>index='.$index;
  //echo '<br>sql='.$sql;
  //echo '<br>xml='.$xml;

  $html = '';
  //if ($xml == '') {echo "exit"; return $html; exit;}
    // input, если не обязательное, required если обязательно
  if ($notnull == 1) {
  	$fclass = 'required';
  	$ftitle = ' title="Обязательное поле" ';
  } else {
  	$fclass = 'input';
  	$ftitle = '';
  }

  $html .= "<select id='".$prop_namevar."' name=".$control_name." ".$options." class='".$fclass."' $ftitle style='width:".$width."px'>";
  $html .= "<option value=''></option>";

  if (($xml <> '') or ($sql <> '')) {
  //if ($sql <> '') {
    // читаем выпадающий список
    $refs = get_ref_values_list($xml, $column_view, $sql);
    //print_r($refs);

    for ($i = 0; $i < count($refs); $i++) {
      $id = $refs[$i][DOCUMENT_ID];
      $value = $refs[$i][$column_view];
      //$value_id = $refs[$i][VALUE_ID];
      $parent = $refs[$i][PARENT];
      // текущее значение
      if ($id == $ref_value[DOCTARGET_ID][0]) {$selected = "selected";} else {$selected = "";};
      $html .= "<option value='$id' $selected>$value</option>";
    }
  } else {
    // текущее значение - $ref0
    $html .= "<option value='".$ref_value[DOCTARGET_ID][0]."' selected>".$ref_value[DOC_NAME][0]."</option>";
  }
  $html .= "</select>";
  return $html;
}

function get_ref_popup_lite($xml, $column_view, $sql, $ref_value, $multi, $notnull, $prop_namevar, $control_name, $options, $width = 200, $height = 0) {
  // возвращает html для popup-контрола - ссылочного типа
  // column_view - наименование колонки (UPPERCASE!!!) для выдачи в выпадающем списке
  $html = '';
  if ($xml == '') {return $html; exit;}
  // input, если не обязательное, required если обязательно
  if ($notnull == 1) {
  	$fclass = 'required';
  	$ftitle = ' title="Обязательное поле" ';
  } else {
  	$fclass = 'input';
  	$ftitle = '';
  }
  //echo '<pre>index='.$index.' xml='.$xml.'</pre>';
  $refs = get_ref_values_list($xml, $column_view, $sql);
  //print_r($refs);

  $html .= "<select id='".$prop_namevar."' name=".$control_name." ".$options." class='".$fclass."' $ftitle style='width:".$width."px'>";
  $html .= "<option value=''></option>";

  for ($i = 0; $i < count($refs); $i++) {
    $id = $refs[$i][DOCUMENT_ID];
    $value = $refs[$i][$column_view];
    $parent = $refs[$i][PARENT];
    if ($id == $ref_value) {$selected = "selected";} else {$selected = "";};
    $html .= "<option value='$id' $selected>$value</option>";
  }
  $html .= "</select>";
  return $html;
}

function get_str_date($str)
// возвращает дату из строки 28.07.2005^00:00:00 -> 28.07.2005
{
  $res = substr($str, 0, strpos($str, '^'));
  return $res;
}
function get_str_hour($str)
// возвращает дату из строки 28.07.2005^00:00:00 -> 28.07.2005
{
  $res = substr($str, strpos($str, '^') + 1, 2);
  return $res;
}
function get_str_min($str)
// возвращает дату из строки 28.07.2005^00:00:00 -> 28.07.2005
{
  $res = substr($str, strpos($str, '^') + 4, 2);
  return $res;
}
function get_str_sec($str)
// возвращает дату из строки 28.07.2005^00:00:00 -> 28.07.2005
{
  $res = substr($str, strpos($str, '^') + 7, 2);
  return $res;
}

  // возвращает значения из Post-переменной
  function get_posted_values2($doc_id, $prop_id, $prop_namevar, $prop_type, $prop_object, $multi, &$v, &$v1, &$v2)
  {
    global $EXTPATH;

    $v = '';
    $v1 = '';
    $v2 = '';
    $res = false;

    // P_DOCID_PROPNAMEVAR
    $control_name = "P_".$doc_id."_".$prop_namevar;
    //echo $control_name."<br>";
    //print_r($_POST);


    switch ($prop_type) {
      case 1: {// =============== ПРОСТЫЕ ТИПЫ ДАННЫХ ===============
        switch ($prop_object) {
          // ЧИСЛОВЫЕ
          case 11: // стандартная запись числа
            $res = get_posted_values_ex($control_name, '', '', $v, $v1, $v2);
            break;
          case 12: // число с допуском (xxxx +/- yyyy)
            $res = get_posted_values_ex($control_name, $control_name."_1", '', $v, $v1, $v2);
            break;
          case 13: // интервал (от ... до ...)
            $res = get_posted_values_ex($control_name, $control_name."_1", '', $v, $v1, $v2);
            break;
          case 14: // размер (x ... y ... z ...)
            $res = get_posted_values_ex($control_name, $control_name."_1", $control_name."_1", $v, $v1, $v2);
            break;
          case 15: // цвет
            $res = get_posted_values_ex($control_name, '', '', $v, $v1, $v2);
            break;
          // ДЕНЕЖНЫЙ
          case 2: // денежный
            $res = get_posted_values_ex($control_name, '', '', $v, $v1, $v2);
            break;
          // ДАТА И ВРЕМЯ
          /*case 31: // полный (дата + время)


            $html .= "<input type='text' style='width:75px; padding-top:0px;' class='input' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''></a>";
            $html .= "&nbsp;&nbsp;<input type='text' name='".$control_name."_HH' value=".get_str_hour($v0)." class='input' style='width:30px; padding-top:0px;' onKeypress='checknum();'>&nbsp;";
            $html .= ":&nbsp;<input type='text' name='".$control_name."_MM' value=".get_str_min($v0) ." class='input' style='width:30px; padding-top:0px;' onKeypress='checknum();'>&nbsp;";
            $html .= ":&nbsp;<input type='text' name='".$control_name."_SS' value=".get_str_sec($v0) ." class='input' style='width:30px; padding-top:0px;' onKeypress='checknum();'>&nbsp;";
            break;
          case 32: // полный (дата + время)
            $html .= "<input type='text' style='width:75px; padding-top:0px;' class='input' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''>";
            break;
          case 33: // время
            $html .= "<input type='text' style='width:75px; padding-top:0px;' class='input' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''>";
            break; */
          case 34: // дата (год и месяц)
            $res = get_posted_values_date($control_name, $prop_type, $prop_object, $v, $v1, $v2);
            //$html .= "<input type='text' style='width:75px; padding-top:0px;' class='input' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''>";
            break;
          case 35: // дата (год)
            $res = get_posted_values_date($control_name, $prop_type, $prop_object, $v, $v1, $v2);
            //$html .= "<input type='text' style='width:75px; padding-top:0px;' class='input' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''>";
            break;
          // ТЕКСТОВЫЙ
          case 4: // текстовый
            $res = get_posted_values_ex($control_name, '', '', $v, $v1, $v2);
            break;
          // ЛОГИЧЕСКИЙ
          case 5: // логический
            $res = get_posted_values_ex($control_name, '', '', $v, $v1, $v2);
            break;
        }
        break;
      }
      case 9: {// ===============ССЫЛОЧНЫЙ ТИП ДАННЫХ ===============
        //echo "REF NOW! MULTI=".$multi."\n";
        // поддерживаем только одиночные ссылки
        //echo "reff";
        if ($multi == 0) {
          $res = get_posted_values_ex($control_name, '', '', $v, $v1, $v2);
        } else {
          $res = get_posted_values_multi($control_name, '', '', $v, $v1, $v2);
        }
        break;
      }
      case 10: {// =============== СЛОВАРНЫЙ ===============
        //echo "vocab";
        $res = get_posted_values_ex($control_name, '', '', $v, $v1, $v2);
        break;
      }
      case 11: {// =============== ВЫБОРКА ИЗ ТАБЛИЦЫ ===============
        $res = get_posted_values_ex($control_name, '', '', $v, $v1, $v2);
        break;
      }
      case 12: {// =============== ОБРАТНАЯ ССЫЛКА ===============
        //$html .= $display;
        break;
      }
      case 16: {// =============== МЕДИА ===============
        //$html .= $display;
        break;
      }
      case 17: {// =============== СЧЕТЧИК ===============
        //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
        //$html .= $display;
        break;
      }
      case 18: {// =============== ОТОБРАЖЕНИЕ ПОЛЯ ===============
        //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
        //$html .= $display;
        break;
      }
      case 19: {// =============== СИСТЕМНАЯ ФУНКЦИЯ ===============
        //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
        //$html .= $display;
        break;
      }
      case 20: {// =============== СПРАВОЧНИК - КЛАССИФИКАТОР ===============
        //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
        //$html .= $display;
        break;
      }
      case 21: {// =============== СПРАВОЧНИК - ПАРАМЕТРЫ ===============
        //$html .= "<input type='text' name='input1' value='".$input1." class='input' style='width:200px; padding-top:0px;' onKeypress='checknum();'>";
        //$html .= $display;
        break;
      }
    }
    //echo "v=".$v." v1=".$v1." v2=".$v2."<br>";
    return $res;
  }

function get_posted_values_ex($control_name0, $control_name1, $control_name2, &$v0, &$v1, &$v2)
{
  //echo "control_name0=".$control_name0."<br>";
  // проверяем, есть ли контролы
  if ($control_name0 <> '')
  {
    // проверяем только на первое значение. если его нет, то не сохраняем
    if (array_key_exists($control_name0, $_POST))
    {
      //$var = '$_POST['..']';
      $v0 = $_POST[$control_name0];
      //echo "v=".$v0."<br>";
      // остальные
      $v1 = $_POST[$control_name1];
      $v2 = $_POST[$control_name2];
      return true;
    } else
      return false; // не сохраняем такую запись
  }
}

// возхвращает multi-value (только v0 !!!)
// используется для мульти, ссылочные поля
function get_posted_values_multi($control_name0, $control_name1, $control_name2, &$v0, &$v1, &$v2)
{

  global $MAX_CNT_REFS;
  //echo "control_name0=".$control_name0."<br>";
  // проверяем, есть ли контролы
  if ($control_name0 <> '')
  {
    $cnt = 0;
    $v0 = array();
    // проверяем только на первое значение. если его нет, то не сохраняем
    for ($i = 0; $i < 100; $i++)
    {
        $control_name = $control_name0.'_'.$i;
        //echo "cn=".$control_name."<br>";
	    if (array_key_exists($control_name, $_POST))
	    {
	      $cnt++;
	      //$var = '$_POST['..']';
	      array_push($v0, $_POST[$control_name]);
	      //echo "v+".$control_name."=".$_POST[$control_name]."<br>";
	      // остальные
	      //$v1 = $_POST[$control_name1];
	      //$v2 = $_POST[$control_name2];
	      // return true;
	    }
	     // break;//return false; // не сохраняем такую запись
	}

  }
  if ($cnt > 0) {return true;} else {return false;}
}

function get_posted_values_date($control_name, $docprop_kind, $docprop_object, &$v0, &$v1, &$v2)
{
  // функция собирает форматы и преобразует в DD.MM.YYYY
  // проверяем, есть ли контролы
  if ($control_name <> '')
  {
    // проверяем только на первое значение. если его нет, то не сохраняем
        switch ($docprop_object) {
          // ДАТА И ВРЕМЯ
          case 31: // полный (дата + время)
            // доделать!!!
            //$html .= "<input type='text' style='width:75px; padding-top:0px;' class='input' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''></a>";
            //$html .= "&nbsp;&nbsp;<input type='text' name='".$control_name."_HH' value=".get_str_hour($v0)." class='input' style='width:30px; padding-top:0px;' onKeypress='checknum();'>&nbsp;";
            //$html .= ":&nbsp;<input type='text' name='".$control_name."_MM' value=".get_str_min($v0) ." class='input' style='width:30px; padding-top:0px;' onKeypress='checknum();'>&nbsp;";
            //$html .= ":&nbsp;<input type='text' name='".$control_name."_SS' value=".get_str_sec($v0) ." class='input' style='width:30px; padding-top:0px;' onKeypress='checknum();'>&nbsp;";
            break;
          case 32: // полный (дата + время)
            // доделать!!!
            //$html .= "<input type='text' style='width:75px; padding-top:0px;' class='input' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''>";
            break;
          case 33: // время
            // доделать!!!
            //$html .= "<input type='text' style='width:75px; padding-top:0px;' class='input' name='".$control_name."_DD' value='".get_str_date($v0)."' size=12 onfocus='this.blur()' readonly><a href='javascript:void(0)' onclick='if(self.gfPop)gfPop.fPopCalendar(document.mainform.".$control_name."_DD);return false;' HIDEFOCUS><img align='absmiddle' src='formz/daterange/calbtn.gif' width=34 height=22 border=0 alt=''>";
            break;
          case 34: // дата (год и месяц)
            //$dd = $_POST[${$control_name."_DD"}];

            $control_name_dd = $control_name."_DD";
            $control_name_mm = $control_name."_MM";
            $control_name_yyyy = $control_name."_YYYY";
            $mm = $_POST[$control_name_mm];
            $yyyy = $_POST[$control_name_yyyy];
            if (!empty($yyyy)){
              if (empty($mm)) {
              	$mm="01";
              }
              if (strlen($mm) == 1) {
                $mm = "0".$mm;
              }
              $v0 = "01.".$mm.".".$yyyy."^00:00:00";
            } else {
              return false; // не сохраняем такую запись
            }
            break;
          case 35: // дата (год)
            //$dd = $_POST[${$control_name."_DD"}];

            //$control_name_dd = $control_name."_DD";
            //$control_name_mm = $control_name."_MM";
            $control_name_yyyy = $control_name."_YYYY";
            //$mm = $_POST[$control_name_mm];
            $yyyy = $_POST[$control_name_yyyy];
            if (!empty($yyyy)){
              if (empty($mm)) {
              	$mm="01";
              }
              if (strlen($mm) == 1) {
                $mm = "0".$mm;
              }
              $v0 = "01.".$mm.".".$yyyy."^00:00:00";
            } else {
              return false; // не сохраняем такую запись
            }
            break;

        }
    return true;
  }
}

?>