<?php

// КЛАСС ДЛЯ РАБОТЫ С ФОРМАЛИЗОВАННЫМ ДОКУМЕНТООБОРОТОМ ЧЕРЕЗ WEB
// Версия 1.0
// (©) Molochnikov Mikhail, mikhail@molochnikov.com
// дата начала разработки PHP-версии: 25.02.2003
///////////////////////////////////////////////////////////////////////////
// Функции работы с объектами формализованного документооборота
///////////////////////////////////////////////////////////////////////////
// КОНСТАНТЫ
//$USER_ID = 5056;        // ID пользователя
// $USER_ID = 5056;        // ID пользователя
$USER_LOGIN_REGIME = 2;   // Тип регистрации - для register_user()

$STATUS_CREATED = 3853;
$STATUS_DELETED = 3857;

$PROPKIND_REF = 9;
$PROPKIND_BREF = 12;

$MAX_CNT_REFS = 100; // максимальное количество ссылок

function register_user($user_id, $regime = 2) {
// Регистрация пользователя
	ora_proc("DOCUMENTS.REGISTER_USER('$user_id', '$regime')");
}

// Global Const
function geteventid($EventName) {
// возвращает ИД стандартного события
	switch (strtoupper($EventName)) {
		case 'DELETED': return 3857;
		case 'CREATED': return 3853;
	}
}

; // GetEventID

function GetDocKindIDByName($dockind_name) {
// возвращает ИД типа документа по системному наименованию ZAYAVKA -> 1024
	include("db/logon.inc");

	$stmt = OCIParse($conn, "select value_id from vocabs where vocab_id = get_vocab_id('Doc_Kind') and value = '$dockind_name'");

	OCIExecute($stmt);
	OCIFetchstatement($stmt, $res);

	return $res['VALUE_ID'][0];

	if (empty($res['VALUE_ID'][0])) {
		die('<b>GetDocKindIDByName. Тип документа ' . $dockind_name . ' задан неверно!</b>');
	}
	OCILogoff($conn);
}

; //GetDockindByName()

function getdockindid($Document_ID) {
// возвращает ИД типа документа по ИД документа
	include("db/logon.inc");

	$stmt = OCIParse($conn, "select dockind_id from documents_tree where document_id = $Document_ID");

	OCIExecute($stmt);
	OCIFetchstatement($stmt, $res);

	return $res['DOCKIND_ID'][0];

	OCILogoff($conn);
}

; //GetDocKindID()

function get_dockind_name() {
	return $res;
}

function get_dockind_namevar() {
	return $res;
}

function getdocpropidbyname($Dockind_Name, $Docprop_Name) {
// возвращает ИД реквизита по наименованию типа документа и наименованию реквизита
	include("db/logon.inc");

	$sql = "select docprop_id from doc_kind_properties dk where dk.dockind_id =
            (select value_id
             from vocabs
             where vocab_id = get_vocab_id('Doc_Kind') and value = '$Dockind_Name')
          and dk.docprop_descr = '$Docprop_Name'";
	$stmt = OCIParse($conn, $sql);

	OCIExecute($stmt);
	OCIFetchstatement($stmt, $res);

	return $res['DOCPROP_ID'][0];

	OCILogoff($conn);
}

function getdocumentslist($dockind_id, $SQL) {
// возвращает cписок всех документов указанного типа в виде
// [document_id]   [doc_descr]
	include("db/logon.inc");
	$Deleted_Event = GetEventID('Deleted');
	//$stmt=OCIParse($conn, "select DOCUMENT_ID, doc_descr from documents_tree d where d.dockind_id = $dockind_id");
	if (empty($SQL) or $SQL == '') {
		$SQL = "select d.DOCUMENT_ID, d.doc_descr, de.doceventkind_id from documents_tree d, doc_events de
            where d.dockind_id = $dockind_id and de.dockind_id = $dockind_id and d.document_id = de.document_id and de.history = 0 and de.doceventkind_id <> $Deleted_Event";
	};
	$stmt = OCIParse($conn, $SQL);

	OCIExecute($stmt);
	OCIFetchstatement($stmt, $res);

	return $res;

	OCILogoff($conn);
}

; //GetDocumentsList
// Создает документ
// Возвращает ID документа
function create_document($dockind_namevar) {
	$commit = 1;
	$func = "create_document_empty_with_fun('" . $dockind_namevar . "', sys.diutil.int_to_bool(" . $commit . "))";
	// здесь уже не коммитим второй раз
	//$doc_id = exec_func($func, false);
	$doc_id = ora_func($func, false);
	return $doc_id;
}

function get_properties_list($dockind_id, $status_id = '', $cache_level = 1) {
// возвращает cписок всех реквизитов документа  C УЧЕТОМ ДОСТУПА!
	//include("db/logon.inc");
	global $STATUS_CREATED;

	if (empty($status_id)) {
		$status_id = $STATUS_CREATED;
	}
	if (empty($dockind_id)) {
		die('<b>GetPropertiesList. Не задан тип документа!</b>');
	}

	$sql = "SELECT DKP.DOCPROP_ID,
       DKP.DOCKIND_ID,
       (SELECT MU_NAME
          FROM MEASURING_UNIT
         WHERE MEASURING_UNIT.MU_ID = DOC_MU_KIND) AS DOC_MU_NAME,
       DKP.DOC_FORMAT,
       DKP.DOCPROP_DESCR,
       DKP.DOCPROP_NAME,
       DKP.DOCPROP_KIND,
       (SELECT DPE.DOCPROP_VISIBLE
          FROM DOC_PROP_EVENTS DPE
         WHERE DPE.DOCPROP_ID = DKP.DOCPROP_ID
           AND DPE.DOCEVENTKIND_ID = $status_id) DOCPROP_VISIBLE,
       (SELECT DPE1.DOCPROP_NOTNULL
          FROM DOC_PROP_EVENTS DPE1
         WHERE DPE1.DOCPROP_ID = DKP.DOCPROP_ID
           AND DPE1.DOCEVENTKIND_ID = $status_id) DOCPROP_NOTNULL,
       DKP.DOCPROP_UNIQUE,
       DKP.DOCPROP_OBJECT,
       DKP.DOCPROP_REPEAT,
       DKP.DOCPROP_MULTI,
       DKP.DOCPROP_SQL,
       DKP.SHOW_ORDER,
       DKP.DOCPROP_FPATH,
       NVL(DKN.SHOW_ORDER, -1) AS DOCPROP_DISPLAY_ORDER,
       DKN.NAME_PREFIX || CHR(4) || DKN.NAME_SUFFIX AS DOCPROP_DISPLAY_COMMENT,
       get_refxml_simple(DKP.DOCPROP_ID, DKP.DOCPROP_KIND) as REF_XML,
       '' as REF_SQL,
       '' as REF_COLUMN,
       '' as REF_COMBO,
       DOCUMENTS.DOCF_CHECK_PERMISSIONS(2,
                                         $dockind_id,
                                         $status_id,
                                         DKP.DOCPROP_ID,
                                         NULL) as IS_WRITEBLE,
 (SELECT COUNT(D.DEPENDENT_DOCPROP_ID)
    FROM DOC_KIND_PROP_DEPENDENCIES D
   START WITH D.DEPENDENT_DOCPROP_ID = DKP.DOCPROP_ID
  CONNECT BY PRIOR D.DOCPROP_ID = D.DEPENDENT_DOCPROP_ID) AS DOCPROP_VLEVEL FROM DOC_KIND_PROPERTIES DKP, DOC_KIND_NAME DKN
 WHERE (DKP.DOCKIND_ID = $dockind_id)
   AND DKN.DOCPROP_ID(+) = DKP.DOCPROP_ID
   /* TODO Убрать фильтр по видимости после того как будет реализовано скрытие невидимых полей!!! */
   AND (SELECT DPE.DOCPROP_VISIBLE
          FROM DOC_PROP_EVENTS DPE
         WHERE DPE.DOCPROP_ID = DKP.DOCPROP_ID
           AND DPE.DOCEVENTKIND_ID = $status_id) = 1
   AND
       (DOCUMENTS.DOCF_CHECK_PERMISSIONS(1,
                                         $dockind_id,
                                         $status_id,
                                         DKP.DOCPROP_ID,
                                         NULL) = 1)
  ORDER BY DKP.SHOW_ORDER";


	//echo '<li>'.$sql;

	global $currentUser;
	$uid = $currentUser->userId();
	switch ($cache_level) {
		case 0:
			// no-cache
			$res = ora_select($sql, 'no-cache', '', '');
			break;
		case 1:
			// only struc
			$res = ora_select($sql, "get_props_list_user_$uid", "dockind_$dockind_id", "status_$status_id");
			break;
		case 2:
			// all
			$res = ora_select($sql, "get_props_list_user_$uid", "dockind_$dockind_id", "status_$status_id");
			break;
	}

	//$stmt=OCIParse($conn, $sql);
	//OCIExecute($stmt);
	//OCIFetchstatement($stmt, $res);
	//print_r($res);
	return $res;

	//OCILogoff($conn);
}

; //GetPropertiesList

function get_values_list($document_id, $docprop_id_list, $cache_level = 2) {
// возвращает cписок всех значений документа указанного ИД
// [v0]
// [v1]
// [v2]
	global $conn;

	//$docprop_id_list = implode(",", $->Properties[DOCPROP_ID]);
	// для каждого значения получаем display-значение
	/*  $sql = "SELECT DOCPROP_ID,
	  PLURAL,
	  DOC_PROP_VALUE#MULTI_0 AS V0,
	  DOC_PROP_VALUE#MULTI_1 AS V1,
	  DOC_PROP_VALUE#MULTI_2 AS V2,
	  PKG_WEB.PRIVATE_DOCF_GET_MULTI_VALUE($document_id, DOCPROP_ID) AS DISPLAY
	  FROM TABLE(CAST(PKG_VALUES.DOCF_GET_VALUES($document_id,
	  T_NUMBER_LIST($docprop_id_list)) AS
	  T_DOCF_PROP_VALUES))";
	 */

	$sql = "SELECT T.DOCPROP_ID,
       T.PLURAL,
       DOC_PROP_VALUE#MULTI_0 AS V0,
       DOC_PROP_VALUE#MULTI_1 AS V1,
       DOC_PROP_VALUE#MULTI_2 AS V2,
       PKG_WEB.PRIVATE_DOCF_GET_MULTI_VALUE($document_id, T.DOCPROP_ID) AS DISPLAY,
       MEDIA.DOC_PROP_CLOB V_CLOB
  FROM TABLE(CAST(PKG_VALUES.DOCF_GET_VALUES($document_id,
                                             T_NUMBER_LIST($docprop_id_list)) AS T_DOCF_PROP_VALUES)) T, DOC_PROPERTIES_MEDIA MEDIA WHERE MEDIA.DOCPROP_ID (+)= T.DOCPROP_ID AND MEDIA.DOCUMENT_ID (+) = T.DOCUMENT_ID AND MEDIA.PLURAL(+) = T.PLURAL";


	//echo $sql;

	switch ($cache_level) {
		case 0:
			// no-cache
			$res = ora_select($sql, 'no-cache', '', '');
			break;
		case 1:
			// only struc
			$res = ora_select($sql, 'no-cache', '', '');
			break;
		case 2:
			// all
			$res = ora_select($sql, 'get_valus_list', $document_id, md5($docprop_id_list));
			break;
	}
	//$stmt=OCIParse($conn, $sql);
	//OCIExecute($stmt);
	//OCIFetchstatement($stmt, $res);

	return $res;
}

; // get_values_list

function get_refs_list($document_id, $dockind_id_list) {
// возвращает cписок всех ССЫЛОЧНЫХ значений документа указанного ИД
// [v0]
// [v1]
// [v2]
	//global $conn;
	//$dockind_id_list = implode(",", $->Properties[DOCPROP_ID]);
	// для каждого значения получаем display-значение
	$sql = "SELECT DOCSOURCE_ID$               AS DOCSOURCE_ID,
                 DOCPROPSOURCE_ID$           AS DOCPROPSOURCE_ID,
                 DOCTARGET_ID$               AS DOCTARGET_ID,
                 /* DOC_NAME$ AS DOC_NAME, */ 
                 replace(DOC_NAME$, chr(05)) AS DOC_NAME,
                 DOC_KIND_NAME$              AS DOC_KIND_ID
  FROM TABLE(CAST(PKG_VALUES.DOCF_GET_REFS_LITE($document_id, T_NUMBER_LIST($dockind_id_list)) AS
                  T_DOCF_REF_QUERIES))";

	//$res = ora_select($sql, 'get_refs_lisr', $document_id, md5($dockind_id_list));
	$res = ora_select($sql, 'no-cache', '', '');
	//echo $sql;
	//$stmt=OCIParse($conn, $sql);
	//OCIExecute($stmt);
	//OCIFetchstatement($stmt, $res);

	return $res;
}

; //GetDocumentsList
// СТАТУСЫ ДОКУМЕНТА

/*

  получает список доступных статусов для данного документа
  -- см. также DOCUMENTS.DOCF_GET_DOCUMENT_STATUSES
  FUNCTION GET_STATUS_LIST_ALL(DOCKIND_ID$ IN DOCUMENTS_TREE.DOCUMENT_ID%TYPE)
  RETURN T_CURSOR;

  получает список доступных статусов для данного документа с учетом пути возможных изменений статуса
  -- см. также DOCUMENTS.DOCF_GET_DOCUMENT_STATUSES_2
  FUNCTION GET_STATUS_LIST(DOC_ID$ IN DOCUMENTS_TREE.DOCUMENT_ID%TYPE, DOCKIND_ID$ IN DOCUMENTS_TREE.DOCKIND_ID%TYPE, STATUS_ID$ IN DOC_EVENTS.DOCEVENTKIND_ID%TYPE)
  RETURN T_CURSOR;


 */

function get_status_list_all($dockind_id) {
// возвращает список доступных статусов для данного типа документа 
	global $conn;
	global $USER_ID;
	$sql = "PKG_WEB.GET_STATUS_LIST_ALL('" . $dockind_id . "')";
	//echo '<li>'.$sql;

	$res = ora_cursor($sql);
	$res = $sql;
	//print_r($res);
	return $res;
}

;

function get_status_list($document_id, $dockind_id, $current_status_id) {
// возвращает список доступных статусов для данного документа с учетом пути возможных изменений статуса 
	global $conn;
	global $USER_ID;
	$sql = "PKG_WEB.GET_STATUS_LIST(" . $document_id . ", " . $dockind_id . ", " . $current_status_id . ")";
	//echo '<li>'.$sql;

	$res = ora_cursor($sql);
	//print_r($res);
	return $res;
}

;

function GetStrDate($str) {
	// возвращает дату из строки вида 12.01.2003^11:00:02
	return substr($str, 0, 10);
}

function GetVocabValue($code, $vocab_name) {
	// возвращает значение из словаря $vocab_name по коду $code
	include("db/logon.inc");
	if (empty($code)) {
		return '';
		exit;
	};
	$stmt = OCIParse($conn, "select VALUE from vocabs v where v.vocab_id = Get_Vocab_Id('$vocab_name') and code = $code");
	OCIExecute($stmt);
	OCIFetchstatement($stmt, $res);
	return $res['VALUE'][0];
	OCILogoff($conn);
}

function GetVocabName($code, $vocab_name) {
	// возвращает наименования (Names) из словаря $vocab_name по коду $code
	$stmt = OCIParse($conn, "select NAME from vocabs v where v.vocab_id = Get_Vocab_Id('$vocab_name') and code = $code");
	OCIExecute($stmt);
	OCIFetchstatement($stmt, $res);
	return $res['NAME'][0];
	OCILogoff($conn);
}

function get_value($doc, $prop_id) {
	// возвращает массив значений реквизита
	// с учетом множественности, первый элемент -- "0"
	$values = $doc->values;
	$res = array();
	//print_r($values);
	$offset = 0;
	for ($i = 0; $i < count($values[DOCPROP_ID]); $i++) {
		if ($values[DOCPROP_ID][$i] == $prop_id) {
			$res[DOCPROP_ID][$offset] = $values[DOCPROP_ID][$i];
			$res[PLURAL][$offset] = $values[PLURAL][$i];
			$res[V0][$offset] = $values[V0][$i];
			$res[V1][$offset] = $values[V1][$i];
			$res[V2][$offset] = $values[V2][$i];
			$res[DISPLAY][$offset] = $values[DISPLAY][$i];
			$offset++;
		}
	}
	//print_r($res);
	return $res;
}

function get_ref_value($doc, $prop_id) {
	// возвращает массив значений ССЫЛОЧНОГО реквизита
	// с учетом множественности, первый элемент -- "0"

	/*
	  массив ссылок состоит из:
	  DOCSOURCE_ID,
	  DOCPROPSOURCE_ID,
	  DOCTARGET_ID,
	  DOC_NAME,
	  DOC_KIND_ID
	 */
	$refs = $doc->refs;
	$res = array();
	//print_r($refs);

	$offset = 0;
	for ($i = 0; $i < count($refs[DOCPROPSOURCE_ID]); $i++) {
		if ($refs[DOCPROPSOURCE_ID][$i] == $prop_id) {
			$res[DOCSOURCE_ID][$offset] = $refs[DOCSOURCE_ID][$i];
			$res[DOCPROPSOURCE_ID][$offset] = $refs[DOCPROPSOURCE_ID][$i];
			$res[DOCTARGET_ID][$offset] = $refs[DOCTARGET_ID][$i];
			$res[DOC_NAME][$offset] = $refs[DOC_NAME][$i];
			$res[DOC_KIND_ID][$offset] = $refs[DOC_KIND_ID][$i];
			$offset++;
		}
	}
	//print_r($res);
	/* результат:
	  ref_value=Array (
	  [DOCSOURCE_ID] => Array ( [0] => 1240076 )
	  [DOCPROPSOURCE_ID] => Array ( [0] => 14749 )
	  [DOCTARGET_ID] => Array ( [0] => 1005198 )
	  [DOC_NAME] => Array ( [0] => KIA )
	  [DOC_KIND_ID] => Array ( [0] => 28552 ) )
	 */
	return $res;
}

function get_vocab_values_list($vocab_name) {
// возвращает cписок значений из словаря (заполняет выпадающий список для выбора значений)
	$res = ora_cursor("PKG_WEB.VOC_GET_VALUES_LIST('$vocab_name')");

	return $res;
}

;

/**
 * возвращает cписок значений из словаря (заполняет выпадающий список для выбора значений)
 * 
 */
function get_table_values_list($sql) {
	// Илья@2011.07.21 16:49 Для чего такая заглушка? Портит вывод табличных данных
	//$sql = 'select vocab_id, vocab_name from vocab_vocabs';
	// Илья@2011.07.21 16:49
	//$res = ora_select($sql,'tablevalueslist','','');
	$res = ora_select($sql, md5($sql), '', '');

	$res = utls::_orares_to_arr($res);
	// приводим выдачу данных в формате ID - VALUE
	$res_tbl = array();
	$keys = array_keys($res[0]);
	for ($i = 0; $i < count($res); $i++) {
		$res_tbl[] = array("ID" => $res[$i][$keys[0]], "VALUE" => $res[$i][$keys[1]]);
	}
	return $res_tbl;
}

function get_ref_values_list($xml, $orderby_column = '', $sql = '') {
// возвращает cписок значений - ссылок (заполняет выпадающий список для выбора значений)
// если задан SQL, то читаем его, иначе читаем XML
// $orderby_column - колонка для сортировки списка
	global $conn;
	global $USER_ID;
	//echo $sql;
	if (!empty($sql)) {
		// SQL - фильтр
		//include("db/logon.inc");
		exec_proc("DOCUMENTS.REGISTER_USER('" . $USER_ID . "',2)");
		//echo '<br><br>'.$sql;
		$res = ora_cursor_sql($sql);
	} else { // XML - фильтр
		$res = ora_cursor("PKG_WEB.DOCF_GET_REFS_LIST('$xml', '$orderby_column')");
	}
	// print_r($res);
	return $res;
}

;

function get_ref_values_list_fetch($xml, $sort_column = '', $sort_order = 'asc', $sql = '', $max_cnt = 100, $page_no = 1) {
// возвращает cписок значений - ссылок (заполняет выпадающий список для выбора значений)
// $orderby_column - колонка для сортировки списка
// $page_no - номер страницы начиная с 1!!!
	global $conn;
	global $USER_ID;
	//echo $sql;
	if (!empty($sql)) {
		// SQL - фильтр
		//include("db/logon.inc");
		exec_proc("DOCUMENTS.REGISTER_USER('" . $USER_ID . "',2)");
		//echo '<br><br>'.$sql;
		die('Get_ref_values_list_fetch: fetch is not supported by SQL syntax!');
		// TODO: дописать (если это потребуется)!
		$res = ora_cursor_sql($sql);
	} else { // XML - фильтр
		$res = ora_cursor_fetch("PKG_WEB.DOCF_GET_REFS_LIST('$xml', '$sort_column', '$sort_order')", $max_cnt, $page_no);
	}
	// print_r($res);
	return $res;
}

;

function get_ref_values_list_count($xml) {
// возвращает количество найденных документов - ссылок (заполняет выпадающий список для выбора значений)
	global $conn;
	global $USER_ID;
	//echo $sql;
	/* if (!empty($sql)) {
	  // SQL - фильтр
	  //include("db/logon.inc");
	  exec_proc("DOCUMENTS.REGISTER_USER('".$USER_ID."',2)");
	  //echo '<br><br>'.$sql;
	  die('Get_ref_values_list_count: fetch is not supported by SQL syntax!');
	  // TODO: дописать (если это потребуется)!
	  $res = ora_cursor_sql($sql);
	  } else { */ // XML - фильтр
	$res = ora_func("PKG_WEB.DOCF_GET_REFS_LIST_COUNT('$xml')");
	//}
	//echo ($res);
	return $res;
}

;

/**
 * СОХРАНЕНИЕ МЕДИА-ПОЛЯ В СИСТЕМУ
 * создаёт неформализованный документ (аттач) и сжимает его средствами БД, коммитит результат
 * ВНИМАНИЕ: не забыть после создания документа записать значение в DOC_PROPERTIES[v0] - ссылку на ID документа
 * @global object $conn
 * @global int $USER_ID
 * @param int $doc_id ID формализованного документа (родителя)
 * @param string $user_filename имя файла, которое будет показываться пользователю
 * @param type $media_data поток данных
 * @return int ID медиа-документа
 */
function save_media_stream($doc_id, $user_filename, $media_data) {
	global $conn;
	global $USER_ID;

	//$filename = 'image.jpg';
	//$doc_id = 1418100;
	$res = array('media_id' => null, 'content_type' => null);

	$sql = "INSERT INTO DOCUMENTS_TREE (PARENT, DOC_NAME, DOC_DESCR, DOC_CONTENT, DOC_CONTENT_TYPE)
    VALUES (" . $doc_id . ", '" . $user_filename . "', '" . $user_filename . "', EMPTY_BLOB(), pkg_values.GET_MEDIA_TYPE('" . $user_filename . "')) returning DOCUMENT_ID, DOC_CONTENT, DOC_CONTENT_TYPE into :media_id, :lob_locator, :content_type";

	try {
		$stmt = oci_parse($conn, $sql);
	} catch (Exception $e) {
		//if ($debug) {
		$e1 = oci_error($stmt);  // For oci_execute errors pass the statement handle
		$errMsg = '<b><br />========== SAVE_MEDIA_STREAM:PARSE ===========<br /></b>';
		$errMsg .= htmlentities($e1['message']);
		$errMsg .= print "\n<pre>\n";
		$errMsg .= htmlentities($e1['sqltext']);
		$errMsg .= sprintf("\n%" . ($e1['offset'] + 1) . "s", "^");
		$errMsg .= "\n</pre>";
		$errMsg .= '<b><br />==============================<br /></b>';
		//die();
		throw new Exception($errMsg);
		//}
	}
	$lob = oci_new_descriptor($conn, OCI_D_LOB);
	oci_bind_by_name($stmt, ':lob_locator', $lob, -1, OCI_B_BLOB);
	oci_bind_by_name($stmt, ":media_id", $media_id, 64);
	oci_bind_by_name($stmt, ":content_type", $content_type, 64);
	//echo '<li> sql='.$sql;
	try {
		ociexecute($stmt, OCI_DEFAULT);
	} catch (Exception $e) {
		//if ($debug) {
		$e1 = oci_error($stmt);  // For oci_execute errors pass the statement handle
		$errMsg = '<b><br />========== SAVE_MEDIA_STREAM:EXECUTE ===========<br /></b>';
		$errMsg .= htmlentities($e1['message']);
		$errMsg .= print "\n<pre>\n";
		$errMsg .= htmlentities($e1['sqltext']);
		$errMsg .= sprintf("\n%" . ($e1['offset'] + 1) . "s", "^");
		$errMsg .= "\n</pre>";
		$errMsg .= '<b><br />==============================<br /></b>';
		//die();
		throw new Exception($errMsg);
		//}
	}
	try {
		$lob->save($media_data);
	} catch (Exception $e) {
		//if ($debug) {
		$e1 = oci_error($stmt);  // For oci_execute errors pass the statement handle
		$errMsg = '<b><br />========== SAVE_MEDIA_STREAM:SAVE_BLOB ===========<br /></b>';
		$errMsg .= htmlentities($e1['message']);
		$errMsg .= print "\n<pre>\n";
		$errMsg .= htmlentities($e1['sqltext']);
		$errMsg .= sprintf("\n%" . ($e1['offset'] + 1) . "s", "^");
		$errMsg .= "\n</pre>";
		$errMsg .= '<b><br />==============================<br /></b>';
		//die();
		throw new Exception($errMsg);
		//}
	}
	//echo '<li> media_id='.$media_id;
	$sql = "pkg_values.COMPRESS_MEDIA_DOC(" . $media_id . ")";
	//echo '<li> compress_sql='.$sql;
	ora_func($sql);

	oci_commit($conn);

	$res['media_id'] = $media_id;
	$res['content_type'] = $content_type;

	return $res;
}

/**
 * создаёт неформализованный документ (аттач) и сжимает его средствами БД, коммитит результат
 * ВНИМАНИЕ: не забыть после создания документа записать значение в DOC_PROPERTIES[v0] - ссылку на ID документа
 * @param int $doc_id ID формализованного документа (родителя)
 * @param string $filename имя файла на сервере, которое надо вставить в базу
 * @param string $user_filename имя файла, которое будет показываться пользователю
 * @return int ID медиа-документа
 */
function save_media_file($doc_id, $filename, $user_filename) {
	$media_data = fread(fopen($filename, "rb"), filesize($filename));
	$media_id = save_media_stream($doc_id, $user_filename, $media_data);
	return $media_id;
}

////////////////////////////////////////////////////////////////////////////
/**
  ПЕЧАТЬ КОНТРОЛА ДОКУМЕНТА В РЕЖИМЕ РЕДАКТИРОВАНИЯ
 * @param doc_id        - ИД документа
 * @param doc_prop_name - системное наименование реквизита (ex: 'DATE_PODP')
 * @param doc_kind_name - системное наименование типа документа (ex: 'PERSON')
 * @param control_name  - наименование контрола ?????
 * @param width         - ширина контрола
 * @param height        - высота контрола (для текстовых полей)
  ВОЗВРАЩАЕМОЕ ЗНАЧЕНИЕ
  нет
 */
function print_control($doc_id, $doc_prop_name, $doc_kind_name, $width = 300, $height = 0) {
	global $conn;
	$html = get_popup_ex($doc_id, $doc_prop_name, $doc_kind_name, $width, $height);
	echo $html;
}

/**
 *  удаление элемента из массива
 * This function deletes the given element from a one-dimension array
 * @param $array:    the array (in/out)
 * @param $deleteIt: the value which we would like to delete
 * @param $useOldKeys: if it is false then the function will re-index the array (from 0, 1, ...)
 *                          if it is true: the function will keep the old keys
 * @return true, if this value was in the array, otherwise false (in this case the array is same as before)
 */
function deleteFromArray(&$array, $deleteIt, $useOldKeys = FALSE) {
	$key = array_search($deleteIt, $array, TRUE);
	if ($key === FALSE)
		return FALSE;
	unset($array[$key]);
	if (!$useOldKeys)
		$array = array_values($array);
	return TRUE;
}

?>