<?php
include_once '../carabi/smarty/plugins/function.staticCounter.php';
/**
* Чтение словаря или справочника из БД. Данные читаются из справочника, если задано
* одно или несколько полей, которые требуется прочитать.
* @param array $params параметры, передаваемые в Smarty
* $params["vocabularyName"] Имя словаря или справочника
* $params["vocabularyField"] Имя требуемого поля из справочника
* $params["vocabularyFields"] Массив имён требуемых полей из справочника
* $params["equalFilter"] Ассоциативный массив "поле => значение" для фильтрации по точному совпадению
* $params["likeFilter"] Ассоциативный массив "поле => значение" для фильтрации по частичному совпадению
* $params["statusFilter"] Имя или массив имён статусов
* $params["delimiter"] Разделитель, вставляемый между несколькими выбираемыми полями
* $params["unselectedRow"] Строка, добавляемая с индексом 0 для невыбранного вырианта
* $params["cache"] Кэшировать (по умолчанию -- да)
* $params["orderBy"] Порядок сортировки: 'value' -- по значению (по умолчанию), 'code' -- по ключу
* $params["assignTo"] Имя переменной, к которой присваиваивается выборка (по умолчанию vocabulary)
*/
function smarty_function_loadVocabulary($params, $tpl){
	$vocabulary = null;
	$cache = $params["cache"];
	if (!isset($cache)) $cache = true;
	if (isset($params["vocabularyField"])) {
		$vocabularyRaw = Vocab::searchInGlossary(
				$params["vocabularyName"],
				$params["vocabularyField"],
				$params["equalFilter"],
				$params["likeFilter"],
				$params["delimiter"],
				$cache,
				$params["statusFilter"],
				$params["orderBy"]
		);
		$vocabulary = Vocab::rawToIndex($vocabularyRaw, $params["unselectedRow"]);
	} else if (isset($params["vocabularyFields"])) {
		$vocabularyRaw = Vocab::searchInGlossary(
				$params["vocabularyName"],
				$params["vocabularyFields"],
				$params["equalFilter"],
				$params["likeFilter"],
				$params["delimiter"],
				$cache,
				$params["statusFilter"],
				$params["orderBy"]
		);
		$vocabulary = Vocab::rawToIndex($vocabularyRaw, $params["unselectedRow"]);
	} else {
		$vocabularyRaw = get_vocab_list2($params["vocabularyName"], '', $params["orderBy"]);
		$vocabulary = assotiate_vocab_list($vocabularyRaw, $params["unselectedRow"]);
	}
	if (isset($params["assignTo"])) {
		$assignTo = $params["assignTo"];
	} else {
		$assignTo = "vocabulary";
	}
	$tpl->assign($assignTo, $vocabulary);
}
?>
