<?php
include_once '../core.rent.ru/wave_editor/class.WaveEditor.php';
/**
 * Просмотр и редактирование набора объектов. Выводится список объектов с возможностью
 * редактирования каждого из них и форма для добавления нового.
 * Список объектов может передаваться в виде двухмерного массива {id, name, description},
 * SQL-запроса, возвращающего такую таблицу или словаря {id => name} и функции,
 * строящей описание из записи в словаре. Вместо словаря могут быть использованы
 * параметры функции loadVocabulary.
 * Если задана Smarty-переменная waveReadOnly -- выводится только просмотр
 * @param array $params
 * boolean $params["withLine"] Рисовать ли линию над блоком (по умолчанию -- да)
 * string $params["title"] Заголовок
 * string $params["captionAdd"] Надпись на кнопке открытия формы для добавления нового объекта
 * string $params["captionChange"] 
 * string $params["captionInsertOK"] 
 * string $params["captionInsertCancel"] 
 * string $params["captionUpdateOK"] 
 * string $params["captionUpdateCancel"] 
 * string $params["captionDelete"] 
 * string $params["description"] Описание (выводится в абзац перед таблицей)
 * 
 * string $params["formName"] Название структуры формы Carabi для чтения и записи объектов
 * string $params["editorTpl"] шаблон для вывода редактора одного объекта (должен содержать табличные строки)
 *
 * Из следующих пяти параметров требуется ровно один
 * array $params["data"] готовый массив {id, name, description}
 * string $params["sql"] SQL-запрос, возвращающий массив {id, name, description}
 * array $params["vocabulary"] словарь {id => name}, описания будут создаваться
 * array $params["vocabularyParameters"] параметры функции loadVocabulary
 * array $params["idArray"] массив ID, имена и описания будут создаваться
 * 
 * string $params ["descriptionGenerator"] имя файла с классом, реализующим интерфейс generateDocumentDescription
 * string $params ["saver"] имя файла с классом, реализующим интерфейс saver
 * array $params ["addToLink"] массив {ID, documentName, fieldName} с индексом объекта,
 *       именем его типа и множественной ссылкой, куда будут добавляться новые документы
 * int $params["parentID"] индекс родительского объекта
 * string $params["linkToParent"] имя поля, куда будет заноситься ссылка на него
 * boolean $params["reloadAfterInsert"] при добавлении объекта перезагружать всю web-страницу (по умолчанию -- нет)
 * string $params ["dropStatus"] название статуса, в который переводятся объекты вместо удаления
 */
function smarty_function_collectionEditor($params, $tpl) {
	utls::setHTMLPageOption("js_links", "/js/wave_editor/collectionEditor.js");
	$result = "";
	$blockID = smarty_function_staticCounter();
	$data = null;
	$formName = $params["formName"];
	$descriptionGenerator = $params["descriptionGenerator"];
	$title = $params["title"];
	if (!isset($title) || $title == "") {
		$title = "&nbsp;";
	}
	$captionAdd         = isset($params["captionAdd"]) ? $params["captionAdd"] : "Добавить объект";
	$captionChange	    = isset($params["$captionChange"]) ? $params["$captionChange"] : "изменить";
	$captionInsertOK    = isset($params["captionInsertOK"]) ? $params["captionInsertOK"] : "Добавить";
	$captionInsertCancel= isset($params["captionInsertCancel"]) ? $params["captionInsertCancel"] : "Отмена";
	$captionUpdateOK    = isset($params["captionUpdateOK"]) ? $params["captionUpdateOK"] : "Сохранить";
	$captionUpdateCancel= isset($params["captionUpdateCancel"]) ? $params["captionUpdateCancel"] : "Отмена";
	$captionDelete      = isset($params["captionDelete"]) ? $params["captionDelete"] : "Удалить";
	$reloadAfterInsert	= isset($params["reloadAfterInsert"]) ? (string)$params["reloadAfterInsert"] : "false";
	$captions = array(
		"updateOK" => $captionUpdateOK,
		"updateCancel" => $captionUpdateCancel,
		"delete" => $captionDelete,
		"change" => $captionChange
	);

	if (isset($params["data"])) {
		$data = $params["data"];
	} else if (isset($params["sql"])) {
		$data = ora_redim(ora_select($params["sql"], 'no-cashe', '', ''));
	} else if (isset($params["vocabulary"])) {
		$data = addDescriptions($params["vocabulary"], $formName, $descriptionGenerator, true, $params["parentID"]);
	} else if (isset($params["vocabularyParameters"])) {
		smarty_function_loadVocabulary($params["vocabularyParameters"], $tpl);
		$vocabulary = $tpl->getTemplateVars("vocabulary");
		$data = addDescriptions($vocabulary, $formName, $descriptionGenerator, true, $params["parentID"]);
	} else if (isset($params["idArray"])) {
		$data = addDescriptions($params["idArray"], $formName, $descriptionGenerator, false, $params["parentID"]);
	} else {
		throw new Exception("No data for collectionEditor");
	}
	if ($params["withLine"] || !isset($params["withLine"])) {
		$result .= "<div class=\"line\"></div>\n";
	}
	$result .= "<div class=\"title\">";
	if (!$tpl->getTemplateVars("waveReadOnly")) {
		$result .= "<div class=\"title_right\"><a href=\"#\" class=\"bookmarks_link allow_many_open\" data-targetId=\"$blockID\">$captionAdd</a></div>";
	}
	$result .= "$title</div>\n";
	if (isset($params["description"])) {
		$result .= "<div class=\"description\">{$params["description"]}</div>\n";
	}
	$newDocumentTpl = $tpl->createTemplate($params["editorTpl"]);
	$newDocument = WaveEditor::getDocument(-1, $formName);
	if (isset($params["parentID"])) {
		$newDocumentTpl->assign("parentID", $params["parentID"]);
		if (isset($params["linkToParent"])) {
			$newDocument->__set($params["linkToParent"], $params["parentID"]);
		}
	}
	$newDocumentTpl->assign("document", $newDocument);
	$newDocumentForm = $newDocumentTpl->fetch();
	
	$result .=
"<div class=\"table wide radio_toggle_container\">
	<div  width=\"100%\" id=\"{$blockID}_full\" class=\"bookmarks\">
		<form id=\"form_{$blockID}\" action=\"/waveEditor/?sendedByJS\" method=\"post\">
		<table cellspacing=\"1\" width=\"100%\" id=\"{$blockID}_full_table\"><tbody id=\"{$blockID}_full_table_body\">
			$newDocumentForm
		</tbody></table>
		<div class=\"button\">
			<span class=\"action\" id=\"sendDocumentBtn_$blockID\">$captionInsertOK</span>
			<span class=\"action3\" onClick=\"$(this).parent().parent().parent().hide();\">$captionInsertCancel</span>
		</div>
		</form>
". sendInsertFormJS("$blockID", $formName, $params["editorTpl"], $params["descriptionGenerator"], $params["addToLink"], $params["dropStatus"], $params["saver"], $params["parentID"], $captions, $reloadAfterInsert) ."
		<div class=\"line\"></div>\n
	</div>
</div>
";
	$documentsDisplay = "";
	foreach($data as $object) {
		$documentsDisplay .= 
		"<tr id=\"row_{$blockID}_{$object[0]}_display\">
			<td class=\"name\">{$object[1]}</td>
			<td class=\"value\">";
		if (!$tpl->getTemplateVars("waveReadOnly")) {
			$documentsDisplay .="
				<div style=\"float: right\">
					<span id=\"bookmark_{$blockID}_{$object[0]}\" class=\"bookmark link\">$captionChange</span>
				</div>";
		}
			$documentsDisplay .="
				<div class=\"objectDescription\">{$object[2]}</div>
			</td>
		</tr>
		<tr id=\"row_{$blockID}_{$object[0]}_editor\" class=\"white\" style=\"display:none\">
		</tr>\n";
		if (!$tpl->getTemplateVars("waveReadOnly")) {
			$documentsDisplay .= loadUpdateFormJS($blockID, $object[0], $formName, $params["editorTpl"], $params["descriptionGenerator"], $captions, $params["addToLink"], $params["dropStatus"], $params["saver"], $params["parentID"]);
		}
	}
	$result .= 
"<div class=\"table wide radio_toggle_container\">
	<div  width=\"100%\">
		<table cellspacing=\"1\" width=\"100%\" id=\"{$blockID}_list_table\"><tbody>
			$documentsDisplay
		</tbody></table>
	</div>
</div>
";

	return $result;
}

/**
 * Добавление описаний к массиву индексов или словарю с использованием объекта generateDocumentDescription
 */
function addDescriptions($array, $formName, $descriptionGeneratorFile, $arrayIsVocab, $parentID) {
	if (isset($descriptionGeneratorFile)) {
		include_once $descriptionGeneratorFile;
	}
	$descriptionGeneratorClass = getClassName($descriptionGeneratorFile);
	$data = array();
	if ($arrayIsVocab) {
		foreach ($array as $id => $objectName) {
			$descriptionGeneratorClass::generateDocumentDescription($id, $formName, $objectName, $description, $parentID, $arrayIsVocab);
			$row = array($id, $objectName, $description);
			$data[] = $row;
		}
	} else {
		foreach ($array as $id) {
			$descriptionGeneratorClass::generateDocumentDescription($id, $formName, $objectName, $description, $parentID, $arrayIsVocab);
			$row = array($id, $objectName, $description);
			$data[] = $row;
		}
	}
	return $data;
}

/**
 * Вывод JavaScript-кода редактора в HTML
 */
function loadUpdateFormJS($collectionID, $documentID, $formName, $templateName, $descriptionGeneratorFile, $captions, $addToLink, $dropStatus, $saver, $parentID) {
	if (isset($addToLink)) {
		$linkParameters = "&linkingObjectID={$addToLink[0]}&type={$addToLink[1]}&field={$addToLink[2]}";
	}
	if (isset($saver)) {
		$saverFile = "&saverFile=$saver";
	}
	return '<script type="text/javascript" language="javascript">
	captions = {
		updateOK:"'.$captions["updateOK"].'",
		updateCancel:"'.$captions["updateCancel"].'",
		deleteRow:"'.$captions["delete"].'",
		change:"'.$captions["change"].'"
	}
	components = {
		form: "#form_'.$collectionID.'_'.$documentID.'",
		row_display: "#row_'.$collectionID.'_'.$documentID.'_display",
		row_editor: "#row_'.$collectionID.'_'.$documentID.'_editor",
		bookmark:"#bookmark_'.$collectionID.'_'.$documentID.'"
	}
	' .
	"collectionEditor_loadUpdateForm(components, $collectionID, $documentID, '$parentID', '$formName', '$templateName', '$descriptionGeneratorFile', captions, '$linkParameters', '$dropStatus', '$saverFile');
</script>
";
}

function sendInsertFormJS($formID, $formName, $templateName, $descriptionGeneratorFile, $addToLink, $dropStatus, $saver, $parentID, $captions, $reloadAfterInsert) {
	if (isset($addToLink)) {
		$linkParameters = "&linkingObjectID={$addToLink[0]}&type={$addToLink[1]}&field={$addToLink[2]}";
	}
	if (isset($saver)) {
		$saverFile = "&saverFile=$saver";
	}
	return '<script type="text/javascript" language="javascript">
	captions = {
		updateOK:"'.$captions["updateOK"].'",
		updateCancel:"'.$captions["updateCancel"].'",
		deleteRow:"'.$captions["delete"].'",
		change:"'.$captions["change"].'"
	}
	components={
		formContainer:"#'.$formID.'_full_table_body",
		documentsList:"#'.$formID.'_list_table"
	};'."
	collectionEditor_sendInsertForm(components, $formID, '$formName', '$templateName', '$descriptionGeneratorFile', captions, '$linkParameters', '$dropStatus', '$saverFile', '$parentID', $reloadAfterInsert)
</script>
";
}
?>
