<?php

/**
* @param array $params
* boolean $params["colspan"] Объединить ячейки
* string $params["caption"] Подпись к строке
* string $params["info"] всплывающая подсказка
* boolean $params["required"] пометка звёздочкой
* string $params["rowClass"]
* string $params["rowID"]
*/
function smarty_block_printTableRow($params, $content, $template, &$repeat) {
	static $result;
	static $segmentID;
	if ($repeat) {
		$result = "<tr";
		$rowClass = $params["rowClass"];
		$rowID = $params["rowID"];
		if (isset($rowClass)) {
			$result .= " class=\"$rowClass\"";
		}
		if (isset($rowID)) {
			$result .= " id=\"$rowID\"";
		}
		$result .= ">";
		if ($params["colspan"]) {
			$result .= "<td class=\"description no_underline\" colspan=\"2\" align=\"left\">\n";
		} else {
			if ($params["info"]) {
				$info = "<div class=\"info_popup\">
					<img class=\"info_image\"/>
					<span>{$params["info"]}<small></small></span>
				</div>";
			}
			$result .= "<td class=\"name";
			if ($params["required"]) {
				$result .= " required";
			}
			$result .= "\">$info{$params["caption"]}:</td><td class=\"value\">\n";
		}
	} else {
		$result .= "$content\n</td></tr>\n";
	}
	return $result;
}
?>
