<?php
include_once '../carabi/smarty/plugins/function.staticCounter.php';
/**
* Вывод сегмента гармони (заголовка и таблиц для отображения и редактирования объекта)
* Элементы для отображения -- текст и теги, не содержащие таблиц, функции print*Display
* Элементы для редактирования -- строки таблицы, функции print*Row
* Если задана Smarty-переменная waveReadOnly -- выводится только просмотр
* @param array $params
* boolean $params["withLine"] Рисовать ли линию над сегментом
* string $params["title"] Заголовок
* string $params["caption"] Надпись в ссылке раскрытия
* string $params["linkClass"] Класс ссылки раскрытия
* string $params["description"] Описание (выводится в абзац перед таблицей)
* string $params["segmentID"]
*/
function smarty_block_harmonySegment($params, $content, $tpl, &$repeat) {
	static $result;
	static $segmentID;
	if ($repeat) {
		$result = "";//инициализируем переменные при первом вызове функции
		if ($params["withLine"]) {
			$result .= "<div class=\"line\"></div>\n";
		}
		if (isset($params["segmentID"]) && $params["segmentID"] != "") {
			$segmentID = $params["segmentID"];
		} else {
			$segmentID = smarty_function_staticCounter();
		}
		$tpl->assign("segmentID", $segmentID);
		$title = $params["title"];
		$title .= "&nbsp;";
		$caption = $params["caption"];
		//Если редактирование не доступно -- заголовка редактора нет
		if ($tpl->getTemplateVars("waveReadOnly")) {
			$caption = "";
		} else if (!isset ($caption)) {
			$caption = "изменить";
		}
		$result .= "<div class=\"title\" id=\"title_$segmentID\"><div class=\"title_right\"><a href=\"#\" class=\"bookmarks_link allow_many_open {$params["linkClass"]}\" data-targetId=\"segment_$segmentID\">$caption</a></div>$title</div>\n";
		if (isset($params["description"])) {
			$result .= "<div class=\"description\">{$params["description"]}</div>\n";
		}
	} else {
		$result .=
"<div class=\"table wide radio_toggle_container\" id=\"$segmentID\">
	$content
</div>
";
	}
	return $result;
}
?>
