<?php
include_once '../carabi/smarty/plugins/function.staticCounter.php';
/**
 * Вывод формы для редактирования документа
 * @param array $params
 * $params["formID"]
 * $params["ok"] надпись на кнопке ОК (по умолчанию "Сохранить")
 * $params["url"] адрес страницы, обрабатывающей submit-запрос
 * $params["classOk"] класс кнопки ОК (по умолчанию action)
 * $params["check"] функция JS, выполняемая перед отправкой запроса (если возвращает false -- запрос не отправляется)
 * $params["cancel"] надпись на кнопке Отмена
 * $params["urlCancel"] адрес страницы, открываемой при нажатии кнопки Отмена
 * $params["noCancel"] не рисовать кнопку Отмена
 * $params["back"] надпись на кнопке Назад (если не задана -- кнопка не рисуется)
 * $params["urlBack"] адрес страницы, открываемой при нажатии кнопки Назад
 * $params["empty"] не рисовать панель с кнопками
 * $params["style"] 
 * $params["method"] метод post (по умолчанию) или get
 * $params["document"] документ -- если задан, сохраняется его ID
 */
function smarty_block_documentEditForm($params, $content, $tpl, &$repeat) {
	static $result;
	static $formID;
	static $buttons;
	if ($repeat) {
		//инициализируем переменные при первом вызове функции
		if (isset($params["formID"]) && $params["formID"] != "") {
			$formID = $params["formID"];
		} else {
			$formID = "form" . smarty_function_staticCounter();
		}
		if ($params["method"] == "post" || $params["method"] == "get") {
			$method = $params["method"];
		} else {
			$method = "post";
		}
		$result = "<form id=\"$formID\" action=\"{$params["url"]}\" method=\"$method\">
		<div class=\"search_form inline\" style=\"{$params["style"]}\">\n";

		if (isset($params["document"])) {
			$result .= "<input type=\"hidden\" name=\"{$params["document"]->formName}\" value=\"{$params["document"]->id}\">";
		}
		
		if (isset($params["ok"])) {
			$ok = $params["ok"];
		} else {
			$ok = "Сохранить";
		}

		$buttons  = "<div class=\"button\">";
		if (isset($params["back"])) {
			$buttons .= "<a href=\"{$params["urlBack"]}\" class=\"back\">".$params["back"]."</a>";
		}
		if (isset($params["classOk"])) {
			$classOk = $params["classOk"];
		} else {
			$classOk = "action";
		}
		$script = isset($params["check"])?$params["check"]." && ":"";
		$buttons .= "<span class=\"$classOk\" onClick=\"$('.uncheckBeforeSend').removeAttr('checked'); {$script}document.getElementById('$formID').submit()\">$ok</span>";
		if (!$params["noCancel"]) {
			if (isset($params["cancel"])) {
				$cancel = $params["cancel"];
			} else {
				$cancel = "Отмена";
			}
			if (isset($params["urlCancel"])) {
				$buttons .= "<a href=\"{$params["urlCancel"]}\" class=\"action3\" onClick=\"document.getElementById('$formID').reset()\">$cancel</a>";
			} else {
				$buttons .= "<span class=\"action3\" onClick=\"document.getElementById('$formID').reset()\">$cancel</span>";
			}
		}
		$buttons .= "</div>";
	} else {
		if (isset($params["empty"]) || $tpl->getTemplateVars("waveReadOnly")) {
			$result .= "$content
					</div>
				</form>
				";
		 } else {
			$result .= "$content $buttons
					</div>
				</form>
				";
		 }
	}
	return $result;
}
?>
