<?php

/**
 * Description of WaveEditorUtils
 *
 * @author sasha
 */
class WaveEditorUtils {

	/**
	 * убрать время из записи вида dd.mm.yyyy^hh:mm:ss
	 */
	public static function datetimeToDate(&$DateTime) {
		$timeCutPattern = "#\^\d\d:\d\d:\d\d#";
		$DateTime = preg_replace($timeCutPattern, "", $DateTime);
		return $DateTime;
	}

	/**
	 * 
	 */
	public static function formatDateTime(&$DateTime) {
		return preg_replace("#\^#", ", ", $DateTime);
	}

	/**
	 * Привести год (четырёхзначное число) к записи вида 01.01.xxxx^00:00:00
	 * @param int|string year
	 */
	public static function datetimeFromYear($year) {
		$yearStr = "";
		if (empty($year)) {
			return $yearStr;
		}
		if (is_int($year) && $year <= 9999 && year > 0) {
			$yearStr = (string) $year;
		} else if (is_string($year) && strlen($year) <= 4 && (int)$year > 0) {
			$yearStr = $year;
		} else {
			throw new Exception("Incorrect year: $year");
		}
		while (strlen($yearStr) < 4) {
			$yearStr = "0" . $yearStr;
		}
		return "01.01.$yearStr^00:00:00";
	}
	
	public static function datetimeToYear($datetime) {
		$date = WaveEditorUtils::datetimeToDate($datetime);
		return preg_replace("#^\d\d.\d\d.#", "", $date);
	}
	
	private static function log($sql, $logName="WaveEditor") {
		utls::logStr("WaveEditor", $sql);
	}
	
	public static function getReference($parentID, $parentTypeName, $fieldName) {
		$sql = "GET_REF($parentID, '$fieldName', '$parentTypeName')";
		self::log($sql);
		return ora_func($sql);
	}

	public static function getMultiReference($parentID, $parentTypeName, $fieldName) {
		$sql = "select * from table(GET_REFS($parentID, '$fieldName', '$parentTypeName'))";
		self::log($sql);
		$multi_ref = ora_select($sql, 'no-cache', '', '');
		return $multi_ref["COLUMN_VALUE"];
	}

	public static function addReference($parentID, $parentTypeName, $fieldName, $childID, $commit=true) {
		$sql = "INSERT_REF($parentID, '$fieldName', '$parentTypeName', '$childID')";
		self::log($sql);
		ora_proc($sql, $commit);
	}

	public static function delReference($parentID, $parentTypeName, $fieldName, $childID, $commit=true) {
		$sql = "DELETE_REF($parentID, '$fieldName', '$parentTypeName', '$childID')";
		self::log($sql);
		ora_proc($sql, $commit);
	}

	public static function getSimpleField($docID, $typeName, $fieldName, $commit = true) {
		$sql = "GET_SIMPLE_FIELD($docID, '$fieldName', '$typeName')";
		self::log($sql);
		return ora_func($sql, $commit);
	}
	
	public static function getMultiField($docID, $typeName, $fieldName) {
		$sql = "select * from table(get_plural_field($docID, '$fieldName', '$typeName'))";
		self::log($sql);
		$multi_field = ora_select($sql, 'no-cache', '', '');
		return $multi_field["COLUMN_VALUE"];
	}

	public static function updateSimpleField($docID, $typeName, $fieldName, $value, $commit = true) {
		$sql = "UPDATE_SIMPLE_FIELD($docID, '$fieldName', '$typeName', '$value')";
		self::log($sql);
		ora_proc($sql, $commit);
	}
	
	public static function deleteDocument($documentID, $commit=true) {
		$sql = "delete from DOCUMENTS_TREE where DOCUMENT_ID = $documentID";
		self::log($sql);
		ora_proc($sql, $commit);
	}

	public static function getDocumentStatus($docID) {
		$sql = "documents.GET_STATUS_NAME(documents.DOCF_GET_STATUS($docID))";
		self::log($sql);
		return ora_func($sql);
	}
	
	public static function changeDocumentStatus($docID, $statusName, $commit=true) {
		$sql = "SET_STATUS($docID, GET_DOCEVENTKIND_ID('$statusName'), true)";
		self::log($sql);
		ora_proc($sql, $commit);
	}
	
	public static function createEmptyDocument($documentType, $commit=true) {
		$sql = "inc_create_document_empty ('$documentType', :TYPE_ID, :DOCUMENT_ID)";
		$binding = array("TYPE_ID" => &$typeID, "DOCUMENT_ID" => &$docID);
		self::log($sql);
		$error = ora_func($sql, $commit, $binding);
		if ($error != 0) {
			throw new Exception("Could not create new $documentType");
		}
		return $docID;
	}
	
	/**
	 * Удаление документа из ссылочного поля одного родителя и вставка в другой
	 * Один из родителей может быть опущен
	 * @param int $documentID ID перемещаемого документа
	 * @param int $oldParentID ID старого родителя
	 * @param int $newParentID ID нового родителя
	 * @param string $oldparentType тип старого родителя
	 * @param string $oldField поле с документом в старом родителе
	 * @param string $newParentType тип нового родителя (если не задан -- берётся от старого)
	 * @param string $newField поле с документом в новом родителе (если не задано -- берётся от старого)
	 */
	public static function reparentDocument($documentID, $oldParentID, $newParentID, $oldParentType, $oldField, $newParentType = null, $newField = null) {
		if (!empty($oldParentID)) {
			WaveEditorUtils::delReference($oldParentID, $oldParentType, $oldField, $documentID);
		}
		if (!empty($newParentID)) {
			if (empty($newParentType)) $newParentType = $oldParentType;
			if (empty($newField)) $newField = $oldField;
			WaveEditorUtils::addReference($newParentID, $newParentType, $newField, $documentID);
		}
		
	}
	/**
	 * Привязка всех документов, находящихся во множественной ссылке у одного, к другому.
	 * @param int $parentID ID текущего родительского объекта
	 * @param string $parentType тип текущего родительского объекта
	 * @param string $childrenField поле с детьми
	 * @param int $newParentID ID нового родительского объекта (если не задано -- дети остаются сиротами)
	 * @param string $newParentType тип нового родительского объекта (если не задан -- берётся от старого)
	 * @param string $newChildrenField новое поле с детьми (если не задано -- берётся от старого)
	 */
	public static function reparentChildren($parentID, $parentType, $childrenField, $newParentID, $newParentType = null, $newChildrenField = null) {
		if (empty($newParentType)) {
			$newParentType = $parentType;
		}
		if (empty($newChildrenField)) {
			$newChildrenField = $childrenField;
		}
		$children = self::getMultiReference($parentID, $parentType, $childrenField);
		foreach ($children as $child) {
			WaveEditorUtils::delReference($parentID, $parentType, $childrenField, $child);
			if (!empty($newParentID)) {
				WaveEditorUtils::addReference($newParentID, $newParentType, $newChildrenField, $child);
			}
		}
		
	}
}
?>
