<?php
include_once 'class.EmptyFieldsException.php';
include_once 'class.Document.php';
include_once 'class.Field.php';
include_once 'class.WaveEditorUtils.php';

/**
 * Универсальный редактор документов
 *
 * @author aleksandr
 */
class WaveEditor {
	/**
	 * Получение документа и запись его копии в кэш
	 * @return Document 
	 */
	public static function getDocument($docID, $formName) {
		$sql = "select * from table(APPL_WEB_FORM.GET_FORM_DATA ('$formName', $docID))";
		//echo $sql; //td
		utls::logStr("WaveEditor", $sql);
		$res = ora_select($sql, 'no-cache', '', '');
		$res = ora_redim($res);
		$document = new Document($docID, $formName);
		foreach ($res as $record) {
			$field = new Field();
			$field->fieldName = $formName . "_" . $record['FIELD_NAME'];
			$field->caption = $record['CAPTION'];
			$field->comment = $record['INFORMATION'];
			$field->notNull = $record['NOT_NULL'];
			$field->readOnly = $record['READ_ONLY'];
			$field->value = $record['FIELD_VALUE'];
			$field->display = $record['FIELD_DISPLAY'];
			$document->fields[$record['FIELD_NAME']] = $field;
		}
		$document->checkRecentSaving();
		file_put_contents(DATA_DIR . "/cache/$docID" . "_" ."$formName",
				'<?php $oldDocument = ' . var_export($document, true) . " ?>");
		//utls::logStr("WaveEditor", print_r($document, true));//td
		return $document;
	}

	/**
	 * Сохранение документа
	 * @param Document $newDocument
	 * @return int id документа (нового или отредактированного)
	 */
	public static function saveDocument(Document $newDocument, $commit=true) {
		  utls::logStr("WaveEditor", "got: ".print_r($newDocument, true));//td
//		  utls::logStr("WaveEditor", "entered: ".$newDocument->allFieldsEntered);//td
		if (!$newDocument->allFieldsEntered) {
			throw new EmptyFieldsException($newDocument);
		}
		$oldDocument = null; //Версия до редактирования (из кэша)
		$createdNew = true; //документ создавался, а не редактировался
		try {
			//считываем $oldDocument
			include DATA_DIR . "/cache/$newDocument->id" . "_" ."$newDocument->formName";
			$createdNew = false;
		} catch (Exception $e){}
		$values = "";
		$formNameLen = strlen($newDocument->formName);
		if ($createdNew) { //если $oldDocument не было -- пишем документ целиком
			foreach ($newDocument->fields as $field) {
				if ($field->toWrite && !$field->readOnly) {
					$fieldName = substr($field->fieldName, $formNameLen + 1);
					$values = ", \n\tT_WEB_FORM_IN_RECORD('$fieldName', '$field->value')"
							. $values;
				}
			}
		} else { //иначе пишем patch
			foreach ($newDocument->fields as $name => $newValue) {
				$old = $oldDocument->fields[$name]->value;
				if ($old != $newValue->value && $newValue->toWrite && !$newValue->readOnly) {
					$field = $newValue;
					$fieldName = substr($field->fieldName, $formNameLen + 1);
					$values = ", \n\tT_WEB_FORM_IN_RECORD('$fieldName', '$field->value')" . $values;
				}
			}
		}
		if ($values != "") {
			$values = substr($values, 2);
			$sql = "APPL_WEB_FORM.SET_FORM_DATA('$newDocument->formName', $newDocument->id,
	T_WEB_FORM_IN ($values
	)
)";
			utls::logStr("WaveEditor", "save: $sql");//td
			$result = ora_func($sql, $commit);
			if ((int)$result > 0) {
				if (!is_array($_SESSION["savedDocuments"])) {
					$_SESSION["savedDocuments"] = array();
				}
				$_SESSION["savedDocuments"][]=(int)$result;
				return (int)$result;
			} else {
				throw new Exception("$result\nQuery:  $sql");
			}
		} else {
			return $newDocument->id;
		}
	}

	/**
	 * Считывание пустого документа из БД и изменение ID на требуемый
	 * @param int $docID
	 * @param string $formName 
	 * @return Document
	 */
	public static function createTemplate($docID, $formName) {
		$template = WaveEditor::getDocument(-1, $formName);
		$template->id = $docID;
		return $template;
	}

	/**
	 * Создание документа из данных, отправленных попльзователем.
	 * Сохраняются поля POST-переменной, названия которых совпадают с полями шаблона.
	 * @param int $docID
	 * @param string $formName 
	 * @return Document
	 */
	public static function createWebPostDocument($docID, $formName, $iconv = false) {
		$document = WaveEditor::createTemplate($docID, $formName);
		foreach ($document->fields as $fieldName => $field) {
			if (isset($_POST[$field->fieldName])) {
				$document->saveWebPostField($fieldName, $iconv);
			}
		}
		return $document;
	}

	/**
	 * Изменение статуса любого поддокумента в Web-форме
	 * @param int $docID
	 * @param string $formName 
	 * @param array $statuses Ассоциативный массив Имя документа => имя статуса
	 */
	public static function changeWebformStatus($docID, $formName, $statuses, $commit=true) {
		$sql = "APPL_WEB_FORM.SET_WEB_FORM_STATUS('$formName', $docID, T_WEB_FORM_IN (";
		foreach ($statuses as $subdocument => $status) {
			$sql .= "T_WEB_FORM_IN_RECORD('$subdocument', '$status')";
		}
		$sql .= "))";
		utls::logStr("WaveEditor", "status: $sql");//td
		$result = ora_func($sql, $commit);
		if ($result != "") {
			throw new Exception("$result<br/>\n$sql");
		}
	}
}
?>
