<?php

/**
* Поле документа. Содержит имя, под которым поле представлено в документе,
* Carabi-форме и, как правило, Web-форме, значение,
* отображаемое значение (для ссылок и словарных полей), подпись и комментарий,
* флаги редактируемости и обязательности заполнения.
*
* @author aleksandr
*/
class Field {
	public $fieldName;
	public $caption;
	public $comment;
	public $notNull;
	public $readOnly;
	public $value;
	public $display;

	public $toWrite = false;//При сохранении документа это поле должно быть записано в БД 
							//(после чтения было изменено пользователем или программой)
	public $reenter = false;//пользователь должен ввести данные повторно

	public function __construct($fieldName=null, $caption=null, $value=null, $notNull=null) {
		$this->fieldName = $fieldName;
		$this->caption = $caption;
		$this->value = $value;
		$this->notNull = $notNull;
	}

	public static function __set_state($array) {
		$field = new Field();
		$field->fieldName = $array["fieldName"];
		$field->caption = $array["caption"];
		$field->comment = $array["comment"];
		$field->notNull = $array["notNull"];
		$field->readOnly = $array["readOnly"];
		$field->value = $array["value"];
		$field->display = $array["display"];
		return $field;
	}

	/**
	* Для множественных словарных полей и ссылок.
	* @return array
	*/
	public function getMultivalue() {
		if (strlen($this->value) > 0) {
			return explode("\x5", $this->value);
		} else {
			return array();
		}
	}
	public function setMultivalue($array) {
		$this->value = implode("\x5", $array);
	}
}

?>
