{function name="renderMulti"}
	<script type="text/javascript">
	head(function() {
		var f = function() {
			var cId = '{$id}';
			var control = VocabularyList({
				'container': '#vocCont_' + cId + ' .vocList',
				'multi': true,
				'items': [ {$items} ],
				'input': '#' + cId
			});
			var liHeight = $('#vocCont_' + cId + ' .vocList li').height();
			var vocList = $('#vocCont_' + cId + ' .vocList');
			var oldMaxHeight = (7*liHeight)+'px';
			var newMaxHeight = (25*liHeight)+'px';
			vocList.css('max-height', oldMaxHeight);
			$('#vocCont_'+cId+' .expandButton').bind('click', function() {
				var newHeight;
				if ($(this).hasClass('collapse')) {
					newHeight = oldMaxHeight;
				} else {
					newHeight = newMaxHeight;
				}
				vocList.animate({
					"max-height": newHeight
				},500);
				$(this).toggleClass('collapse');
			});
		};
		getCSS(js_url+'/de/vocabulary.css');
		head.js(
			js_url + '/de/optionsList.js',
			js_url + '/de/stringSource.js',
			js_url + '/de/vocabulary.js',
			f
		);
	});
	</script>
	<input
		type="hidden"
		name="{$id}"
		id="{$id}"
		value='{$value}'
	><div class="vocabulary" id="vocCont_{$id}">
		<div id="" class="vocList"></div>
		<div class="expandPanel">
		<span class="expandButton"></span>
		</div>
	</div>
{/function}

{function name="renderSingle"}
	{if $readonly}
		<span class="uneditable-input" style>{$value}</span>
	{else}
		<select id="{$id}" name="{$id}" class="frmSelect frm_10">
			{if $addEmptyNode}
				<option value="" style="font-style:italic; color: grey;">нет</option>
			{/if}
			{$items}
		</select>
	{/if}
{/function}

{if $isMulti}
	{renderMulti}
{else}
	{renderSingle}
{/if}