<?php

namespace documentEditor;

class session
{

    protected $session;
    protected $carabiEditor;
    protected $documentId;
    protected $isNewSession;
    protected $sessionToken;



    public function __construct(\carabiEditor $carabiEditor)
    {
        $this->carabiEditor = $carabiEditor;
        session_start();
        $this->logger()->logStr('PHP Session id: ' . session_id());        
        if (!array_key_exists('carabiEditor', $_SESSION)) {
            $_SESSION['carabiEditor']=array();
        }
        $this->sessionToken = null;
    }



    public function isValidSessionToken($testSessionToken)
    {
        if (!$this->getMainDocumentId())
            return false;
        
        return array_key_exists($testSessionToken, $_SESSION['carabiEditor']);
    }



    public function newSession()
    {
        $documentId = $this->getMainDocumentId();
        if (!$documentId)
            throw new \Exception('Invalid document.');
        $tok = md5(uniqid());
        $this->logger()->logStr('New session. Token: ' . $tok);
        $this->sessionToken = $tok;
        $this->isNewSession = true;
        $_SESSION['carabiEditor'][$this->sessionToken] = array($documentId=>array());
        $this->session =& $_SESSION['carabiEditor'][$this->sessionToken][$documentId];
        $this->logger()->logStr('New session. Token: ' . $this->sessionToken);        
    }



    public function setSession($sessionToken)
    {
        if (!$this->isValidSessionToken($sessionToken))
            throw new \Exception('Invalid session token.');
        
        $documentId = $this->getMainDocumentId();
        $this->logger()->logStr('Continue session. Token: ' . $sessionToken . '. ' . PHP_EOL . 'Session content:' . print_r($this->session, true));
        $this->sessionToken = $sessionToken;
        $this->isNewSession = false;
        $this->session =& $_SESSION['carabiEditor'][$this->sessionToken][$documentId];
        $this->logger()->logStr('Continue session. Token: ' . $this->sessionToken . '. ' . PHP_EOL . 'Session content:' . print_r($this->session, true));
    }



    public function getSessionToken()
    {
        return $this->sessionToken;
    }



    //public function reset()
    //{
    //    $this->check();
    //    $this->logger()->logStr('Session reseted');
    //    $this->session = array();
    //}



    /**
     * @todo Сделать проверку на id добавляемого документа и главного документа
     * при совпадении тригеровать ошибку.
     *
    */
    public function addDocument($documentId)
    {
        $this->check();
        if (!is_array($this->session['openedDocuments'])) {
            $this->session['openedDocuments'] = array();
        }
        
        $this->session['openedDocuments'][$documentId] = array();
        $this->logger()->logStr('Added document in session. Session content: ' . print_r($this->session, true));
    }



    public function &getDocuments()
    {
        $this->check();
        
        if (!is_array($this->session['openedDocuments'])) {
            $this->session['openedDocuments'] = array();
        }
        
        return $this->session['openedDocuments'];
    }



    protected function logger()
    {
        return $this->carabiEditor->logger();
    }



    protected function check()
    {
        if (!is_array($this->session)) {
            throw new \Exception('Invalid session.');
        }
    }
    
    protected function getMainDocumentId()
    {
        if (!$this->documentId) {
            $md = $this->carabiEditor->mainDocument();
            if (!$md)
                return;
                //throw new Exception('Document is not defined');
            $this->documentId = $md->document_id;
        }
        return $this->documentId;
    }

}

    //protected function &session() {
    //    if (!is_array($this->session)) {
    //        $this->sessionStart();
    //    }
    //    return $this->session;
    //}
    //        //if (empty($this->sessionToken))) {
    //        //    throw new Exception('Invalid session token.');
    //        //}
    //        //if (!array_key_exists($sessionToken, $_SESSION['carabiEditor'])) {
    //        //
    //        //    $_SESSION['carabiEditor'][$sessionToken] = array();
    //        //}
    //        //
    //        //$md = $this->carabiEditor->mainDocument();
    //        //if (!$md)
    //        //    throw new Exception('Document is not defined');
    //        //$mainDocumentId = $md->document_id;
    //        //if (!array_key_exists($mainDocumentId, $_SESSION['carabiEditor'][$sessionToken])) {
    //        //    $_SESSION['carabiEditor'][$sessionToken][$mainDocumentId] = array();
    //        //}
    //        if (empty($this->sessionToken) || empty())
    //        $this->session =& $_SESSION['carabiEditor'][$sessionToken][$mainDocumentId];
    //        $this->logger()->logStr('Session content: ' . print_r($this->session, true));

?>