<?php
/**

 * @todo разобраться с isSended
 * @todo extractJSON_intArray в утилс
 * 
*/

namespace carabiEditor;

class propertyEditor
{
    // объект реквизита объекта Караби
    protected $simpleProperty=null;
    // объект редактора родительского объекта Караби
    protected $documentEditor=null;
	protected $config;
	protected $propertyKindName;
	protected $requested;



    public function __construct(\SimpleProperty $simpleProperty,
								documentEditor $documentEditor)
    {
		$this->simpleProperty = $simpleProperty;
		$this->documentEditor = $documentEditor;
		$this->readConfig();
		$this->requested = false;
    }



    /**
     *
    */
    public function processRequest()
    {
		$this->logger()->logStr(PHP_EOL);
		$this->logger()->logStr('docId:' . $this->document()->document_id
								. ' propId:' . $this->property()->get_docprop_id()
								. ' (' . $this->property()->get_docprop_descr() . ')'
								. ' -> ' . __METHOD__);
		
		$call = $_REQUEST['call'];
		$propertyRequestHandler = 'request_' . $call;
		$this->requested = true;
		$cb = $this->config->getValue($propertyRequestHandler);
		$this->carabiEditor()->executeFunction($cb, $this);        
    }



    /**
     * Функция выводит пользовательское представление текущего свойства, либо
     * передаёт управление выводом соответсвующему плагину.
     *
    */    
    public final function renderProperty()
    {
		$this->logger()->logStr(PHP_EOL);
		$this->logger()->logStr('docId:' . $this->document()->document_id
								. ' propId:' . $this->property()->get_docprop_id()
								. ' (' . $this->property()->get_docprop_descr() . ')'
								. ' -> ' . __METHOD__);
		
		$cb = $this->config->getValue('renderProperty');
		$this->carabiEditor()->executeFunction($cb, $this, $return);
    }



	public function renderControl($return=false)
	{
		$this->logger()->logStr(PHP_EOL);
		$this->logger()->logStr('docId:' . $this->document()->document_id
								. ' propId:' . $this->property()->get_docprop_id()
								. ' (' . $this->property()->get_docprop_descr() . ')'
								. ' -> ' . __METHOD__);
		
		$cb = $this->config->getValue('renderControl');
		$this->carabiEditor()->executeFunction($cb, $this, $return);
	}



	public function saveProperty()
	{
		$this->logger()->logStr(PHP_EOL);
		$this->logger()->logStr('docId:' . $this->document()->document_id
								. ' propId:' . $this->property()->get_docprop_id()
								. ' (' . $this->property()->get_docprop_descr() . ')'
								. ' -> ' . __METHOD__);
		
		$cb = $this->config->getValue('save');
		$this->carabiEditor()->executeFunction($cb, $this);
	}



    /**
     * Если аргумент не указан функция проверяет было ли поле посланно ранее в
     * сессии. Если аргемент указан (bool), то cохраняет в сессии это значение.
     *
     * Функция устаревшая.
     * 
     * @todo прекратить использование
    */
    public function isSended($isSended=null)
    {
		$docs = &$this->session()->getDocuments();
		$docId = $this->document()->document_id;
		if (!is_array($docs[$docId]['sendedProperties']))
			$docs[$docId]['sendedProperties'] = array();
		if (is_null($isSended)) {
			return ($docs[$docId]['sendedProperties'][$this->property()->get_docprop_id()] ? true : false);
		} else {
			$docs[$docId]['sendedProperties'][$this->property()->get_docprop_id()] = $isSended;
		}
    }



	/**
	 * Возвращает true если поле было вызванно из запроса.
	 *
	 * @todo пересмотреть функцию
	 * 
	*/
	public function isRequested()
	{
		return $this->requested?true:false;
	}



    public function propertyKind($asName=false)
    {
		if ($asName) {
			if (!$this->propertyKindName) {
				$pts = $this->carabiEditor()->config()->getValue('propertyTypes');
				$this->propertyKindName = $pts[$this->property()->get_docprop_kind()];
			}
			return $this->propertyKindName;
		} else {
			return $this->property()->get_docprop_kind();
		}
    }



    public function propertySubKind()
    {
		return $this->property()->get_docprop_object();
    }



    /**
     * Функция генерирует уникальный идентификатор. Используется в
     * пользовательском представлении.
     *
     * Претендент на шаблонную функцию, либо JS
     *
    */
    public function control_id($doc_id=null, $prop_id=null)
    {
		if (!$prop_id)
			$prop_id = $this->property()->get_docprop_descr();
		if (!$doc_id)
			$doc_id = $this->document()->document_id;
	
		$prop_id = str_replace('-', '_', $prop_id);
		
		return 'P_'
			. $doc_id
			. '_'
			. $prop_id;
    }


	/**
	 * Читает конфиги в определнной последовательности
	 *
	 * @todo добавить ещё из getConfigValues! для полноценной навигации по переопределнным значениям.
	 *
	*/
	protected function readConfig()
	{
		$propertyTypeName = $this->propertyKind(true);
		$propertyName = $this->property()->get_docprop_descr();
		$documentType = $this->document()->dockind_namevar;
		
		$this->config = new \carabiEditor\config((array)$this->carabiEditor()->config()->getValue('property'),
												 (array)$this->carabiEditor()->config()->getValue('property_D' . strtolower($documentType)),
												 (array)$this->carabiEditor()->config()->getValue('property_T' . strtolower($propertyTypeName)),
												 (array)$this->carabiEditor()->config()->getValue('property_P' . strtolower($propertyName)),
												 (array)$this->carabiEditor()->config()->getValue('property_D' . strtolower($documentType) . '_T' . strtolower($propertyTypeName)),
												 (array)$this->carabiEditor()->config()->getValue('property_D' . strtolower($documentType) . '_P' . strtolower($propertyName)));
	}
	
	



    public function __call($name, $arguments)
    {
        switch (strtolower($name)) {
            case 'carabieditor':
                return $this->documentEditor->carabiEditor();
            break;

            case 'session':
                return $this->documentEditor->carabiEditor()->session();
            break;

            case 'logger':
                return $this->documentEditor->carabiEditor()->logger();
            break;
        
            case 'renderer':
                return $this->documentEditor->carabiEditor()->renderer();
            break;
        

            case 'editor':
                return $this->documentEditor->carabiEditor()->editor();
            break;

            case 'maindocumenteditor':
                return $this->documentEditor->carabiEditor()->editor()->documentEditor();
            break;

            case 'maindocument':
                return $this->documentEditor->carabiEditor()->editor()->document();
            break;
        
            case 'documenteditor':
                return $this->documentEditor;
            break;
		
            case 'document':
                return $this->documentEditor->document();
            break;
		
            case 'property':
                return $this->simpleProperty;
            break;
		
            case 'config':
                return $this->config;
            break;
		
            default:
                throw new \Exception('No such method in propertyEditor: "' . $name . '"');
            break;
        }
    }

}





/**
 *
 *
 * Набор get'еров
 * 
 *
*/


//    /**
//     * Функция возвращает объект Караби, к которому пренадлежит текущее
//     * свойство.
//     * 
//    */
//    public function document ()
//    {
//	return $this->documentEditor_document()->document();
//    }
//
//
//
//    /**
//     * Функция возвращает редактор Караби, к которому пренадлежит документ
//     * текущего свойства.
//     *
//    */
//    public function documentEditor ()
//    {
//	return $this->documentEditor_document()->documentEditor();
//    }


//
//    /**
//     * Функция возвращает редактор объекта Караби, к которому пренадлежит
//     * текущее свойство.
//     *
//    */
//    public function documentEditor_document ()
//    {
//	return $this->documentEditor_document;
//    }
//
//
//
//    /**
//     * Функция возвращает рендерер
//     * 
//    */
//    public function renderer ()
//    {
//	return $this->documentEditor_document()->renderer();
//    }



//    /**
//     * функция возвращает текущее свойство объекта Караби
//     * 
//    */
//    public function property ()
//    {
//	return $this->simpleProperty;
//    }
//
//
//
//    /**
//     *
//     *
//    */
//    public function logger($scope='')
//    {
//	return $this->documentEditor()->logger($scope);
//    }
//    protected function smartyPropertyFetch($renderedControl)
//    {
//		$tmplt = $this->smartyFindTemplate();
//		$tpl = $this->createTemplate($tmplt);
//		$tpl->assign('control', $renderedControl);
//		return $tpl->fetch();
//    }
//
//    protected function smartyFindTemplate()
//    {
//		$tmplts = array();
//		$tmplts[] = 'de_property_' . $this->propertyKind(true) . '_' . $this->propertySubKind() . '.tpl.html';
//		$tmplts[] = 'de_property_' . $this->propertyKind() . '_' . $this->propertySubKind() . '.tpl.html';
//		$tmplts[] = 'de_property_' . $this->propertyKind(true) . '.tpl.html';
//		$tmplts[] = 'de_property_' . $this->propertyKind() . '.tpl.html';
//		$tmplts[] = $this->propertyTmplt;
//		for ($i=0, $j=count($tmplts); $i<$j; $i++) {
//			//echo '<li>', $tmplts[$i];
//			if ($this->renderer()->templateExists($tmplts[$i])){
//			return $tmplts[$i];
//			}
//		}
//		return false;
//    }
//
//
//    protected function createTemplate($templateFileName, $parentTemplate=null)
//    {
//		$tpl = $this->renderer()->createTemplate($templateFileName, $parentTemplate);
//		$tpl->configLoad('de.conf');
//		$tpl->assign('carabiEditor', $this->carabiEditor());
//		$tpl->assign('options', $this->options);
//		$tpl->assign('documentEditor', $this->documentEditor());
//		$tpl->assign('propertyEditor', $this);
//		return $tpl;
//    }
//    protected function renderPropertyNative()
//    {
//		$this->isSended(true);
//		$renderedControl = $this->renderControl();
//		
//		if (false===$renderedControl) {
//			return null;
//		} else {
//			return $this->smartyPropertyFetch($renderedControl);
//		}
//    }
//    
//    /**
//     * Функция возвращает пользовательское представление для текущего свойства.
//     * Должен возвращаться не всё представление, а только контрол.
//     * Если взвращается ложь, то свойство вообще не будет отображенно.
//     *
//    */
//    public final function renderControl()
//    {
//		$this->logger()->logStr(sprintf('DID:%d, DTYPE:"%s"; PID:%d, PTYPE:"%s"',
//										$this->document()->document_id,
//										$this->document()->dockind_namevar,
//										$this->property()->get_docprop_id(),
//										$this->property()->get_docprop_descr())
//								. ' Rendering control: ');
//		
//		$pluginCall = $this->pluginFinder->find('renderControl');
//		if (false!==$pluginCall) {
//			$this->logger()->logAddStr('By plugin: ' . implode('::', $pluginCall).'().');
//			$renderedControl = call_user_func($pluginCall, $this);
//		} else {
//			$this->logger()->logAddStr('Native.');
//			$renderedControl = $this->renderControlNative();
//		}
//		
//		return $renderedControl;
//    }
//   
//    protected function renderControlNative()
//    {
//		return false;
//    }
//
//

/**
 *      /
 *    /  Р Е Н Д Е Р И Н Г
 *  /
*/
//    /**
//     * Статическая функция-фабрика для инициализации редактора свойства объекта
//     * Караби. Сперва пытается инициализировать класс в зависимости от
//     * типа свойства, иначе инициализирует этот класс. Так же выполняется
//     * проверка как инстанцировать класс. Если в классе есть статический метод
//     * 'inst', то классс будет инстанцирования через него, иначе через
//     * стандартный метод.
//     *
//     * @param simpleProperty $simpleproperty
//     * @param documentEditor_document $documentEditor_document
//     *
//     * @return documentEditor_property
//    */
//    static public final function init($simpleproperty, $documentEditor_document)
//    {
//		//if ($simpleproperty->get_docprop_kind()==16)
//		$propertyTypeName = self::$propertyTypes[$simpleproperty->get_docprop_kind()];
//		if(!$propertyTypeName)
//			return;
//		$cn = 'carabiEditor\\Properties\\' . $propertyTypeName;
//		try {
//			if (is_callable(array($cn, 'inst'))) {
//				return $cn::inst($simpleproperty, $documentEditor_document);
//			} else {
//				return new $cn($simpleproperty, $documentEditor_document);
//			}
//		} catch (\Exception $e) {
//			//echo $e->getMessage();
//			return false;
//		}
//    }
//        if (empty($this->propertyConfig[$propertyRequestHandler]))
//            throw new \Exception('No handler for property request. 01: "' . $call . '".');
//            
//        if (!is_callable($this->propertyConfig[$propertyRequestHandler]))
//            throw new \Exception('No handler for property request. 02: '
//								 . print_r($this->propertyConfig[$propertyRequestHandler], true));
//            
//        call_user_func($this->propertyConfig[$propertyRequestHandler], $this, $return);
		
		//$this->logger()->logStr(sprintf('DID:%d, DTYPE:"%s"; PID:%d, PTYPE:"%s"',
		//				$this->document()->document_id,
		//				$this->document()->dockind_namevar,
		//				$this->property()->get_docprop_id(),
		//				$this->property()->get_docprop_descr())
		//			. ' Internal call: ');
		//$call = $_REQUEST['call'];
		//$this->logger()->logAddStr($call . '. ');
		//
		//$pluginCall = $this->pluginFinder->find('call_' . $call);
		//if (false!==$pluginCall) {
		//	$this->logger()->logAddStr('Calling: ' . implode('::',$pluginCall) . '().');
		//	call_user_func($pluginCall, $this);
		//} else {
		//	$this->logger()->logAddStr('No callbacks found');
		//	throw new Exception('This is not internall call: "' . $call . '".');
		//	
		//}
        //if (empty($this->propertyConfig['renderProperty']))
        //    throw new \Exception('No render for property. 01. ' );
        //    
        //if (!is_callable($this->propertyConfig['renderProperty']))
        //    throw new \Exception('No render for property. 02. ' . print_r($this->propertyConfig['renderProperty'], true));
        //    
        //call_user_func($this->propertyConfig['renderProperty'], $this, $return);

		//$this->logger()->logStr(sprintf('DID:%d, DTYPE:"%s"; PID:%d, PTYPE:"%s"',
		//								$this->document()->document_id,
		//								$this->document()->dockind_namevar,
		//								$this->property()->get_docprop_id(),
		//								$this->property()->get_docprop_descr())
		//						. ' Rendering property: ');
		//
		//if (!$this->property()->get_DOCPROP_VISIBLE()) {
		//	$this->logger()->logAddStr('Not visible. Skipping.');
		//	return;
		//}

		//
		//$pluginCall = $this->pluginFinder->find('renderProperty');
		//if (false!==$pluginCall) {
		//	$this->logger()->logAddStr('By plugin: ' . implode('::', $pluginCall) . '().');
		//	$renderedProperty = call_user_func($pluginCall, $this);
		//} else {
		//	$this->logger()->logAddStr('Native.');
		//	$renderedProperty = $this->renderPropertyNative();
		//}
		//return $renderedProperty;
        //if (empty($this->propertyConfig['renderControl']))
        //    throw new \Exception('No render for control. 01. ' );
        //    
        //if (!is_callable($this->propertyConfig['renderControl']))
        //    throw new \Exception('No render for control. 02. ' . print_r($this->propertyConfig['renderControl'], true));
        //
        //call_user_func($this->propertyConfig['renderControl'], $this, $return);
		
        //if (empty($this->propertyConfig['save']))
        //    throw new \Exception('No save. 01');
        //    
        //if (!is_callable($this->propertyConfig['save']))
        //    throw new \Exception('No save. 02');
        //    
        //call_user_func($this->propertyConfig['save'], $this);
//
//
//
//    /**
//     * Следующие функции для переопределения в дочерних классах. В будущем
//     * возможна абстракция
//     *
//    */
//
//
//    final public function collectValue()
//    {
//		if ($this->isSended()) {
//			$this->logger()->logStr(sprintf('DID:%d, DTYPE:"%s"; PID:%d, PTYPE:"%s"',
//							$this->document()->document_id,
//							$this->document()->dockind_namevar,
//							$this->property()->get_docprop_id(),
//							$this->property()->get_docprop_descr())
//						. ' Collecting value: ');
//			
//			$pluginCall = $this->pluginFinder->find('collectValue');
//			if (false!==$pluginCall) {
//				$this->logger()->logAddStr('By plugin: ' . implode('::', $pluginCall).'().');
//				$retVal = call_user_func($pluginCall, $this);
//			} else {
//				$this->logger()->logAddStr('Native.');
//				$retVal = $this->_collectValue();
//			}
//			return $retVal;
//		} else {
//			$this->logger()->logStr('This property wasnt sended to user. Skipping');
//			return true;
//		}
//    }
//
//    /**
//     * Собирает из массива $_REQUEST необходимые данные для свойства.
//     * Кандидат на абстракцию.
//     *
//    */    
//    protected function _collectValue()
//    {
//		$this->logger()->logStr('[info] unsupported property`s type: '
//			.$this->property()->get_docprop_kind()
//			.' ('
//			.self::$propertyTypes[$this->property()->get_docprop_kind()]
//			.')'
//		);
//		return true;
//    }
//	protected function executeFunction($f)
//	{
//		$this->logger()->logStr('[execute function]');
//		
//        if (!empty($f['class']) && !empty($f['method'])) {
//            $cb = array($f['class'], $f['method']);
//        } elseif (!empty($f['method'])) {
//            $cb = $f['method'];
//        } else 
//            throw new \Exception('Bad plugin function definition for execution.');
//            
//        if (!is_callable($cb))
//            throw new \Exception('Wrong plugin function for execution: ' . print_r($f, true));
//			
//		$this->logger()->logArr('Function to execute: ', $cb);
//		$this->logger()->logStr('Start execution');
//		$this->logger()->addTab();
//		try {
//			$args = func_get_args();
//			array_shift($args);
//			call_user_func_array($cb, $args);
//		} catch (\Exception $e) {
//			$this->logger()->deTab();
//			$this->logger()->logStr('Execution failed!');
//			throw $e;
//		}
//		$this->logger()->deTab();
//		$this->logger()->logStr('Execution success!');
//	}
/*    public function testNumeric($test)
    {
		$test = str_replace(',', '.', $test);
		if (!is_numeric($test)) {
			return false;
		}
		return (float)$test;
    }
*/

?>