<?php

namespace carabiEditor\plugins\objects;

class property_vocabulary extends property_default {

	private function __construct(){}

	public static function renderControl(\carabiEditor\propertyEditor $propertyEditor, $return) {
		$voc_vals = get_vocab_values_list($propertyEditor->property()->get_docprop_object());
		if (!is_array($voc_vals)) {
			$voc_vals = array();
		}

		$tpl = self::createTemplate($propertyEditor, 'de_control_vocabulary.tpl');
		$tpl->assign("id", $propertyEditor->control_id());
		$tpl->assign("isMulti", $propertyEditor->property()->isMulti());
		$readonly = !$propertyEditor->property()->isWriteable();
		$tpl->assign("readonly", $readonly);
		if ($propertyEditor->property()->isMulti()) {
			$items = '';
			for ($i=0, $j=count($voc_vals); $i<$j; $i++) {
				$items .= '{id:"' . $voc_vals[$i]['CODE'] . '", str:"'
				.$voc_vals[$i]['VALUE'] . '"}' . (($i+1)<$j?',':'');
			}

			$tpl->assign("items", $items);
			$tpl->assign("value", json_encode($propertyEditor->property()->get_values()));
		} else {
			if ($readonly) {
				$value = $propertyEditor->property()->get_value();
				foreach ($voc_vals as $voc) {
					if ($voc['CODE']==$value) {
						$tpl->assign("value", $voc['VALUE']);
						break;
					}
				}
			} else {
				$value = $propertyEditor->property()->get_value();
				$tpl->assign("value", $value);
				$canBeNull = !$propertyEditor->property()->get_docprop_notnull();
				$isNull = !$propertyEditor->property()->get_value();
				$tpl->assign("addEmptyNode", $canBeNull || $isNull);
				$items = '';
				foreach ($voc_vals as $voc) {
					$items .= "<option value=\"{$voc['CODE']}\""
						.($voc['CODE']==$value ? ' selected="selected"' : "")
						.">{$voc['VALUE']}</option>"
					;
				}
				$tpl->assign("items", $items);
			}
		}
		$retVal = $tpl->fetch();
		if ($return)
			return $retVal;
		else
			echo $retVal;

	}



	public static function saveProperty(\carabiEditor\propertyEditor $propertyEditor) {
		$reqKey = $propertyEditor->control_id();
		
		$propertyEditor->logger()->logStr('[VOCABULARY]   Control id: "' . $reqKey . '"');
		
		if (!array_key_exists($reqKey, $_REQUEST)) {
			$propertyEditor->logger()->logStr('Property wasnt been sent by user. Skipping.');
		}
		
		$propertyEditor->logger()->logStr('REQUEST RAW CONTENT: ' . $_REQUEST[$reqKey]);
		
		if ($propertyEditor->property()->isMulti()) {
			self::saveMultiValue($propertyEditor);
		} else {
			self::saveSingleValue($propertyEditor);
		}
	}
	
	
	
	protected static function saveMultiValue(\carabiEditor\propertyEditor $propertyEditor) {
		$propertyEditor->logger()->logStr('Collecting as a multi value');
		$reqKey = $propertyEditor->control_id();
		$v = \deutils::extractJSON_intArray(trim($_REQUEST[$reqKey]));
		if (!is_array($v)) {
			throw new Exception('Wrong format of data. Array expected.');
		}
		//$propertyEditor->logger()->logStr('Request parsed content: ' . print_r($v, true));
		$propertyEditor->logger()->logArr('Request parsed content: ', $v);
		
		if (empty($v) && $propertyEditor->property()->get_docprop_notnull()) {
			//$propertyEditor->logger()->logStr('Wrong data. Required property. No data.');
			//return false;
			throw new Exception('Required property');
		}
		
		// сохранённые значения
		$values = $propertyEditor->property()->get_values();
		$propertyEditor->logger()->logArr('SAVED VALUES:', $values);
		// удаляем невыделенные значения по их индексу вбазе. см. todo.
		$idx_to_delete = array_keys(array_diff($values, $v));
		array_walk($idx_to_delete,
			function($value_idx, $i, $those) {
				$those->logger()->logStr('Delete value with idx=' . $value_idx);
				$those->property()->deleteValue($value_idx);
			},
			$propertyEditor
		);
		
		if (!empty($v)) {
			// значения для добавления
			$non_saved_values = array_diff($v, $values);
			// все доступные значения
			$available_values = &self::getAvailableValues($propertyEditor);
			$propertyEditor->logger()->logArr('AVAIL VALUES: ', $available_values);
			// валидируем пришедшие значения
			$values_to_add = array_intersect($non_saved_values, $available_values);
			// добавляем
			array_walk($values_to_add,
				function($value, $i, $those) {
					$those->logger()->logStr('Adding value:' . $value);
					$those->property()->addValue(array('V0'=>$value));
				},
				$propertyEditor
			);
		}
		return true;
	}
	

	protected static function saveSingleValue(\carabiEditor\propertyEditor $propertyEditor) {
		$propertyEditor->logger()->logStr('Collecting as a single value');
		$reqKey = $propertyEditor->control_id();
		$v = (int)trim($_REQUEST[$reqKey]);
		$propertyEditor->logger()->logStr('Parsed content: "' . $v . '"');
		$storedValue = $propertyEditor->property()->get_value();
		$propertyEditor->logger()->logStr('Stored value: "' . $storedValue . '"');
		
		if ($v==$storedValue) {
			$propertyEditor->logger()->logStr('Values is equal. Skipping.');
			return;
		}
		
		if (!empty($v)) {
			$available_values = &self::getAvailableValues($propertyEditor);
			if (!in_array($v, $available_values)) {
				throw new Exception('Unexisting request value');
			}
			$propertyEditor->logger()->logStr('Update value: ' . $v);
			$propertyEditor->property()->setValue(array('V0'=>$v));
			return true;
		} else {
			if ($propertyEditor->property()->get_docprop_notnull()) {
				throw new Exception('Required property.');
			}
			$propertyEditor->logger()->logStr('Clear value.');
			$propertyEditor->property()->deleteValue();
			return true;
		}
	}

	

	protected static function &getAvailableValues(\carabiEditor\propertyEditor $propertyEditor) {
		$voc_vals = get_vocab_values_list($propertyEditor->property()->get_docprop_object());
		if (!is_array($voc_vals)) {
			$voc_vals = array();
		}
		$available_values = array_map(function($available_value) {
										return $available_value['CODE'];
									  },
									  $voc_vals);
		return $available_values;
	}

}

?>