<?php

namespace carabiEditor\plugins\objects;

class property_simple extends property_default {

	protected static $simpleTypes = array (
		2 => '2', // денежный
		4 => '4', // текст
		5 => '5', // логический выбор

		11 => '11', // стандартная запись числа
		12 => '12', // число с допуском (xxxx +/- yyyy)
		13 => '13', // интервал (от ... до ...)
		14 => '14', // размер (x ... y ... z ...)

		15 => '15', // цвет

		31 => '31', // полный (дата + время)
		32 => '32', // дата
		33 => '33', // время
		34 => '34', // год и месяц
		35 => '35', // год
		36 => '36', // месяц
		37 => '37', // час мин
		38 => '38', // час
		39 => '39', // интервал дат
		40 => '40', // интервал времени
		41 => '41', // полный интервал
		42 => '42', // неделя
		43 => '43', // год неделя

	);

	protected static $simpleTypeNames = array (
		11 => 'стандартная запись числа',
		12 => 'число с допуском (xxxx +/- yyyy)',
		13 => 'интервал (от ... до ...)',
		14 => 'размер (x ... y ... z ...)',
		15 => 'цвет',
		2 => 'денежный',
		31 => 'полный (дата + время)',
		32 => 'дата',
		33 => 'время',
		34 => 'год и месяц',
		35 => 'год',
		36 => 'месяц',
		37 => 'час мин',
		38 => 'час',
		39 => 'интервал дат',
		40 => 'интервал времени',
		41 => 'полный интервал',
		42 => 'неделя',
		43 => 'год неделя',
		4 => 'текст',
		5 => 'логический выбор',
	);



	private function __construct(){}



	public static function renderControl(\carabiEditor\propertyEditor $propertyEditor, $return) {
		$subTypeId = $propertyEditor->property()->get_docprop_object();
		$subTypeHandlerPrefix = self::$simpleTypes[$subTypeId];
		$renderFunction = array(self, 'renderControl_' . $subTypeHandlerPrefix);
		if (!is_callable($renderFunction)) {
			throw new Exception('Bad simple render.');
		}
		if ($return) {
			return call_user_func($renderFunction, $propertyEditor);
		} else {
			echo call_user_func($renderFunction, $propertyEditor);
		}
	}



	public static function saveProperty(\carabiEditor\propertyEditor $propertyEditor) {
		$propertyEditor->logger()->logStr('[SIMPLE]   Control id: "' . $propertyEditor->control_id() . '"');
		$subTypeId = $propertyEditor->property()->get_docprop_object();
		$subTypeHandlerPrefix = self::$simpleTypes[$subTypeId];
		$propertyEditor->logger()->logStr('[' . self::$simpleTypeNames[$subTypeId] . ']');
		$saveFunction = array(self, 'saveProperty_' . $subTypeHandlerPrefix);
		if (!is_callable($saveFunction)) {
			throw new Exception('Bad save property function.');
		}
		call_user_func($saveFunction, $propertyEditor);
	}



	/***************************************************************************
	 * Числовые
	 *
	 */

	// стандартная запись числа
	protected static function renderControl_11(\carabiEditor\propertyEditor $propertyEditor) {
		$tpl = self::createTemplate($propertyEditor, 'de_control_simple_numeric.tpl');
		return $tpl->fetch();
	}

	// число с допуском (xxxx +/- yyyy)
	protected static function renderControl_12(\carabiEditor\propertyEditor $propertyEditor) {
		$tpl = self::createTemplate($propertyEditor, 'de_control_simple_numeric.tpl');
		return $tpl->fetch();
	}

	// интервал (от ... до ...)
	protected static function renderControl_13(\carabiEditor\propertyEditor $propertyEditor) {
		$tpl = self::createTemplate($propertyEditor, 'de_control_simple_numeric.tpl');
		return $tpl->fetch();
	}

	// размер (x ... y ... z ...)
	protected static function renderControl_14(\carabiEditor\propertyEditor $propertyEditor) {
		$tpl = self::createTemplate($propertyEditor, 'de_control_simple_numeric.tpl');
		return $tpl->fetch();
	}



	// стандартная запись числа
	protected static function saveProperty_11(\carabiEditor\propertyEditor $propertyEditor) {
		// Проверка на существующие значения.
		// Если в запросе нет ключа, или его значение пусто, тогда удаляем
		// это значение из базы, иначе обновляем значени (SimpleProperty сам
		// проверит следует ли обновлять значение или пропустить).
		$stored_values = $propertyEditor->property()->get_values();
		//$propertyEditor->logger()->logArr('', $stored_values);
		for ($i=0, $j=count($stored_values); $i<$j; $i++) {
			$k = $propertyEditor->control_id() . '_' . $i;
			if (!array_key_exists($k, $_REQUEST)) {
				$propertyEditor->logger()->logStr('Property wasnt been sent by user. Skipping.');
				continue;
			}
			$propertyEditor->logger()->logStr('Checking stored value with idx: '
									. $i . ' value: ' . $stored_values[$i]);
			//$v = $propertyEditor->testNumeric(trim($_REQUEST[$k]));
			$v = \deutils::testNumeric(trim($_REQUEST[$k]));
			if (false===$v) {
				// todo if $i==0 && required {setValue V0=0}
				$propertyEditor->logger()->logAddStr(' - delete value');		
				$propertyEditor->property()->deleteValue($i);
			} else {
				$propertyEditor->logger()->logAddStr('. Request value: ' . $v);
				$propertyEditor->logger()->logAddStr(' - update/skip value ');
				$propertyEditor->property()->setValue(array('V0'=>$v), $i);
			}
		}
		// Проверка на новые значения для мульти поля.
		// Перебираем значение/значения ключа в запросе. Если значение не
		// пусто, тогда добавляем его в базу.

		$k = $propertyEditor->control_id() . '_new';
		$v = self::numericRequestNewValues($propertyEditor, $k);
		
		if (count($v)) {
			$propertyEditor->logger()->logStr('Have ' . count($v) . ' of new values.');
			if ($propertyEditor->property()->isMulti()) {
				$propertyEditor->logger()->logAddStr(' All of theme will be added.');
				$j = count($v);
			} else {
				if (count($stored_values)) {
					$propertyEditor->logger()->logAddStr(' None of theme will be added.');
					$j=0;
				} else {
					$propertyEditor->logger()->logAddStr(' First of theme will be added.');
					$j=1;
				}
			}

			for ($i=0; $i<$j; $i++) {
				$propertyEditor->logger()->logStr('Adding new value with crc: ' . sprintf("%u", crc32($v[$i])));
				$propertyEditor->property()->addValue(array('V0'=>$v[$i]));
			}
		}
		
		
		if ($propertyEditor->property()->isMulti()) {
			$v = $_REQUEST[$k];
			if (is_array($v)) {
				for ($i=0, $i=count($v); $i<$j; $i++) {
					$v[$i] = \deutils::testNumeric(trim($v[$i]));
					if (false===$v[$i])
					unset($v[$i]);
				}
			} else {
				$v = array(\deutils::testNumeric(trim($_REQUEST[$k])));
				if (false===$v[0])
					$v = array();
			}
			for ($i=0, $j=count($v); $i<$j; $i++) {
				$propertyEditor->logger()->logStr('Adding new value: ' . $v[$i]);
				$propertyEditor->property()->addValue(array('V0'=>$v[$i]));
			}
		}
		return true;
	}



	protected static function numericRequestNewValues(\carabiEditor\propertyEditor $propertyEditor, $request_key) {
		//$v = ;
		$retVal = array();
		if (is_array($_REQUEST[$request_key])) {
			for ($i=0, $j=count($_REQUEST[$request_key]); $i<$j; $i++) {
				$str = \deutils::testNumeric(trim($_REQUEST[$request_key][$i]));
				if (false===$str) {
					continue;
				} else {
					$retVal []= $str;
				}
			}
		} else {
			$str = \deutils::testNumeric(trim($_REQUEST[$request_key]));
			if (false===$str) {
			} else {
				$retVal []= $str;
			}
		}
		return $retVal;
	}


	// число с допуском (xxxx +/- yyyy)
	protected static function saveProperty_12(\carabiEditor\propertyEditor $propertyEditor) {
		$propertyEditor->logger()->logStr('REQUEST CONTENT: '
			.$_REQUEST[$propertyEditor->control_id().'_0']
			.'; '
			.$_REQUEST[$propertyEditor->control_id().'_1']
			.'; '
			.$_REQUEST[$propertyEditor->control_id().'_2']	    
		);
		
		$reqKey = $propertyEditor->control_id() . '_0';
		if (!array_key_exists($reqKey, $_REQUEST)) {
			$propertyEditor->logger()->logStr('Property wasnt been sent by user. Skipping.');
			return true;
		}
		
		$v1 = trim($_REQUEST[$propertyEditor->control_id().'_0']);
		if (empty($v1) && $propertyEditor->property()->get_docprop_notnull()) {
			//echo ' [not valid1]';
			return false;
		}
		
		if (false===($v1=\deutils::testNumeric($v1))) {
			//echo ' [not valid2]';
			return false;
		}
		
		$v2 = trim($_REQUEST[$propertyEditor->control_id().'_1']);
		if (empty($v2) && $propertyEditor->property()->get_docprop_notnull()) {
			//echo ' [not valid3]';
			return false;
		}
		
		if (false===($v2=\deutils::testNumeric($v2))) {
			//echo ' [not valid4]';
			return false;
		}
		
		$v3 = trim($_REQUEST[$propertyEditor->control_id().'_2']);
		if (empty($v3) && $propertyEditor->property()->get_docprop_notnull()) {
			//echo ' [not valid5]';
			return false;
		}
		
		if (false===($v3=\deutils::testNumeric($v3))) {
			//echo ' [not valid6]';
			return false;
		}
		
		//echo ' [valid]';
		//$propertyEditor->property()->setValue($v1, $v2, $v3);
		$propertyEditor->property()->setValue(array('v0'=>$v1, 'v1'=>$v2, 'v2'=>$v3));
		return true;
	}



	// интервал (от ... до ...)
	protected static function saveProperty_13(\carabiEditor\propertyEditor $propertyEditor) {
		$propertyEditor->logger()->logStr('REQUEST CONTENT: '
			.$_REQUEST[$propertyEditor->control_id().'_0']
			.'; '
			.$_REQUEST[$propertyEditor->control_id().'_1']
		);
		
		$reqKey = $propertyEditor->control_id() . '_0';
		if (!array_key_exists($reqKey, $_REQUEST)) {
			$propertyEditor->logger()->logStr('Property wasnt been sent by user. Skipping.');
			return true;
		}
		
		$v1 = trim($_REQUEST[$propertyEditor->control_id().'_0']);
		if (empty($v1)) {
				if ($propertyEditor->property()->get_docprop_notnull()) {
					return false;
				} else {
					return true;
				}
		}
		if (false===($v1=\deutils::testNumeric($v1))) {
			return false;
		}
		
		$v2 = trim($_REQUEST[$propertyEditor->control_id().'_1']);
		if (empty($v2)) {
				if ($propertyEditor->property()->get_docprop_notnull()) {
					return false;
				} else {
					return true;
				}
		}
		if (false===($v2=\deutils::testNumeric($v2))) {
			return false;
		}
		
		$propertyEditor->property()->setValue(array('v0'=>$v1, 'v1'=>$v2));
		return true;
	}



	// размер (x ... y ... z ...)
	protected static function saveProperty_14(\carabiEditor\propertyEditor $propertyEditor) {
		$propertyEditor->logger()->logStr('REQUEST CONTENT: '
			.$_REQUEST[$propertyEditor->control_id().'_0']
			.'; '
			.$_REQUEST[$propertyEditor->control_id().'_1']
			.'; '
			.$_REQUEST[$propertyEditor->control_id().'_2']	    
		);
		
		$reqKey = $propertyEditor->control_id() . '_0';
		if (!array_key_exists($reqKey, $_REQUEST)) {
			$propertyEditor->logger()->logStr('Property wasnt been sent by user. Skipping.');
			return true;
		}
		
		$v1 = trim($_REQUEST[$propertyEditor->control_id().'_0']);
		if (empty($v1) && $propertyEditor->property()->get_docprop_notnull()) {
			//echo ' [not valid]';
			return false;
		}
		if (false===($v1=\deutils::testNumeric($v1))) {
			//echo ' [not valid]';
			return false;
		}
		
		$v2 = trim($_REQUEST[$propertyEditor->control_id().'_1']);
		if (empty($v2) && $propertyEditor->property()->get_docprop_notnull()) {
			//echo ' [not valid]';
			return false;
		}
		if (false===($v2=\deutils::testNumeric($v2))) {
			//echo ' [not valid]';
			return false;
		}
		
		$v3 = trim($_REQUEST[$propertyEditor->control_id().'_2']);
		if (empty($v3) && $propertyEditor->property()->get_docprop_notnull()) {
			//echo ' [not valid]';
			return false;
		}
		if (false===($v3=\deutils::testNumeric($v3))) {
			//echo ' [not valid]';
			return false;
		}
		
		$propertyEditor->property()->setValue(array('v0'=>$v1, 'v1'=>$v2, 'v2'=>$v3));	
		return true;
	}



	protected static function renderControl_numeric(\carabiEditor\propertyEditor $propertyEditor, $opts=array()) {
		$readonly = !$propertyEditor->property()->isWriteable();
		if ($readonly) {
			$retVal = "<span class=\"uneditable-input\">{$opts['value']}</span>";
		} else {
			$retVal = "<input id=\"{$opts['id']}\" name=\"{$opts['name']}\" value=\"{$opts['value']}\" type=\"text\" class=\"frmNum {$opts['className']}\" onKeypress=\"checknum();\" />";
		}
		return $retVal;
	}

	/***************************************************************************
	 * Цвет
	 *
	 */

	// цвет
	protected static function renderControl_15(\carabiEditor\propertyEditor $propertyEditor) {
		return self::renderControl_numeric(
			$propertyEditor,
			array (
				'id' => $propertyEditor->control_id().'_0',
				'name' => $propertyEditor->control_id().'_0',
				'value' => $propertyEditor->property()->get_value( 'V0' ),
				'className' => 'frm_1_15 frm_1_15_0',
			)
		);
	}

	// цвет
	protected static function saveProperty_15(\carabiEditor\propertyEditor $propertyEditor) {
		$propertyEditor->logger()->logStr('REQUEST CONTENT: '
			.$_REQUEST[$propertyEditor->control_id().'_0']
		);
		$v = trim($_REQUEST[$propertyEditor->control_id().'_0']);
		if (empty($v) && $propertyEditor->property()->get_docprop_notnull()) {
			//echo ' [not valid]';
			return false;
		}
		if (false===($v=\deutils::testNumeric($v))) {
			//echo ' [not valid]';
			return false;
		}
		// length ?
		$propertyEditor->property()->setValue(array('v0'=>$v));
		return true;
	}



	/***************************************************************************
	 * Дата/Время
	 *
	 */
	protected static $dateTimeFormats = array(
		'full' => 'd.m.Y H:i:s',
		'standard' => 'd.m.Y',
		'time' => 'H:i:s',
		'shorttime' => 'H:i',
		'hour' => 'H'
	);


	protected static $dateTimeFormats2 = array(
		'full' => array('date'=>'d.m.Y', 'time'=>'H:i:s'),
		'standard' => array('date'=>'d.m.Y'),
		'time' => array('time'=>'H:i:s'),
		'shorttime' => array('time'=>'H:i'),
		'hour' => array('time'=>'H')
	);

// Перенести в simpleproperty!
	protected static $dateTimeOracleFormats = array(
		'full' => 'd.m.Y^H:i:s',
		'standard' => 'd.m.Y^00:00:00',
		'time' => '01.01.0004^H:i:s',
		'shorttime' => '01.01.0004^H:i:00',
		'hour' => '01.01.0004^H:00:00'
	);

	protected static $oracleDateTime = "d.m.Y^H:i:s";
	
	protected static function renderControl_datetime(\carabiEditor\propertyEditor $propertyEditor, $opts=array() ) {
		$a1=array( 'full', 'standard', 'time', 'shorttime', 'hour' );
		if (in_array($opts['dateType'], $a1)) {
			$timeFormat = array();
			if ($opts['dateType'] == 'shorttime') {
				$timeFormat = array("database" => 'H:M', "php" => 'H:i', "human" => 'ЧЧ:MM');
			} else if ($opts['dateType']=='hour') {
				$timeFormat = array("database" => 'H', "php" => 'H', "human" => 'ЧЧ');
			} else {
				$timeFormat = array("database" => 'H:M:S', "php" => 'H:i:s', "human" => 'ЧЧ:MM:СС');
			}

			$datePart = '';
			$timePart = '';

			$showDatePart = $opts['dateType']=='full' || $opts['dateType']=='standard';
			$showTimePart = $opts['dateType']=='full' || $opts['dateType']=='time'
			|| $opts['dateType']=='shorttime' || $opts['dateType']=='hour';

			if (!empty($opts['value'])) {
				try {
					$dt = \DateTime::createFromFormat(
						self::$oracleDateTime,
						$opts['value']
					);
				} catch (\Exception $e) {
				}
				//В базе встречаются даты, записанные не по правилам:
				//"d.m.Y" вместо "d.m.Y^H:i:s". Их надо уметь распознавать.
				if (empty($dt)) {
					try {
						$dt = \DateTime::createFromFormat(
							"d.m.Y",
							$opts['value']
						);
						$opts['value'] .= "^00:00:00";
					} catch (\Exception $e) {
						echo "Bad date: {$opts['value']}"; die;
					}

				}
				if ($showDatePart) {
					$datePart = $dt->format('d.m.Y');
				}
				if ($showTimePart) {
					$timePart = $dt->format($timeFormat["php"]);
				}
			}

			$tpl = self::createTemplate($propertyEditor, 'de_control_simple_datetime.tpl');
			$tpl->assign("id", $opts['id']);
			$tpl->assign("name", $opts['name']);
			$tpl->assign("className", $opts['className']);
			$tpl->assign("showDatePart", $showDatePart);
			$tpl->assign("showTimePart", $showTimePart);
			$tpl->assign("datePart", $datePart);
			$tpl->assign("timePart", $timePart);
			$tpl->assign("timeFormat", $timeFormat);
			$tpl->assign("timeFormat", $timeFormat);
			$retVal = $tpl->fetch();
		} else {
			$retVal = '<i>нет реализации</i>';
		}
		return $retVal;
	}



	protected static function saveProperty_datetime(\carabiEditor\propertyEditor $propertyEditor, $name, $dateType) {
		$reqKey1 = $name . '_date';
		$reqKey2 = $name . '_time';
	
		$propertyEditor->logger()->logStr('REQUEST CONTENT:'
			. ' Date: "' . $_REQUEST[$reqKey1] . '"'
			. ' Time: "' .$_REQUEST[$reqKey2] . '"'
		);
		
		if (!array_key_exists($reqKey1, $_REQUEST)
			&& !array_key_exists($reqKey2, $_REQUEST)
		) {
			$propertyEditor->logger()->logStr('Property wasnt been sent by user. Skipping.');
			return true;
		}
		
		$v1 = trim($_REQUEST[$reqKey1]);
		$v2 = trim($_REQUEST[$reqKey2]);
		if (empty($v1) && empty($v2)) {
			return null;
		}
		
		try {
			$propertyEditor->logger()->logStr('Trying to format. "' 
				. 'Date type is: "' . $dateType . '",' 
				. ' date format: "' . self::$dateTimeFormats2[$dateType]['date'] . '", '
				. ' time format: "' . self::$dateTimeFormats2[$dateType]['time'] . '"'
			);

			if (!empty(self::$dateTimeFormats2[$dateType]['date']) && !empty($v1)) {
				$dt1 = \DateTime::createFromFormat(
					self::$dateTimeFormats2[$dateType]['date'],
					$v1
				);
			}

			if (!empty(self::$dateTimeFormats2[$dateType]['time']) && !empty($v2)) {
				$dt2 = \DateTime::createFromFormat(
						self::$dateTimeFormats2[$dateType]['time'],
						$v2
				);

				if ($dt1) {
					$dt1->setTime($dt2->format('H'),
									$dt2->format('i'),
									$dt2->format('s')
					);
				} else {
					$dt1 = $dt2;
				}
			}
	
			if (!$dt1) {
				$propertyEditor->logger()->logStr('FAILED');
				return false;
			} else {
				$propertyEditor->logger()->logStr('Collected DT: ' . $dt1->format(self::$dateTimeOracleFormats[$dateType]));
				$v = $dt1->format(self::$dateTimeOracleFormats[$dateType]);
			}


			/*
			$propertyEditor->logger()->logStr('Trying to format: "' 
					. $v . '", date type is: "' . $dateType . '", format for date type is: "' 
					. self::$dateTimeFormats[$dateType] . '"');
	
			$v = \DateTime::createFromFormat(
			self::$dateTimeFormats[$dateType],
			$v
			);
			if (!$v) {
				$propertyEditor->logger()->logStr('FAILED');
				return false;
			} else {
				$v = $v->format(self::$dateTimeOracleFormats[$dateType]);
			}
			*/
		} catch (\Exception $e) {
			return false;
		}
	
		return $v;
	}



	// полный (дата + время)
	protected static function renderControl_31(\carabiEditor\propertyEditor $propertyEditor) {
		return self::renderControl_datetime(
			$propertyEditor,
			array (
				'id' => "{$propertyEditor->control_id()}_0",
				'name' => "{$propertyEditor->control_id()}_0",
				'value' => $propertyEditor->property()->get_value( 'V0' ),
				'className' => 'frm_1_31',
				'dateType' => 'full',
			)
		);
	}

	// полный (дата + время)
	protected static function saveProperty_31(\carabiEditor\propertyEditor $propertyEditor) {
		//$propertyEditor->logger()->logStr('0');
		//echo ' полный (дата + время)', ' ';
		//echo $_REQUEST[$propertyEditor->control_id().'_0'];
		$v = self::saveProperty_datetime($propertyEditor,
													$propertyEditor->control_id().'_0',
													'full');
		//$propertyEditor->logger()->logStr('a');
		if (false === $v) {
			//echo ' [not valid]';
			//return false;
			//$propertyEditor->logger()->logStr('b');
			throw new Exception('Not Valid Value.');
		}
		//$propertyEditor->logger()->logStr('c');
		if (is_null($v) && $propertyEditor->property()->get_docprop_notnull()) {
			//echo ' [not valid]';
			//return false;
			////$propertyEditor->logger()->logStr('d');
			throw new Exception('Required property.');
		}
		//$propertyEditor->logger()->logStr('e');
		$propertyEditor->property()->setValue(array('v0'=>$v));
		return true;
	}



	// дата
	protected static function renderControl_32(\carabiEditor\propertyEditor $propertyEditor) {
		return self::renderControl_datetime(
			$propertyEditor,
			array(
				'id' => "{$propertyEditor->control_id()}_0",
				'name' => "{$propertyEditor->control_id()}_0",
				'value' => $propertyEditor->property()->get_value( 'V0' ),
				'className' => 'frm_1_32',
				'dateType' => 'standard',
			)
		);
	}



	// дата
	protected static function saveProperty_32(\carabiEditor\propertyEditor $propertyEditor) {
		//echo ' дата', ' ';
		//echo $_REQUEST[$propertyEditor->control_id().'_0'.'_date'];
		//echo $propertyEditor->control_id().'_0';
		//echo '1';
		$v = self::saveProperty_datetime($propertyEditor,
													$propertyEditor->control_id().'_0',
													'standard');
		
		if (false === $v) {
			//echo ' [not valid]';
			return false;
		}
		
		if (is_null($v) && $propertyEditor->property()->get_docprop_notnull()) {
			//echo ' [not valid]';
			return false;
		}
		//echo ' [valid]';
		$propertyEditor->property()->setValue(array('v0'=>$v));
		return true;
	}

	// время
	protected static function renderControl_33(\carabiEditor\propertyEditor $propertyEditor) {
		return self::renderControl_datetime(
			$propertyEditor,
			array(
				'id' => "{$propertyEditor->control_id()}_0",
				'name' => "{$propertyEditor->control_id()}_0",
				'value' => $propertyEditor->property()->get_value( 'V0' ),
				'className' => 'frm_1_33',
				'dateType' => 'time',
			)
		);
	}


	// время
	protected static function saveProperty_33(\carabiEditor\propertyEditor $propertyEditor) {
		//echo ' время', ' ';
		//echo $_REQUEST[$propertyEditor->control_id().'_0'];
		$v = self::saveProperty_datetime($propertyEditor,
													$propertyEditor->control_id().'_0',
													'time');
		if (false === $v) {
			//echo ' [not valid]';
			return false;
		}
		if (is_null($v) && $propertyEditor->property()->get_docprop_notnull()) {
			//echo ' [not valid]';
			return false;
		}
		
		//var_dump($v);
		//var_dump($propertyEditor->property()->get_value('V0'));
		$propertyEditor->property()->setValue(array('v0'=>$v));
		return true;
	}



	// год и месяц
	protected static function renderControl_34(\carabiEditor\propertyEditor $propertyEditor) {
		$retVal = '';
		//
		return $retVal;
	}

	// год и месяц
	protected static function saveProperty_34(\carabiEditor\propertyEditor $propertyEditor) {
		//echo ' год и месяц [not implemented]';
		return true;
	}

	// год
	protected static function renderControl_35(\carabiEditor\propertyEditor $propertyEditor) {
		$retVal = '';
		//
		return $retVal;
	}

	// год
	protected static function saveProperty_35(\carabiEditor\propertyEditor $propertyEditor) {
		//echo ' год [not implemented]';
		return true;
	}

	// месяц
	protected static function renderControl_36(\carabiEditor\propertyEditor $propertyEditor) {
		$retVal = '';
		//
		return $retVal;
	}

	// месяц
	protected static function saveProperty_36(\carabiEditor\propertyEditor $propertyEditor) {
		//echo ' месяц [not implemented]';
		return true;
	}

	// час мин
	protected static function renderControl_37(\carabiEditor\propertyEditor $propertyEditor) {
		$retVal = sprintf( '%s',
			self::renderControl_datetime(
				$propertyEditor,
				array(
					'id' => "{$propertyEditor->control_id()}_0",
					'name' => "{$propertyEditor->control_id()}_0",
					'value' => $propertyEditor->property()->get_value( 'V0' ),
					'className' => 'frm_1_37',
					'dateType' => 'shorttime',
				)
			)
		);
		return $retVal;
	}



	// час мин
	protected static function saveProperty_37(\carabiEditor\propertyEditor $propertyEditor) {
		//echo ' час мин', ' ';
		//echo $_REQUEST[$propertyEditor->control_id().'_0'];
		$v = self::saveProperty_datetime($propertyEditor,
													$propertyEditor->control_id().'_0',
													'shorttime');
		if (false === $v) {
			//echo ' [not valid]';
			return false;
		}
		if (is_null($v) && $propertyEditor->property()->get_docprop_notnull()) {
			//echo ' [not valid]';
			return false;
		}
		
		$propertyEditor->property()->setValue(array('v0'=>$v));
		return true;
	}



	// час
	protected static function renderControl_38(\carabiEditor\propertyEditor $propertyEditor) {
		return self::renderControl_datetime(
			$propertyEditor,
			array(
				'id' => "{$propertyEditor->control_id()}_0",
				'name' => "{$propertyEditor->control_id()}_0",
				'value' => $propertyEditor->property()->get_value( 'V0' ),
				'className' => 'frm_1_38',
				'dateType' => 'hour',
			)
		);
	}



	// час
	protected static function saveProperty_38(\carabiEditor\propertyEditor $propertyEditor) {
		//echo ' час', ' ';
		//echo $_REQUEST[$propertyEditor->control_id().'_0'];
		$v = self::saveProperty_datetime($propertyEditor,
													$propertyEditor->control_id().'_0',
													'hour');
		if (false === $v) {
			//echo ' [not valid]';
			return false;
		}
		if (is_null($v) && $propertyEditor->property()->get_docprop_notnull()) {
			//echo ' [not valid]';
			return false;
		}
		
		$propertyEditor->property()->setValue(array('v0'=>$v));
		return true;
	}



	// интервал дат
	protected static function renderControl_39(\carabiEditor\propertyEditor $propertyEditor) {
		$retVal = '';
		//
		return $retVal;
	}

	// интервал дат
	protected static function saveProperty_39(\carabiEditor\propertyEditor $propertyEditor) {
		//echo ' интервал дат [not implemented]';
		return true;
	}

	// интервал времени
	protected static function renderControl_40(\carabiEditor\propertyEditor $propertyEditor) {
		$retVal = '';
		//
		return $retVal;
	}

	// интервал времени
	protected static function saveProperty_40(\carabiEditor\propertyEditor $propertyEditor) {
		//echo ' интервал времени [not implemented]';
		return true;
	}

	// полный интервал
	protected static function renderControl_41(\carabiEditor\propertyEditor $propertyEditor) {
		$retVal = '';
		//
		return $retVal;
	}

	// полный интервал
	protected static function saveProperty_41(\carabiEditor\propertyEditor $propertyEditor) {
		//echo ' полный интервал [not implemented]';
		return true;
	}


	// неделя
	protected static function renderControl_42(\carabiEditor\propertyEditor $propertyEditor) {
		$retVal = '';
		//
		return $retVal;
	}

	// неделя
	protected static function saveProperty_42(\carabiEditor\propertyEditor $propertyEditor) {
		//echo ' неделя [not implemented]';
		return true;
	}

	// год неделя
	protected static function renderControl_43(\carabiEditor\propertyEditor $propertyEditor) {
		$retVal = '';
		//
		return $retVal;
	}

	// год неделя
	protected static function saveProperty_43(\carabiEditor\propertyEditor $propertyEditor) {
		//echo ' год неделя [not implemented]';
		return true;
	}



	/***************************************************************************
	* Денежный
	*
	*/

	// денежный
	protected static function renderControl_2(\carabiEditor\propertyEditor $propertyEditor) {
		return self::renderControl_numeric(
			$propertyEditor,
			array(
				'id' => $propertyEditor->control_id().'_0',
				'name' => $propertyEditor->control_id().'_0',
				'value' => $propertyEditor->property()->get_value( 'V0' ),
				'className' => 'frm_1_2',
			) 
		);

	}

	// денежный
	protected static function saveProperty_2(\carabiEditor\propertyEditor $propertyEditor) {
		$propertyEditor->logger()->logStr('REQUEST CONTENT: '
			.$_REQUEST[$propertyEditor->control_id().'_0']
		);
		
		$reqKey = $propertyEditor->control_id() . '_0';
		if (!array_key_exists($reqKey, $_REQUEST)) {
			$propertyEditor->logger()->logStr('Property wasnt been sent by user. Skipping.');
			return true;
		}
		
		$v = trim($_REQUEST[$propertyEditor->control_id().'_0']);
		if (empty($v) && $propertyEditor->property()->get_docprop_notnull()) {
			//echo ' [not valid]';
			return false;
		}
		if (false===($v=\deutils::testNumeric($v))) {
			//echo ' [not valid]';
			return false;
		}
		// digits after point ?
		$propertyEditor->property()->setValue(array('v0'=>$v));
		return true;
	}



	/***************************************************************************
	 * Текст
	 *
	 */

	// текст
	protected static function renderControl_4(\carabiEditor\propertyEditor $propertyEditor) {
		$tpl = self::createTemplate($propertyEditor, 'de_control_simple_text.tpl');
		return $tpl->fetch();
	}

	// текст
	protected static function saveProperty_4(\carabiEditor\propertyEditor $propertyEditor) {
		// Проверка на существующие значения.
		// Если в запросе нет ключа, или его значение пусто, тогда удаляем
		// это значение из базы, иначе обновляем значени (SimpleProperty сам
		// проверит следует ли обновлять значение или пропустить).
		$stored_values = $propertyEditor->property()->get_values();
		for ($i=0, $j=count($stored_values); $i<$j; $i++) {
			$k = $propertyEditor->control_id() . '_' . $i;
			if (!array_key_exists($k, $_REQUEST)) {
				$propertyEditor->logger()->logStr('Property wasnt been sent by user. Skipping.');
				continue;
				//return true;
			}
			
			$propertyEditor->logger()->logStr('Checking stored value with idx: ' . $i
			. ' (crc: ' . sprintf("%u", crc32($stored_values[$i])) . ')');
			
			$v = trim($_REQUEST[$k]);
			if (empty($v)) {
				// todo if $i==0 && required {setValue V0=''}
				$propertyEditor->logger()->logAddStr(' - delete value');
				$propertyEditor->property()->deleteValue($i);
			} else {
				$propertyEditor->logger()->logAddStr('. Request value crc: '
					. sprintf("%u", crc32($v)));
				$propertyEditor->logger()->logAddStr(' - update/skip value ');
				$propertyEditor->property()->setValue(array('V0'=>$v), $i);
			}
		}
	
		$k = $propertyEditor->control_id() . '_new';
		$v = self::textRequestNewValues($propertyEditor, $k);

		//$propertyEditor->logger()->logStr(print_r($_REQUEST[$k],true));
		//$propertyEditor->logger()->logStr(print_r($v,true));

	// Проверка на новые значения для мульти поля.
	// Перебираем значение/значения ключа в запросе. Если значение не
	// пусто, тогда добавляем его в базу.
		if (count($v)) {
			$propertyEditor->logger()->logStr('Have ' . count($v) . ' of new values.');
			if ($propertyEditor->property()->isMulti()) {
				$propertyEditor->logger()->logAddStr(' All of theme will be added.');
				$j = count($v);
			} else {
				if (count($stored_values)) {
					$propertyEditor->logger()->logAddStr(' None of theme will be added.');
					$j=0;
				} else {
					$propertyEditor->logger()->logAddStr(' First of theme will be added.');
					$j=1;
				}
			}

			for ($i=0; $i<$j; $i++) {
				$propertyEditor->logger()->logStr('Adding new value with crc: ' . sprintf("%u", crc32($v[$i])));
				$propertyEditor->property()->addValue(array('V0'=>$v[$i]));
			}
		}
		return true;
	}

	protected static function textRequestNewValues(\carabiEditor\propertyEditor $propertyEditor, $request_key) {
		//$v = ;
		$retVal = array();
		if (is_array($_REQUEST[$request_key])) {
			for ($i=0, $j=count($_REQUEST[$request_key]); $i<$j; $i++) {
				$str = trim($_REQUEST[$request_key][$i]);
				if (empty($str)) {
					continue;
				} else {
					$retVal []= $str;
				}
			}
		} else {
			$str = trim($_REQUEST[$request_key]);
			if (empty($str)) {
			} else {
				$retVal []= $str;
			}
		}
		return $retVal;
	}


	/***************************************************************************
	 * Логический выбор
	 *
	 */

	// логический выбор
	protected static function renderControl_5(\carabiEditor\propertyEditor $propertyEditor) {
		$readonly = !$propertyEditor->property()->isWriteable();
		if ($readonly) {
			$format = '<span class="uneditable-input">%s</span>';
			$value = (int)$propertyEditor->property()->get_value();
			$valueStr = $value===0 ? "Нет" : "Да";
			return sprintf($format, $valueStr);
		}
		$retVal = "<select name=\"{$propertyEditor->control_id()}_0\""
			." id=\"{$propertyEditor->control_id()}_0\" class=\"frmBool frm_1_5"
			.($propertyEditor->property()->get_docprop_notnull()?" required":"")
			."\">";
		
		$canBeNull = !$propertyEditor->property()->get_docprop_notnull();
		$isNull = $propertyEditor->property()->get_value()!==0 && $propertyEditor->property()->get_value()!==1;
		if ($canBeNull || $isNull) {
			$retVal .= "<option value=\"\"></option>";
		}

		$val = (int)$propertyEditor->property()->get_value();

		$retVal .= "<option value=\"0\""
			.($val===0?' selected':'')
			.">Нет</option>";
		$retVal .= "<option value=\"1\""
			.($val===1?' selected':'')
			.">Да</option>";
		$retVal .= "</select>";
		return $retVal;
	}

	// логический выбор
	protected static function saveProperty_5(\carabiEditor\propertyEditor $propertyEditor) {
		$propertyEditor->logger()->logStr('REQUEST CONTENT: '
			.$_REQUEST[$propertyEditor->control_id().'_0']
		);
		
		$reqKey = $propertyEditor->control_id() . '_0';
		if (!array_key_exists($reqKey, $_REQUEST)) {
			$propertyEditor->logger()->logStr('Property wasnt been sent by user. Skipping.');
			return true;
		}
		
		$v = (int)trim($_REQUEST[$propertyEditor->control_id().'_0']);
		
		if ($v===1 || $v==="1" || $v===0 || $v==="0") {
			$v = (int)$v;
		} else {
			$v = null;
		}
		
		if (is_null($v) && $propertyEditor->property()->get_docprop_notnull()) {
			return false;
		}
		
		$propertyEditor->property()->setValue(array('v0'=>$v));
		return true;
	}

}
    //protected $subTypeId;
    //protected $subTypeHandlerPrefix;
    //protected $collectFunction;
    //protected $renderFunction;

//    public function __construct($simpleProperty, $documentEditor_form)
//    {
//        parent::__construct($simpleProperty, $documentEditor_form);
//	
//	$propertyEditor->subTypeId = $propertyEditor->property()->get_docprop_object();
//	$propertyEditor->subTypeHandlerPrefix = self::$simpleTypes[$propertyEditor->subTypeId];
//	
//	$propertyEditor->collectFunction = array(
//	    $this,
//	    'collectFormData_' . $propertyEditor->subTypeHandlerPrefix
//	);
//	if (!is_callable($propertyEditor->collectFunction)) {
//	    $propertyEditor->collectFunction = null;
//	}
//	
//	$propertyEditor->renderFunction = array(
//	    $this,
//	    'print_control_' . $propertyEditor->subTypeHandlerPrefix
//	);
//	if (!is_callable($propertyEditor->renderFunction)) {
//	    $propertyEditor->renderFunction = null;
//	}
//    }



//    public function renderControlNative()
//    {
//	if (!$propertyEditor->renderFunction) {
//	    return;
//	}
//	return call_user_func($propertyEditor->renderFunction);
//    }



?>