<?php

namespace carabiEditor\plugins\objects{


class property_refcost
{

	static public function renderControl(\carabiEditor\propertyEditor $propertyEditor, $return=false)
	{
		ob_start();
		$restateCost = new \restateCost($propertyEditor);
		$price = $restateCost->getPrice();
		$currency = $restateCost->getCurrency();
		
?><div id="COST_<?=$propertyEditor->control_id()?>">

	<input id="<?=$propertyEditor->control_id()?>"
		   type="hidden"
		   name="<?=$propertyEditor->control_id()?>"
		   value='<?=json_encode($price)?>'>
		   
	<div style="display:none;">
		<table>
			<tr class="tmpltRow">
				<td style="padding-right: 20px;" >
					<span class="dateFrom"></span>
					<input type="hidden" class="dateFrom">
						-
				<span class="dateTo"></span>
					<input type="hidden" class="dateTo">
					</td>	
				<td><input type=text
						   class="first"
						   style='width:90px; color: #565656;'
						   value=''/></td>
				<td><input type=text
						   class="second"
						   style='width:90px;  color: #565656;'
						   value=''/></td>
				<td><input type=text
						   class="third"
						   style='width:90px;  color: #565656;'
						   value=''/></td>
				<td><input type=text
						   class="fourth"
						   style='width:90px;  color: #565656;'
						   value=''/></td>
				<td><input type=text
						   class="fifth"
						   style='width:90px;  color: #565656;'
						   value=''/></td>	
				<td><span class="deletePriceRow" style="cursor:pointer;"></span></td>	   
			</tr>
		</table>
	</div>
	<b>Задайте стоимость квартиры на требуемый период</b><br><br>
	<p>Валюта: <span class="currencyLabel"></span></p>
	<table>
		<tr>
		<td><b>Период:&nbsp;&nbsp;</b></td>
		<td><b>1-2 дня</b></td>
		<td><b>3-5 дней</b></td>
		<td><b>6-12 дней</b></td>
		<td><b>от 13 дней</b></td>
		<td><b>от 1 месяца</b></td>	
		</tr>
		<tr style="display: none;" class="insertAfter row"></tr>

	</table>

	<span class="addPriceRow" style="cursor:pointer;"></span> 
	<span class="addPrice"></span>
	<span class="addPriceRow" style="cursor:pointer;">Добавить</span>
	<script type="text/javascript">

	if (typeof func_<?=$propertyEditor->control_id()?> === 'undefined') {
		func_<?=$propertyEditor->control_id()?> = true;
		
		getCSS(js_url + '/j/jquery.datepick.package-4.0.3/jquery.datepick.css');
		getCSS(js_url + '/de/restateCostForm.css');
		head.js(
			// toJSON
			js_url + '/j/jquery.datepick.min.js',
			js_url + '/j/jquery.datepick.package-4.0.3/jquery.datepick-ru-1251.js',
			js_url + '/de/restateCostForm.js',
			function()
			{
				var containerEl = $('#COST_<?=$propertyEditor->control_id()?>');
				var rcf = restateCostForm({
					'containerEl': containerEl,
					'tmpltEl': containerEl.find('.tmpltRow'),
					'inputEl': $('#<?=$propertyEditor->control_id()?>'),
					'currency': '<?=$currency[1]?>'
<?php/*					,'currency': {
						<?php
						$curencies = get_vocab_list2('pub_currency');
						for ($i=0, $j=count($curencies); $i<$j; $i++):?>
						'<?=$curencies[$i]['code']?>':'<?=$curencies[$i]['description']?>'
						<?=($i<($j-1)?',':'')?>
						<?php endfor; ?>
					}
*/?>
				});
			}
		);
	}
	</script>
</div><?php

		$retVal = ob_get_contents();
		ob_end_clean();

		if ($return)
			return $retVal;
		else
			echo $retVal;
	}



	//static protected $deProperty;
	//static protected $restateId;
	
	static public function saveProperty(\carabiEditor\propertyEditor $propertyEditor)
	{
		if (!array_key_exists($propertyEditor->control_id(), $_REQUEST)) {
			$propertyEditor->logger()->logStr('Property wasnt sent by user. Skip.');
			return;
		}
		
		$propertyEditor->logger()->addTab();
		try {
			//self::$propertyEditor = $propertyEditor;
			$restateCost = new \restateCost($propertyEditor);
			$newPrices = self::getFromRequest($propertyEditor);
			$propertyEditor->logger()->logArr('PRICES FROM REQUEST', $newPrices);
			self::compareAndSavePrices($propertyEditor, $restateCost, $newPrices);
		} catch (\Exception $e) {
			$propertyEditor->logger()->deTab();
			throw $e;
		}
		$propertyEditor->logger()->deTab();
		//return true;
	}



	static protected function getFromRequest(\carabiEditor\propertyEditor $propertyEditor)
	{
		$retVal = json_decode($_REQUEST[$propertyEditor->control_id()], true);
		if (!is_array($retVal))
			throw new \Exception('Not array!');
		for ($i=0, $j=count($retVal); $i<$j; $i++) {
			if (!is_array($retVal[$i]))
				throw new \Exception('Not array!');
			$retVal[$i]['FIRST_TERM_COST'] = self::testNumeric($propertyEditor, $retVal[$i]['FIRST_TERM_COST']);
			$retVal[$i]['SECOND_TERM_COST'] = self::testNumeric($propertyEditor, $retVal[$i]['SECOND_TERM_COST']); 
			$retVal[$i]['THIRD_TERM_COST'] = self::testNumeric($propertyEditor, $retVal[$i]['THIRD_TERM_COST']);
			$retVal[$i]['FOURTH_TERM_COST'] = self::testNumeric($propertyEditor, $retVal[$i]['FOURTH_TERM_COST']);
			$retVal[$i]['FIFTH_TERM_COST'] = self::testNumeric($propertyEditor, $retVal[$i]['FIFTH_TERM_COST']);
			$retVal[$i]['FROMDATE'] = self::testDate($retVal[$i]['FROMDATE']);
			$retVal[$i]['TODATE'] = self::testDate($retVal[$i]['TODATE']);
		}
		return $retVal;
	}
	
	static protected function testNumeric(\carabiEditor\propertyEditor $propertyEditor, $testNum)
	{
		$num = \deutils::testNumeric($testNum);
		if (false===$num)
			$num = 0;
		return $num;
	}
	
	static protected function testDate($testDate)
	{
		$date = \DateTime::createFromFormat('d.m.Y', $testDate);
		if (!$date)
			throw new \Exception('Not date!');
		return $date->format('d.m.Y');
	}
	
	static protected function compareAndSavePrices(\carabiEditor\propertyEditor $propertyEditor, $restateCost, $newPrices)
	{
		$savedPrices = $restateCost->getPrice();
		
		$savedPricesToDeleteIdx = array();
		$updatePricesIdx = array();
		$keepIdx = array();
		for ($i=0, $j=count($savedPrices); $i<$j; $i++) {
			$toDelete = true;
			for ($i2=0, $j2=count($newPrices); $i2<$j2; $i2++) {
				if ($savedPrices[$i]['FROMDATE'] == $newPrices[$i2]['FROMDATE']
					&& $savedPrices[$i]['TODATE'] == $newPrices[$i2]['TODATE']
				) {
					if ($savedPrices[$i]['FIRST_TERM_COST'] == $newPrices[$i2]['FIRST_TERM_COST']
						&& $savedPrices[$i]['SECOND_TERM_COST'] == $newPrices[$i2]['SECOND_TERM_COST']
						&& $savedPrices[$i]['THIRD_TERM_COST'] == $newPrices[$i2]['THIRD_TERM_COST']
						&& $savedPrices[$i]['FOURTH_TERM_COST'] == $newPrices[$i2]['FOURTH_TERM_COST']
						&& $savedPrices[$i]['FIFTH_TERM_COST'] == $newPrices[$i2]['FIFTH_TERM_COST']
					) {
						$keepIdx[] = $i2;
					} else {
						$updatePricesIdx[] = $i2;
					}
					$toDelete = false;
					break;
				}
			}
			if ($toDelete) {
				$savedPricesToDeleteIdx[] = $i;
			}
		}
		
		foreach (array_values($savedPricesToDeleteIdx) as $idx) {
			$propertyEditor->logger()->logArr('DEL', $savedPrices[$idx]);
			$restateCost->deletePrice($savedPrices[$idx]);
		}
		
		$addPricesIdx = array();
		for ($i=0, $j=count($newPrices); $i<$j; $i++) {
			if (!in_array($i, $updatePricesIdx) && !in_array($i, $keepIdx)) {
				//$addPricesIdx[] = $i;
				$propertyEditor->logger()->logArr('ADD', $savedPrices[$idx]);
				$restateCost->addPrice($newPrices[$i]);
			}
		}
		
		//foreach (array_values($addPricesIdx) as $idx) {
		//	self::$deProperty->logger()->logStr('TOADD:' . print_r($newPrices[$idx], true));			
		//}
		
		foreach (array_values($updatePricesIdx) as $idx) {
			//self::$deProperty->logger()->logStr('TOUPDATE:' . print_r($newPrices[$idx], true));
			$propertyEditor->logger()->logArr('UPD', $savedPrices[$idx]);
			$restateCost->updatePrice($newPrices[$idx]);
		}
		
		$propertyEditor->logger()->logStr('REFCOST SAVE Completed');
		
	}
	
	static protected function logger()
	{
		return self::$deProperty->logger();
	}

	static protected function restateId()
	{
		return self::$deProperty->document()->document_id;
	}
/**/
	
}
}

namespace {

	class restateCost
	{
		protected $restateId;
		protected $logger;
		
		public function __construct(\carabiEditor\propertyEditor $propertyEditor)
		{
			$this->restateId = $propertyEditor->document()->document_id;
			$this->logger = $propertyEditor->logger();
		}
		
		public function getPrice()
		{
			$sql = "select * from table(appl_rent_web.get_cost_table({$this->restateId}))";
			$price = ora_select($sql, 'no-cache', '', '');
			$price = ora_redim($price);
			return $price;
		}
	
		public function addPrice($price)
		{
			$this->logger->logArr('TOADD:', $price);
			$sql = sprintf("appl_rent_web.add_cost('%d', to_date('%s', 'DD.MM.YYYY'), to_date('%s', 'DD.MM.YYYY'), %d, %d, %d, %d, %d)",
						   $this->restateId,
						   $price['FROMDATE'],
						   $price['TODATE'],
						   $price['FIRST_TERM_COST'],
						   $price['SECOND_TERM_COST'],
						   $price['THIRD_TERM_COST'],
						   $price['FOURTH_TERM_COST'],
						   $price['FIFTH_TERM_COST']);
			$this->logger->logStr('TOADD:' . $sql);
			//$res = ora_func($sql);
			$this->logger->logAddStr(' RES: ' . $res);
		}
	
		public function updatePrice($price)
		{
			$this->logger->logArr('TOUPDATE:', $price);
			$sql = sprintf("appl_rent_web.update_cost('%d', to_date('%s', 'DD.MM.YYYY'), to_date('%s', 'DD.MM.YYYY'), %d, %d, %d, %d, %d)",
						   $this->restateId,
						   $price['FROMDATE'],
						   $price['TODATE'],
						   $price['FIRST_TERM_COST'],
						   $price['SECOND_TERM_COST'],
						   $price['THIRD_TERM_COST'],
						   $price['FOURTH_TERM_COST'],
						   $price['FIFTH_TERM_COST']);
			$this->logger->logStr('TOUPDATE:' . $sql);
			//$res = ora_func($sql);
			$this->logger->logAddStr(' RES: ' . $res);
		}
		
		public function deletePrice($price)
		{
			$this->logger->logArr('TODELETE:', $price);
			$sql = sprintf("appl_rent_web.delete_cost('%d', to_date('%s', 'DD.MM.YYYY'), to_date('%s', 'DD.MM.YYYY'))",
						   $this->restateId,
						   $price['FROMDATE'],
						   $price['TODATE']);
			$this->logger->logStr('TODELETE:' . $sql);
			//$res = ora_func($sql);
			$this->logger->logAddStr(' RES: ' . $res);
		}
		
		public function getCurrency()
		{
			$sql = "select column_value as currency from table(appl_rent_web.get_currency({$this->restateId}))";
			$currency = ora_select($sql, 'no-cache', '', '');
			//$currency = ora_redim($currency);
			return $currency['CURRENCY'];
		}
	
		
	}
}

?>