<?php

namespace carabiEditor\plugins\objects;

class property_ref
	// implements document_plugin
{
	private function __construct(){}



	public static function saveProperty(\carabiEditor\propertyEditor $propertyEditor) {
		$propertyEditor->logger()->logStr('[REF]   Control id XDEBUG: "' . $propertyEditor->control_id() . '"');
		
		//echo "test123";
		//exit;
		if ($propertyEditor->property()->isRefLink() && !$propertyEditor->property()->isRefCreate())
		{
			$propertyEditor->logger()->logStr('[REF]  case 1');
			// link only
			$retVal=self::collectFormData_link($propertyEditor);
		} else {
			$propertyEditor->logger()->logStr('[REF]  case Else');
			$propertyEditor->logger()->logStr('TRACING PROPERTYEDITOR...');
			//$propertyEditor->logger()->logStr(print_r($propertyEditor, true));
			$retVal=self::collectFormData_create($propertyEditor);
			self::saveLinkedDocuments($propertyEditor);
		}
		
		return $retVal;
	}



	protected static function collectFormData_link(\carabiEditor\propertyEditor $propertyEditor, $addAsCreated=false) {
		$propertyEditor->logger()->logStr("link");
		
		if (!array_key_exists($propertyEditor->control_id(), $_REQUEST)) {
			$propertyEditor->logger()->logStr('Property wasnt sent by user!');
			return;
		}
		
		$propertyEditor->logger()->logStr('REQUEST RAW CONTENT: "' . $_REQUEST[$propertyEditor->control_id()] . '"');
		
		//$v = $propertyEditor->extractJSON_intArray(
		$v = \deutils::extractJSON_intArray(
			trim($_REQUEST[$propertyEditor->control_id()])
		);
		$propertyEditor->logger()->logStr('Parsed content: "' . join(', ', $v) . '"');
		
		// обязательное поле
		if (count($v)==0 && $propertyEditor->property()->get_docprop_notnull()) {
			throw new \Exception('Required property');
		}
		
		// много значений для не мульти поля.
		if (count($v)>1 && !$propertyEditor->property()->get_docprop_multi()) {
			throw new \Exception('This is no multi property.');
		}
		
		$stored_refs = $propertyEditor->property()->get_refs();
		$propertyEditor->logger()->logStr('Stored refs: "'
								. join(', ', array_map(
													   function($value) {
														return $value['DOCTARGET_ID'];
														},
														$stored_refs
														)
									   )
								. '"');

		for ($i=0, $j=count($stored_refs); $i<$j; $i++)
		{
			// Ищем в присланных рефах те которые были сохранены ранее.
			$idx = array_search($stored_refs[$i]['DOCTARGET_ID'], $v);
			
			if ($idx === false) {
				$propertyEditor->logger()->logStr($stored_refs[$i]['DOCTARGET_ID'].' - TO DELETE');
				$propertyEditor->property()->deleteRef($i);
			} else {
				$propertyEditor->logger()->logStr($stored_refs[$i]['DOCTARGET_ID'].' - SKIP');
				array_splice($v, $idx, 1);
			}
		}
		
		for ($i=0, $j=count($v); $i<$j; $i++) {
			$propertyEditor->logger()->logStr($v[$i].' - ADD');
			$propertyEditor->property()->addRef($v[$i]);
			if ($addAsCreated) {
				$propertyEditor->session()->addDocument($v[$i]);
			}
		}
		
		return true;
	}



	protected static function collectFormData_create(\carabiEditor\propertyEditor $propertyEditor) {
		$propertyEditor->logger()->logStr('create (collecting as link)');
		return self::collectFormData_link($propertyEditor, true);
	}



	protected static function saveLinkedDocuments(\carabiEditor\propertyEditor $propertyEditor) {
		$propertyEditor->logger()->logStr('saveLinkedDocuments: Begin');
		$linkedDocuments = $propertyEditor->property()->get_refs();
		if (empty($linkedDocuments)) {
			$propertyEditor->logger()->logStr('saveLinkedDocuments: Linked is empty. Exiting');
			return;
		}
		
		$openedDocuments = $propertyEditor->session()->getDocuments();
		if (empty($openedDocuments)) {
			$propertyEditor->logger()->logStr('saveLinkedDocuments: No Opened docs. Exiting');
			return;
		}
		
		$openedDocumentsId = array_keys($openedDocuments);
		
		$propertyEditor->logger()->logStr('saveLinkedDocuments: Opened docs ID List:'. print_r($openedDocumentsId, true));
		
		$openedLinkedDocumentsId = array();
		for ($i=0, $j=count($linkedDocuments); $i<$j; $i++) {
			if (in_array((int)$linkedDocuments[$i]['DOCTARGET_ID'], $openedDocumentsId)) {
				$openedLinkedDocumentsId []= (int)$linkedDocuments[$i]['DOCTARGET_ID'];
			}
		}
		
		if (empty($openedLinkedDocumentsId))
			return;
		
		$propertyEditor->logger()->logStr('Count of linked documents opened for editing: ' . count($openedLinkedDocumentsId));
		for ($i=0, $j=count($openedLinkedDocumentsId); $i<$j; $i++) {
			$propertyEditor->logger()->logStr("Go by link idx: {$i}, id: {$openedLinkedDocumentsId[$i]}");
			$propertyEditor->logger()->addTab();
			try {
				$openedLinkedDocumentEditor = new \carabiEditor\documentEditor($openedLinkedDocumentsId[$i],
																			   $propertyEditor->carabiEditor());
				$openedLinkedDocumentEditor->saveDocument();
			} catch (Exception $e) {
				$propertyEditor->logger()->deTab();
				$propertyEditor->logger()->logStr('Linked documents saving failed.');
				throw $e;
			}
		}
		$propertyEditor->logger()->deTab();
		$propertyEditor->logger()->logStr('Linked documents saved.');
	}



	public static function constructDocumentEditorByRef(\carabiEditor\propertyEditor $propertyEditor, $refIdx=0) {
		$targetDocumentId = $propertyEditor->property()->get_ref_target_id($refIdx);
		$targetSimpleDocument = new \SimpleDocument($targetDocumentId);
		$targetDocumentEditor = new \carabiEditor\documentEditor($targetSimpleDocument,
																 $propertyEditor->carabiEditor());
		$propertyEditor->session()->addDocument($targetDocumentId);
		return $targetDocumentEditor;
	}


	/**
	 * Обрабатывает запрос на выдачу документа по сслыке поля.
	 *
	*/
	public static function request_getSubDocument(\carabiEditor\propertyEditor $propertyEditor) {
		$targetDocumentId = (int)$_REQUEST['documentId'];
		if ($targetDocumentId<=0) {
			throw new \Exception('Wrong target document id. Code 01.');
		}
		
		$refs = $propertyEditor->property()->get_refs();
		$targetDocument = null;
		$targetDocumentEditor = null;
		for ($i=0, $j=count($refs); $i<$j; $i++) {
			if ((int)$refs[$i]['DOCTARGET_ID']===$targetDocumentId) {
				$targetDocument = new \simpledocument($targetDocumentId);
				$targetDocumentEditor = new \carabiEditor\documentEditor($targetDocument, $propertyEditor->carabiEditor());
				$targetDocumentEditor->session()->addDocument($targetDocumentId);
				break;
			}
		}
		
		if (!$targetDocumentEditor) {
			throw new \Exception('Wrong target document id. Code 02.');
		}
		
		//$tpl = $propertyEditor->renderer()->createTemplate($propertyEditor->getConfigValue('subDocumentTemplate'));
		$tpl = $propertyEditor->renderer()->createTemplate($propertyEditor->config()->getValue('subDocumentTemplate'));
		$tpl->assign('propertyEditor', $propertyEditor);
		$tpl->assign('documentEditor', $propertyEditor->documentEditor());
		$tpl->assign('carabiEditor', $propertyEditor->carabiEditor());
		$tpl->assign('targetDocumentEditor', $targetDocumentEditor);
		$tpl->display();
	}



	public static function request_getControl(\carabiEditor\propertyEditor $propertyEditor) {
		$propertyEditor->renderControl();
	}



	public static function request_createSubObject(\carabiEditor\propertyEditor $propertyEditor) {
		try {
			$_REQUEST['type'] = $_REQUEST['type'];
			if (!$_REQUEST['type']) {
				return;
			}
			
			$rots = $propertyEditor->property()->getRefObjectTypes();
			$doctype = null;
			for($i=0, $j=count($rots); $i<$j; $i++) {
				//if ($rots[$i]['dockind_id']==$_REQUEST['type']) {
				if ($rots[$i]['dockind_namevar']===$_REQUEST['type']) {
					$doctype = $_REQUEST['type'];
					break;
				}
			}
			
			if (!$doctype) {
				return false;
			}
			
			$docid = \create_document($doctype);
			$document = new \simpleDocument($docid);
			$editor = new \carabiEditor\documentEditor($document, $propertyEditor->carabiEditor());
			ob_start();
	?>
	<script type="text/javascript">
	$(function(){
		ref_<?=$propertyEditor->control_id()?>.addRef({'id':<?=$docid?>, 'name':''}, '<?=$_REQUEST['listItemId']?>');
	});
	</script>
	
	<?php
			$editor->displayWidget();
			$cnt = ob_get_contents();
			ob_end_clean();
			echo $cnt;
		} catch (\Exception $e) {
			// ? send_x_error ?			
		}
	}



	public static function request_getAvailRefs(\carabiEditor\propertyEditor $propertyEditor) {
		//$propertyEditor->logger()->logStr('');
		try {
			$req_include = explode(',', $_REQUEST['inc']);
			$req_exclude = explode(',', $_REQUEST['exc']);
			$req_from = $_REQUEST['f'] ? $_REQUEST['f'] : 0;
			$req_count = $_REQUEST['c'] ? $_REQUEST['c'] : 100;
			$dependsOnValue = ($_REQUEST['dependsOnValue'] ? $_REQUEST['dependsOnValue'] : null);
			if (is_array($dependsOnValue))
				$dependsOnValue=$dependsOnValue[0];
			$xml_sql = self::buildXML($propertyEditor, $dependsOnValue);
			if (!$ref_vals_=get_ref_values_list($xml_sql, '', ''))
				$ref_vals_=array();
				
			$fake_list=array();
			for ($i=0, $j=count($ref_vals_); $i<$j; $i++) {
				$fake_list [] =array('id' => $ref_vals_[$i]['DOCUMENT_ID'],
									 'str' => preg_replace('/\x05/', '',
														   $ref_vals_[$i]['DOC_DESCR']),
									 'idx' => $i);
			}
			$ret_val = self::makeRefsList($fake_list,
										  $req_include, $req_exclude,
										  $req_from, $req_count);
			
			$propertyEditor->logger()->logStr('XML: ' .$xml_sql);
			$propertyEditor->logger()->logStr('Avail refs count:' . count($fake_list) . '; Raw count: ' . count($ref_vals_));
			$propertyEditor->logger()->logArr('Include:', $req_include);
			$propertyEditor->logger()->logArr('Exclude:', $req_exclude);
			$propertyEditor->logger()->logStr('From:' . $req_from);
			$propertyEditor->logger()->logStr('Count:' . $req_count);
			$propertyEditor->carabiEditor()->send_x_answer(true, $ret_val);
		} catch (\Exception $e) {
			$propertyEditor->carabiEditor()->send_x_answer(false, array(), $e->getMessage());
			// ? send_x_error ?
		}
	}



	protected static function buildXML(\carabiEditor\propertyEditor $propertyEditor, $dependsOnValue) {
		$xml_sql = $propertyEditor->property()->get_ref_xml();
		$xml_doc = new \DOMDocument();
		$xml_doc->loadXML($xml_sql);
		$xpath = new \DOMXPath($xml_doc);
		$query = '//query/formal/reference/property[@valuevar][@doc_prop_value]';
		$entries = $xpath->query($query);
		$a = $dependsOnValue;
		foreach ($entries as $entry) {
			$item = $entry->attributes->getNamedItem('valuevar');
			$item->value='';
			$item = $entry->attributes->getNamedItem('doc_prop_value');
			$item->value = $a;
			$item = $entry->attributes->getNamedItem('descr');
			$item->value='';
		}
		
		// Сохранение XML. Метод "в лоб" не подходит поскольку сохраняет в
		// валидном формате (добавляет лишнего).
		$xml_sql = '';
		foreach ($xml_doc->childNodes as $node){
			// Приходится использовать такую конструкцию, поскольу все не
			// латинские символы преобразовываются в HTML сущности, что ломает
			// запрос.
			$xml_sql .= html_entity_decode($xml_doc->saveXML($node),
						   ENT_COMPAT, 'UTF-8')
			. "\n";
		}
		return $xml_sql;
	}



	/**
	 * Функция возвращает элементы $availRefs с $from позиции в количестве не
	 * более $count штук. Так же к результату добавляются элементы $availRefs
	 * чьё поле id имеется в $include. А так же из результата исключаются
	 * элементы, id которых имеюися в $exclude.
	 *
	 * Если id элемента $availRefs имеется и в $include и в $exclude тогда этот
	 * элемент будет добавлен в результат, но количество элементов в результате
	 * будет не более чем $count + количество элементов с id в обоих списках.
	 *
	 * 
	 * @param array $availRefs Элементом массива является ассоциативный
	 * массив, с обязательным ключом "id"
	 * @param array $include Элементом массива является id элемента $availRefs
	 * @param array exclude Элементом массива является id элемента $availRefs
	 * @param int $from
	 * @param int $count
	 *
 	 * @return array
	*/
	protected static function makeRefsList($availRefs, $include, $exclude, $from, $count) {
		if (!is_array($availRefs))
			$availRefs = (array)$availRefs;
		if (!is_array($include))
			$include = (array)$include;
		if (!is_array($exclude))
			$exclude = (array)$exclude;
			
		$from = (int)$from;
		$count = (int)$count;
		if (!$count)
			$count = 50;
			
		if (count($include)) {
			$startFrom = 0;
			$maxCount = count($availRefs);
		} else {
			$startFrom = $from;
			if (count($exclude)) {
				$maxCount = count($availRefs);
			} else {
				$maxCount = $from + $count;
			}
		}
		
		$rangeAdded = 0;
		$includeAdded = 0;
		$rangeLastAddedIdx = -1;
		$isInclude = false;
		$isInRange = false;
		$isExclude = false;
		$add = false;
		$ret_arr = array();
		
		for ($i=$startFrom; $i<$maxCount; $i++) {
			if ($i>=$from && $rangeAdded<$count) {
				$isInRange = true;
			} else {
				$isInRange = false;
			}
			
			$isInclude = in_array($availRefs[$i]['id'], $include);
			$isExclude = in_array($availRefs[$i]['id'], $exclude);
				
			if ($isInRange) {
				if ($isExclude) {
					$add = false;
				} else {
					$add = true;
					$rangeLastAddedIdx=$i;
					$rangeAdded++;
				}
			} else {
				$add = false;
			}
			
			if ($isInclude) {
				$add = true;
				$includeAdded++;
				if ($isInRange) {
					//rangeAdded--;
				}
			}
			
			if ($add) {
				$ret_arr[] = $availRefs[$i];
			}
			
			if ($rangeAdded>=$count && $includeAdded>=count($include)) {
				break;
			}
		}
		
		$ret_val = array(
			'strings' => $ret_arr,
			'lastIdx' => $rangeLastAddedIdx,
			'totalCount' => count($availRefs),
		);
		
		return $ret_val;
	}
}
?>