<?php

namespace carabiEditor\plugins\objects;

class property_media
	// implements document_plugin
{

	private function __construct(){}



	public static function request_processFileUpload(\carabiEditor\propertyEditor $propertyEditor)
	{
		\utls::logStr('MEDIA FIELD. FILE UPLOADING');
		\utls::logStr(print_r($_FILES['file'], true));
		try {
			if (!empty($_FILES['files']['error'])) {
				throw new \Exception('');
			}
			
			if (!is_uploaded_file($_FILES['file']['tmp_name'])) {
				throw new \Exception('');
			}
			
			$ret = save_media_file($propertyEditor->document()->document_id,
								   $_FILES['file']['tmp_name'],
								   $_FILES['file']['name']);
			
			$retVal = array('id'=>$ret['media_id'],
							'name'=>$_FILES['file']['name'],
							'content_type_id'=>$ret['content_type']);
			
			$propertyEditor->carabiEditor()->send_x_answer(true, $retVal);
			return true;
		} catch (\Exception $e) {
			\utls::logStr('Uploading error');
			$propertyEditor->carabiEditor()->send_x_answer(false, array(), '');
			return false;
		}
	}



	public static function saveProperty(\carabiEditor\propertyEditor $propertyEditor)
	{
		$propertyEditor->logger()->logStr('[MEDIA]   Control id: "' . $propertyEditor->control_id() . '"');
		$propertyEditor->logger()->logStr('REQUEST RAW CONTENT: '.$_REQUEST[$propertyEditor->control_id()]);
		try {
			$values = \deutils::JSONToValues(trim($_REQUEST[$propertyEditor->control_id()]));
			self::sanitizeValues($propertyEditor, $values);
			
			$propertyEditor->logger()->logStr('PARSED & SANITIZED: ' . serialize ($values));
			
			self::checkRequired($propertyEditor, $values);
			self::checkNonMulti($propertyEditor, $values);
			self::setValues($propertyEditor, $values);
		} catch(\Exception $e) {
			$propertyEditor->logger()->logStr($e->getMessage());
			return false;
		}
		return true;
	}



	/**
	 * Прототип функции должен быть на уровень выше либо в интерфейсе
	 *
	*/
	protected static function sanitizeValues(\carabiEditor\propertyEditor $propertyEditor, &$values)
	{
		for ($i=0, $j=count($values); $i<$j; $i++) {
			
			if (array_key_exists('PLURAL', $values[$i]))
				$values[$i]['PLURAL'] = (int)$values[$i]['PLURAL'];
				
			$values[$i]['V0'] = (int)$values[$i]['V0'];
			if ($values[$i]['V0'] <= 0)
				throw new \Exception('Wrong type or value.');
			
			if (array_key_exists('V1', $values[$i]))
				unset($values[$i]['V1']);
				
			if (array_key_exists('V2', $values[$i]))
				unset($values[$i]['V2']);
			
			if (array_key_exists('DISPLAY', $values[$i]))
				unset($values[$i]['DISPLAY']);
				
			if (array_key_exists('FLAGS', $values[$i])) {
				// ?
			}
		}
	}



	/**
	 * Возможно функцию следует перенести в simpleproperty.
	 *
	*/
	protected function checkRequired(\carabiEditor\propertyEditor $propertyEditor, &$values)
	{
		if (count($values)===0 && $propertyEditor->property()->get_docprop_notnull()) {
			throw new \Exception('!ERROR required property');
		}
		return true;
	}



	/**
	 * Возможно функцию следует поднять в simpleproperty.
	 *
	*/
	protected function checkNonMulti(\carabiEditor\propertyEditor $propertyEditor, &$values)
	{
		if (count($values)>1 && !$propertyEditor->property()->isMulti()) {
			throw new \Exception('!ERROR this is no multi property');
		}
		return true;
	}



	/**
	 * Возможно функцию следует поднять на более высокий уровень.
	 *
	*/
	protected function setValues(\carabiEditor\propertyEditor $propertyEditor, &$values)
	{
		for ($i=0, $j=count($values); $i<$j; $i++) {
			if ($values[$i]['isNew']) {
				$propertyEditor->logger()->logArr('ADD: ', $values[$i]);
				$propertyEditor->property()->addValue($values[$i]);
			} else {
				if ($values[$i]['isToDelete']) {
					$propertyEditor->logger()->logArr('DEL: ', $values[$i]);
					$propertyEditor->property()->deleteValue($i);
				} else if ($values[$i]['isToUpdate']) {
					$propertyEditor->logger()->logArr('UPD: ', $values[$i]);
					$propertyEditor->property()->setValue($values[$i], $i);
				} else {
					$propertyEditor->logger()->logArr('SKP: ', $values[$i]);
				}
			}
		}
	}

}

?>