<?php

namespace carabiEditor\plugins\objects;

class property_default
	// implements document_plugin
{

	private function __construct(){}



	public static function renderProperty(\carabiEditor\propertyEditor $propertyEditor, $return)
	{
		//$tmplt = $propertyEditor->getConfigValue('defaultRenderPropertyTemplate');
		$tmplt = $propertyEditor->config()->getValue('defaultRenderPropertyTemplate');
		$tpl = self::createTemplate($propertyEditor, $tmplt);
		$tpl->configLoad($propertyEditor->carabiEditor()->config()->getValue('tmpltCfg'));
		if ($return)
			return $tpl->fetch();
		else
			$tpl->display();
	}



	public static function saveProperty(\carabiEditor\propertyEditor $propertyEditor)
	{
		$propertyEditor->logger()->logStr(
			sprintf(
				'DID:%d, DTYPE:"%s"; PID:%d, PTYPE:"%s"',
				$propertyEditor->document()->document_id,
				$propertyEditor->document()->dockind_namevar,
				$propertyEditor->property()->get_docprop_id(),
				$propertyEditor->property()->get_docprop_descr()
			) . 'Default save property.'
		);
	}



	public static function renderControl(\carabiEditor\propertyEditor $propertyEditor, $return)
	{
		//$tmplt = $propertyEditor->getConfigValue('defaultRenderControlTemplate');
		$tmplt = $propertyEditor->config()->getValue('defaultRenderControlTemplate');
		if (empty($tmplt))
			return false;
		
		$propertyEditor->logger()->logStr('Rendering template: ' . $tmplt);
		
		if (!$propertyEditor->renderer()->templateExists($tmplt))
			throw new \Exception('Template doesnt exists: "'. $tmplt .'."');

		$tpl = self::createTemplate($propertyEditor, $tmplt);

		if ($return)
			return $tpl->fetch();
		else
			$tpl->display();
	}



	protected static function smartyPropertyFetch(\carabiEditor\propertyEditor $propertyEditor, $return)
	{
	}

	protected static function createTemplate(\carabiEditor\propertyEditor $propertyEditor, $templateFileName, $parentTemplate=null) {
		$tpl = $propertyEditor->renderer()->createTemplate($templateFileName, $parentTemplate);
		$tpl->configLoad('de.conf'); // @todo из конфига
		$tpl->assign('carabiEditor', $propertyEditor->carabiEditor());
		$tpl->assign('options', $propertyEditor->options);
		$tpl->assign('documentEditor', $propertyEditor->documentEditor());
		$tpl->assign('propertyEditor', $propertyEditor);
		return $tpl;
	}
}


	//protected static $propertyTmplt = 'de_property.tpl.html';
	//protected static function smartyFindTemplate(\carabiEditor\propertyEditor $propertyEditor)
	//{
	//	$tmplts = array();
	//	$tmplts[] = 'de_property_' . $propertyEditor->propertyKind(true) . '_' . $propertyEditor->propertySubKind() . '.tpl.html';
	//	$tmplts[] = 'de_property_' . $propertyEditor->propertyKind() . '_' . $propertyEditor->propertySubKind() . '.tpl.html';
	//	$tmplts[] = 'de_property_' . $propertyEditor->propertyKind(true) . '.tpl.html';
	//	$tmplts[] = 'de_property_' . $propertyEditor->propertyKind() . '.tpl.html';
	//	$tmplts[] = self::$propertyTmplt;
	//	for ($i=0, $j=count($tmplts); $i<$j; $i++) {
	//		if ($propertyEditor->renderer()->templateExists($tmplts[$i])){
	//			return $tmplts[$i];
	//		}
	//	}
	//	return false;
	//}

?>