<?php

namespace carabiEditor\plugins\objects;

class document_geo_point
{

	static public function renderWidget(\carabiEditor\documentEditor $documentEditor, $return)
	{
		
		/*
		 TODO $this->isSended()
		 
		*/
		$properties = array('LAT', 'LNG', 'MAPLAT', 'MAPLNG', 'MAPZOOM', 'NAME', 'ADDRESS', 'DESCRIPTION', 'PHONE');
		
		$renderer = $documentEditor->renderer()->smarty;
		$renderer->smarty->addTemplateDir( dirname(__FILE__).'/../../tmplt' );
		$tpl = $renderer->createTemplate( 'de_geopoint.tpl.html' );
                $tpl->configLoad($documentEditor->carabiEditor()->config()->getValue('tmpltCfg'));
		$tpl->assign( 'documentEditor', $documentEditor);
		foreach ($properties as $property) {
			$p = $documentEditor->getPropertyEditor($property);
			$p->isSended(true);
			$tpl->assign($property, $p->property());
		}

		if ($return) {
			return $tpl->fetch();
		} else {
			$tpl->display();
		}
	}


	static public function saveDocument(\carabiEditor\documentEditor $documentEditor)
	{
		//$documentEditor->getProperty()
		//$properties = array('LAT', 'LNG', 'MAPLAT', 'MAPLNG', 'MAPZOOM', 'NAME', 'ADDRESS', 'DESCRIPTION', 'PHONE');

		$p = $documentEditor->getPropertyEditor('LAT');
		self::saveFloatValue($p, $_REQUEST[self::getHTMLControlId($p)]);

		$p = $documentEditor->getPropertyEditor('LNG');
		self::saveFloatValue($p, $_REQUEST[self::getHTMLControlId($p)]);

		$p = $documentEditor->getPropertyEditor('MAPLAT');
		self::saveFloatValue($p, $_REQUEST[self::getHTMLControlId($p)]);

		$p = $documentEditor->getPropertyEditor('MAPLNG');
		self::saveFloatValue($p, $_REQUEST[self::getHTMLControlId($p)]);
		
		$p = $documentEditor->getPropertyEditor('MAPZOOM');
		$p->property()->setValue(array('V0'=>(int)$_REQUEST[self::getHTMLControlId($p)]));
		
                $p = $documentEditor->getPropertyEditor('NAME');
		self::saveTextValue($p, $_REQUEST[self::getHTMLControlId($p)]);

		$p = $documentEditor->getPropertyEditor('ADDRESS');
		self::saveTextValue($p, $_REQUEST[self::getHTMLControlId($p)]);

		$p = $documentEditor->getPropertyEditor('DESCRIPTION');
		self::saveTextValue($p, $_REQUEST[self::getHTMLControlId($p)]);

		$p = $documentEditor->getPropertyEditor('PHONE');
		self::saveTextValue($p, $_REQUEST[self::getHTMLControlId($p)]);

		$documentEditor->document()->save_prepare();

	}

	static public function getHTMLControlId(\carabiEditor\propertyEditor $propertyEditor)
	{
		return "P_{$propertyEditor->document()->document_id}_{$propertyEditor->property()->get_docprop_descr()}_0";
	}

	static public function saveFloatValue(\carabiEditor\propertyEditor $propertyEditor, $value)
	{
		if (preg_match('/[^\d\.]/', $value) > 0)
			throw new \Exception('Invalid value: ' . $value);
		$propertyEditor->property()->setValue(array('V0'=>$value));
	}

	/**
	 * @todo sanitize!
	 */
	static public function saveTextValue(\carabiEditor\propertyEditor $propertyEditor, $value)
	{
		$propertyEditor->property()->setValue(array('V0'=>$value));
	}
}







	//static public function collect_subObject($documentEditor_document) {
	//	$dId = $documentEditor_document->document()->document_id;
	//
	//	$this->document()->get_property(
	//	    $this->document()->properties['DOCPROP_ID'][$i]
	//	)
	//	
	//	$_REQUEST["C_{$dId}_lat"];
	//	$_REQUEST["C_{$dId}_lng"];
	//	$_REQUEST["C_{$dId}_maplat"];
	//	$_REQUEST["C_{$dId}_maplng"];
	//	$_REQUEST["C_{$dId}_mapzoom"];
	//	$_REQUEST["C_{$dId}_name"];
	//	$_REQUEST["C_{$dId}_address"];
	//	$_REQUEST["C_{$dId}_description"];
	//	$_REQUEST["C_{$dId}_phone"];
	//	
	//	return true;
	//}


/*
                            [0] => MAP_TYPE *
                            [1] => LAT
                            [2] => LNG
                            [3] => MODIFIED *
                            [4] => ALIAS *
                            [5] => URL *
                            [6] => MAPLAT
                            [7] => MAPLNG
                            [8] => MAPZOOM
                            [9] => ACCURACY *
                            [10] => NAME
                            [11] => ADDRESS
                            [12] => DESCRIPTION
                            [13] => PHONE
                            [14] => GEO_POS *
                            [15] => COMMENTS *
                            [16] => LAYER *
                            [17] => ALT *
                            [18] => SNIPPET *
                            [19] => ID *

*/
?>