<?php

namespace carabiEditor\plugins\objects;

class document_default
	// implements document_plugin
{
	private function __construct(){}

	public static function renderWidget(\carabiEditor\documentEditor $documentEditor, $return)
	{
		//$tmplt_fn = $documentEditor->carabiEditor()->getConfigValue('objectTmplt');
		//$tmplt_fn = $documentEditor->getConfigValue('defaultTmplt');
		$tmplt_fn = $documentEditor->config()->getValue('defaultTmplt');
		$documentEditor->logger()->logStr("Tmplt: ". $tmplt_fn);
		$cfg_fn = $documentEditor->carabiEditor()->config()->getValue('tmpltCfg');

		$tpl = $documentEditor->renderer()->smarty->createTemplate($tmplt_fn);
		$tpl->configLoad($cfg_fn);
		$tpl->assign('carabiEditor', $documentEditor->carabiEditor());
		$tpl->assign('editor', $documentEditor->editor());
		$tpl->assign('options', $documentEditor->carabiEditor()->options);
		$tpl->assign('documentEditor', $documentEditor);
		$tpl->assign('tpl', $tpl);
        
		if ($return) {
			return $tpl->fetch();
		} else {
			$tpl->display();
		}
	}

	public static function saveDocument(\carabiEditor\documentEditor $documentEditor)
	// Сохранение стандартного документа 
	{
		$documentEditor->logger()->logStr("Collecting document (native): {$documentEditor->document()->document_id}");
		$documentEditor->logger()->addTab();
		$properties = $documentEditor->getPropertiesEditors();
		//$documentEditor->logger()->logStr("Prop_debug1: " . print_r($properties, true));
		
		//print_r($properties);
		//exit;
		foreach ($properties as $property) {
			if ($property->property()->isWriteable()) {
				$documentEditor->logger()->logStr('');
				$documentEditor->logger()->logStr('Collecting property: ' . $property->property()->get_docprop_id() . ' (' . $property->property()->get_docprop_descr() . ')');
				try {
					$property->saveProperty();
				} catch (\Exception $e) {
					$documentEditor->logger()->logStr('Error during saving property: ' . $e->getMessage());				
					$documentEditor->logger()->deTab();
					throw $e;
				}
			}
		}
		$documentEditor->document()->save_prepare();
		
		$documentEditor->logger()->deTab();
		$documentEditor->logger()->logStr('Property collected.');
	}

}

?>