<?php

namespace carabiEditor;

class editor
{
    protected $carabiEditor;
    protected $mainDocumentEditor;



    /**
     * Конструктор редактора.
     *
     * @param \carabiEditor $carabiEditor
     * @param mixed $document
     *      - integer
     *      - SimpleDocument
     *
    */
    public function __construct(\carabiEditor $carabiEditor, $document)
    {
        $this->carabiEditor = $carabiEditor;
        $this->mainDocumentEditor = new documentEditor($document, $carabiEditor);
    }



    /**
     * Выводит виджет редактора
     *
    */
    public function displayWidget()
    {
        $tpl = $this->smartyEditorPrepare();
        $tpl->disply();
    }



    /**
     * Возвращает код виджета редактора
     *
     * @return string
     *
    */
    public function fetchWidget()
    {
        $tpl = $this->smartyEditorPrepare();
        return $tpl->fetch();
    }



    /**
     * Обрабатывает запрос. Сохранение документа или что-либо другое
     *
    */
    public function processRequest()
    {
        $this->logger()->logStr('Proccessing system call [' . $_REQUEST['do'] . ']');
        
        switch ($_REQUEST['do']) {
            case 'saveDocuments':
                $this->saveDocuments();
                // очищаем кэш данных для обновления
                $this->clearCache('carabi');
                return true;
            break;
        
            default:
                $this->logger()->logStr('This is not system call.');
                throw new \Exception('This is not system call: "' . $_REQUEST['do'] . '".');
            break;
        }
    }



    /**
     * Сохранение документов
     *
    */
    protected function saveDocuments()
    {
        try {
            // пытаемся выполнить сохранение документа
            // $this->documentEditor() - это $this->mainDocumentEditor
            $this->documentEditor()->saveDocument();
            if (0 != $this->documentEditor()->document()->save_commit()) {
                throw new \Exception('Commiting changes failed');
            }
            $this->logger()->logStr('[saved]');
            if (!empty($_REQUEST["setMainDocumentStatus"])) {
                $documentID = $this->documentEditor()->document()->document_id;
                $status = $_REQUEST["setMainDocumentStatus"];
                ora_proc("SET_STATUS($documentID, $status, true)");
                $this->logger()->logStr("[status changed to $status]");
            }
            $this->logger()->logStr('[SUCC]');
            $this->carabiEditor()->send_x_answer(true, array());
        } catch (\Exception $e) {
            $this->logger()->logStr('Saving failed.');
            $this->carabiEditor()->send_x_answer(false, array(), $e->getMessage());
        }
    }


    /**
     * Очистка кэша
     *
    */
   
	private function clearCache($option) {
		//print_a($_SERVER);
		function cleardir($dir, $controlMaxSize = true) {
			try {
                $MAX_FILE_SIZE = 200000; // размер максимального файла. Файлы больше этого размера не удаляем
                foreach(glob($dir.'/*') as $f) {
                    //$this->logger()->logStr('cache_debug', $f . ' - ' . filesize($f));
                    $size = filesize($f);
                    if ($controlMaxSize && $size < $MAX_FILE_SIZE) {
                        unlink($f);
                    }
                }
            } catch (\Exception $e) {
                $this->logger()->logStr('Cleaning cache failed: '.$e->getMessage());
                $this->carabiEditor()->send_x_answer(false, array(), $e->getMessage());
            }
		}
		switch ($option) {
			case "carabi": {
                $dir = DATA_DIR . "/cache";
				$this->logger()->logStr($dir);
                cleardir($dir);
                break;
			}
			case "smarty": {
				cleardir($dir = DATA_DIR . "/smarty/templates_c", false);
				break;
			}
			case "oracle": {
				ora_proc("pkg_rent_cache.drop_cache()");
				break;
			}
			case "all": {
				cleardir(DATA_DIR . "/cache");
				cleardir($dir = DATA_DIR . "/smarty/templates_c", false);
				ora_proc("pkg_rent_cache.drop_cache()");
				break;
			}
		}
		//header("Location: " . $_SERVER["HTTP_REFERER"]);
        $this->logger()->logStr('clearCache :: SUCCESS');
	}
    



    /**
     * Подсистема ренедринга, основана на Smarty.
     *
    */

    /**
     * 
     *
    */
    protected function smartyEditorPrepare()
    {
        $tpl = $this->renderer()->smarty->createTemplate(
            $this->carabiEditor()->config()->getValue('editorTmplt')
        );
		//echo $this->carabiEditor()->config()->getValue('editorTmplt'); exit;
		$tpl->configLoad($this->carabiEditor()->config()->getValue('tmpltCfg'));
        $tpl->assign('carabiEditor', $this->carabiEditor());
        $tpl->assign('editor', $this);
        
        // заглушка для совместимости
        $tpl->assign('options', $this->carabiEditor()->options);
        $tpl->assign('tpl', $tpl);
        return $tpl;
    }

    /**
     *
     * /smarty
    */



    /**
     *
     *
    */
    public function __call($name, $arguments)
    {
        switch (strtolower($name)) {
            case 'carabieditor':
                return $this->carabiEditor;
            break;

            case 'session':
                return $this->carabiEditor->session();
            break;

            case 'logger':
                return $this->carabiEditor->logger();
            break;

            case 'renderer':
                return $this->carabiEditor->renderer();
            break;

            case 'documenteditor':
                return $this->mainDocumentEditor;
            break;
            
            case 'document':
                return $this->mainDocumentEditor->document();
            break;
        
            case 'renderer':
                return $this->carabiEditor->renderer();
            break;
        
            default:
                throw new \Exception('No such method in editor: "' . $name . '"');
            break;
        }
    }
    
}


        //$this->logger()->logStr('Saving documents');
        //$this->logger()->logStr('REQUEST: ' . print_r($_REQUEST,true));
        //try {
        //    $this->logger()->logStr('All documents:');
        //    $oDs = $this->session()->getDocuments();
        //    $this->logger()->logStr(print_r($oDs, true));
        //    foreach ($oDs as $oDID => $oD) {
        //        $sD = new SimpleDocument($oDID);
        //        $sDEd = new DocumentEditor_Document($sD, $this->carabiEditor());
        //        $sDEd->saveDocument();
        //    }
        //    $this->logger()->logStr('Commiting changes');
        //    if (0 != $this->documentEditor()->document()->save_commit()) {
        //        throw new \Exception('Commiting changes failed');
        //    }
        //    $this->logger()->logStr('[SUCC]');
        //    $this->send_x_answer(true, array());
        //    return true;
        //} catch (\Exception $e) {
        //        $this->logger()->logStr($e->getMessage());
        //        $this->logger()->logStr('Error');
        //        $this->send_x_answer(false, array(), $e->getMessage());
        //        return false;
        //}

?>