<?php

/**
 * @todo пересмотреть работу методов "getPropertiesEditors", "getPropertyEditor",
 *       "preparePropertiesEditors".
 *
*/

namespace carabiEditor;
//include_once($_SERVER['DOCUMENT_ROOT'] . '/../carabi/classes/class.utls.php');

class documentEditor
{
    protected $carabiEditor;
    protected $simpleDocument;
    protected $propertiesEditors;
    protected $config;
    protected $requested;



    /**
     * Конструктор редактора документа.
     *
     * @param mixed $document. Может быть либо объектом класса SimpleDocument, либо идентификатором объекта.
     * @param \carabiEditor $carabiEditor
     *
    */
    public function __construct($document,
								\carabiEditor $carabiEditor)
    {
        if ($document instanceof \SimpleDocument) {
            $this->simpleDocument = $document;
        } elseif ((int)$document>0) {
            $this->simpleDocument = new \SimpleDocument((int)$document);
        } else {
            throw new Exception('Wrong SimpleDocument.');
        }
        
		$this->carabiEditor = $carabiEditor;
        $this->requested = false;
        $this->readConfig();
    }



    /**
     * Обрабатывает запрос (controller)
     *
    */
    public function processRequest()
    {
        $this->logger()->logStr(PHP_EOL);
	$this->logger()->logStr('docId:' . $this->document()->document_id. ' -> ' . __METHOD__);
	//utls::logStr('docs_debug', 'ProcessRequest func - ' . print_r($_REQUEST, true));
        
        $call = $_REQUEST['do'];
	$documentRequestHandler = 'request_' . $call;
	
	$this->requested = true;
	$cb = $this->config->getValue($documentRequestHandler);
	$this->carabiEditor()->executeFunction($cb, $this);
        
		//$call = $_REQUEST['call'];
        // ? а где запрос в плагин ?
		//$this->logger()->logStr('Proccessing internal call [' . $_REQUEST['do'] . ']');
		//switch ($_REQUEST['do']) {
		//	default:
		//		$this->logger()->logStr('This is not internall call.');
		//		throw new \Exception('This is not internall call: "' . $_REQUEST['do'] . '".');
		//	break;
		//}
    }



    public function renderDocument($return=false)
    {
        $this->logger()->logStr(PHP_EOL);
		$this->logger()->logStr('docId:' . $this->document()->document_id
								. ' -> ' . __METHOD__);
        
        $cb = $this->config->getValue('render');
        $this->carabiEditor()->executefunction($cb, $this, $return);
    }



    public function saveDocument()
    // Сохранение документа
    {
        $this->logger()->logStr(PHP_EOL);
	$this->logger()->logStr('docId:' . $this->document()->document_id. ' -> '.__METHOD__);
        
	
        $cb = $this->config->getValue('save');
	
	/* вернули что-то типа
	 Array
	    (
		[class] => carabiEditor\plugins\objects\document_default
		[method] => saveDocument
	    )
	*/
        //print_r($cb);
	//exit;
	//utls::logStr('docs_debug', 'documentEditor.saveDocument() - cb='.$cb);
	
	$this->carabiEditor()->executefunction($cb, $this);
    }



    /**
     * Возвращает код виджета редактора (view)
     *
     * @return string
     *
    */
    public function fetchWidget()
    {
        $this->logger()->logStr($this->document()->document_id . ' ' . 'Rendering');
        return $this->renderDocument(true);
    }



    /**
     * Выводит виджет редактора (view)
     *
    */
    public function displayWidget()
    {
        $this->logger()->logStr($this->document()->document_id . ' ' . 'Rendering');
        $this->renderDocument(false);
    }



    /**
     * Проверяет является ли текущий объект главным объектом для редактора.
     *
    */
    public function isTopDocument(){
        return $this->carabiEditor()->mainDocument()->document_id
            == $this->document()->document_id;
    }



    /**
     * Блок работы со свойствами документа.
     * @todo Переделать!
     *
    */
    
    /**
     *
     *
    */
    public function getPropertiesEditors()
    {
        if (empty($this->propertiesEditors))
            $this->propertiesEditors = $this->preparePropertiesEditors();
        return $this->propertiesEditors;
    }

    /**
     *
     *
    */
    public function getPropertyEditor($propertyId)
    {
        $propertyEditor = new propertyEditor($this->document()->get_property($propertyId),
                                               $this);
        
        return $propertyEditor;
    }

    /**
     *
     *
    */
    protected function preparePropertiesEditors()
    {
        $skippedProperties = (array)$this->config->getValue('skipProperties');
        array_walk($skippedProperties, function(&$v){$v=strtolower($v);});
        
        $propertiesEditors = array();
        for ($i=0, $j=count($this->document()->properties['DOCPROP_ID']); $i<$j; $i++) {
            if (in_array(strtolower($this->document()->properties['DOCPROP_DESCR'][$i]),
                         $skippedProperties)
            ) {
                continue;
            }
            if ($propertyEditor=$this->getPropertyEditor($this->document()->properties['DOCPROP_ID'][$i])) {
                $propertiesEditors[] = $propertyEditor;
            }
        }
	//print_r($propertiesEditors);
	//exit;
        return $propertiesEditors;
    }



	/**
	 * Читает конфиги в определнной последовательности
	 *
	 * @todo добавить ещё из getConfigValues! для полноценной навигации по переопределнным значениям.
	 *
	*/
    protected function readConfig()
    {
        $this->config = new \carabiEditor\config(
            (array)$this->carabiEditor->config()->getValue('object'),
            (array)$this->carabiEditor->config()->getValue('object_' . strtolower($this->document()->dockind_namevar))
        );
    }



    public function __call($name, $arguments)
    {
        switch (strtolower($name)) {
            case 'carabieditor':
                return $this->carabiEditor;
            break;

            case 'session':
                return $this->carabiEditor->session();
            break;

            case 'logger':
                return $this->carabiEditor->logger();
            break;
        
            case 'renderer':
                return $this->carabiEditor->renderer();
            break;
        
            case 'editor':
                return $this->carabiEditor->editor();
            break;

            case 'maindocumenteditor':
                return $this->carabiEditor->editor()->documentEditor();
            break;

            case 'maindocument':
                return $this->carabiEditor->editor()->document();
            break;
        
            case 'document':
                return $this->simpleDocument;
            break;
        
            case 'config':
                return $this->config;
            break;
        
            default:
                throw new \Exception('No such method in documentEditor: "' . $name . '"');
            break;
        }
    }

    
}








        //if ($this->document()->prepare()) {
        //    
        //} else {
        //    $this->logger()->logStr('[ERROR]');
        //}

    //public function renderer()
    //{
    //    if ($this->render) {
    //        return $this->render;
    //    } else {
    //        return $this->documentEditor()->renderer();
    //    }
    //}

//    public function documentEditor()
//    {
//	return $this->documentEditor;
//    }
//
//    public function document()
//    {
//	return $this->simpleDocument;
//    }
//    
//    public function &session()
//    {
//	return $this->documentEditor()->session();
//    }

//    public function get_options()
//    {
//	return $this->documentEditor()->options;
//    }

//    public function logger($scope='')
//    {
//	return $this->documentEditor()->logger($scope);
//    }
    ///**
    // *
    // *
    //*/
    //final public function display()
    //{
    //	echo $this->fetch();
    //}
    //
    //
    ///**
    // *
    // *
    //*/
    //final public function fetch()
    //{
    //	return $this->render();
    //}
    ///**
    // *
    // *
    //*/
    //public function callPlugin()
    //{
    //    $args = func_get_args();
    //    $object_type = array_shift($args);
    //    $name = array_shift($args);
    //    //echo '1';
    //    if ($clName = $this->checkPlugin($object_type, $name)) {
    //        return call_user_func_array(array($clName, $name), $args);
    //    }
    //}
    ///**
    // *
    // *
    //*/
    //public function isDocumentRenderedByPlugin($object_type, $name)
    //{
    //    //$object_type = strtolower($object_type);
    //    //$className = "de_objectPlugin_{$object_type}";
    //    //\utls::require_class(
    //    //            $className,
    //    //            "{$object_type}.php",
    //    //            dirname(__FILE__)."/plugins/objects"
    //    //            );
    //    //if (is_callable(array($className, $name))) {
    //    //    return $className;
    //    //} else {
    //    //    return false;
    //    //}
    //    
    //}

        //if ($this->checkPlugin($this->document()->dockind_namevar, 'render_subObject'))
        //{
        //    $this->logger()->logStr($this->document()->document_id . ' ' . 'Render by plugin');
        //    $this->callPlugin($this->document()->dockind_namevar, 'render_subObject', $this);
        //} else {
        //    $this->logger()->logStr( $this->document()->document_id . ' ' . 'Native render');
        //    $this->smartyObjectRender(false);
        //}
    ///**
    // * Подсистема ренедринга, основана на Smarty.
    // *
    //*/
    //
    ///**
    // * Отрисовывает виджет.
    // *
    // * @param boolean $return Если true, то код виджета возвращается. В
    // * противном случае выводится.
    // *
    //*/
    //protected function smartyObjectRender($return=false)
    //{
    //    $tmplt_fn = $this->carabiEditor()->getConfigValue('objectTmplt');
    //    $tpl = $this->renderer()->smarty->createTemplate($tmplt_fn, $tpl);
    //    $tpl->configLoad($this->carabiEditor()->getConfigValue('tmpltCfg'));
    //    $tpl->assign('carabiEditor', $this->carabiEditor());
    //    $tpl->assign('editor', $this->editor());
    //    $tpl->assign('options', $this->carabiEditor()->options);
    //    $tpl->assign('documentEditor', $this);
    //    $tpl->assign('tpl', $tpl);
    //    
    //    if ($return) {
    //        return $tpl->fetch();
    //    } else {
    //        $tpl->display();
    //    }
    //}

    /**
     * /Smarty
    */
    ///**
    // *
    // *
    //*/
    //public function collectFormData()
    //{
    //    if ($this->checkPlugin($this->document()->dockind_namevar, 'collect_subObject')) {
    //        $this->logger()->logStr("Collecting document (plugin): {$this->document()->document_id}");
    //        if (!$this->callPlugin($this->document()->dockind_namevar, 'collect_subObject', $this)) {
    //        $this->logger()->logStr('!ERROR');
    //        return false;
    //        }
    //    } else {
    //        $this->logger()->logStr("Collecting document (native): {$this->document()->document_id}");
    //        $this->logger()->addTab();
    //        $properties = $this->get_properties();
    //        foreach ($properties as $property) {
    //        $this->logger()->logStr('Collecting property: ' . $property->property()->get_docprop_id() . ' (' . $property->property()->get_docprop_descr() . ')');
    //        if (!$property->collectValue()) {
    //            $this->logger()->logStr('!ERROR');
    //            $this->logger()->deTab();
    //            return false;
    //        }
    //        }
    //        $this->logger()->deTab();
    //    }
    //    return true;
    //}
    //
    //
    //
    ///**
    // *
    // *
    //*/
    //public function save()
    //{
    //    $this->logger()->logStr('Prepare transaction for saving.');
    //    $this->document()->save_prepare();
    //    
    //    return true;
    //}
        //if (!empty($cb['class']) && !empty($cb['method'])) {
        //    $cb = array($cb['class'], $cb['method']);
        //} elseif (!empty($cb['method'])) {
        //    $cb = $cb['method'];
        //} else 
        //    throw new \Exception('No render. 01');
        //    
        //if (!is_callable($cb))
        //    throw new \Exception('No render. 02');
        //    
        //call_user_func($cb, $this, $return);
        //if (!empty($cb['class']) && !empty($cb['method'])) {
        //    $cb = array($cb['class'], $cb['method']);
        //} elseif (!empty($cb['method'])) {
        //    $cb = $cb['method'];
        //} else 
        //    throw new \Exception('No save. 01');
        //    
        //if (!is_callable($cb))
        //    throw new \Exception('No save. 02');
        //    
        //call_user_func($cb, $this);

?>