<?php

class documentEditorException extends \Exception
{
    
}



class documentEditorErrorException extends \ErrorException
{
    
}


class deutils
{
    
    
    public static function dEAutoLoad($class)
    {
        $path = explode('\\', $class);
        $prefix = strtolower(array_shift($path));
        if ('documenteditor' != $prefix && 'carabieditor' != $prefix) {
            return false;
        }
        
        $filename = array_pop($path);
        $fullFilename = __DIR__ . '/' .
            implode('/', array_map('strtolower', $path)) . '/' .
            $filename . '.php';
            
        if (!is_file($fullFilename)) {
            return false;
            //throw new Exception('No file [' . $fullFilename . '] for class [' . $class . ']');
        }
        
        require $fullFilename;
        
        if (!class_exists($class, false)) {
            return false;
            //throw new Exception('No class [' . $class . ']');
        }
    }


    public static function smartyInit()
    {
        $renderer = utls::get_renderer(); // todo: избавится.
        $renderer->smarty->addTemplateDir(__DIR__ . '/tmplt');
        $renderer->smarty->addPluginsDir(__DIR__ . '/tmplt/plugins');
        
        $cd = $renderer->smarty->getConfigDir();
        if (empty($cd)) {
            $cd = array();
        } else if (!is_array($cd)) {
            $cd = array($cd);
        }
        $cd []= __DIR__.'/tmplt/cfg';
        $renderer->smarty->setConfigDir($cd);
        
        // Flint: TODO - убрать вызов. Использован для плагина в списке цен
        $renderer->smarty->allow_php_tag=true;
        return $renderer;
    }
    
    
    public static function readConfig($configName)
    {
        $configsDir = realpath(__DIR__ . '/configs');
        $configFilename = $configName . '.php';
        $configFunc = 'carabiEditorConfig_' . $configName;
        $fullFilename = $configsDir . '/' . $configFilename;
        if (!is_file($fullFilename)) {
            throw new Exception('Wrong config name: "' . $configName . '". Code: 01.');
        }
        include_once $fullFilename;
        if (!function_exists($configFunc)) {
            throw new Exception('Wrong config name: "' . $configName . '". Code: 02.');
        }
        return $configFunc();
    }
    

    /**
     * Возможны проблемы с кодировкой при использовании json_encode!
     *
    */
	public static function propertyValuesToJSON(SimpleProperty $simpleproperty)
	{
		// test flow 1 (нет записей)
		//return '[]';

		// test flow 2a (одна пустая запись)
		//return '[{}]';

		// test flow 2b (одна пустая запись)
		//return '[{'V0':''}]';

		// test flow 2c (одна пустая запись)
		//return '[{'DISPLAY':''}]';

		// test flow 3 (много записей)
		//return '[{"V0":"testId1","DISPLAY":"test1"},{"V0":"testId2","DISPLAY":"test2"},{"V0":"testId3","DISPLAY":"test3"}]';

		
		// normal flow (одна запись)
		$valuesCount = ($simpleproperty->isMulti()
						? $simpleproperty->get_values_count()
						: 1);
		$values = array();
		for ($i=0; $i<$valuesCount; $i++) {
			$values []= array('PLURAL' => $simpleproperty->get_value('PLURAL', $i),
							  'V0' => $simpleproperty->get_value('V0', $i),
							  'V1' => $simpleproperty->get_value('V1', $i),
							  'V2' => $simpleproperty->get_value('V2', $i),
							  'DISPLAY' => $simpleproperty->get_display());
		}
		//print_a($values);
		\utls::json_encode($values);
        
		return $values;
	}
    
    
	/**
	 *
	*/
	public static function JSONToValues($json)
	{
		$values = array();
		\utls::json_decode($json, true);
		$row_values = $json;
		$allowedValueKeys = array('V0', 'V1', 'V2', 'DISPLAY', 'PLURAL',
								  'isNew', 'isToDelete', 'isToUpdate');
		
		if (!is_array($row_values))
			return $values;
			
		for ($i=0, $j=count($row_values); $i<$j; $i++) {
			if (!is_array($row_values)) {
				continue;
			}
			$value = array();
			foreach ($row_values[$i] as $k=>$v) {
				if (!in_array($k, $allowedValueKeys)) {
					continue;
				}
				$value[$k] = $v;
			}
			if (count($value)) {
				$values[]=$value;
			}
		}
		return $values;
	}


    public static function array_deep_merge() {
        if (func_num_args() < 2) {
            trigger_error(__METHOD__ .' needs two or more array arguments', E_USER_WARNING);
            return;
        }
        
        $arrays = func_get_args();
        $merged = array();
        while ($arrays) {
            $array = array_shift($arrays);
            if (!is_array($array)) {
                trigger_error(__METHOD__ .' encountered a non array argument', E_USER_WARNING);
                return;
            }
            if (!$array)
                continue;
            foreach ($array as $key => $value)
                if (is_string($key))
                    if (is_array($value) && array_key_exists($key, $merged) && is_array($merged[$key]))
                        $merged[$key] = call_user_func(__METHOD__, $merged[$key], $value);
                    else
                        $merged[$key] = $value;
                else
                    $merged[] = $value;
        }
        return $merged;
    }
    
    public static function testNumeric($test)
    {
		$test = str_replace(',', '.', $test);
		if (!is_numeric($test)) {
			return false;
		}
		return (float)$test;
    }

	public static function extractJSON_intArray($v)
    {
		// пустым будет считаться $v="" и $v="[]";
		if (empty($v)) {
			$v = array();
		} else {
			$v = json_decode($v);
			if (!is_array($v)) {
                return false;
			}
			for ($i=0, $j=count($v); $i<$j; $i++) {
				if ($v[$i]===null)
					continue;
	
                $v[$i] = (int)$v[$i];
                if (empty($v[$i])) {
                    return false;
                }
			}
		}
		return $v;
    }

}

?>