<?php

function carabiEditorConfig_default()
{
	if (defined("SCRIPTS_URL")) {
		$scriptsUrl = SCRIPTS_URL;
	}
	$config = array(
		'editorTmplt' => 'de_main.tpl.html',
		//'objectTmplt' => 'de_object.tpl.html',
		'tmpltCfg' => 'de.conf',
		'javascriptDirPrefix' => $scriptsUrl,
		'connectorUrl' => '',
		'connectorPrefix' => '',
		"downloadUrl" => "/panel/download/",
	
		'propertyTypes' => array(
			1 => 'simple',
			9 => 'ref',
			10 => 'vocabulary',
			11 => 'table',
			16 => 'media',
			12 => 'backref',
			17 => 'counter',
			/*18 => 'display',
			19 => 'system_function',
			20 => 'catalog_classifier',
			21 => 'catalog_parameters',*/
		),



		/**
		 Настройки документов.
		 Имя: 'object_<dockind_namevar>'
		 Если в объекте нужных параметров нет, то берётся из параметра 'object'

		 Параметры:
			render
			save
		*/
		'object' => array(
			'skipProperties' => array(),
			'defaultTmplt' => 'de_object.tpl.html',
			'render' => array('class' => 'carabiEditor\plugins\objects\document_default', 'method' => 'renderWidget'),
			'save' => array('class' => 'carabiEditor\plugins\objects\document_default', 'method' => 'saveDocument'),
		),

		'object_geo_point' => array(
			'skipProperties' => array('map_type', 'MODIFIED', 'ALIAS', 'URL', 'ACCURACY', 'GEO_POS', 'COMMENTS', 
				'LAYER', 'ALT', 'SNIPPET', 'ID'),
			'render' => array('class' => 'carabiEditor\plugins\objects\document_geo_point', 'method' => 'renderWidget'),
			'save' => array('class' => 'carabiEditor\plugins\objects\document_geo_point', 'method' => 'saveDocument'),
		),

		'object_address' => array(
			'skipProperties' => array('kstreet_search', 'kall_search', 'kvybor', 'kladr_address', 'direction',
				'streetmaplink', 'streetmaplink_yandex', 'w_google', 'kregion', 'kraion', 'kcity', 'kplace',
				'latitude', 'longitude', 'settlement', 'address_eng', ),
		),

		/**
			Способы именование свойств:
			1) property - общая настройка для всех свойств всех документов;
			2) property_D<...> - общая настройка для всех свойств для конкретного документа;
			3) property_T<...> - настройка для конкретного типа свойства (все документы);
			4) property_P<...> - настройка конкретного свойства у конкретного документа;
			5) property_D<...>_T<...> - настройка конкретного типа свойства у конкретного документа;
			6) property_D<...>_P<...> - настройка конкретного свойства у конкретного документа;

			Где, :
			D<...>  - $simpledocument->dockind_namevar (например: address)
			T<...>  - $simpleproperty->get_docprop_kind() (например: simple, ref, table)
			P<...>  - $simpleproperty->get_docprop_descr() (например: kstreet)


			Способы приведенны с учётом приоритетотов (от наименьшего к большему).
			Буквы в названиях типов документов и полей должны быть только строчными.

		*/

		'property' => array(
			'renderProperty' => array('class' =>'carabiEditor\plugins\objects\property_default', 'method' => 'renderProperty'),
			'defaultRenderPropertyTemplate' => 'de_property.tpl.html',
			'renderControl' => array('class' =>'carabiEditor\plugins\objects\property_default', 'method' => 'renderControl'),
			'save' =>array('class' =>'carabiEditor\plugins\objects\property_default', 'method' => 'saveProperty'),
		),

		'property_Tsimple' => array(
			'renderControl' => array('class' =>'carabiEditor\plugins\objects\property_simple', 'method' => 'renderControl'),
			'save' =>array('class' =>'carabiEditor\plugins\objects\property_simple', 'method' => 'saveProperty'),
		),

		'property_Tref' => array(
			'defaultRenderControlTemplate' => 'de_control_ref.tpl',
			'subDocumentTemplate' => 'de_control_ref_subdocument.tpl',

			'request_getControl' => array('class' =>'carabiEditor\plugins\objects\property_ref', 'method' => 'request_getControl'),

			'request_getSubDocument' => array('class' =>'carabiEditor\plugins\objects\property_ref', 'method' => 'request_getSubDocument'),
			'request_get_ddd' => array('class' =>'carabiEditor\plugins\objects\property_ref', 'method' => 'request_getAvailRefs'),
			'request_createSubObject' => array('class' =>'carabiEditor\plugins\objects\property_ref', 'method' => 'request_createSubObject'),
			'save' => array('class' =>'carabiEditor\plugins\objects\property_ref', 'method' => 'saveProperty'),
		),
                /*
		'property_Tbackref' => array(
			//'defaultRenderPropertyTemplate' => 'de_property_ref.tpl.html',
			'defaultRenderControlTemplate' => 'de_control_ref.tpl.html',
			'subDocumentTemplate' => 'de_control_ref_subdocument.tpl',

			'request_getControl' => array('class' =>'carabiEditor\plugins\objects\property_ref', 'method' => 'request_getControl'),

			'request_getSubDocument' => array('class' =>'carabiEditor\plugins\objects\property_ref', 'method' => 'request_getSubDocument'),
			'request_get_ddd' => array('class' =>'carabiEditor\plugins\objects\property_ref', 'method' => 'request_getAvailRefs'),
		),
                */
		'property_Ttable' => array(
			'renderControl' => array('class' =>'carabiEditor\plugins\objects\property_table', 'method' => 'renderControl'),
			'save' =>array('class' =>'carabiEditor\plugins\objects\property_table', 'method' => 'saveProperty'),
		),

		'property_Tvocabulary' => array(
			'renderControl' => array('class' =>'carabiEditor\plugins\objects\property_vocabulary', 'method' => 'renderControl'),
			'save' =>array('class' =>'carabiEditor\plugins\objects\property_vocabulary', 'method' => 'saveProperty'),
		),

		'property_Tmedia' => array(
			//'renderControl' => array('carabiEditor\plugins\objects\property_media', 'renderControl'),
			'defaultRenderControlTemplate' => 'de_control_media.tpl',
			'request_proccessFileUpload' => array('class' =>'carabiEditor\plugins\objects\property_media', 'method' => 'request_processFileUpload'),
			'save' =>array('class' =>'carabiEditor\plugins\objects\property_media', 'method' => 'saveProperty'),
		),

		'property_Daddress_Pkstreet' =>array(
			'request_getdummy' => array('class' =>'carabiEditor\plugins\objects\document_address', 'method' => 'request_kstreet_getdummy'),
			'renderProperty' => array('class' =>'carabiEditor\plugins\objects\document_address', 'method' => 'renderProperty_kstreet'),
			'save' => array('class' =>'carabiEditor\plugins\objects\document_address', 'method' => 'saveProperty'),
		),

		'property_Daddress_Pkvybor' =>array(
			'request_getdummy' => array('class' => 'carabiEditor\plugins\objects\document_address', 'method' => 'request_kvybor_getdummy'),
		),

		'property_Prestate-ref-cost' =>array(
			'renderControl' => array('class' => 'carabiEditor\plugins\objects\property_refcost', 'method' => 'renderControl'),
			'save' => array('class' => 'carabiEditor\plugins\objects\property_refcost', 'method' => 'saveProperty'),
		),



	);



	return $config;
}



?>